/*
 Copyright (C) 1996 Mike White
 Permission is granted to any individual or institution to use, copy, or
 redistribute this software so long as all of the original files are included,
 that it is not sold for profit, and that this copyright notice is retained.

*/

#define STRICT
#include <windows.h>
#include <string.h>
#include <commdlg.h>
#include <stdio.h>
#include <dos.h>
#include <time.h>
#include "wiz.h"

#define DKGRAY_PEN      RGB(128, 128, 128)
#define IB_SPACE        -1

/* Forward declarations */
void ButtonBar(HWND, LPBUTTON);
void CreateButtonBar(HWND hWndParent);
VOID SubClassButton (HWND hwnd, WNDPROC SubClassBtnProc);
LRESULT CALLBACK SubClassBtnProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);

static WNDPROC pfnOldProc;
static BOOL first = FALSE;
static HWND hHelpBtnWnd = NULL;
HWND   hWndButtonBarOwner;
HWND   hWndButtonBar;
int    Width, Height;
int    BtnSeparator = 1;
float  BtnMult = (float)BTNWIDTH;

BUTTON    Buttons[NUMOFBUTTONS + 1];
LPBUTTON  lpIB;

/*
 *  function:  SubClassBtnProc
 *
 *  input parameters:  normal window procedure parameters.
 *  global variables:
 *   hWndButtonBar  - parent window of the control.
 */

LRESULT CALLBACK SubClassBtnProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
RECT rc, rw;
POINT p;

  switch (message) {
    case WM_MOUSEMOVE: {
      int left, top;
      POINT pt;

      if (!uf.fShowBubbleHelp)
         return 0;

      p.x = LOWORD(lParam); /* Get mouse coordinates */
      p.y = HIWORD(lParam);

      for (lpIB = Buttons; lpIB->idBtn != 0; lpIB++)
         {
         if (lpIB->hWndBtn == hWnd)
            {
            if  (ChildWindowFromPoint(hWnd, p) != hWnd)
                {
                if (hHelpBtnWnd != NULL)
                   {
                   ShowCaret(hHelpBtnWnd);
                   DestroyWindow(hHelpBtnWnd);
                   }
                hHelpBtnWnd = NULL;
                if (GetCapture != NULL)
                   ReleaseCapture();
                break; /* Mouse has moved off the button */
                }

            if (GetCapture() != hWnd)
               {
               SetCapture(hWnd);
               /* Convert left, right corners of button to hWndMain
                  coordinates
                */
               WinAssert(hWnd);
               GetWindowRect(hWnd, &rc);
               GetWindowRect(hWndMain, &rw);

               if ((rc.left + ((lstrlen(lpIB->ButtonHelp)+1) * dxChar)) < rw.right)
                  {
                  pt.x = rc.left;
                  pt.y = rc.top;
                  ScreenToClient(hWndMain, &pt);
                  left = pt.x;
                  }
               else
                  {
                  pt.x = rc.right;
                  pt.y = rc.bottom;
                  ScreenToClient(hWndMain, &pt);
                  left = pt.x - ((lstrlen(lpIB->ButtonHelp)+1) * dxChar);
                  }
               pt.x = rc.right;
               pt.y = rc.bottom;
               ScreenToClient(hWndMain, &pt);
               top = pt.y;
               hHelpBtnWnd = CreateWindow("EDIT", NULL,
                  WS_VISIBLE|ES_READONLY|WS_BORDER|WS_CHILD,
                  left, top,
                  (lstrlen(lpIB->ButtonHelp)+1) * dxChar, (int)(1.5 * dyChar),
                  hWndMain,
                  (HMENU) NULL,
                  (HANDLE) hInst,
                  NULL);
               SendMessage(hHelpBtnWnd, WM_SETFONT, (WPARAM)hFixedFont, TRUE);
               SendMessage(hHelpBtnWnd, WM_SETTEXT, 0, (LPARAM)lpIB->ButtonHelp);
               HideCaret(hHelpBtnWnd);
               break;
              }
            }
         }
      return 0;
      }
    /*
     * For messages that are not handled explicitly, pass them on
     * to the original window procedure.
     */
    default:
      if (hHelpBtnWnd != NULL)
         {
         DestroyWindow(hHelpBtnWnd);
         hHelpBtnWnd = NULL;
         if (GetCapture() != NULL)
            ReleaseCapture();
         }
      return (CallWindowProc ((pfnOldProc), hWnd, message, wParam, lParam));
    } /* end switch */

}

/*
 *  function:  SubClassButton
 *
 *  input parameters:
 *     hwnd            - window handle to be subclassed,
 *     SubClassBtnProc - the new window procedure.
 *
 *  Set in a new window procedure for this window.  Store the old window
 *  procedure in the first field of the extrabytes structure.  This routine
 *  is specific to this program in the use of this particular extrabyte
 *  structure.  Note that the pointer to the user bytes needs to be freed
 *  later (in WM_DESTROY).
 */

VOID SubClassButton (HWND hwnd, WNDPROC SubClassBtnProc)
{
WinAssert(hwnd);
if (!first)
   {
   pfnOldProc = (WNDPROC) GetWindowLong (hwnd, GWL_WNDPROC);
   first = TRUE;
   }
SetWindowLong (hwnd, GWL_WNDPROC,  (LONG) SubClassBtnProc);
}

/* WARNING If you add a button, you must change the #define in WIZ.H for
   NUMOFBUTTONS. Any more buttons, and you might have trouble with VGA, or
   640x480 display modes.
*/
void CreateButtonBar(HWND hWndParent)
{
int i=0;
/* WARNING: The order here MUST be the same order as is used down below
   where handles are assigned to the various buttons, otherwise you will
   get strange results as buttons are given different handles than intended.
 */

Buttons[i].idBtn     = IDM_ZIP_TARGET;
Buttons[i].ButtonHelp = "Create/Update Archive\0";
Buttons[i++].hBMP = "ARCHIVE_BUTTON\0";

Buttons[i].idBtn     = IDM_OPEN;
Buttons[i].ButtonHelp = "Open Archive\0";
Buttons[i++].hBMP = "OPEN_BUTTON\0";

Buttons[i].idBtn     = IDM_EXTRACT;
Buttons[i].ButtonHelp = "Extract File(s) From Archive\0";
Buttons[i++].hBMP = "EXTRACT_BUTTON\0";

Buttons[i].idBtn     = IDM_CHDIR;
Buttons[i].ButtonHelp = "Unzip To Directory\0";
Buttons[i++].hBMP = "UNZIPTODIR_BUTTON\0";

Buttons[i].idBtn     = IDM_SELECT_ALL;
Buttons[i].ButtonHelp = "Select All Files\0";
Buttons[i++].hBMP = "SELECTALL_BUTTON\0";

Buttons[i].idBtn     = IDM_DESELECT_ALL;
Buttons[i].ButtonHelp = "De-Select All Files\0";
Buttons[i++].hBMP = "DESELECTALL_BUTTON\0";

Buttons[i].idBtn     = IDM_SELECT_BY_PATTERN;
Buttons[i].ButtonHelp = "Select Files By Pattern\0";
Buttons[i++].hBMP = "SELECTPATTERN_BUTTON\0";
#ifdef MAX_BUTTONS
Buttons[i].idBtn     = IDM_DISPLAY;
Buttons[i].ButtonHelp = "Display File From Archive\0";
Buttons[i++].hBMP = "DISPLAY_BUTTON\0";

Buttons[i].idBtn     = IDM_TEST;
Buttons[i].ButtonHelp = "Test Archive\0";
Buttons[i++].hBMP = "TEST_BUTTON\0";

Buttons[i].idBtn     = IDM_GET_ZIPINFO;
Buttons[i].ButtonHelp = "Get Zip Information\0";
Buttons[i++].hBMP = "GET_ZIPINFO_BUTTON\0";

Buttons[i].idBtn     = IDM_SHOW_COMMENT;
Buttons[i].ButtonHelp = "Show Comment\0";
Buttons[i++].hBMP = "COMMENT_BUTTON\0";

Buttons[i].idBtn     = IDM_COPY_ARCHIVE;
Buttons[i].ButtonHelp = "Copy Archive\0";
Buttons[i++].hBMP = "COPY_BUTTON\0";

Buttons[i].idBtn     = IDM_MOVE_ARCHIVE;
Buttons[i].ButtonHelp = "Move Archive\0";
Buttons[i++].hBMP = "MOVE_BUTTON\0";

Buttons[i].idBtn     = IDM_RENAME_ARCHIVE;
Buttons[i].ButtonHelp = "Rename Archive\0";
Buttons[i++].hBMP = "RENAME_BUTTON\0";

Buttons[i].idBtn     = IDM_MAKE_DIR;
Buttons[i].ButtonHelp = "Make Directory\0";
Buttons[i++].hBMP = "MAKEDIR_BUTTON\0";
#endif
Buttons[i].idBtn     = IDM_DELETE_ARCHIVE;
Buttons[i].ButtonHelp = "Delete Archive\0";
Buttons[i++].hBMP = "DELETE_BUTTON\0";

Buttons[i].idBtn     = IDM_CLEAR_STATUS;
Buttons[i].ButtonHelp = "Clear Status/Display Window\0";
Buttons[i++].hBMP = "CLEARSTATUS_BUTTON\0";

Buttons[i].idBtn     = IDM_STATUS;
Buttons[i].ButtonHelp = "Hide Edit/Status Window\0";
Buttons[i++].hBMP = "STATUS_BUTTON\0";

Buttons[i].idBtn     = IDM_EXIT;
Buttons[i].ButtonHelp = "Exit WiZ\0";
Buttons[i++].hBMP = "EXIT_BUTTON\0";

Buttons[i].idBtn     = IDM_HELP;
Buttons[i].ButtonHelp = "WiZ Help\0";
Buttons[i++].hBMP = "HELP_BUTTON\0";

Buttons[i].idBtn     = 0;
Buttons[i].ButtonHelp = NULL;
Buttons[i].hWndBtn   = NULL;

ButtonBar(hWndParent, Buttons);
return;
}

void ButtonBar(HWND hWndParent, LPBUTTON lpButton)
{
int          i, x;
RECT         rect;

hWndButtonBarOwner  = hWndParent;
WinAssert(hWndParent);
GetWindowRect(hWndParent, &rect);
hWndButtonBar = CreateWindow("ButtonBar", NULL,
        WS_VISIBLE | WS_CLIPSIBLINGS |WS_DLGFRAME| WS_CHILD,
        0, 0,
        rect.right - rect.left,
        (int)(2.1 * dyChar),
        hWndButtonBarOwner,
        (HMENU) NULL,
        (HINSTANCE) hInst,
        NULL);
WinAssert(hWndButtonBar);
ShowWindow(hWndButtonBar, SW_SHOW);
GetClientRect(hWndButtonBar, &rect);
Height = rect.bottom;
BtnSeparator = 1;   /* Set distance between buttons back to 1 */
BtnMult = (float)BTNWIDTH; /* Reset multiplier to original setting */
Width = (int)(BtnMult*dxChar);

WinAssert(hWndParent);
#ifdef RESIZE_BUTTONS
GetClientRect(hWndParent, &rect);
if (((Width * NUMOFBUTTONS) + NUMOFBUTTONS) > rect.right)
   {
   while (BtnMult > MIN_BTN_WIDTH)
      {
      BtnMult = (float)(BtnMult - 0.1);
      Width = (int)(BtnMult*dxChar);
      if (((Width * NUMOFBUTTONS) + NUMOFBUTTONS) < rect.right)
         continue;
      }
   }

/* Last ditch effort to get all the buttons on the screen */
if (((Width * NUMOFBUTTONS) + NUMOFBUTTONS) > rect.right)
   {
   BtnSeparator = 0;
   }
#endif
x = BtnSeparator;

for (lpIB = lpButton; lpIB->idBtn != 0; lpIB++)
    {
    if (lpIB->idBtn == -1)
       continue;
    (lpIB->hWndBtn) = CreateWindow("BUTTON", "",
                      WS_VISIBLE | BS_OWNERDRAW | WS_CHILD,
                      x, 0,
                      Width, Height,
                      hWndButtonBar,
                      (HMENU) lpIB->idBtn, (HINSTANCE) hInst, NULL );
    SubClassButton (lpIB->hWndBtn, SubClassBtnProc);
    x += Width + BtnSeparator;
    }
/* WARNING: The order here MUST be the same order as is used above
   where the various buttons are created, otherwise you will
   get strange results as buttons are given different handles than
   intended.
 */

i = 0;
hArchive       = Buttons[i++].hWndBtn;
hOpen          = Buttons[i++].hWndBtn;
hExtract       = Buttons[i++].hWndBtn;
hUnzipToDir    = Buttons[i++].hWndBtn;
hSelectAll     = Buttons[i++].hWndBtn;
hDeselectAll   = Buttons[i++].hWndBtn;
hSelectPattern = Buttons[i++].hWndBtn;
#ifdef MAX_BUTTONS
hDisplay       = Buttons[i++].hWndBtn;
hTest          = Buttons[i++].hWndBtn;
hZipInfo       = Buttons[i++].hWndBtn;
hShowComment   = Buttons[i++].hWndBtn;
hCopyArchive   = Buttons[i++].hWndBtn;
hMoveArchive   = Buttons[i++].hWndBtn;
hRenameArchive = Buttons[i++].hWndBtn;
hMakeDir       = Buttons[i++].hWndBtn;
#endif
hDeleteArchive = Buttons[i++].hWndBtn;
hClearStatus   = Buttons[i++].hWndBtn;
hStatusButton  = Buttons[i++].hWndBtn;
hExit          = Buttons[i++].hWndBtn;
hHelp          = Buttons[i].hWndBtn;

return;
}

void MoveButtons(void)
{
int x = BtnSeparator;

for (lpIB = Buttons; lpIB->idBtn != 0; lpIB++)
    {
    WinAssert(lpIB->hWndBtn);
    MoveWindow(lpIB->hWndBtn, x, 0, Width, Height, FALSE);
    x += Width + BtnSeparator;
    }
}

LRESULT WINAPI ButtonBarWndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
HPEN             hPen, hOldPen;
HBRUSH           hBrush;
LPDRAWITEMSTRUCT lpdis;
HDC              hdcMem;
HBITMAP          hBitmap;
long             flag;
int              i;

switch(message)
   {
   case WM_COMMAND:
        SendMessage(hWndButtonBarOwner, message, wParam, lParam);
        return(FALSE);

   case WM_DRAWITEM:
        lpdis = (LPDRAWITEMSTRUCT) lParam;
        lpIB = Buttons;
        for (i=0;;i++)
           {
           if (lpIB[i].idBtn == 0)
               return (FALSE); /* Not one of our controls */
           if (lpIB[i].idBtn == (signed int)lpdis->CtlID)
               break;          /* Found the right control */
           }
        if (lpIB[i].idBtn == IDM_STATUS)
           {
           if (!lstrcmp(lpIB[i].hBMP, "STATUS_BUTTON\0"))
              {
              lpIB[i].ButtonHelp = "Hide Edit/Status Window\0";
              lpIB[i].hBMP = "LTSTATUS_BUTTON\0";
              ModifyMenu(hMenu, IDM_MAX_STATUS, MF_BYCOMMAND |
                 MF_ENABLED, IDM_MAX_STATUS,
                 "Hide Edit/Status Window");
              /* If we do a ShowWindow(hWndStatic, SW_SHOWNA) (which is what
                 you would expect to do), if you hide, then unhide the status
                 window, then minimize the main application, the status
                 window will remain up. Hence this little tap dance here.
               */  
              ShowWindow(hWndStatic, SW_SHOW);
              SetActiveWindow(hWndMain);
              }
           else
              {
              lpIB[i].ButtonHelp = "Show Edit/Status Window\0";
              lpIB[i].hBMP = "STATUS_BUTTON\0";
              ModifyMenu(hMenu, IDM_MAX_STATUS, MF_BYCOMMAND |
                 MF_ENABLED, IDM_MAX_STATUS,
                 "Show Edit/Status Window");
              ShowWindow(hWndStatic, SW_HIDE);
              }
           }
        lpdis->rcItem.right = Width;
        lpdis->rcItem.bottom = Height;

        lpdis->rcItem.right--;
        lpdis->rcItem.bottom--;

        hBrush = CreateSolidBrush(GetSysColor(COLOR_MENU));
        FillRect(lpdis->hDC, &lpdis->rcItem, hBrush);
        DeleteObject(hBrush);
        hOldPen = SelectObject(lpdis->hDC, GetStockObject(BLACK_PEN));
        MoveToEx(lpdis->hDC,lpdis->rcItem.left,lpdis->rcItem.top, NULL);
        LineTo(lpdis->hDC,lpdis->rcItem.right,lpdis->rcItem.top);
        LineTo(lpdis->hDC,lpdis->rcItem.right,lpdis->rcItem.bottom);
        LineTo(lpdis->hDC,lpdis->rcItem.left,lpdis->rcItem.bottom);
        LineTo(lpdis->hDC,lpdis->rcItem.left,lpdis->rcItem.top);
        SelectObject(lpdis->hDC, hOldPen);
        lpdis->rcItem.left++;
        lpdis->rcItem.right--;
        lpdis->rcItem.top++;
        lpdis->rcItem.bottom--;
        if (!IsWindowEnabled(lpIB[i].hWndBtn))
           {
           flag = SRCINVERT;  /* "Gray" out button */
           }
        else
           {
           flag = SRCCOPY;
           }
        if (lpdis->itemState & ODS_SELECTED)
           {
           /* Button has been depressed - make it look depressed */
           hPen = CreatePen(PS_SOLID, 1, DKGRAY_PEN);
           hOldPen = SelectObject(lpdis->hDC, hPen);
           MoveToEx(lpdis->hDC,lpdis->rcItem.left,lpdis->rcItem.bottom,NULL);
           LineTo(lpdis->hDC,lpdis->rcItem.left,lpdis->rcItem.top);
           LineTo(lpdis->hDC, lpdis->rcItem.right, lpdis->rcItem.top);
           SelectObject(lpdis->hDC, hOldPen);
           DeleteObject(hPen);
           hdcMem = CreateCompatibleDC(lpdis->hDC);
           hBitmap = LoadBitmap(hInst, lpIB[i].hBMP);
           hOldPen = SelectObject(hdcMem, hBitmap);
           StretchBlt(lpdis->hDC,   /* device to be drawn */
              lpdis->rcItem.left+2, /* x upper left destination */
              lpdis->rcItem.top+2,  /* y upper left destination */
              lpdis->rcItem.right - lpdis->rcItem.left -2, /* width */
              lpdis->rcItem.bottom - lpdis->rcItem.top - 2,/* height */
              hdcMem, /* source bitmap */
              0,      /* x upper left source */
              0,      /* y upper left source */
              32,     /* source bitmap width */
              32,     /* source bitmap height */
              flag);
           SelectObject(hdcMem, hOldPen);
           DeleteDC(hdcMem);
           DeleteObject(hBitmap);
           }
        else
           {
           if (lpIB[i].idBtn == IDM_STATUS)
              {
              if (!lstrcmp(lpIB[i].hBMP, "STATUS_BUTTON\0"))
                 lpIB[i].hBMP = "LTSTATUS_BUTTON\0";
              else
                 lpIB[i].hBMP = "STATUS_BUTTON\0";
              }
           /* Draw button */
           hOldPen = SelectObject(lpdis->hDC, GetStockObject(WHITE_PEN));
           MoveToEx(lpdis->hDC,lpdis->rcItem.left,lpdis->rcItem.bottom,NULL);
           LineTo(lpdis->hDC,lpdis->rcItem.left,lpdis->rcItem.top);
           LineTo(lpdis->hDC,lpdis->rcItem.right,lpdis->rcItem.top);
           SelectObject(lpdis->hDC, hOldPen);
           hPen = CreatePen(PS_SOLID, 1, DKGRAY_PEN);
           hOldPen = SelectObject(lpdis->hDC, hPen);
           MoveToEx(lpdis->hDC,lpdis->rcItem.left,lpdis->rcItem.bottom,NULL);
           LineTo(lpdis->hDC,lpdis->rcItem.right,lpdis->rcItem.bottom);
           LineTo(lpdis->hDC,lpdis->rcItem.right,lpdis->rcItem.top);
           SelectObject(lpdis->hDC, hOldPen);
           DeleteObject(hPen);
           hdcMem = CreateCompatibleDC(lpdis->hDC);
           hBitmap = LoadBitmap(hInst, lpIB[i].hBMP);
           hOldPen = SelectObject(hdcMem, hBitmap);
           StretchBlt(lpdis->hDC,
              lpdis->rcItem.left+2,
              lpdis->rcItem.top+2,
              lpdis->rcItem.right - lpdis->rcItem.left -2,
              lpdis->rcItem.bottom - lpdis->rcItem.top - 2,
              hdcMem,
              0,
              0,
              32,
              32,
              flag); /* This flag makes it look either enabled or greyed */
           SelectObject(hdcMem, hOldPen);
           DeleteDC(hdcMem);
           DeleteObject(hBitmap);
           }
        return TRUE;
/* This section draws a line around the button bar to highlight. It was decided
   to take this out from the application, but the code is left here for those
   who want this feature.
           
   case WM_PAINT:
        {
        RECT             rect;
        PAINTSTRUCT      ps;
        
        BeginPaint(hWnd, &ps);
        WinAssert(hWnd);
        GetClientRect(hWnd, &rect);
        hOldPen = SelectObject(ps.hdc, GetStockObject(WHITE_PEN));
        MoveToEx(ps.hdc, rect.left, rect.top, NULL);
        LineTo(ps.hdc, rect.right+1, rect.top);
        SelectObject(ps.hdc, hOldPen);
        hPen = CreatePen(PS_SOLID, 1, DKGRAY_PEN);
        hOldPen = SelectObject(ps.hdc, hPen);
        MoveToEx(ps.hdc, rect.left, rect.bottom-2, NULL);
        LineTo(ps.hdc, rect.right+1, rect.bottom-2);
        SelectObject(ps.hdc, hOldPen);
        DeleteObject(hPen);
        hPen = CreatePen( PS_SOLID, 1, BLACK_PEN);
        hOldPen = SelectObject(ps.hdc, hPen);
        MoveToEx(ps.hdc, rect.left, rect.bottom-1, NULL);
        LineTo(ps.hdc, rect.right+1, rect.bottom-1);
        SelectObject(ps.hdc, hOldPen);
        DeleteObject(hPen);
        EndPaint(hWnd, &ps);
        return (FALSE);
        }
*/
   default:
      return(DefWindowProc(hWnd, message, wParam, lParam));
   }
}

