/*
 Copyright (C) 1996 Mike White
 Permission is granted to any individual or institution to use, copy, or
 redistribute this software so long as all of the original files are included,
 that it is not sold for profit, and that this copyright notice is retained.

*/

#include <windows.h>
#include <stdio.h>
#include "wiz.h"
#ifdef __BORLANDC__
#include <dir.h>
#else
#include <direct.h>
#endif
#include "helpids.h"

char szRefDir[PATH_MAX];

/****************************************************************************

    FUNCTION: GetDirProc(HWND, unsigned, WPARAM, LPARAM)

    PURPOSE:  Processes messages for "Set Reference Dir Procedure for
              Update Archive" dialog box

    MESSAGES:

    WM_INITDIALOG - initialize dialog box
    WM_COMMAND    - Input received

****************************************************************************/

#ifdef __BORLANDC__
#pragma warn -par
#pragma warn -aus
#endif
BOOL WINAPI
GetDirProc(HWND hwndDlg, WORD wMessage, WPARAM wParam, LPARAM lParam)
{
HWND hTemp;

   switch (wMessage) {
   case WM_INITDIALOG:
      hTemp = GetDlgItem(hwndDlg, lst1);
      WinAssert(hTemp);
      EnableWindow(hTemp, FALSE);
      ShowWindow(hTemp, SW_HIDE);
      hTemp = GetDlgItem(hwndDlg, edt1);
      WinAssert(hTemp);
      EnableWindow(hTemp, FALSE);
      ShowWindow(hTemp, SW_HIDE);

      szRefDir[0] = '\0';
      CenterDialog(GetParent(hwndDlg), hwndDlg); /* center on parent */
      break;
   case WM_COMMAND:
      switch (LOWORD(wParam)) {
         case IDC_SET_REF:
            getcwd(szRefDir, PATH_MAX);
            SetWindowText(GetDlgItem(hwndDlg, IDC_REF_DIR), szRefDir);
            break;
         case IDC_FREE_REF:
            szRefDir[0] = '\0';
            SetWindowText(GetDlgItem(hwndDlg, IDC_REF_DIR), szRefDir);
            break;
         case IDCANCEL:
            szRefDir[0] = '\0';
            EndDialog(hwndDlg, FALSE);
            break;
         case IDOK:
            EndDialog(hwndDlg, TRUE);
            break;
         }
      default:
         break;
   }
   return FALSE;
}
#ifdef __BORLANDC__
#pragma warn .aus
#pragma warn .par
#endif

