/* edit.c -- the editor module of WiZ
 * Author Mike White
 */
#include "wiz.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>
#include <string.h>
#include <ctype.h>
#include <io.h>
#include <stdio.h>
#include <stdarg.h>

HMENU hStaticMenu;

LRESULT WINAPI StaticWndProc(HWND hWnd, WORD wMessage, WPARAM wParam, LPARAM lParam)
{
RECT rectT;
switch (wMessage)
    {
    case WM_SIZE:
        GetClientRect(hWndStatic, &rectT);
        MoveWindow(hWndEdit,
                rectT.left, rectT.top,
                rectT.right, rectT.bottom,
                FALSE);
        ShowWindow(hWndEdit, SW_SHOW);
        break;
    case WM_INITMENU:
      {
        UINT fEnable;
        UINT ichStart, ichEnd;
      hStaticMenu = GetMenu(hWndStatic);
        if (!hStaticMenu)
            return 0;
        fEnable = (UINT)SendMessage(hWndEdit, EM_CANUNDO, 0, 0);
        EnableMenuItem(hStaticMenu, IDM_EDIT_UNDO,
                    (fEnable ? MF_ENABLED : MF_DISABLED|MF_GRAYED)|MF_BYCOMMAND);

        /* Can we paste from the clipboard? */
        if (OpenClipboard(hWnd))
           {
           /* Only allow text */
           if (IsClipboardFormatAvailable(CF_TEXT) ||
              IsClipboardFormatAvailable(CF_OEMTEXT))
              fEnable = TRUE;
           else
              fEnable = FALSE;
           }
        CloseClipboard();
        EnableMenuItem(hStaticMenu, IDM_EDIT_PASTE,
                    (fEnable ? MF_ENABLED : MF_DISABLED|MF_GRAYED)|MF_BYCOMMAND);


        SendMessage(hWndEdit, EM_GETSEL, (WPARAM)&ichStart, (LPARAM)&ichEnd);
        fEnable = (ichStart != ichEnd);
        EnableMenuItem(hStaticMenu, IDM_EDIT_CUT,
                (fEnable ? MF_ENABLED : MF_DISABLED|MF_GRAYED)|MF_BYCOMMAND);
        EnableMenuItem(hStaticMenu, IDM_EDIT_COPY,
                (fEnable ? MF_ENABLED : MF_DISABLED|MF_GRAYED)|MF_BYCOMMAND);
        EnableMenuItem(hStaticMenu, IDM_EDIT_DELETE,
                (fEnable ? MF_ENABLED : MF_DISABLED|MF_GRAYED)|MF_BYCOMMAND);

        fEnable = (UINT)SendMessage(hWndEdit, WM_GETTEXTLENGTH, 0, 0);
        EnableMenuItem(hStaticMenu, IDM_EDIT_SELECT_ALL,
                (fEnable ? MF_ENABLED : MF_DISABLED|MF_GRAYED)|MF_BYCOMMAND);
        EnableMenuItem(hStaticMenu, IDM_CLEAR_STATUS,
                (fEnable ? MF_ENABLED : MF_DISABLED|MF_GRAYED)|MF_BYCOMMAND);
        EnableMenuItem(hStaticMenu, IDM_EDIT_SAVE_AS,
                (fEnable ? MF_ENABLED : MF_DISABLED|MF_GRAYED)|MF_BYCOMMAND);
      }
      break;

     case WM_COMMAND:
        switch (LOWORD(wParam))
            {
            case IDM_EDIT_OPEN_FILE:
                SendMessage(hWndMain, WM_COMMAND, (WPARAM)IDM_EDIT_OPEN_FILE, 0);
                break;
            case IDM_EDIT_SAVE_AS:
                SendMessage(hWndMain, WM_COMMAND, (WPARAM)IDM_EDIT_SAVE_AS, 0);
                break;
            case IDM_EDIT_UNDO:
                SendMessage(hWndEdit, EM_UNDO, 0, 0);
                break;
            case IDM_EDIT_CUT:
                SendMessage(hWndEdit, WM_CUT, 0, 0);
                break;
            case IDM_EDIT_COPY:
                SendMessage(hWndEdit, WM_COPY, 0, 0);
                break;
            case IDM_EDIT_PASTE:
                SendMessage(hWndEdit, WM_PASTE, 0, 0);
                break;
            case IDM_EDIT_DELETE:
                SendMessage(hWndEdit, WM_CLEAR, 0, 0);
                break;
            case IDM_EDIT_SELECT_ALL:
                SendMessage(hWndEdit, EM_SETSEL, (WPARAM)0,
                        (LPARAM)MAKELPARAM(0,-1));
            break;
         case IDM_CLEAR_STATUS:  
                SendMessage(hWndEdit, WM_COMMAND, IDM_CLEAR_STATUS, 0L);
                break;
            default:
                return DefWindowProc(hWnd, wMessage, wParam, lParam);
         }
    default:
        return DefWindowProc(hWnd, wMessage, wParam, lParam);
    }
return DefWindowProc(hWnd, wMessage, wParam, lParam);
}

extern FARPROC lpOldEditProc;
LRESULT CALLBACK SubClassEditProc(HWND hWnd, WORD message, WPARAM wParam, LPARAM lParam)
{
switch (message)
    {
   case WM_COMMAND:
        switch (LOWORD(wParam))
            {
            case IDM_EDIT_UNDO:
                SendMessage(hWndEdit, EM_UNDO, 0, 0);
                break;
            case IDM_EDIT_CUT:
                SendMessage(hWndEdit, WM_CUT, 0, 0);
                break;
            case IDM_EDIT_COPY:
                SendMessage(hWndEdit, WM_COPY, 0, 0);
                break;
            case IDM_EDIT_PASTE:
                SendMessage(hWndEdit, WM_PASTE, 0, 0);
                break;
            case IDM_EDIT_DELETE:
                SendMessage(hWndEdit, WM_CLEAR, 0, 0);
                break;
            case IDM_EDIT_SELECT_ALL:
                SendMessage(hWndEdit, EM_SETSEL, (WPARAM)0,
                        (LPARAM)MAKELPARAM(0,-1));
                break;
            case IDM_CLEAR_STATUS:
                {
#ifdef WIN32
                HGLOBAL hTemp;
                PARAFORMAT pf;
#endif
                SetWindowText(hWndStatic, "WiZ Edit/Status Window");
#ifdef WIN32
                /* Reallocate the editor buffer to original size */
                GlobalUnlock(hEditor);
                hTemp = GlobalReAlloc(hEditor, EDIT_BUF_SIZE, GMEM_MOVEABLE);
                if (hTemp)
                   {
                   hEditor = hTemp;
                   dwEditBufSize = EDIT_BUF_SIZE;
                   }
                pszBuffer = GlobalLock(hEditor);
                SendMessage(hWndEdit, EM_EXLIMITTEXT, (WPARAM)0,
                   (LPARAM)dwEditBufSize);
                memset(pszBuffer, '\0', dwEditBufSize);
#else
                _fmemset(pszBuffer, '\0', (unsigned int)dwEditBufSize);
#endif
                SendMessage(hWndEdit, WM_SETTEXT, 0, (LPARAM) pszBuffer);
#ifdef WIN32
                /* Insure alignment is set to left. Clearing sometimes seems
                   to cause centering with rich edit controls.
                 */
                pf.cbSize = sizeof(PARAFORMAT);

                SendMessage(hWndEdit, EM_GETPARAFORMAT, 0, (LPARAM) &pf);

                pf.dwMask = PFM_ALIGNMENT;     /* only change the alignment */
                pf.wAlignment = PFA_LEFT;
                SendMessage(hWndEdit, EM_SETPARAFORMAT, 0, (LPARAM) &pf);

#endif
                break;
                }
            default:
                return DefWindowProc(hWnd, message, wParam, lParam);
         }
      }
return (CallWindowProc((FARPROC)(lpOldEditProc), hWnd, message, wParam, lParam));
}

