/* Action.c module of WizUnZip.
 * Author: Robert A. Heath, 1993
 * I, Robert Heath, place this source code module in the public domain.
 *
 * Modifications: Mike White 1995, 1996
 * Now modified for WiZ - WizUnZip no longer exists
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#ifndef  WIN32
#  include <dos.h>
#  include <ctype.h>
#endif
#include "wiz.h"
#include "unzip\unzip.h"
#include "helpids.h"
#ifdef ZE_MEM
#undef ZE_MEM
#define ZE_MEM 4
#endif
#include "ziperr.h"

int argc;
char **argv;

extern BOOL fUpdateEntries;
extern BOOL fSpool;
extern char szRefDir[PATH_MAX];
extern LPSTR szFileList;
extern HANDLE hFileList;
unsigned long dSpaceToUse;

char __based(__segname("STRINGS_TEXT")) szNoMemory[] =
            "Insufficient memory for this operation!";

char __based(__segname("STRINGS_TEXT")) szCantChDir[] =
         "Can't change directory to %s!";

BOOL IsValidArchive(LPSTR archive)
{
int retcode, AllCodes = FALSE;

hSaveCursor = SetCursor(hHourGlass);
ShowCursor(TRUE);
retcode = (*Unz_Validate)((char *)archive, AllCodes);
ShowCursor(FALSE);
SetCursor(hSaveCursor);
return retcode;
}

/* Get Selection Count returns a count of the selected
 * list box items. If the count is  greater than zero, it also returns
 * a pointer to a locked list in local memory of the item nos.
 * and their local memory handle.
 *
 * A value of -1 indicates an error.
 *
 * Note the WIN32 version does not use the parameter hListBox
 */

#ifdef __BORLANDC__
#pragma argsused
#endif
int CLBItemsGet(HWND hListBox, int __far * __far *ppnSelItems, HANDLE *phnd)
{
#ifndef WIN32
int cSelLBItems = (int)SendMessage(hListBox, LB_GETSELCOUNT, 0, 0L);
#else
int i, j, k = 0;
LV_ITEM lvi;
int cSelLBItems = ListView_GetSelectedCount(hWndList);
#endif

if ( !phnd )
   return -1;

*phnd = 0;
if (cSelLBItems)
   {
   *phnd = GlobalAlloc(GMEM_FIXED, cSelLBItems * sizeof(int));
   if ( !*phnd )
      return -1;

   *ppnSelItems = (int __far *)GlobalLock( *phnd );
   if ( !*ppnSelItems )
      {
      GlobalFree( *phnd );
      *phnd = 0;
      return -1;
      }

   /* Get list of selected items. Return value is number of selected items */
#ifndef WIN32
   if (SendMessage(hWndList, LB_GETSELITEMS, cSelLBItems, (LONG)*ppnSelItems) != cSelLBItems)
      {
      GlobalUnlock(*phnd);
      GlobalFree(*phnd);
      *phnd = 0;
      return -1;
      }
#else
   j = ListView_GetItemCount(hWndList);
   for (i = 0; i < j; i++)
      {
      lvi.mask      = LVIF_STATE;
      lvi.stateMask = LVIS_SELECTED;
      lvi.iItem     = i;
      lvi.iSubItem  = 0;

      ListView_GetItem(hWndList, &lvi);

      if (lvi.state)
         {
         (*ppnSelItems)[k++] = i;
         }
      }
#endif
   }
   return cSelLBItems;
}

#ifndef WIN32
/* Re-select listbox contents from given list. The pnSelItems is a
 * list containing the indices of those items selected in the listbox.
 * This list was probably created by GetLBSelCount() above.
 *
 * This routine is only called from wndproc.c when switching between
 * the long and short format. As the short format is not supported
 * by the Win32 version, this routine is not necessary.
 *
 */
void ReselectLB(HWND hListBox, int cSelLBItems, int __far *pnSelItems)
{
int i;

for (i = 0; i < cSelLBItems; ++i)
   {
   SendMessage(hListBox, LB_SETSEL, TRUE, MAKELPARAM(pnSelItems[i],0));
   }
}
#endif

/* Action is called on double-clicking, or selecting one of the
 * main action buttons. The action code is the action
 * relative to the listbox or the button ID.
 */
void Action(HWND hWnd, WPARAM wActionCode)
{
HANDLE  hMem;
int i;
int iSelection;
int cch;
unsigned long dFreeSpace, dStrlen = 0;
int cSelLBItems;
int __far *pnSelItems;  /* pointer to list of selected items */
#ifndef WIN32
struct diskfree_t df;
#else
DWORD SectorsPerCluster, BytesPerSector, FreeClusters, Clusters;
#endif
HANDLE  hnd = 0;
char **pszIndex;
char *sz;
LPSTR lpszT;
#ifndef WIN32
WORD wIndex = (WORD)(!uf.fFormatLong ? SHORT_FORM_FNAME_INX
   : LONG_FORM_FNAME_INX);
#endif

cSelLBItems = CLBItemsGet(hWndList, &pnSelItems, &hnd);
/* if no items were selected */
if (cSelLBItems < 1)
   return;

    /* Note: this global value can be overriden in replace.c */
uf.fDoAll = (lpDCL->noflag) ? 1 : 0;

SetCapture(hWnd);
hSaveCursor = SetCursor(hHourGlass);
ShowCursor(TRUE);

    /* If all the files are selected pass in no filenames */
    /* since unzipping all files is the default */
hMem = GlobalAlloc( GPTR, (PATH_MAX * 2));
if ( !hMem )
   goto done;
lpszT = (LPSTR)GlobalLock( hMem );
if ( !lpszT )
   {
   GlobalFree( hMem );
   goto done;
   }

hFileList = GlobalAlloc( GPTR, FILENAME_BUF_SIZE);
szFileList = (LPSTR)GlobalLock(hFileList);
if (!szFileList)
   {
   GlobalFree(hFileList);
   goto done;
   }

argc = ((WORD)cSelLBItems == cZippedFiles) ? 0 : 1;
iSelection = 0;
do
   {
   if ((argc) || (fUpdateEntries))
      {
      dSpaceToUse = 0;
      pszIndex = (char **)szFileList;
      cch = (sizeof(char *) * ((cSelLBItems > cchFilesMax-1 ) ? cchFilesMax :
         cSelLBItems+1));
      sz = szFileList + cch;

      for (i=0; ((i+iSelection) < cSelLBItems) && (i < cchFilesMax-1); ++i)
         {
#ifndef WIN32
         cch = (int)SendMessage(hWndList, LB_GETTEXTLEN, pnSelItems[i+iSelection], 0L);
         if (cch != LB_ERR)
            {
            cch = (int)SendMessage(hWndList, LB_GETTEXT, pnSelItems[i+iSelection], (LONG)lpszT);
            if ((cch != LB_ERR) && (cch > (int)wIndex))
               {
               /* Get uncompressed totals to pre-flight the extraction process
                * The pre-flight portion of this needs to be modified to occur
                * only during actual extraction to disk.
                */
               strncpy(sz, lpszT, 9);
               sz[9] = '\0';
               dSpaceToUse += atol(sz);
               lstrcpy(sz, lpszT+wIndex);
               dStrlen += lstrlen(sz) + 1;
               if (dStrlen > FILENAME_BUF_SIZE )
                  {
                  MessageBox(hWndMain, "Try selecting fewer files at a time",
                  "Insufficient Memory", MB_OK |MB_SYSTEMMODAL|
                  MB_ICONEXCLAMATION);
                  goto done;
                  }
               pszIndex[i] = sz;
               sz += (cch + 1 - wIndex);
               }
            else
               {
               break;
               }
            }
         else
            {
            MessageBeep(1);
            goto done;
            }
#else
         /* Get uncompressed totals to pre-flight the extraction process
          * The pre-flight portion of this needs to be modified to occur
          * only during actual extraction to disk.
          */
         ListView_GetItemText(hWndList, pnSelItems[i+iSelection], 1, lpszT,
               (PATH_MAX * 2));
         lstrcpy(sz, lpszT);
         dSpaceToUse += atol(sz);

         /* Now we get the actual name */        
         ListView_GetItemText(hWndList, pnSelItems[i+iSelection], 0, lpszT,
               (PATH_MAX * 2));
         lstrcpy(sz, lpszT+1);
         dStrlen += lstrlen(sz) + 1;
         if (dStrlen > FILENAME_BUF_SIZE )
            {
            MessageBox(hWndMain, "Try selecting fewer files at a time",
            "Insufficient Memory", MB_OK |MB_SYSTEMMODAL|
            MB_ICONEXCLAMATION);
            goto done;
            }
         pszIndex[i] = sz;
         sz += (strlen(lpszT) + 1);
#endif
         } /* end of for loop */
      if (i == 0)
         {
         goto done;
         }
      argc = i;

      pszIndex[i] = 0;
      iSelection += i;
      }
   else
      {
      iSelection = cSelLBItems;
      }

switch (wActionCode)
   {
#ifdef WIN32
   char tempChar;
#endif
   int Ok;
   case 0:         /* extract button */
         /* Get amount of free space on target drive */
#ifndef WIN32
          _dos_getdiskfree((toupper(szUnzipToDirName[0]) - 'A'+1), &df);
          dFreeSpace = (long)df.avail_clusters *
                       ((long)df.sectors_per_cluster *
                       (long)df.bytes_per_sector);
#else
         tempChar = szUnzipToDirName[3];
         szUnzipToDirName[3] = '\0';
			GetDiskFreeSpace(szUnzipToDirName, &SectorsPerCluster,
			                 &BytesPerSector, &FreeClusters, &Clusters);
         szUnzipToDirName[3] = tempChar;
         dFreeSpace = (long)SectorsPerCluster * (long)BytesPerSector * (long)FreeClusters;
#endif
         if (dFreeSpace < dSpaceToUse)
            {
            sprintf(sz, "Free Disk Space = %lu bytes\nUncompressed Files Total %lu bytes\nContinue?\n",
               dFreeSpace, dSpaceToUse);
            Ok = MessageBox(hWndMain, sz, "Insufficient Disk Space?", MB_OKCANCEL |
               MB_ICONEXCLAMATION);
            }
         else
            Ok = IDOK;
         if (Ok != IDOK)
            break;
         lpDCL->ncflag = 0;
         lpDCL->fQuiet = 0;
         lpDCL->ntflag = 0;
         lpDCL->nvflag = 0;
         lpDCL->nUflag = lpDCL->ExtractOnlyNewer;
         lpDCL->nzflag = 0;
         lpDCL->ndflag = (int)(uf.fRecreateDirs ? 1 : 0);
         lpDCL->noflag = uf.fDoAll;
         lpDCL->naflag = (int)(uf.fTranslate ? 1 : 0);
         lpDCL->lpszZipFN = lpumb->szFileName;
         argv = (char **)szFileList;
         if (!uf.fUnzipToZipDir && szUnzipToDirName[0])
            {
            lstrcpy(lpumb->szBuffer, szUnzipToDirName); /* OK to clobber szBuffer! */
            }
         hSaveCursor = SetCursor(hHourGlass);
         ShowCursor(TRUE);
         if (szUnzipToDirName[0])
            lpDCL->lpszExtractDir = szUnzipToDirName;
         else
				lpDCL->lpszExtractDir = NULL;
         Unz_SingleEntryPoint(argc, argv, 0, NULL, lpDCL, lpUserFunctions);
			ShowCursor(FALSE);
         SetCursor(hSaveCursor);
         ShowCursor(TRUE);
         if (!uf.fUnzipToZipDir && szUnzipToDirName[0])
            {
            lstrcpy(lpumb->szBuffer, lpumb->szDirName); /* OK to clobber szBuffer! */
            }
         break;
        case 1:     /* display to message window */
            {
            int rc; /* return code */
            bRealTimeMsgUpdate = FALSE;
            lpDCL->fQuiet = 2; /* Kill all messages */
            lpDCL->ncflag = 1;
            lpDCL->ntflag = 0;
            lpDCL->nvflag = 0;
            lpDCL->nUflag = 1;
            lpDCL->nzflag = 0;
            lpDCL->ndflag = 0;
            lpDCL->noflag = 0;
            lpDCL->naflag = TRUE;
            lpDCL->nZIflag = 0;
            lpDCL->lpszZipFN = lpumb->szFileName;
            argv = (char **)szFileList;
            hSaveCursor = SetCursor(hHourGlass);
            ShowCursor(TRUE);
            lpDCL->lpszExtractDir = NULL;
				rc = Unz_SingleEntryPoint(argc, argv, 0, NULL, lpDCL, lpUserFunctions);
				if (rc == IZ_UNSUP)
               BufferOut("%s is an encrypted file. Encryption not supported in this version",
                         argv[0]);
            SetWindowText(hWndStatic, argv[0]);
            ShowCursor(FALSE);
            SetCursor(hSaveCursor);
            bRealTimeMsgUpdate = TRUE;

            /* Following extraction to status window, user will want
             * to scroll around, so put him/her in Edit/Status window.
             */
            if (rc != IZ_UNSUP)
               PostMessage(hWnd, WM_COMMAND, IDM_SETFOCUS_ON_STATUS, 0L);
            fSpool = FALSE;
            }
            break;
        case 2:     /* test */
            lpDCL->ncflag = 0;
            lpDCL->fQuiet = 0;
            lpDCL->ntflag = 1;
            lpDCL->nvflag = 0;
            lpDCL->nUflag = 1;
            lpDCL->nzflag = 0;
            lpDCL->ndflag = 0;
            lpDCL->noflag = 0;
            lpDCL->naflag = 0;
            lpDCL->nZIflag = 0;
            lpDCL->lpszZipFN = lpumb->szFileName;
            argv = (char **)szFileList;
            hSaveCursor = SetCursor(hHourGlass);
            ShowCursor(TRUE);
            lpDCL->lpszExtractDir = NULL;
				Unz_SingleEntryPoint(argc, argv, 0, NULL, lpDCL, lpUserFunctions);
				ShowCursor(FALSE);
            SetCursor(hSaveCursor);
            break;
        case 3:     /* Get Zip Information */
            {
            lpDCL->fQuiet = 2;
            lpDCL->ncflag = 0;
            lpDCL->ntflag = 0;
            lpDCL->nvflag = 0;
            lpDCL->nUflag = 0;
            lpDCL->nzflag = 0;
            lpDCL->ndflag = 0;
            lpDCL->noflag = 0;
            lpDCL->naflag = 0;
            lpDCL->nZIflag = 1;
            lpDCL->lpszZipFN = lpumb->szFileName;
            argv = (char **)szFileList;
            hSaveCursor = SetCursor(hHourGlass);
            ShowCursor(TRUE);
            lpDCL->lpszExtractDir = NULL;
				Unz_SingleEntryPoint(argc, argv, 0, NULL, lpDCL, lpUserFunctions);
            
				ShowCursor(FALSE);
				SetCursor(hSaveCursor);
            lpDCL->nZIflag = 0;
            lpDCL->fQuiet = 0;
            break;
            }
        case 4:     /* Delete Archive Entries */
            {
            int retcode;
            /* Save off zip flags */
            BOOL fSuffix = ZpOpt.fSuffix;
            BOOL fEncrypt = ZpOpt.fEncrypt;
            BOOL fSystem = ZpOpt.fSystem;
            BOOL fVolume = ZpOpt.fVolume;
            BOOL fExtra = ZpOpt.fExtra;
            BOOL fNoDirEntries = ZpOpt.fNoDirEntries;
            BOOL fExcludeDate = ZpOpt.fExcludeDate;
            BOOL fVerbose = ZpOpt.fVerbose;
            BOOL fQuiet = ZpOpt.fQuiet;
            BOOL fCRLF_LF = ZpOpt.fCRLF_LF;
            BOOL fLF_CRLF = ZpOpt.fLF_CRLF;
            BOOL fJunkDir = ZpOpt.fJunkDir;
            BOOL fRecurse = ZpOpt.fRecurse;
            BOOL fGrow = ZpOpt.fGrow;
            BOOL fForce = ZpOpt.fForce;
            BOOL fMove = ZpOpt.fMove;
            BOOL fUpdate = ZpOpt.fUpdate;
            BOOL fFreshen = ZpOpt.fFreshen;
            BOOL fJunkSFX = ZpOpt.fJunkSFX;
            BOOL fLatestTime = ZpOpt.fLatestTime;
            BOOL fmakesfx = fMakeSFX;
            BOOL fComment = ZpOpt.fComment;
            BOOL fOffsets = ZpOpt.fOffsets;

            /* Set all zip flags to false */
            ZpOpt.fSuffix = FALSE;
            ZpOpt.fEncrypt = FALSE;
            ZpOpt.fSystem = FALSE;
            ZpOpt.fVolume = FALSE;
            ZpOpt.fExtra = FALSE;
            ZpOpt.fNoDirEntries = FALSE;
            ZpOpt.fExcludeDate = FALSE;
            ZpOpt.fVerbose = FALSE;
            ZpOpt.fQuiet = FALSE;
            ZpOpt.fCRLF_LF = FALSE;
            ZpOpt.fLF_CRLF = FALSE;
            ZpOpt.fJunkDir = FALSE;
            ZpOpt.fRecurse = FALSE;
            ZpOpt.fGrow = FALSE;
            ZpOpt.fForce = FALSE;
            ZpOpt.fMove = FALSE;
            ZpOpt.fUpdate = FALSE;
            ZpOpt.fFreshen = FALSE;
            ZpOpt.fJunkSFX = FALSE;
            ZpOpt.fLatestTime = FALSE;
            ZpOpt.fComment = FALSE;
            ZpOpt.fOffsets = FALSE;
            fMakeSFX = FALSE;

            ZpOpt.fDeleteEntries = TRUE;
            ZpZCL.argc = argc;
            ZpZCL.lpszZipFN = lpumb->szFileName;
            ZpZCL.FNV = (char **)szFileList;
            retcode = MessageBox(hWndMain, "Are You Sure?",
               "Deleting Archive Entries",
               MB_OKCANCEL | MB_ICONEXCLAMATION);
            if (retcode == IDOK)
               {
               BufferOut( "Deleting Files From Archive: %s\n",
                  lpumb->szFileName);
               hSaveCursor = SetCursor(hHourGlass);
               ShowCursor(TRUE);
               ZipSetOptions(ZpOpt);
               retcode = ZipArchive(ZpZCL);
               ShowCursor(FALSE);
               SetCursor(hSaveCursor);
               if (retcode == ZE_OK)
                  UpdateListBox();
               }
            else
               BufferOut( "Deleting Files from archive canceled\n");
            /* Restore zip flags */
            ZpOpt.fDeleteEntries = FALSE;
            ZpOpt.fSuffix = fSuffix;
            ZpOpt.fEncrypt = fEncrypt;
            ZpOpt.fSystem = fSystem;
            ZpOpt.fVolume = fVolume;
            ZpOpt.fExtra = fExtra;
            ZpOpt.fNoDirEntries = fNoDirEntries;
            ZpOpt.fExcludeDate = fExcludeDate;
            ZpOpt.fVerbose = fVerbose;
            ZpOpt.fQuiet = fQuiet;
            ZpOpt.fCRLF_LF = fCRLF_LF;
            ZpOpt.fLF_CRLF = fLF_CRLF;
            ZpOpt.fJunkDir = fJunkDir;
            ZpOpt.fRecurse = fRecurse;
            ZpOpt.fGrow = fGrow;
            ZpOpt.fForce = fForce;
            ZpOpt.fMove = fMove;
            ZpOpt.fUpdate = fUpdate;
            ZpOpt.fFreshen = fFreshen;
            ZpOpt.fJunkSFX = fJunkSFX;
            ZpOpt.fLatestTime = fLatestTime;
            ZpOpt.fComment = fComment;
            ZpOpt.fOffsets = fOffsets;
            fMakeSFX = fmakesfx;
            }
            break;
        case 5:     /* Update Archive Entries */
            {
            int retcode;
#ifndef WIN32
            FARPROC lpGetDirProc;
#endif
            dwCommDlgHelpId = HELPID_ZIP_UPDATE_ARCHIVE;
            ZpZCL.argc = argc;
            ZpZCL.lpszZipFN = lpumb->szFileName;
            ZpZCL.FNV = (char **)szFileList;
            retcode = MessageBox(hWndMain, "Are You Sure?",
               "Update All Archive Entries",
               MB_OKCANCEL | MB_ICONEXCLAMATION);
            if (retcode == IDOK)
               {
               OPENFILENAME ofn;
               char szTemp[256];
#ifndef WIN32
               _fmemset(&ofn, '\0', sizeof(OPENFILENAME)); /* initialize struct */
#else
               memset(&ofn, '\0', sizeof(OPENFILENAME)); /* initialize struct */
#endif
               WinAssert(hWnd);
               szTemp[0] = '\0';
               ofn.lStructSize = sizeof(OPENFILENAME);
               ofn.hwndOwner = hWnd;
               ofn.hInstance = hInst;
               ofn.lpstrFilter = "All Files (*.*)\0*.*\0\0";
               ofn.nFilterIndex = 1;

               ofn.lpstrFile = szTemp;
               ofn.nMaxFile = PATH_MAX;
               ofn.lpstrFileTitle = NULL;
               ofn.nMaxFileTitle = PATH_MAX; /* ignored ! */
               ofn.lpstrTitle = (LPSTR)"Set Reference Directory";
               ofn.lpstrInitialDir = NULL;
               ofn.Flags = OFN_SHOWHELP | OFN_ENABLEHOOK | OFN_CREATEPROMPT |
                  OFN_HIDEREADONLY|OFN_ENABLETEMPLATE;
#ifndef WIN32
               lpGetDirProc = MakeProcInstance((FARPROC)GetDirProc, hInst);
#   ifndef MSC
               (UINT CALLBACK *)ofn.lpfnHook = (UINT CALLBACK *)lpGetDirProc;
#   else
               ofn.lpfnHook = lpGetDirProc;
#   endif
#else
               ofn.lpfnHook = (LPOFNHOOKPROC)GetDirProc;
#endif
               ofn.lpTemplateName = "GETDIR";   /* see getfiles.dlg   */
               if ((GetOpenFileName(&ofn)) &&
                  (szRefDir[0] != '\0'))
                  {
                  BufferOut( "Updating Files in Archive: %s\n",
                     lpumb->szFileName);
                  hSaveCursor = SetCursor(hHourGlass);
                  ShowCursor(TRUE);
                  ZipSetOptions(ZpOpt);
                  retcode = ZipArchive(ZpZCL);
                  ShowCursor(FALSE);
                  SetCursor(hSaveCursor);
                  if (retcode == ZE_OK)
                     UpdateListBox();
                  }
               }
            else
               BufferOut( "Updating archive canceled\n");
            break;
            }
          }
    } while (iSelection < cSelLBItems);


    /* march through list box checking what's selected
     * and what is not.
     */

done:

    if ( hMem )
       {
       GlobalUnlock( hMem );
       GlobalFree( hMem );
       }
    if (hFileList)
       {
       GlobalUnlock(hFileList);
       GlobalFree(hFileList);
       }
    GlobalUnlock(hnd);
    GlobalFree(hnd);


    ShowCursor(FALSE);
    SetCursor(hSaveCursor);
    ReleaseCapture();
    SoundAfter();      /* play sound afterward if requested */
    if (!uf.fIconSwitched)  /* if haven't already, switch icons */
    {
        HANDLE hIcon;

        hIcon = LoadIcon(hInst,"unzipped"); /* load final icon   */
        WinAssert(hIcon);
#ifndef WIN32
        SetClassWord(hWndMain, GCW_HICON, hIcon);
#else
        SetClassLong(hWndMain, GCL_HICON, (LONG)hIcon);
#endif
        uf.fIconSwitched = TRUE;    /* flag that we've switched it  */
    }
}

/* Display the archive comment using the Info-ZIP engine. */
void DisplayComment(HWND hWnd)
{

   SetCapture(hWnd);
   hSaveCursor = SetCursor(hHourGlass);
   ShowCursor(TRUE);
   bRealTimeMsgUpdate = FALSE;
   /* Called here when showing zipfile comment */
   lpDCL->ncflag = 0;
   lpDCL->fQuiet = 0;
   lpDCL->ntflag = 0;
   lpDCL->nvflag = 0;
   lpDCL->nUflag = 1;
   lpDCL->nzflag = 1;
   lpDCL->ndflag = 0;
   lpDCL->noflag = 0;
   lpDCL->naflag = 0;
   argc   = 0;
   lpDCL->lpszZipFN = lpumb->szFileName;
   argv = NULL;
   lpDCL->lpszExtractDir = NULL;
	Unz_SingleEntryPoint(argc, argv, 0, NULL, lpDCL, lpUserFunctions);
	ShowCursor(FALSE);
	SetCursor(hSaveCursor);
   bRealTimeMsgUpdate = TRUE;
   ReleaseCapture();
   SoundAfter();      /* play sound during if requested         */
}
