/* Author Mike White, 1996. Based on original WizUnZip code by
 * Robert Heath.
 */
#include <windows.h>    /* required for all Windows applications */
#include <stdio.h>
#include "wiz.h"
#include "unzip\unzip.h"
#include "wizver.h"
#include "api.h"

#ifndef WIN32
#define UNZIP_DLL_NAME "UnZip16"
#define DLL_VERSION "(16-bit Version)"
#define ZIP_DLL_NAME "Zip16"
#else
#define UNZIP_DLL_NAME "UnZip32"
#define DLL_VERSION "(32-bit Version)"
#define ZIP_DLL_NAME "Zip32"
#endif

/****************************************************************************

    FUNCTION: About(HWND, unsigned, WPARAM, LPARAM)

    PURPOSE:  Processes messages for "About" dialog box

    MESSAGES:

    WM_INITDIALOG - initialize dialog box
    WM_COMMAND    - Input received

****************************************************************************/

#ifdef __BORLANDC__
#pragma argsused
#endif
BOOL WINAPI
AboutProc(HWND hwndDlg, WORD wMessage, WPARAM wParam, LPARAM lParam)
{
UzpVer2 VersionUzp;
ZpVer   VersionZp;
char string[80];
#ifndef USE_UNZIP_LIB
typedef void (WINAPI * _get_unzip_ver) (UzpVer2 far *);
_get_unzip_ver GetUnzipVersion;
#endif
#ifndef USE_ZIP_LIB
typedef void (WINAPI * _get_zip_ver) (ZpVer far *);
_get_zip_ver GetZipVersion;
#endif

if ((wMessage == WM_CLOSE) ||
    (wMessage == WM_COMMAND && LOWORD(wParam) == IDOK))
        EndDialog(hwndDlg, TRUE);

if (wMessage == WM_INITDIALOG)
   {
#ifndef BETA
   sprintf(string, "%s %s", APPLICATION, DLL_VERSION);
   SetWindowText(hwndDlg, string);
#else
   SetWindowText(hwndDlg, "BETA - Do Not Distribute");
#endif

   sprintf(string, "Info-ZIP's WiZ version %d.%d.%d%s %s",
      WIZ_MAJORVER, WIZ_MINORVER, WIZ_PATCHLEVEL, WIZBETALEVEL,
      WIZ_VERSION_DATE);
   SetDlgItemText(hwndDlg, IDM_ABOUT_VERSION_INFO, string);

#ifndef USE_ZIP_LIB
   (_get_zip_ver) GetZipVersion =
      (_get_zip_ver)GetProcAddress(hZipDll, "ZpVersion");
   if (!GetZipVersion)
      {
      lstrcpy(string, "Cannot get ZpVersion address");
      }
   else
      {
      (*GetZipVersion)(&VersionZp);
      sprintf(string, "%s DLL Version %d.%d%d %s",
         ZIP_DLL_NAME,
         VersionZp.windll.major,
         VersionZp.windll.minor,
         VersionZp.windll.patchlevel,
         VersionZp.betalevel);
      }
#else
      ZpVersion(&VersionZp);
      sprintf(string, "%s Library Version %d.%d%d %s",
         ZIP_DLL_NAME,
         VersionZp.windll.major,
         VersionZp.windll.minor,
         VersionZp.windll.patchlevel,
         VersionZp.betalevel);
#endif
   SetDlgItemText(hwndDlg, IDM_ABOUT_ZIP_INFO, string);

#ifndef USE_UNZIP_LIB
   (_get_unzip_ver) GetUnzipVersion =
      (_get_unzip_ver)GetProcAddress(hUnzipDll, "UzpVersion2");
   if (!GetUnzipVersion)        
      {
      lstrcpy(string, "Cannot get UzpVersion address");
      }
   else
      {
      (*GetUnzipVersion)(&VersionUzp);
      sprintf(string, "%s DLL Version %d.%d%d %s",
         UNZIP_DLL_NAME,
         VersionUzp.windll.major,
         VersionUzp.windll.minor,
         VersionUzp.windll.patchlevel,
         VersionUzp.betalevel);
      }
#else
      UzpVersion2(&VersionUzp);
      sprintf(string, "%s Library Version %d.%d%d %s",
         UNZIP_DLL_NAME,
         VersionUzp.windll.major,
         VersionUzp.windll.minor,
         VersionUzp.windll.patchlevel,
         VersionUzp.betalevel);
#endif
   SetDlgItemText(hwndDlg, IDM_ABOUT_UNZIP_INFO, string);

   CenterDialog(GetParent(hwndDlg), hwndDlg);
   }
return ((wMessage == WM_CLOSE) || (wMessage == WM_INITDIALOG) || (wMessage == WM_COMMAND))
            ? TRUE : FALSE;
}

/*
 *      CenterDialog
 *
 *      Purpose:
 *              Moves the dialog specified by hwndDlg so that it is centered on
 *              the window specified by hwndParent. If hwndParent is null,
 *              hwndDlg gets centered on the screen.
 *
 *              Should be called while processing the WM_INITDIALOG message
 *              from the dialog's DlgProc().
 *
 *      Arguments:
 *              HWND    parent hwnd
 *              HWND    dialog's hwnd
 *
 *      Returns:
 *              Nothing.
 *
 */
void
CenterDialog(HWND hwndParent, HWND hwndDlg)
{
RECT    rectDlg;
RECT    rect;
int             dx;
int             dy;

if (hwndParent == NULL)
   {
   rect.top = rect.left = 0;
   rect.right = GetSystemMetrics(SM_CXSCREEN);
   rect.bottom = GetSystemMetrics(SM_CYSCREEN);
   }
else
   {
   GetWindowRect(hwndParent, &rect);
   }

GetWindowRect(hwndDlg, &rectDlg);
OffsetRect(&rectDlg, -rectDlg.left, -rectDlg.top);

dx = (rect.left + (rect.right - rect.left -
     rectDlg.right) / 2 + 4) & ~7;
dy = rect.top + (rect.bottom - rect.top -
     rectDlg.bottom) / 2;
WinAssert(hwndDlg);
MoveWindow(hwndDlg, dx, dy, rectDlg.right, rectDlg.bottom, 0);
}

