/* UnESP for UNIX  v0.1 beta       (C) 1999 A'rpi/ESP-team */

/* Extract files or list an .ESP archive file. */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <time.h>
#include <sys/types.h>
#include <utime.h>

extern char *getpass( const char * prompt ); /* #include <pwd.h> */

#include "unesp.h"

#define IN_BUFFSIZE 8192
#define OUT_BUFFSIZE 16384
#define PATH_MEM_SIZE 0x4000

#define MEMSIZE (DICT_SIZE+LOOK_AHEAD+OUT_BUFFSIZE)

#define INLINE static inline

/***********************************************************/

void fatal(char *str){ fprintf(stderr,"ESP: Fatal error: %s\n",str); exit(1);}

char cat_strings_temp[1024];

char *cat_strings(char *s1,char *s2,char *s3){
  sprintf(cat_strings_temp,"%s%s%s%s",s1?s1:"",s2?s2:"",s2?"/":"",s3?s3:"");
  return cat_strings_temp;
}

/***********************************************************/
int cmdchr=0;

int always_yes=0;
int always_no=0;
int wait4key=0;
int enable_beep=0;
int dirlist_mode=0;  /* 0=normal  1=binary  2=MC */

int dirlist_lines=0;
#define dirlist_maxlines 21

char *extract_path="";
char *extract_name=NULL;
int extract_name_flag=0;

/***********************************************************/

typedef struct fmask_st_ {
  struct fmask_st_ *next;
  char mask[1];
} fmask_st;

fmask_st *fmask_first=(fmask_st*)NULL;

void add_filemask(char *fmask){
  int i=(*fmask!='/' && strchr(fmask,'/')) ? 1 : 0;
  fmask_st *m=malloc(sizeof(fmask_st)+strlen(fmask)+i);
  if(!m) fatal("Not enough mem for filemasks");
  sprintf(m->mask,"%s%s",i?"/":"",fmask);
  m->next=fmask_first;
  fmask_first=m;
}

int check_filemask(char *path,char *name){
register fmask_st *f=fmask_first;
int path_len;
  if(!f) return 1;
  if(!path) path="";
  path_len=strlen(path);
  do{
    char *m=f->mask;
    if(*m=='/'){
      char *n=strrchr(m,'/');
      if(!(m==n && path_len==0)){
        ++m;
        if(path_len!=n-m) goto skip;
        if(strncmp(m,path,path_len)!=0) goto skip;
      }
      m=n+1;
//printf("Mask! path=%s  m=%s  n=%s\n",path,m,n);
    }
    if(strcmp(m,name)==0) return 1;  /* FIX IT!!! */
  skip:
    f=f->next;
  }while(f);
  return 0;
}

/***********************************************************/

typedef struct dirst_ {
  char name[12];
  char* path;
  byte attrib;
  byte selected;
  dword size;
  dword repsize;
  dword datetime;
  struct dirst_ *next;
} dirst;

dirst *dirst_first=(dirst*)NULL;
dirst *dirst_last=(dirst*)NULL;

/************ INPUT ********************/

byte in_buff[IN_BUFFSIZE];
FILE *in_file;
dword in_xor=0;

int buffer_read(byte **in_buff_pos){
  int i=fread(*in_buff_pos=in_buff,1,IN_BUFFSIZE,in_file);
  if(i>0 && in_xor){
    dword* p=(dword*)in_buff;
    do{ *p++ ^= in_xor;} while( (byte*)p < (in_buff+i) );
  }
  return i;  /* 0=EOF or -1=error or buffersize */
}

/************ OUTPUT FILES ******************/

INLINE int min(int x,int y){
  if(x<y) return x;
  return y;
}

void set_datetime(char *filename,dword datetime){
  struct utimbuf utb;
  struct tm t;
  int time=datetime&0xffff;
  int date=datetime>>16;
  
  t.tm_sec=2*(time&31);
  t.tm_min=(time>>5)&63;
  t.tm_hour=(time>>11)&31;
  t.tm_mday=date&31;
  t.tm_mon=((date>>5)&15)-1;
  t.tm_year=1980+(date>>9)-1900;
  t.tm_isdst=0;  /* daylight saving time ??? */
  
  if((utb.actime=utb.modtime=mktime(&t))<0) printf("Invalid date/time\n");
    else utime(filename,&utb);
}

dirst *current_dirst;
char current_name[256];
FILE* current_file=NULL;
int current_ok=0;
int current_sizeleft=0;

int current_repsize=0;
char* current_repbuff=NULL;
int current_repbuffsize=0;
int current_repptr=0;

int buffer_write_files(char *buff_pos,int buff_size){
  int _buff_size=buff_size;
  while(buff_size>0){
    if(!current_ok){
      /* ---------------------- Open new file ------------------------- */
      register dirst* d=current_dirst;  /* save some typing :) */
      if(!d) return 0;  /* no more files */
      current_ok=1;
      { char *n=current_name;
        strcpy(n,extract_path);n+=strlen(extract_path);
        if(cmdchr=='x' && d->path) n+=sprintf(n,"%s/", d->path);
        strncpy(n,d->name,12); n[12]=0;
      }
      if(!d->selected){
        current_file=NULL;
      } else {
        if(extract_name) strcpy(current_name,extract_name);
        if(always_yes) goto overwrite;
        if((current_file=fopen(current_name,"r"))){
          fclose(current_file);
          if(always_no){
skip_it:    printf("Skipping %s\n",current_name);fflush(stdout);
            current_file=NULL;
            goto ok_open;
          }
          { int c;
            printf("File exists: %s  Overwrite? (y/n/ay/an) ",current_name);fflush(stdout);
            do{ c=getchar(); } while(c!='y' && c!='a' && c!='n');
            if(c=='a'){
              do{ c=getchar(); } while(c!='y' && c!='n');
              if(c=='n') always_no=1;
              if(c=='y') always_yes=1;
            }
            if(c!='y') goto skip_it;
          }  
        }
overwrite:
        current_file=fopen(current_name,"wb");
        if(!current_file) printf("Cannot open file: %s\n",current_name);
                     else {printf("Extracting %s",current_name);fflush(stdout);}
      }                     
ok_open:
      current_sizeleft=d->size - d->repsize;
      /* Save REP: */
      if(d->repsize<current_repsize) fatal("Internal error (repsize)");
      if(current_file) fwrite(current_repbuff,1,d->repsize,current_file);
      /* Update REP variables: */
      { int next_rep= d->next ? d->next->repsize : 0;
        if(next_rep>current_repbuffsize){
          /* re-allocate rep-buffer, because the current one is too small */
          char *next_buff;
          if(current_repsize==0){ if(current_repbuff) free(current_repbuff); current_repbuff=NULL; }
          next_buff=malloc(next_rep); if(!next_buff) fatal("Can't allocate memory for rep-buffer");
          if(current_repsize){
            memcpy(next_buff,current_repbuff,current_repsize);
            if(current_repbuff) free(current_repbuff);
          }
          current_repbuff=next_buff;
          current_repbuffsize=next_rep;
        }
        current_repptr=current_repsize;
        current_repsize=next_rep;
      }
    }
      /* ---------------- Continue writting a file --------------------- */
      if(current_repptr<current_repsize){
        int i=min(current_repsize-current_repptr,buff_size);
        memcpy(&current_repbuff[current_repptr],buff_pos,i);
        current_repptr+=i;
      }
      if(current_sizeleft){
        int i=min(current_sizeleft,buff_size);
        if(current_file){
          /* writing to a file */
          i=fwrite(buff_pos,1,i,current_file);
          if(i<0) return i; /* error */
        }
        buff_size-=i; buff_pos+=i;
        if(current_sizeleft-=i) continue;
      }
      /* end of file, close it! */
      if(current_file){
        fclose(current_file);
        printf(" Ok.\n");
        set_datetime(current_name,current_dirst->datetime);
      }
      current_ok=0;
      current_dirst=current_dirst->next; /* process next file */
  }
  return _buff_size-buff_size;
}


/************ OUTPUT DIR ********************/

int dir_db=0;
int file_db=0;
int total_repsize=0;
int total_rep_db=0;
int total_size=0;
int selected_size=0;
int selected_file_db=0;

#define DIRENTRY_SIZE 28
char path_mem[PATH_MEM_SIZE];
int path_mem_len=0;

#define DPT(x) (*((dword*)&x))
#define WPT(x) (*((word*)&x))

INLINE void process_direntry(char *de){
  char *path=NULL;
  int pathi=WPT(de[4]);
  if(pathi!=0xFFFF && pathi<path_mem_len) path=&path_mem[pathi];
  
  if(de[19]&0x10){
    /* Directory! */
    char *dname=&path_mem[path_mem_len];
    path_mem_len+=1+sprintf(&path_mem[path_mem_len],"%s%s%s",
       path ? path : "", path ? "/" : "", &de[6]);
	++dir_db;
    /* if(mkdir(dname)) printf("Cannot create dir: %s\n",dname); */
    if(cmdchr=='x'){
      char *c=cat_strings(extract_path,NULL,dname);
      if(!mkdir(c)) set_datetime(c,DPT(de[20]));
    }
  } else {
    /* File */
	dirst* d=malloc(sizeof(dirst));
	if(!d) fatal("Not enough memory to load directory");
	strncpy(d->name,&de[6],12);
	total_size+=d->size=DPT(de[24]);
	total_repsize+=d->repsize=DPT(de[0]);
	d->datetime=DPT(de[20]);
	d->path=path;
	d->attrib=de[19];
	d->selected=check_filemask(path,&de[6]);
    d->next=(dirst*)NULL;
	/* Add to list: */
	if(!dirst_first) dirst_first=d;
	if(dirst_last) dirst_last->next=d;
    dirst_last=d;
	++file_db;
	if(d->repsize) ++total_rep_db;
  }
}

int buffer_write_dir(char *buff_pos,int buff_size){
  int i=0;
  while(i+DIRENTRY_SIZE<=buff_size){
    process_direntry(&buff_pos[i]);
    i+=DIRENTRY_SIZE;
  }
  return i;
}


/************ OUTPUT DIR-LIST ********************/

char months[16][4]={"???","Jan","Feb","Mar","Apr","May","Jun","Jul",
                   "Aug","Sep","Oct","Nov","Dec","???","???","???"};

char *csik="------------------------------------------------------------------------------\n";

INLINE void process_direntry_list(char *de){
  int i;
  char *path=NULL;
  int pathi=WPT(de[4]);
  int de_time=WPT(de[20]);
  int de_date=WPT(de[22]);
  
  if(pathi!=0xFFFF && pathi<path_mem_len) path=&path_mem[pathi];
  if(de[19]&0x10){
    /* Directory! */
    path_mem_len+=1+sprintf(&path_mem[path_mem_len],"%s%s%s",
       path ? path : "", path ? "/" : "", &de[6]);
    ++dir_db;
  } else {
    ++file_db;
    total_size+=DPT(de[24]);
  }
  
  if(dirlist_mode==2){  /* Midnight Commander list */
    printf("%s   1 %-8d %-6d %10d %s %2d %4d %02d:%02d %s%s%s%s\n",
//  printf("%s %3d %-8d %-8d %8d %s %2d %4d %02d:%02d %s%s%s%s\n",
      (de[19]&0x10)?"drwxrwxrwx":"-rw-rw-rw-",
      getuid(),getgid(),DPT(de[24]),
      months[(de_date>>5)&15], de_date&31,1980+(de_date>>9),
      de_time>>11, (de_time>>5)&63,
      path?path:"",path?"/":"",&de[6],(de[19]&0x10)?"/":"");
    return;
  }

  if(de[19]&0x10) return;

  if(!check_filemask(path,&de[6])) return;
  
  selected_size+=DPT(de[24]); ++selected_file_db;
  
  if(dirlist_mode==0){  /* normal list to the screen */
    if(dirlist_lines==0) printf("%s     Size    Date     Time    FileName\n%s",csik,csik);
    printf("%9d  %02d/%02d/%02d %02d:%02d:%02d  ",
      DPT(de[24]),
      (de_date>>5)&15, de_date&31, 80+(de_date>>9),
      de_time>>11, (de_time>>5)&63, 2*(de_time&31)
    );
    if(cmdchr=='v' && path) printf("%s/",path);
    printf("%s\n",&de[6]);
    ++dirlist_lines;
    if(wait4key && dirlist_lines>=dirlist_maxlines){
      printf("<< Press ENTER to continue! >>",csik);fflush(stdout);
      (void) getchar();
      printf("\n\n\n");
      dirlist_lines=0;
    }
  
  }

}

int buffer_write_dirlist(char *buff_pos,int buff_size){
  int i=0;
  while(i+DIRENTRY_SIZE<=buff_size){
    process_direntry_list(&buff_pos[i]);
    i+=DIRENTRY_SIZE;
  }
  return i;
}

/************************* MAIN *******************************/

int main(int argc,char* argv[]){
int i,optchr;
char *mem;
dword dir_pos;
char *name;
char *password=NULL;

if(argc<3 || strcmp(argv[1],"vm"))
  printf("\nUnESP for UNIX v0.1 beta             (C) 1999 A'rpi/ESP-team\n\n");

if(argc<3){
/*--------------------- Print HELP ------------------------*/
print_help:
//  printf("Usage: unesp cmd[opt] archivename[.esp] [extractpath/] [filemasks]\n");

printf("\
Usage: UNESP command[options][passw] archive[.esp] [extractpath/] [filemasks]\n\
\n\
     <Command>\n\
?: View this help\n\
e: Extract files from archive\n\
x: eXtract files with full path\n\
l: List contents of archive without path\n\
v: List contents of archive with full path\n\
t: Test archive\n\
\n\
     <Options>\n\
f: list to binary File (L,V)\n\
k: wait for a Key after each screenful of information (L,V)\n\
p: set Password\n\
s: Skip comments & DRR\n\
y: always Yes\n\
n: always No\n\
b: enable BEEP\n\
");

  return 1;
}

/*--------------------- Process options -------------------*/

cmdchr=argv[1][0];
if(cmdchr=='?') goto print_help;
if(cmdchr>='A' && cmdchr<='Z') cmdchr+=32; /* downcase */
if(cmdchr!='x' && cmdchr!='e' && cmdchr!='l' && cmdchr!='v'){
  printf("Invalid command char: '%c'\n",cmdchr ? cmdchr : ' '); exit(1);
}

i=1;
while((optchr=argv[1][i++])){
  if(optchr>='A' && optchr<='Z') optchr+=32; /* downcase */
  if(optchr=='y'){ always_yes^=1;continue;}
  if(optchr=='n'){ always_no^=1;continue;}
  if(optchr=='b'){ enable_beep^=1;continue;}
  if(cmdchr=='v' || cmdchr=='l'){
    if(optchr=='f'){ dirlist_mode=1;continue;}
    if(optchr=='m'){ dirlist_mode=2;continue;}
    if(optchr=='k'){ wait4key^=1;continue;}
  } else {
    if(optchr=='m'){ extract_name_flag=1;continue;}
  }
  if(optchr=='p'){
    if(argv[1][i]) password=&argv[1][i];
              else password=getpass("Enter password: ");
    break;
  }
  printf("Invalid option char: '%c'\n",optchr); exit(1);
}

i=3;
if(extract_name_flag) extract_name=argv[i++];
for(;i<argc;i++){
  char *p=argv[i];
  if(p && p[strlen(p)-1]=='/') extract_path=p; else {
  //  if(*p=='@') load_listfile(&p[1]); else 
    add_filemask(p);
  }  
}

/*--------------------- Open archive file -----------------*/

/* printf("Current password: '%s'\n",password); */
if(password){ printf("Sorry, decryption not yet implemented... :(\n"); exit(1);}

in_file=fopen(argv[2],"rb");
if(!in_file){
  char *name=malloc(strlen(argv[2])+5);
  if(!name) fatal("Not enough memory");
  sprintf(name,"%s.esp",argv[2]);
  in_file=fopen(name,"rb");
  if(!in_file){ printf("Archive file not found: %s\n",name); return 1;}  
}
fseek(in_file,6,SEEK_SET);
if(fread(&dir_pos,1,4,in_file)!=4 || fseek(in_file,dir_pos,SEEK_SET)){
  printf("Bad archive (seek error)\n"); return(1);
}

mem=(char*)malloc(MEMSIZE); if(!mem) return 3;

in_xor=*((dword*)"GyiK"); /* ESP v1.6+ always uses XOR32 'GyiK' coding */

if(cmdchr=='l' || cmdchr=='v'){
/*--------------------- List directory --------------------*/
  i=unesp(mem,MEMSIZE,buffer_read,buffer_write_dirlist);
  if(i<0){ printf("\nUnpack error: %d\n",i);exit(1);}
  if(dirlist_mode==0){
    int csize;
    fseek(in_file,0,SEEK_END);csize=ftell(in_file);
    printf("%s  Unpacked size: %9d  (listed: %d)\n",csik,total_size,selected_size);
    printf("  Compressed size: %d    Ratio: %5.3f%%\n",csize,
       total_size ? (100.0*(float)csize/total_size) : 0.0f );
    printf("  Listed %d of %d files.\n%s",selected_file_db,file_db,csik);
  }
  return 0;
}

/*--------------------- Extract files: --------------------*/

printf("Reading directory...");fflush(stdout);
i=unesp(mem,MEMSIZE,buffer_read,buffer_write_dir);
if(i<0){ printf("\nUnpack error: %d\n",i);exit(1);}
printf(" OK, found %d files in %d dirs.\n",file_db,dir_db);
printf("Total size=%d  rep=%d in %d files\n",total_size,total_repsize,total_rep_db);

current_dirst=dirst_first;

fseek(in_file,10,SEEK_SET);
i=unesp(mem,MEMSIZE,buffer_read,buffer_write_files);
if(i<0){ printf("\nUnpack error: %d\n",i);exit(1);}

fclose(in_file);
return 0;
}
