////////////////////////////////////////////////////////////////////////
//	UDA Shell 0.301 (2006.12.19) Author:dwing
////////////////////////////////////////////////////////////////////////
//#pragma comment(linker,"/MERGE:.data=.text")
//#pragma comment(linker,"/MERGE:.rdata=.text")
#include <time.h>
#include <io.h>
#include "uda.h"
#define BUFSIZE (1024*32)
const int ZMARK=(('Z')+('D'<<8)+(0x0F<<16)+(0<<24));
//	09 : 0.260-0.27x
//	0A : 0.280-0.282
//	0B : 0.283(UDA,only MODE-0)
//	0C : 0.284(UDA,only MODE-0)
//	0D : 0.29x
//	0E : 0.300(UDA,only MODE-0)
//	0F : 0.301(UDA,only MODE-0)
////////////////////////////////////////////////////////////////////////
void compress(char *fname,char *aname)
{
	unsigned i,j,fs,ns=0;
	U8 buf[BUFSIZE],*p;
	FILE *ar,*fp;
	double tm=clock();

	if(access(aname,0)!=-1) 	{printf("ERROR: %s already exists\n",aname);return;}
	if(!(fp=fopen(fname,"rb"))) {printf("ERROR: Can't open %s\n"	,fname);return;}
	if(!(ar=fopen(aname,"wb"))) {printf("ERROR: Can't create %s\n"	,aname);fclose(fp);return;}
	printf("%s => %s\n",fname,aname);
	fseek(fp,0,SEEK_END);fs=ftell(fp);fseek(fp,0,SEEK_SET);
	fwrite(&ZMARK,4,1,ar);fwrite(&fs,4,1,ar);

	Coder enc(Coder::ENC,ar);
	for(i=fs/BUFSIZE;i;--i)
	{
		if(fread(buf,1,BUFSIZE,fp)!=BUFSIZE) {printf("\nERROR: Can't read %s\n",fname);goto end_;}
		for(j=BUFSIZE,p=buf;j;--j) enc.enc(*p++);
		ns+=BUFSIZE; printf("\r%3.1lf%%",(double)ns*100/fs);
	}
	if((i=fs%BUFSIZE))
	{
		if(fread(buf,1,i,fp)!=i) {printf("\nERROR: Can't read %s\n",fname);goto end_;}
		for(j=i,p=buf;j;--j) enc.enc(*p++);
	}
	printf("\r100.0%% Finished!\n");
	if(fs)
	{
		enc.flush();
		i=ftell(ar); tm=(clock()-tm)/CLOCKS_PER_SEC*1000+1;
		printf("%u/%u in %.2lf sec, %.4lf bpb, %.1lf%% at %.1lf KB/s\n",
			i,fs,(double)tm/1000,(double)i*8/fs,(double)i*100/fs,(double)fs/tm);
	}
end_:
	fclose(ar);
	fclose(fp);
}
////////////////////////////////////////////////////////////////////////
void extract(char *aname,char *fname)
{
	unsigned i,j,fs,ns=0;
	U8 buf[BUFSIZE],*p;
	FILE *ar,*fp;
	double tm=clock();

	if(access(fname,0)!=-1) 	{printf("ERROR: %s already exists\n",fname);return;}
	if(!(ar=fopen(aname,"rb"))) {printf("ERROR: Can't open %s\n"	,aname);return;}
	fread(&i,4,1,ar);if(i!=ZMARK){printf("ERROR: Unknown format\n");fclose(ar);return;}
	if(!(fp=fopen(fname,"wb"))) {printf("ERROR: Can't create %s\n"	,fname);fclose(ar);return;}
	printf("%s => %s\n",aname,fname);
	fread(&fs,4,1,ar);

	Coder dec(Coder::DEC,ar);
	for(i=fs/BUFSIZE;i;--i)
	{
		for(j=BUFSIZE,p=buf;j;--j) *p++=dec.dec();
		if(fwrite(buf,1,BUFSIZE,fp)!=BUFSIZE) {printf("\nERROR: Can't write %s\n",fname);goto end_;}
		ns+=BUFSIZE;
		printf("\r%3.1lf%%",(double)ns*100/fs);
	}
	if((i=fs%BUFSIZE))
	{
		for(j=i,p=buf;j;--j) *p++=dec.dec();
		if(fwrite(buf,1,i,fp)!=i) {printf("\nERROR: Can't write %s\n",fname);goto end_;}
	}
	printf("\r100.0%% Finished!\n");
	if(fs)
	{
		i=ftell(ar); tm=(clock()-tm)/CLOCKS_PER_SEC*1000+1;
		printf("%u/%u in %.2lf sec, %.4lf bpb, %.1lf%% at %.1lf KB/s\n",
			i,fs,(double)tm/1000,(double)i*8/fs,(double)i*100/fs,(double)fs/tm);
	}
end_:
	fclose(fp);
	fclose(ar);
}
////////////////////////////////////////////////////////////////////////
void __cdecl main(int argc,char **argv)
{
	printf( "UDA 0.301 -- Experimental Console Version -- Base on PAQ8I -- 19 Dec 2006\n"
			"Author: dwing -- dwing@163.com -- http://wex.cn/dwing http://dwing.51.net\n");
	if(argc==4)
		switch(*argv[1])
		{
		case'e':case'E':compress(argv[2],argv[3]); return;
		case'd':case'D': extract(argv[2],argv[3]); return;
//		default: printf("ERROR: Unknown command \'%s\'\n",argv[1]);
		}
//	else
		printf( "Usage: uda e <in_filename> <out_filename> --- for compression\n"
				"       uda d <in_filename> <out_filename> --- for decompression\n"
				"Memory needed: 180 MB\n");
}
////////////////////////////////////////////////////////////////////////
