;
P5ORG   equ     295h
;
XORColor equ    (0Eh xor 18h)
MaxS    equ     9d
MinS    equ     0d
StartM  equ     20d
StartM2 equ     26d
;
Color1  equ     66h
Color2  equ     25h
Area    equ     34d
Speed   equ     1d
Spacing equ     3d      ; space between star tracks
StarNum equ     21d*3d
StarColor equ    0Fh
StarColor2 equ   19h
StarColor3 equ   17h
;
ScrollNum equ   16d
ScrollDelay equ 1d
MessLine equ    70d
MessLine2 equ   20d
ScrOFF  equ     310d
;
PKHeader equ 100h ; less than 10 paragraphs
.RADIX 16
CODE    SEGMENT PUBLIC  'CODE'
        ORG     100h
ASSUME  CS:CODE,DS:CODE,SS:CODE,ES:CODE
UX_UX_UX:
        jmp     Begin
;
; internal stack
        db      400h dup (0)
sta:
;
PKCode  dw      0
fszlo   dw      0000h
fszhi   dw      0000h
ChkComp db      0
memory  dw      0000h
off1Bh  dw      0000h
seg1Bh  dw      0000h
off24h  dw      0000h
seg24h  dw      0000h
offour  dw      0000h
segour  dw      0000h
IT      db      20h*4h dup(00)
FH      dw      0000h
fileb   dw      0000h
filee   dw      0000h
outfb   dw      0000h
outfe   dw      0000h
;
;
Clear   PROC    Near
        push    ax
;
        push    cs
        pop     es
        xor     ax,ax
        mov     cx,(EOP-AfterQuit) /2 + 1 + 200h
        cld
        mov     di,OFFSET AfterQuit
REP     STOSW
        pop     ax
        mov     ah,4Ch
        int     21h
Clear   ENDP
;
AfterQuit:
VARS:
;
;
ZUsed   db      0
P5Fail  db      0
p5code  db      0
chkUnknown db   0
DIET145memok db 0
sign    dw      0000h
NoRDIET db      0
iflag   db      0
RTpoi   dw      0000h
;
Ctrl    db      00h
tmp1    dw      0000h
tmp2    dw      0000h
tmp     dw      0000h
time    dw      0000h
date    dw      0000h
;
segcode dw      0000h
OvrLow  dw      0000h   ; beginning of the overlay data, low bytes
OvrHigh dw      0000h   ; beginning of the overlay data, high bytes
OVR     db      00h     ; 0 if no overlay data present
base    dw      0000h
oldmin  dw      0000h
normMin dw      0000h
normMax dw      0000h
oldexe  dw      0000h   ; size of the old load image
newexe  dw      0000h   ; size of the new load image
iniCS   dw      0000h
Which   db      00h
freehi  dw      0000h
SingRET db      00h
reloc   dw      0000h
highsz  dw      0000h   ; high bytes of the load image size
lowsz   dw      0000h   ; low bytes of the load image size
;
needPK  dw      0000h   ; how much memory the executable needs (PKLITE & LZEXE)
needLZ  dw      0000h   ; how much memory the executable needs (PKLITE & LZEXE)
PKLSP   dw      0000h
PKLSS   dw      0000h
;
        db      10h dup(0)
VARSend:
;
setborder PROC  Near
KillBorder:
        push    ax
        push    dx
        mov     dx,3dah
        in      al,dx
        mov     dx,3c0h
        mov     al,11h+32d
        out     dx,al
        mov     al,cs:[borderc]
        inc     byte ptr cs:[borderc]
        out     dx,al
        pop     dx
        pop     ax
        ret
setborder ENDP
borderc db      0
;
Print   PROC    Near
; prints an ASCIIZ string
        push    ax
        push    dx
        push    di
RepeatPrint:
        mov     dl,[di]
        inc     di
        cmp     dl,00
        je      ExitPrint
        mov     ah,02h
        int     21h
        jmp     short RepeatPrint
ExitPrint:
        pop     di
        pop     dx
        pop     ax
        ret
Print   ENDP
;
int24h:
        add     sp,12d*2
        iret
;
Restore PROC    Near
; restore DOS interrupts
        pushf
        push    ax
        push    cx
        push    si
        push    di
        push    ds
        push    es
        call    ROM
;
        push    cs
        pop     ds
        xor     ax,ax
        mov     es,ax
        mov     di,9h*4
        mov     si,OFFSET IT
        mov     cx,20h*2
        cli
        cld
REP     MOVSW
;RepeatRestore:
;        mov     ax,ds:[si]
;        mov     es:[di],ax
;        mov     ax,ds:[si+2]
;        mov     es:[di+2],ax
;        add     si,4
;        add     di,4
;        loop    RepeatRestore
        sti
;
; restore our interrupt
        mov     bx,0080h
Loc1    equ     $ - 2
        mov     cx,2
        shl     bx,cl
        xor     ax,ax
        mov     ds,ax
        mov     ax,cs:offour
        cli
        mov     ds:[bx],ax
        mov     ax,cs:segour
        mov     ds:[bx+2],ax
        sti
;
        pop     es
        pop     ds
        pop     di
        pop     si
        pop     cx
        pop     ax
        popf
        ret
Restore ENDP
;
Begin:
;
; get random number too..
        mov     ax,cs
        add     ax,(EOP - CODE ) SHR 4
        mov     es,ax
        xor     dx,dx
;
        mov     dx,66h
; dx has some sort of a random number

; get int21h
        mov     ax,3521h
        int     21h
        mov     off21h,bx
        mov     seg21h,es

; get int24h
        mov     ax,3524h
        int     21h
        mov     off24h,bx
        mov     seg24h,es
;
; get Ctrl-Break interrupt
        mov     ax,351Bh
        int     21h
        mov     seg1Bh,es
        mov     off1Bh,bx

        call    ROM

; set Ctrl-Break
        mov     ax,251Bh
        mov     dx,OFFSET CtrlBreak
        push    cs
        pop     ds
        int     21h
;
; set Ctrl-C
        mov     ax,2523h
        mov     dx,OFFSET IRET_
        int     21h
;

; randomize
        mov     ax,0040h
        mov     ds,ax
        mov     ax,ds:[006Ch]
        add     ax,dx
        xor     al,ah
        push    cs
        pop     ds
;
        jmp     SkipSettingLoc
; AL has some sort of a random number
        cmp     al,6Fh  ; don't allow any BIOS or DOS IV's be used
        jb      SkipSettingLoc
; set locations
        mov     byte ptr ds:Loc1,al
        mov     byte ptr ds:Loc2,al
        mov     byte ptr ds:Loc3,al
        mov     byte ptr ds:Loc4,al
        mov     byte ptr ds:Loc5,al
        mov     byte ptr ds:Loc6,al
        mov     byte ptr ds:Loc7,al
        mov     byte ptr ds:Loc8,al
        mov     byte ptr ds:Loc9,al
        mov     byte ptr ds:Loc10,al
        mov     byte ptr ds:Loc11,al
        mov     byte ptr ds:Loc12,al
        mov     byte ptr ds:Loc13,al
        mov     byte ptr ds:Loc14,al
        mov     byte ptr ds:Loc15,al
        mov     byte ptr ds:Loc15_2,al
        mov     byte ptr ds:Loc16,al
        mov     byte ptr ds:Loc17,al
        mov     byte ptr ds:Loc18,al
        mov     byte ptr ds:Loc19,al
        mov     byte ptr ds:Loc20,al
        mov     byte ptr ds:Loc20_2,al
        mov     byte ptr ds:Loc21,al
        mov     byte ptr ds:Loc22,al
        mov     byte ptr ds:Loc22_2,al
        mov     byte ptr ds:Loc22_3,al
        mov     byte ptr ds:Loc23,al
        mov     byte ptr ds:Loc24,al
        mov     byte ptr ds:Loc25,al
        mov     byte ptr ds:Loc26,al
        mov     byte ptr ds:Loc27,al
        mov     byte ptr ds:Loc28,al
        mov     byte ptr ds:Loc29,al
        mov     byte ptr ds:Loc30,al
        mov     byte ptr ds:Loc31,al
        mov     byte ptr ds:Loc32,al
        mov     byte ptr ds:Loc33,al
        mov     byte ptr ds:Loc34,al
        mov     byte ptr ds:Loc35,al
        mov     byte ptr ds:Loc36,al
        mov     byte ptr ds:Loc37,al
        mov     byte ptr ds:Loc38,al
SkipSettingLoc:
;
        mov     ax,cs
        cli
        mov     ss,ax
        mov     sp,OFFSET sta
        jmp     short $ + 2
        sti
;
; display the message
        mov     ah,09h
        mov     dx,OFFSET Msg
        int     21h
;
        push    cs
        pop     es
; save DOS interrupts
        xor     ax,ax
        mov     ds,ax
        mov     si,9h*4
        cld
        mov     di,OFFSET IT
        mov     cx,20h
RepeatSave:
        mov     ax,ds:[si]
        mov     es:[di],ax
        mov     ax,ds:[si+2]
        mov     es:[di+2],ax
        add     si,4
        add     di,4
        loop    RepeatSave
;
; save our interrupt
        mov     bx,0080h
Loc6    equ     $ - 2
        mov     cx,2
        shl     bx,cl
        xor     ax,ax
        mov     ds,ax
        mov     dx,ds:[bx]
        mov     cs:offour,dx
        mov     dx,ds:[bx+2]
        mov     cs:segour,dx
        push    cs
        pop     ds
;
; how much memory is used by UX, the highest paragraph it needs
        mov     ax,cs
        add     ax,(OFFSET PKHeader + OFFSET RTLen + OFFSET EOP000 - OFFSET CODE) SHR 4 + 1
;
        mov     bx,ds:[0002h]   ; top of memory
        cmp     bx,ax
        jnb     MemoryOK1_
MemoryError:
        mov     dx,OFFSET ErrMsg9
        jmp     Error
MemoryOK1_:
        jmp     MemoryOK1
;
Options PROC    Near
; check options in al, if '-' or '/' stay in the procedure until 20h or 09h
;
        cmp     al,'-'
        je      YesOptions
        cmp     al,'/'
        je      YesOptions
        cmp     al,'?'
        je      YesOptions
OptionsDone2:
        jmp     OptionsDone
YesOptions:
        jcxz    OptionsDone2
        dec     cx
        inc     di
        mov     al,[di]
        cmp     al,0Dh
        je      OptionsDone2
        cmp     al,09h
        je      OptionsDone2
        cmp     al,20h
        je      OptionsDone2
        cmp     al,'?'
        je      short YesOptions
;
        cmp     al,'0'
        jne     NotStopCPU
        mov     byte ptr ds:[CPUInfo],0C3h
        jmp     short YesOptions
;ExtendedHelp3:
;        jmp     ExtendedHelp
NotStopCPU:
;
        cmp     al,'9'
        ja      NotProtect5Method
        cmp     al,'1'
        jb      NotProtect5Method
        push    ax
        push    cx
        sub     al,30h
        xor     ah,ah
        mov     cx,ax
RepeatP5:
        inc     word ptr ds:P5Start
        loop    RepeatP5
        pop     cx
        pop     ax
        jmp     short YesOptions
NotProtect5Method:
        cmp     al,'%'
        jne     NotTheBorder
        mov     byte ptr ds:KillBorder,0C3h
        jmp     short YesOptions
NotTheBorder:
;
        and     al,5Fh
        cmp     al,'H'
        je      short YesOptions
;
        cmp     al,'B'  ;
        jne     NotBackup
        mov     byte ptr ds:[Backup+1],00h      ; make backup
        jmp     short YesOptions
NotBackup:
        cmp     al,'F'  ; force P5
        jne     NotForceP5
        mov     word ptr ds:[P5Force1],9090h
        mov     word ptr ds:[P5Force2],9090h
        jmp     short YesOptions
NotForceP5:
        cmp     al,'I'  ; intro
        jne     NotIntro
        inc     byte ptr iflag
        jmp     short YesOptions
NotIntro:
        cmp     al,'K'  ; don't append PK signature code
        jne     NotKludge
        mov     byte ptr ds:Kludge,0EBh
        jmp     short YesOptions
NotKludge:
        cmp     al,'O'  ; can overwrite output file
        jne     NotOverwrite
        mov     byte ptr ds:Overwrite,0EBh
        jmp     YesOptions
NotOverwrite:
        cmp     al,'R'  ; remove overlay data if any
        jne     NotOverlayRemove
        mov     byte ptr ds:Overlay,0EBh
        jmp     YesOptions
NotOverlayRemove:
        cmp     al,'U'  ; don't set time and date
        jne     DontSetFTimeDate
        mov     word ptr ds:FILEDATE,9090h
        jmp     YesOptions
DontSetFTimeDate:
        cmp     al,'Z'  ; don't set time and date
        jne     DontResetP5Addr
        cmp     byte ptr ds:ZUsed,0
        jnz     ZDone
        sub     word ptr ds:P5Start,(P5ORG-1C1h)
        inc     byte ptr ds:ZUsed
ZDone:
        jmp     YesOptions
DontResetP5Addr:
        mov     dx,OFFSET ErrMsg1
        jmp     Error
OptionsDone:
        ret
;
;ExtendedHelp:
;        mov     dx,OFFSET XHelp
;;Message:
;        push    cs
;        pop     ds
;        mov     ah,09h
;        int     21h
;        jmp     Quit
;
Options ENDP
;
;
MemoryOK1:
        sub     bx,ax
        add     bx,PKHeader SHR 4
        mov     memory,bx ; this memory will be available to the loaded prg

; scan command line
        xor     cx,cx
        mov     di,0080h
        mov     cl,[di]
        inc     cx
RepScan:
        jcxz    NoParameters
        dec     cx
        inc     di
        mov     al,[di]
        call    Options
;
        cmp     byte ptr cs:iflag,1
        jne     SkipIntro
        push    dx
        push    ax
        call    Intro
        mov     ah,09h
        mov     dx,OFFSET Msg
        push    cs
        pop     ds
        inc     byte ptr iflag
        int     21h
        pop     ax
        pop     dx
SkipIntro:
;
        cmp     al,09h
        je      RepScan
        cmp     al,20h
        je      RepScan
        cmp     al,0Dh
        je      NoParameters
        mov     fileb,di
RepScan2:
        inc     di
        dec     cx
        mov     al,[di]
        mov     filee,di
        cmp     al,20h
        je      FoundEOFN
        cmp     al,09h
        je      FoundEOFN
        cmp     al,0Dh
        je      SingleFileName
        jmp     short RepScan2
NoParameters:
        mov     dx,OFFSET HelpMsg
        mov     ah,09h
        int     21h
        jmp     Quit
FoundEOFN:
        mov     byte ptr [di],00h
        mov     filee,di

; check for second filename
Repeat2nd:
        inc     di
        dec     cx
        mov     al,[di]
        call    Options
        cmp     al,20h
        je      Repeat2nd
        cmp     al,09h
        je      Repeat2nd
        cmp     al,0Dh
        je      SingleFileName
; found 2nd filename
        mov     outfb,di
; find end of 2nd filename
Repeat2ndEnd:
        inc     di
        dec     cx
        mov     al,[di]
        cmp     al,20h
        je      Found2ndEOFN
        cmp     al,09h
        je      Found2ndEOFN
        cmp     al,0Dh
        je      Found2ndEOFN
        jmp     Repeat2ndEnd
Found2ndEOFN:
        mov     outfe,di
        mov     byte ptr [di],00h
; is there more stuff on the command line?
        inc     cx
        jcxz    DoneScan
RepeatScanStuff:
        inc     di
        mov     al,[di]
        call    Options
        loop    RepeatScanStuff
DoneScan:
; check if 2nd filename has an extension
        mov     al,'.'
        std
        mov     cx,outfe
        mov     di,cx
        sub     cx,outfb
        inc     cx
REPNE   SCASB
        cmp     cx,0000h
        jne     OKFile_Ext2
; no extension, add .EXE
        mov     di,outfe
        mov     word ptr [di],'E.'
        mov     word ptr [di+2],'EX'
        mov     byte ptr [di+4],00h
        add     di,4
        mov     outfe,di
OKFile_Ext2:

SingleFileName:
; check if filename has an extension
        mov     al,'.'
        std
        mov     cx,filee
        mov     di,filee
        mov     byte ptr [di],00h
        sub     cx,fileb
        inc     cx
REPNE   SCASB
        cmp     cx,0000h
        jne     OKFile_Ext
        cmp     outfb,0000h
        je      No2ndFile
; move the 2nd filename 4 bytes behind
        mov     si,outfe
        mov     cx,outfe
        sub     cx,outfb
        inc     cx
        mov     di,si
        add     di,4
        std
REP     MOVSB
        add     word ptr outfb,4
        add     word ptr outfe,4
No2ndFile:
; no extension, add .EXE
        mov     di,filee
        mov     word ptr [di],'E.'
        mov     word ptr [di+2],'EX'
        mov     byte ptr [di+4],00h
        add     di,4
        mov     filee,di
OKFile_Ext:
;
        cmp     outfb,0000h
        jne     Yes2ndFile
        mov     ax,fileb
        mov     outfb,ax
Yes2ndFile:

;
        mov     di,fileb
        call    Print
        mov     ah,09h
        mov     dx,OFFSET Arrow
        int     21h
        mov     di,outfb
        call    Print
        mov     ah,02h
        mov     dl,0Dh
        int     21h
        mov     dl,0Ah
        int     21h

; set int 24h
        mov     ax,2524h
        mov     dx,OFFSET int24h
        int     21h

CheckCompression:
        inc     byte ptr cs:ChkComp
; clearVARS
        mov     di,OFFSET VARS
        cld
        mov     cx,(VARSend-VARS)/2
        xor     ax,ax
        push    cs
        pop     es
REP     STOSW
;

; set DTA
        mov     ah,1Ah
        mov     dx,OFFSET buffer
        int     21h

; find first (to get file size)
        mov     dx,fileb
        mov     ah,4Eh
        xor     cx,cx
        int     21h
        jc      ReadError
;
        mov     di,OFFSET buffer
        mov     ax,[di+1Ah]
        mov     fszlo,ax
        mov     ax,[di+1Ch]
        mov     fszhi,ax
;
        cmp     byte ptr ChkComp,2
        jne     Proceed
        call    DispInfo
        cmp     word ptr PKCode,0
        jz      Proceed0
        call    PKCodeAdded
Proceed0:
        jmp     short Proceed2
Proceed:
        call    DispInfo0
Proceed2:

; reset DTA
        mov     ah,1Ah
        mov     dx,0080h
        int     21h

RESTART:

; open file for reading
        mov     ax,3D00h
        mov     dx,fileb
        int     21h
        jnc     short OpenOK
ReadError:
        mov     dx,OFFSET ErrMsg2
Error:
; check for 2nd
        cmp     byte ptr cs:ChkComp,2
        jne     Not2nd
        cmp     dx,OFFSET ErrMsg5
        jne     Not2nd
        jmp     Quit
Not2nd:
;
        push    cs
        pop     ds
        push    dx
        call    Restore
        mov     ah,09h
        mov     dx,OFFSET ErrMsg
        int     21h
;
        pop     dx
        int     21h
        jmp     Quit
Arrow   db      '  ',24h
Trap:
        cmp     byte ptr cs:P5fail,0
        jz      SkipEM15
RestartInit:
.386P
        xor     eax,eax
        mov     dr7,eax
        mov     dr0,eax
        mov     dr1,eax
        mov     dr2,eax
        mov     dr3,eax
        mov     dr6,eax
.8086
        call    Restore
        push    cs
        push    cs
        pop     ds
        pop     es
        inc     byte ptr cs:P5Start
        jmp     RESTART
SkipEM15:
        mov     dx,OFFSET ErrM15
        jmp     short Error
CtrlBreak:
; set the flag
        mov     byte ptr cs:Ctrl,01h
IRET_:
        iret
;
NotEXEFile:
        mov     dx,OFFSET ErrM14
        jmp     short Error
OpenOK:
        mov     FH,ax

; get file time and date
        mov     ax,5700h
        mov     bx,FH
        int     21h
        mov     time,cx
        mov     date,dx

; read in the header
        mov     ah,3Fh
        mov     bx,FH
        mov     cx,PKHeader
        mov     dx,OFFSET buffer2
        int     21h
        jnc     short ReadOK
        mov     dx,OFFSET ErrMsg2
        jmp     Error
ReadOK:

; close for now
        mov     ah,3Eh
        mov     bx,FH
        int     21h

; reset entry point
        mov     word ptr cs:jumpoff,0100h
        mov     word ptr cs:jumpseg,0010h

; check if executable
        cmp     word ptr [buffer2],'MZ'
        je      YesEXEFile
        cmp     word ptr [buffer2],'ZM'
        jne     NotEXEFile
YesEXEFile:

; get the load image size of the compressed executable
        mov     ax,[buffer2+4]
        mov     cx,5
        shl     ax,cl   ; the size of the load image in paragraphs
        mov     bx,[buffer2+2]
        cmp     bx,0000h
        je      SkipAddPage
        sub     ax,20h  ; subtract the last page
        mov     cx,4
        shr     bx,cl
        inc     bx
        add     ax,bx
SkipAddPage:
        sub     ax,[buffer2+08] ; subtract the size of the header
        mov     oldexe,ax

; get memory from the original file into need, for LZEXE right here
        mov     ax,ds:[buffer2+0Ah]
        mov     needLZ,ax ; do calculations of this value in the LZEXE part

; sort of check if it's PKLITEd
        cmp     word ptr [buffer2+1Eh],'KP'
        jne     NoPKLITESig
        mov     dx,OFFSET PKMsg
        mov     sign,dx
;        mov     di,OFFSET SigMsg
;        call    FoundM
; get the PKLITE version
        mov     ax,word ptr ds:[buffer2+1Ch]
        push    ax
        mov     bx,ax
        and     bh,00001111b
        add     bh,30h
        mov     PKMaj,bh
        xor     ah,ah
        mov     bl,10d
        div     bl
        add     ah,30h
        mov     ds:[PKMin+1],ah
        xor     ah,ah
        mov     bl,10d
        div     bl
        add     ah,30h
        mov     ds:[PKMin],ah
;
        pop     bx
;
        mov     di,OFFSET XL
        test    bh,00010000b
        jz      NoExtra
        mov     al,'X'
        stosb
NoExtra:
        test    bh,00100000b
        jz      NoLarge
        mov     al,'L'
        stosb
NoLarge:
        mov     versig,OFFSET PKVerSig
;
NoPKLITESig:
        cmp     word ptr [buffer2+1Ch],'zt'
        jne     NotTINYPROGSig
        mov     dx,OFFSET TPMsg
        mov     sign,dx
;        mov     di,OFFSET SigMsg
;        call    FoundM
NotTINYPROGSig:

        cmp     word ptr [buffer2+1Ch],'ZL'
        jne     NotLZEXESig
        mov     dx,OFFSET LZMsg
        mov     sign,dx
;
        mov     ax, word ptr [buffer2+1Eh]
        cmp     ax,'19'
        jne     Not91
        mov     versig,OFFSET LZEXE91
Not91:
        cmp     ax,'90'
        jne     Not09
        mov     versig,OFFSET LZEXE90
Not09:
;        mov     di,OFFSET SigMsg
;        call    FoundM
NotLZEXESig:

        cmp     word ptr [buffer2+1Ch],'id'
        jne     NotDIETSig
        cmp     word ptr [buffer2+1Eh],'te'
        jne     NotDIETSig
        mov     dx,OFFSET DIETMsg
        mov     sign,dx
;        mov     version,OFFSET DIET144
;        mov     di,OFFSET SigMsg
;        call    FoundM
NotDIETSig:

; get initial entry point
        mov     ax,[buffer2+16h]
        mov     iniCS,ax

; checks to do (what should be):
;       IP=100
;       1 relocation entry at 0000:0007h of the load image, i.e. CS:0107h
;       EXE, 0016h=0FFF0Fh (start of code segment in the load image)
; there can be 0 relocation entries in old PKLITEd file (1.03)

        mov     bx,[buffer2+2]  ; bytes in the last page
        mov     ax,fszlo
        sub     ax,bx   ; should be divisible by 512 now
        mov     bx,200h
        xor     dx,dx
        div     bx
        cmp     dx,0000h ; any remainder?
        jne     OvrError
        mov     ax,fszhi
        mov     bx,128d
        mul     bx
        cmp     dx,0000h ; overflow ?
        jne     OvrError
; add low file size
        mov     bx,fszlo
        mov     cx,9
        shr     bx,cl
        add     ax,bx
; ax should be the same as offset 4 -1 if offset if 4<>0
        cmp     word ptr [buffer2+2],0000h
        jz      SkipIncFsz
        inc     ax
SkipIncFsz:
        cmp     ax,[buffer2+4]
        je      NoOVR
OvrError:
        mov     byte ptr OVR,01h
;        cmp     byte ptr ChkComp,2
;        je      NoOVR
;        mov     dx,OFFSET Warn01
;        mov     ah,09h
;        int     21h
NoOVR:
;
        mov     ax,[buffer2+04h] ; load image size in 512-byte pages
        mov     x04,ax  ; just save there

        mov     ax,[buffer2+0Ch] ; maximum required memory
        mov     x0C,ax
        mov     ax,[buffer2+0Ah] ; miminum required memory
        mov     x0A,ax
        mov     oldmin,ax

; start of the code
        mov     ax,[buffer2+14h] ; IP
        mov     jumpoff,ax

        mov     ax,[buffer2+16h] ; CS
        add     jumpseg,ax
;

        mov     ax,[buffer2+06h]     ; number of relocation items
        mov     reloc,ax
        cmp     ax,1
        jna     RelocOK
RelocErr:
        cmp     byte ptr cs:ChkComp,2
        je      Quit001
        mov     dx,OFFSET ErrM13
        jmp     Error
Quit001:
        jmp     Quit
RelocOK:

; get the start of relocation table for PKLITE
        mov     si,[buffer2+18h]
        mov     bx,reloc
        shl     bx,1
        shl     bx,1
        mov     dx,[buffer2+08h] ; header size
        mov     cx,4
        shl     dx,cl
        sub     dx,1Ch
        cmp     si,dx
        jnb     NotNormal
; PKLITE original header should be here (at buffer2+bx+si),everything except MZ
; get the minimum memory
        mov     ax,[bx+si+buffer2+08h]  ; 08 because of no MZ
        mov     normMin,ax       ; save the normal PKLITE min memory size
        mov     ax,[bx+si+buffer2+0Ah]  ; 0A because of no MZ
        mov     normMax,ax       ; save the normal PKLITE max memory size
NotNormal:
        cmp     reloc,00h
        jz      SkipRelocating
; get relocation info for 1 item
        mov     bx,[buffer2+18h]
        mov     ax,[bx+buffer2]
        mov     tmp1,ax
        mov     ax,[bx+buffer2+2]
        mov     tmp2,ax
SkipRelocating:

; get SS:SP
        mov     ax,[buffer2+0Eh]
        add     ax,0010h        ;
        mov     PKLSS,ax
        mov     ax,[buffer2+10h]
        mov     PKLSP,ax

; find a segment for dummy PSP
        push    cs
        pop     dx
        mov     ax,buffer - CODE
        mov     cx,0004h
        shr     ax,cl
        inc     ax
        add     dx,ax   ; this is the dummy segment's address
        mov     segcode,dx
        add     jumpseg,dx

; check how much memory will be available to the PKLITEd program
        mov     ax,segcode
        mov     bx,cs
        sub     ax,bx
        mov     bx,memory
        mov     ax,[buffer2+0Ah] ; minimun number of paragraphs to run
        cmp     ax,bx
        jb      MemoryOK3
        jmp     MemoryError
MemoryOK3:

; calculate where end of the load image is (from the beginning)
        mov     ax,[buffer2+04h]  ; load image in 512-byte pages
        mov     bx,[buffer2+02h]
        cmp     bx,0
        je      DontSub
        dec     ax
DontSub:
        mov     cx,7    ; / 128d
        push    ax
        shr     ax,cl   ; high
        mov     OvrHigh,ax
        pop     ax
        mov     cx,9    ; x 512d
        shl     ax,cl   ; low
        mov     OvrLow,ax
        add     OvrLow,bx       ; last page

; construct a PSP and copy the file's complete load image there
        mov     dx,segcode
        mov     ah,26h
        int     21h


        push    cs
        pop     ds
; copy the top of memory
        mov     ax,ds:[0002h]
        mov     es,segcode
        mov     es:[0002h],ax
; clear the PSP
        mov     word ptr es:[5Ch],0000h
        push    cs
        pop     es

; open the file
        mov     ax,3D00h
        mov     dx,fileb
        int     21h
        mov     FH,ax
        jc      ReadError2

; move the pointer to the beginning of the load image
        mov     ax,4200h
        mov     bx,FH
        mov     dx,ds:[buffer2+0008h]   ; the beginning of load image in paras
        mov     cx,0004h
        shl     dx,cl ;dx has the beginning of the image from the start of file
        xor     cx,cx
        int     21h


; read the file
        mov     cx,0FFFFh - 100h
        mov     ds,cs:segcode
        mov     dx,0100h
KeepReading:
        mov     ah,3Fh
        mov     bx,cs:FH
        int     21h
        mov     ah,3Fh
        mov     bx,cs:FH
        mov     dx,0FFFFh       ; read 1 more byte
        mov     cx,1            ;
        int     21h             ;
        jnc     ReadOK2
ReadError2:
        jmp     ReadError
ReadOK2:
        cmp     ax,1
        jb      short EndOfFile
; check if the whole image has been read in
        sub     cs:x04,(1000h SHR 5)
        jb      short EndOfFile
;
        mov     ax,ds
        add     ax,1000h
        mov     cx,0FFFFh
        mov     dx,0000h
        mov     ds,ax
        cmp     ax,cs:[0002h]
        jna     MemoryOK2
MemoryError2:
        jmp     MemoryError
MemoryOK2:
        jmp     KeepReading
EndOfFile:
        push    cs
        pop     ds

; close the file
        mov     ah,3Eh
        mov     bx,FH
        int     21h

; fixup the relocation entry
        mov     es,segcode
        push    es
        pop     ax
        add     ax,0010h
        cmp     reloc,00h
        jz      Skip
        mov     bx,tmp2
        mov     dx,es
        add     dx,bx
        mov     es,dx
        mov     bx,tmp1
        add     word ptr es:[bx+100],ax
Skip:
;
AfterProtect:
        mov     RTpoi,OFFSET RT

        mov     es,segcode
; get the kind of min memory for PKLITE
        mov     ax,es:[0101h]   ; some sort of available memory check in PKLITE
        mov     needPK,ax
;

        mov     es,jumpseg
        cmp     word ptr jumpoff,0100h
        jne     NotOK1st
;
        cmp     word ptr es:[0100h],0B850h       ; PKLITE 1.50  IBM PKZIP
        jne     NotPKLITE150
        jmp     PKLITE150_1
NotPKLITE150:
;
        cmp     word ptr es:[0100h],8C2Eh       ; PKLITE 1.00 ?? (gamebytes)
        je      OK1st2
        mov     Which,00h
        cmp     byte ptr es:[0100h],0B8h
        je      OK1stNorm       ; normal PKLITE
        jmp     short NotOK1st
OK1st2:
        mov     version0,OFFSET PKLITE100
        mov     Which,06h        ; PKLITE 1.00 gamebytes
OK1stNorm:
        jmp     OK1st   ; first instruction should be mov ax,????h in PKLITE
NotOK1st:

;
; tinyprog part
        mov     di,jumpoff
        mov     es,jumpseg
        cmp     byte ptr es:[di],0E9h
        jne     ChkLZEXE
        jmp     OK1stTP ; first instruction should be long JMP xxxx in TINYPROG
ChkLZEXE:
; LZEXE part
        mov     es,jumpseg
        mov     di,jumpoff
        cmp     byte ptr es:[di],06h
        je      OK1stLZEXE0
        cmp     byte ptr es:[di],50h
        je      OK1stLZEXE0
        cmp     word ptr es:[di],0D38Ch
        je      OK1stLZEXE0
        jmp     short NotOK1stLZEXE
OK1stLZEXE0:
        jmp     OK1stLZEXE
NotOK1stLZEXE:
; DIET ??
;        cmp     byte ptr es:[0000h],0F9h
;        jne     Not1stDIET
;
        mov     es,jumpseg
        mov     di,jumpoff
        mov     al,0B2h
        cld
        mov     cx,300h
RepeatDIET:
REPNE   SCASB
        jcxz    Not1stDIET
        cmp     word ptr es:[di],0CB10h
        je      DIET145_
        cmp     word ptr es:[di],0EA10h
        jne     RepeatDIET
        mov     word ptr es:[di-1],80CDh
Loc20   equ     $ - 1
        inc     di
        mov     IP12,di
        mov     byte ptr Which,03h   ; DIET=03
RegularDIET:
        cmp     word ptr version0,0
        jne     DontTouchDIET
        cmp     byte ptr es:[0000],0F9h
        jne     NotDIETv144
        mov     version0,OFFSET DIET144
NotDIETv144:
        cmp     word ptr version0,0
        jne     DontTouchDIET
        mov     version0,OFFSET DIET120
        cmp     word ptr jumpoff,3
        jne     NotDIETv100
        mov     version0,OFFSET DIET100
NotDIETv100:
DontTouchDIET:
;
        mov     dx,OFFSET DIETMsg
;        mov     di,OFFSET IniMsg
        call    FoundM
; setup jump locations
        mov     jumpseg,es
        jmp     Execute
DIET145_:
        mov     version0,OFFSET DIET145
        mov     byte ptr es:[di-1],90h
        mov     word ptr es:[di],80CDh
Loc20_2 equ     $ - 1
        add     di,2
        mov     IP12_2,di
        mov     byte ptr Which,08h      ; DIET 145=08
        jmp     short RegularDIET
NotSLR2:
        jmp     NotSLR
;
Not1stDIET:
ChkEXEPACK:
; check for the inner OPTLINK / SLR packer
        mov     es,jumpseg
        mov     di,jumpoff
        cmp     di,2
        jne     NotSLR2
        cmp     word ptr es:[0002h],0C087h
        jne     NotSLR2
;
        cld
        mov     al,8Eh
        mov     cx,200h
RepeatSLR1:
REPNE   SCASB
        jcxz    NotSLR2
        cmp     word ptr es:[di],33C2h
        jne     RepeatSLR1
; put a breakpoint for the base
        mov     word ptr es:[di-1],80CDh        ; instead of mov es,dx
Loc34   equ     $ - 1
        inc     di
        mov     IP23,di
;
; number of bytes
        mov     al,8Eh
        mov     cx,200h
RepeatSLR2:
REPNE   SCASB
        jcxz    NotSLR
        cmp     word ptr es:[di],8EDAh
        jne     RepeatSLR2
        mov     word ptr es:[di-1],80CDh ; mov ds,dx
Loc35   equ     $ - 1
        inc     di
        mov     IP24,di
;
; relocation entries
        mov     al,26h
        mov     cx,200h
RepeatSLR3:
REPNE   SCASB
        jcxz    NotSLR
        cmp     word ptr es:[di],5D87h
        jne     RepeatSLR3
        mov     word ptr es:[di-1],80CDh ; mov bx,ax
Loc36   equ     $ - 1
        inc     di
        mov     IP25,di
        mov     word ptr es:[di],9090h
;
; end/cleanup
        mov     di,IP24
        mov     al,2Eh
        mov     cx,200h
RepeatSLR4:
REPNE   SCASB
        jcxz    NotSLR
        cmp     word ptr es:[di],2EFFh
        jne     RepeatSLR4
        mov     byte ptr es:[di-1],90h
        mov     word ptr es:[di],80CDh ; jmp cs:[
Loc37   equ     $ - 1
        add     di,2
        mov     IP26,di
;
        mov     byte ptr Which,09h      ; OPTLINK/SLR internal
        mov     dx,OFFSET SLRMsg
;        mov     di,OFFSET IniMsg
        call    FoundM
        jmp     Execute
NotSLR:
; EXEPACK ??
        mov     al,0CBh
        mov     es,jumpseg
        mov     di,jumpoff
; check for EXEPACK signature
        cmp     word ptr es:[di-2],'BR'
        jne     NotEPSig
        mov     dx,OFFSET EXEPMsg
        mov     sign,dx
;        mov     di,OFFSET SigMsg
;        call    FoundM
NotEPSig:
        mov     al,0CBh
        mov     di,jumpoff
        cld
        mov     cx,200h
RepeatEXEPACK1:
REPNE   SCASB
        jcxz    Unknown666
        cmp     byte ptr es:[di-2],50h
        jne     RepeatEXEPACK1
; PUSH AX, RETF is found
; OPTLINK?
        cmp     jumpoff,0h
        jne     NotOPTLINK
        cmp     word ptr es:[0000h],0C087h
        jne     NotOPTLINK
        mov     byte ptr Which,07h   ; OPTLINK=07
        mov     dx,OFFSET OPTMsg
        call    FoundM
OPT_EXEP:
        mov     word ptr es:[di-2],80CDh
Loc25   equ     $ - 1
        mov     IP16,di
        jmp     Execute
NotOPTLINK:
;
        cmp     jumpoff,0
        je      Unknown666
        mov     dx,OFFSET EXEPMsg
        call    FoundM
        mov     byte ptr Which,04h   ; EXEPACK=04
        jmp     short OPT_EXEP
NotDIET:
NotLZEXE:
        jmp     ChkEXEPACK
Quit000:
        jmp     Quit
NotProtect5_:
        jmp     NotProtect5
;
Unknown666:
        jmp     CheckP4
CheckP5:
; check for Protect 5 here
        xor     di,di
        cmp     word ptr es:[di],0E1Eh
P5Force1 equ $
        jne     NotProtect5_
        mov     ax,es:[di+2]
        cmp     ax,01F0Eh
        je      Protect5
        cmp     ax,0E1Fh
P5Force2 equ $
        jne     NotProtect5_
Protect5:
        cmp     byte ptr ds:Chkcomp,2
        jne     DoProt5
        mov     dx,OFFSET Prot5Msg
        mov     ah,09h
        int     21h
        jmp     Quit
DoProt5:
        call    DoP5
        jmp     NotProtect5
;
DoP5    PROC    Near
;
        mov     ah,09h
        mov     dx,OFFSET MsgP5
        int     21h
; check for 386
        call    VCPI386 ; check cpu type and VCPI presence
        jnc     CPU386
        jmp     NotProtect5
CPU386:
.386P
;
; get int01h
        push    es
        mov     ax,3501h
        int     21h
        mov     cs:off01h,bx
        mov     cs:seg01h,es
        pop     es
;
        cli
        xor     eax,eax
        mov     dr6,eax
        mov     ax,es
        mov     cs:tempCS,es
        shl     eax,4
;        add     eax,word ptr cs:P5Start
        xor     edx,edx
        mov     dx,word ptr cs:P5Start
        add     eax,edx
        mov     dr0,eax
        add     eax,5
;        inc     eax
        mov     dr1,eax
        add     eax,5
;        inc     eax
        mov     dr2,eax
        add     eax,5
;        inc     eax
        mov     dr3,eax
        mov     eax,03FFh
        mov     dr7,eax
        jmp     short $ + 2
        sti
;
        push    ds
        mov     ax,2501h
        push    cs
        pop     ds
        mov     dx,OFFSET HWBP5
        int     21h
        pop     ds
;
        pop     ax      ; the retf
        mov     byte ptr cs:P5Fail,1
        mov     byte ptr cs:P5code,1
        call    setborder
        jmp     Execute4BP
tempCS  dw      0
P5Start dw      P5ORG
;
HWBP5:
;
; find the retf (it should be really close now)
        push    ax
        push    cx
        push    di
        push    es
;
        xor     eax,eax
        cli
        mov     dr7,eax
        mov     dr0,eax
        mov     dr1,eax
        mov     dr2,eax
        mov     dr3,eax
        mov     dr6,eax
        sti
;
        mov     es,cs:tempCS
        cld
        mov     cx,100h
        mov     al,0CBh
        xor     edi,edi
        mov     di,cs:P5Start
AgainP5:
REPNE   SCASB
        jcxz    TryP55
        cmp     word ptr es:[di-3],0ED33h
        jne     AgainP5
; ok found, set the bp now
        dec     di
        xor     eax,eax
        mov     ax,es
        shl     eax,4
        add     eax,edi
        cli
        mov     dr0,eax
; re-set int01 to P5 code
        xor     eax,eax
        mov     es,ax
        mov     word ptr es:[4],OFFSET HWBP
;
        mov     dr6,eax
        mov     eax,0303
        jmp     short $ + 2
        mov     dr7,eax
        sti
;
        pop     es
        pop     di
        pop     cx
        pop     ax

;
        iret
saveBXU dw      0
saveDSU dw      0
;
TryP55:
        mov     es,cs:tempCS
        cld
        mov     cx,200h
        mov     al,0EAh
        xor     edi,edi
        mov     di,cs:P5Start
AgainP55:
REPNE   SCASB
        jcxz    P5_P55_Failed
        cmp     word ptr es:[di-3],0ED33h
        jne     AgainP55
;
        db      0EAh
        dw      0
        dw      0FFFFh
;
P5_P55_Failed:
        pop     es
        pop     di
        pop     cx
        pop     ax
HWBP:
;
; when surfaces over here, the IP is now at RETF (or better be!)
        push    bp
        push    ds
        push    bx
        mov     bp,sp
        mov     ds,[bp+8]
        mov     bx,[bp+6]
        cmp     byte ptr ds:[bx],0CBh
        pop     bx
        pop     ds
        pop     bp
        mov     byte ptr cs:chkUnknown,0
        jne     NOTRETF
        mov     byte ptr cs:chkUnknown,1
NOTRETF:
;
        xor     eax,eax
        mov     dr7,eax
        mov     dr0,eax
        mov     dr1,eax
        mov     dr2,eax
        mov     dr3,eax
        mov     dr6,eax
.8086
;
; reset int 01h
;
        mov     ds,ax
        mov     ax,cs:off01h
        cli
        mov     ds:[4],ax
        mov     ax,cs:seg01h
        mov     ds:[6],ax
        sti
;
        call    Restore
        call    setborder
;
        pop     ax
        pop     ax
        pop     ax
;
        push    cs
        pop     ds
;
;
        pop     ax
        mov     ds:jumpoff,ax
        cmp     byte ptr cs:chkUnknown,0
        jz      DontChkUnknown
        cmp     ax,0
        je      DontChkUnknown
; if chkUnknown is set and jumpoff != 0 =>> must exit on next Unknown
        mov     byte ptr cs:P5code,0
DontChkUnknown:
        pop     ax
        mov     ds:jumpseg,ax
; set up SS & SP
        mov     cs:PKLSP,sp
        mov     ax,ss
        sub     ax,ds:segcode
        mov     cs:PKLSS,ax
        mov     ax,cs
        cli
        mov     ss,ax
        mov     sp,OFFSET sta
        sti
        mov     ah,09h
        mov     dx,OFFSET PDone
        int     21h
;        mov     word ptr cs:P5Start,P5ORG
        mov     byte ptr cs:P5Fail,0
        jmp     AfterProtect
;
DoP5    ENDP
;
off01h  dw      0
seg01h  dw      0
;
Quit000__:
        jmp     Quit000
NotProtect4_:
        jmp     CheckP5
;
CheckP4:
; check for Protect4 then
        xor     di,di
        cmp     word ptr es:[di],0DB8Ch
        jne     NotProtect4_
        cmp     word ptr es:[di+2],0E0Eh
        jne     NotProtect4_
        cmp     word ptr es:[di+4],071Fh
        jne     NotProtect4_
Protect4:
        cmp     byte ptr ds:Chkcomp,2
        jne     DoProt4
        mov     dx,OFFSET Prot4Msg
        mov     ah,09h
        int     21h
        jmp     Quit
DoProt4:
;
        mov     ah,09h
        mov     dx,OFFSET MsgP4
        int     21h
; check for 386
        call    VCPI386 ; check cpu type and VCPI presence
        jnc     CPU386_2
        jmp     NotProtect4_
CPU386_2:
.386P
; set up BP0 for es:6Ch write
        xor     eax,eax
        mov     ax,cs:segcode
        shl     eax,4
        add     eax,06Ch
        mov     dr0,eax
        mov     eax,00050102h
        mov     dr7,eax
        xor     eax,eax
        mov     dr6,eax
;
; get int01h
        push    es
        mov     ax,3501h
        int     21h
        mov     cs:off01h,bx
        mov     cs:seg01h,es
        pop     es
;
        push    ds
        mov     ax,2501h
        push    cs
        pop     ds
        mov     dx,OFFSET HWBP2
        int     21h
        pop     ds
;
        jmp     Execute4BP
;
HWBP2:
;
.386P
        push    ax
        push    bp
        mov     bp,sp
        xor     eax,eax
        mov     dr6,eax
        mov     ax,[bp+6] ; the CS we need to set BP on (CS:138h)
;
        shl     eax,4
        add     eax,0138h
        mov     dr0,eax
        mov     eax,2
        mov     dr7,eax
; re-set int01 to P5 code
        push    ds
;
        xor     ax,ax
        mov     ds,ax
        cli
        mov     word ptr ds:[4],OFFSET HWBP
        sti
;
        pop     ds
;
        pop     bp
        pop     ax
.8086
        iret
;
NotProtect5:
        cmp     byte ptr cs:ChkComp,2
        je      Quit000___
;
        cmp     byte ptr cs:P5code,1
        je      RestartInit0
        mov     dx,OFFSET ErrMsg5
        jmp     Error
Quit000___:
        jmp     Quit000__
RestartInit0:
        jmp     RestartInit
OK1stLZEXE:
        mov     byte ptr Which,02h      ; LZEXE =02
; get minimum memory needed for the decompressed file from the LZEXE header
        mov     ax,es:[000Ch]
        add     ax,15d
        mov     cx,4
        shr     ax,cl
        add     ax,9
        add     ax,es:[000Ah]
        sub     needLZ,ax
        mov     ax,needLZ
        mov     x0A,ax ; this is the memory final UNLZEXEd file will need
; set the jump location
        mov     jumpseg,es
        mov     jumpoff,di
        mov     version0,OFFSET LZEXE91
; bypass the CRC check for LZEXE v0.90
        cld
        mov     al,0D5h
        mov     cx,100h
RepeatLZEXECRC:
REPNE   SCASB
        jcxz    NoCRC
        cmp     word ptr es:[di],0C74h
        jne     RepeatLZEXECRC
        mov     byte ptr es:[di],0EBh
        mov     version0,OFFSET LZEXE90
NoCRC:
; find RETF
        mov     di,jumpoff
        xor     al,al
        mov     cx,100h
RepeatLZEXE:
REPNE   SCASB
        jcxz    NotLZEXE__
        cmp     word ptr es:[di-3],0A2Eh
        je      LZEXEDiff
        cmp     word ptr es:[di],0CB50h
        jne     RepeatLZEXE
        mov     word ptr es:[di],80CDh
Loc17   equ     $ - 1
        add     di,2
        mov     IP9,di
        mov     dx,OFFSET LZMsg
someLZEXE:
;        mov     di,OFFSET IniMsg
        call    FoundM
        jmp     Execute
NotLZEXE__:
        jmp     NotLZEXE
LZEXEDiff:
        mov     byte ptr es:[di-4],90h
        mov     word ptr es:[di-3],9090h
        mov     word ptr es:[di-1],80CDh
Loc28   equ     $ - 1
        inc     di
        mov     IP18,di
        mov     dx,OFFSET LZHMsg
        mov     version0,0
        mov     byte ptr Which,05h      ; hacked LZEXE ??
        jmp     short someLZEXE
OK1stTP:
;
        mov     byte ptr Which,01h ; TINYPROG = 01
; jump
        mov     di,003h
        mov     ax,es:[0001h]
        add     di,ax
        cmp     byte ptr es:[di],0EBh
        je      OK2ndTP ; second should be short jump
NotTinyProg:
        mov     dx,OFFSET ErrMsg5
        jmp     Error
OK2ndTP:
        xor     ax,ax
        mov     al,es:[di+1]
        inc     ax
        inc     ax
        add     di,ax
; scan for the far jump
        mov     al,0FFh
        mov     cx,0200h
        cld
RepeatTP1:
REPNE   SCASB
        jcxz    NotTinyprog
        cmp     word ptr es:[di],126Ch
        je      TinyProg1
        cmp     word ptr es:[di],1A6Ch
        jne     RepeatTP1
        mov     version0,OFFSET TINY33
        jmp     short TinyProg33
TinyProg1:
        mov     version0,OFFSET TINY10
TinyProg33:
; found, place a breakpoint
        mov     byte ptr es:[di-1],90h
        mov     word ptr es:[di],80CDh
Loc13   equ     $ - 1
        add     di,2
        mov     IP5,di
        mov     dx,OFFSET TPMsg
;        mov     di,OFFSET IniMsg
        call    FoundM
        jmp     Execute
;
PKLITE150_1:
        mov     version0,OFFSET PKLITE150
;
        mov     ax,es:[0102h]
        jmp     PKLITE150_C1    ; continue as normal

OK1st:
; check the memory required by the decompression module; first mov ax,????h
        cmp     byte ptr es:[100h],0B8h
        jne     NoMemError2
        mov     ax,es:[0101h]
PKLITE150_C1:
        mov     bx,memory
        cmp     ax,bx
        jb      NoMemError2
        jmp     MemoryError2
NoMemError2:

; place a breakpoint at 1st RETF
        mov     di,0100h
        mov     al,0CBh
        mov     cx,0300h
Repeat1st:
        cld
REPNE   SCASB
        jcxz    No1stRETF
        cmp     word ptr es:[di-3],0A5F3h
        jne     Repeat1st
        jmp     Found1stRETF
No1stRETF:
; recover if PKLITE 1.50
        cmp     word ptr ds:version0,OFFSET PKLITE150
        jne     NotPKLITE150_2
; try to recover the 1st RETF, it's PKLITE 150
        mov     di,0100h
        mov     al,4Ah
        mov     cx,0300h
Repeat1st150:
        cld
REPNE   SCASB
        jcxz    NotPKLITE150_2
        cmp     word ptr es:[di],0F74h
        jne     Repeat1st150
        cmp     byte ptr es:[di-2],0FDh ; std
        je      Found1st150
        cmp     byte ptr es:[di-2],90h ; NOP
        jne     Repeat1st150
Found1st150:
; set the breakpoint
        mov     IP0150,di
        mov     word ptr es:[di-2],80CDh
        jmp     PKLITEOK
NotPKLITE150_2:
;
; look for RET
        mov     di,0100h
        mov     al,0C3h
        mov     cx,0300h
Repeat1stRET0:
        cld
REPNE   SCASB
        jcxz    No1stRET0
        cmp     word ptr es:[di-3],0A5F3h
        jne     Repeat1stRET0
        jmp     short Found1stRET0
No1stRET0:
        jmp     short Recover
Found1stRET0:
        mov     byte ptr es:[di-3],90h
        mov     word ptr es:[di-2],80CDh ; int 03h
Loc3    equ     $ - 1
        mov     IP1,di
        mov     byte ptr SingRET,01h
        mov     version0,OFFSET PKLITE193a
        jmp     PKLITEOK
Recover:
; try to recover the 1st RETF, maybe it's a new PKLITE..
        mov     di,0100h
        mov     al,49h
        mov     cx,0300h
Repeat1stNew:
        cld
REPNE   SCASB
        jcxz    No1stNew
        cmp     word ptr es:[di],0774h
        jne     Repeat1stNew
        cmp     byte ptr es:[di-2],0FDh ; std
        je      Found1stNew
        cmp     byte ptr es:[di-2],90h ; NOP
        jne     Repeat1stNew
        jmp     short Found1stNew
No1stNew:
        jmp     short No1stRETF2
Found1stNew:
; set the breakpoint
        mov     IP0,di
        mov     word ptr es:[di-2],80CDh
Loc4    equ     $ - 1
        mov     cs:version0,OFFSET PKLITE114
        jmp     PKLITEOK
;
No1stRETF2:
; check for PKLITE 1.00 gamebytes
        mov     di,100h
        mov     cx,300h
        mov     al,01h
        cld
Repeat100:
REPNE   SCASB
        jcxz    NotPKLITE
        cmp     word ptr es:[di],0CB50h
        jne     Repeat100
; found PKLITE 1.00 (push ax, retf)
        mov     word ptr es:[di],80CDh
Loc31   equ     $ - 1
        add     di,2
        mov     IP21,di
        jmp     short PKLITEOK
NotPKLITE:
        mov     dx,OFFSET ErrMsg5
        jmp     Error
Found1stRETF:
        mov     byte ptr es:[di-3],90h
        mov     word ptr es:[di-2],80CDh ; int 03h
Loc5    equ     $ - 1
        mov     IP1,di
FoundNewOK:
PKLITEOK:
        mov     dx,OFFSET PKMsg
;        mov     di,OFFSET IniMsg
        call    FoundM

Execute:
        cmp     byte ptr ChkComp,2
        jne     ExecuteOK
        jmp     CheckCompDone
ExecuteOK:
        call    Display0
;
        push    cs
        pop     es
; clear relocation table buffer
        cld
        mov     di,OFFSET RT
        mov     cx,RTLen / 2
        xor     ax,ax
REP     STOSW
;
Execute4BP:
        call    SetTrap

; set SS:SP
        mov     ax,PKLSS
        add     ax,segcode
        mov     ss,ax
        mov     sp,PKLSP

; clean up registers
        xor     ax,ax
        xor     bx,bx
        xor     cx,cx
        xor     dx,dx
        xor     si,si
        xor     di,di

        mov     ds,segcode
        push    ds
        pop     es

; far jump to the actual code
        db      0EAh
jumpoff dw      0100h
jumpseg dw      0010h
;
;offcode dw      0000h

Exit:
        cmp     byte ptr ChkComp,1
        jne     Quit
        mov     ax,outfb
        mov     fileb,ax
;        mov     ah,09h
;        mov     dx,OFFSET SuccessM
;        int     21h
        jmp     CheckCompression
CheckCompDone:

Quit:
        call    Restore
; delete temp file
        mov     ah,41h
        mov     dx,OFFSET tmpfile
        int     21h

; reset int 24h
        mov     ax,2524h
        mov     dx,off24h
        mov     ds,seg24h
        int     21h

; reset Ctrl-Break
        mov     ax,251Bh
        mov     dx,cs:off1Bh
        mov     ds,cs:seg1Bh
        int     21h
;
        mov     al,00h
        mov     cs:borderc,al
        call    setborder
        call    Clear
;
;
int80h:
        mov     cs:saveDS,ds
; set DS so that CS:[ won't be needed
        push    cs
        pop     ds
;
        mov     saveAX,ax
        mov     saveBX,bx
        mov     saveCX,cx
        mov     saveDX,dx
        mov     saveES,es
        mov     saveSI,si
        mov     saveDI,di
        mov     saveBP,bp
        pushf
        pop     ax
        mov     savef,ax
;
        mov     bp,sp
        mov     ax,[bp] ; return IP

;
        db      3Dh   ;  <==>    cmp ax,
IP0     dw      0000h
        jne     NotIP0
; zero entry, new PKLITE
        mov     ax,savef
        push    ax
        popf
        std             ; do the function
        pushf
        pop     ax
        mov     savef,ax     ; has to save flags this way
;
        dec     cx      ; do the function
        mov     saveCX,cx
        mov     es,segcode
        mov     di,[bp]
; reset the jump
        mov     word ptr es:[di-2],49FDh ; put the std, dec cx back
        mov     byte ptr es:[di+1],0FBh  ; reset the jump
        mov     word ptr es:[di-3],80CDh
Loc7    equ     $ - 1
        dec     di
        mov     IP0_1,di
;        call    Display
        jmp     End80h
NotIP0:
;
        db      3Dh   ;  <==>    cmp ax,
IP0150  dw      0000h
        jne     NotIP0150
; zero entry, new PKLITE
        mov     ax,savef
        push    ax
        popf
        dec     dx      ; do the function
        mov     saveDX,dx
        pushf
        pop     ax
        mov     savef,ax     ; has to save flags this way
;
        mov     es,segcode
        mov     di,[bp]
; reset the jump
        mov     word ptr es:[di-2],4A90h ; put the NOP, dec dx back
        mov     byte ptr es:[di+1],0F9h  ; reset the jump
        mov     word ptr es:[di-5],80CDh
        sub     di,3
        mov     IP0150_1,di
        jmp     End80h
NotIP0150:
;
        db      3Dh   ;  <==>    cmp ax,
IP0150_1   dw      0000h
        jne     NotIP0150_1
; zero entry, new PKLITE
; reset the return address
        add     word ptr [bp],0014h
; find RETF and set the breakpoint
        cld
        mov     es,segcode
        mov     di,[bp]
        mov     cx,0300h
        mov     al,0CAh
        cld
Repeat1stDebug150:
REPNE   SCASB
        jcxz    DebugErr3
        cmp     word ptr es:[di-3],0A5F3h
        jne     Repeat1stDebug150
        mov     byte ptr es:[di-3],90h
        mov     word ptr es:[di-2],7FCDh
        mov     IP1150,di
        jmp     End80h
NotIP0150_1:
;
        db      3Dh   ;  <==>    cmp ax,
IP1150  dw      0000h
        je      YesIP1150
        jmp     NoIP1150
YesIP1150:
; execute the instruction
        mov     ds,saveDS
        REPZ    MOVSW
        push    cs
        pop     ds
; reset the return CS:IP
        pop     ax
        pop     ax
        mov     bp,sp
        mov     ax,[bp+2]
        mov     [bp],ax
        mov     di,ax
        mov     ax,[bp+4]
        mov     [bp+2],ax
        mov     es,ax
        pushf
        pop     ax
        mov     [bp+4],ax
; find the 'number of bytes' location mov es,dx 8E C2
        mov     cx,0300h
        mov     al,8Eh
RepeatNumBytes150:
        cld
REPNE   SCASB
        jcxz    DebugErr3
        cmp     byte ptr es:[di],0C2h
        jne     RepeatNumBytes150
;
        mov     word ptr es:[di-1],80CDh  ; int 03h instead of mov es,dx
        inc     di
        mov     IP2150,di
        call    Display0
        jmp     FindReloc
DebugErr3:
        mov     dx,OFFSET ErrMsg5
        jmp     DebugErr
NoIP1150:
;
        db      3Dh   ;  <==>    cmp ax,
IP2150  dw      0000h
        jne     NotIP2150
; second entry into debugging interrupt
; get the load image size, ES:DI - segcode:100
        push    es
        pop     ax
; tmp2:tmp1 will indicate the end of image
        mov     tmp2,ax
        sub     ax,segcode
        mov     highsz,ax
        mov     tmp1,di
        sub     di,0100h
        mov     lowsz,di
;
; put the instruction back and reset the IP on stack to execute it
        sub     word ptr [bp],2
        mov     es,[bp+2]
        mov     di,[bp]
        mov     es:[di],0C28Eh
;
        jmp     End80h
NotIP2150:
;
        db      3Dh   ;  <==>    cmp ax,
IP0_1   dw      0000h
        jne     NotIP0_1
; zero entry, new PKLITE
; reset the return address
        add     word ptr [bp],000Ah
; find RETF and set the breakpoint
        cld
        mov     es,segcode
        mov     di,[bp]
        mov     cx,0300h
        mov     al,0CBh
Repeat1stDebug:
        cld
REPNE   SCASB
        jcxz    No1stDebug
        cmp     word ptr es:[di-3],0A5F3h
        jne     Repeat1stDebug
        jmp     Found1stDebug
No1stDebug:
; check RET Near (C3) the same way
        cld
        mov     es,segcode
        mov     di,[bp]
        mov     cx,0300h
        mov     al,0C3h
Repeat1stDebRET:
        cld
REPNE   SCASB
        jcxz    No1stDebRET
        cmp     word ptr es:[di-3],0A5F3h
        jne     Repeat1stDebRET
        jmp     Found1stDebRET
No1stDebRET:
        mov     dx,OFFSET ErrMsg5
        jmp     DebugErr
Found1stDebRET:
        mov     byte ptr SingRET,01h
Found1stDebug:
        mov     byte ptr es:[di-3],90h
        mov     word ptr es:[di-2],80CDh
Loc8    equ     $ - 1
        mov     IP1,di
        mov     ax,savef
        push    ax
        popf
        std
        pushf
        pop     ax
        mov     savef,ax
;        call    Display
        jmp     End80h
NotIP0_1:
;
        db      3Dh   ;  <==>    cmp ax,
IP1     dw      0000h
        je      YesIP1
        jmp     NotIP1
YesIP1:
; execute the instruction
        mov     ds,saveDS
        REPZ    MOVSW
        push    cs
        pop     ds
; reset the return CS:IP
        cmp     byte ptr SingRET,00h
        jz      YesRETF
        jmp     short YesRET
YesRETF:
        pop     ax
        pop     ax
        mov     bp,sp
        mov     ax,[bp+2]
        mov     [bp],ax
        mov     di,ax
        mov     ax,[bp+4]
        mov     [bp+2],ax
        mov     es,ax
        pushf
        pop     ax
        mov     [bp+4],ax
        jmp     short ResetDone
YesRET:
        pop     ax
        mov     bp,sp
        mov     ax,[bp]
        mov     bx,[bp+2]
        mov     [bp+2],ax       ; return CS
        mov     es,ax
        mov     ax,[bp+4]
        mov     [bp+4],bx       ; flags
        mov     [bp],ax         ; return IP
        mov     di,ax
ResetDone:
; find the 'number of bytes' location POP BX, MOV BP,BX = 5B 8B EB
; mov bp,bx for old PKLITE 1.00 gamebytes
        mov     cx,0300h
        mov     al,8Bh
RepeatNumBytes:
        cld
REPNE   SCASB
        jcxz    NoNumBytes1
        cmp     byte ptr es:[di],0EBh
        jne     RepeatNumBytes
        jmp     short FoundNumBytes1
NoNumBytes1:
; try to find number of bytes 2nd way, MOV BX,SS works with single RET Near
        mov     cx,0300h
        mov     al,8Ch
        sub     di,0300h
RepeatNumB2:
        cld
REPNE   SCASB
        jcxz    NoNumB2
        cmp     byte ptr es:[di],0D3h
        jne     RepeatNumB2
        jmp     short FoundNumB2
NoNumB2:
        mov     dx,OFFSET ErrMsg5
DebugErr:
        push    cs
        pop     ds
        sub     sp,0Ah
        jmp     Error
FoundNumBytes1:
        dec     di
        mov     word ptr es:[di],80CDh  ; int 03h instead of MOV BP,BX
Loc9    equ     $ - 1
        inc     di
        inc     di
        mov     IP2,di
        call    Display0
        jmp     short FindReloc
FoundNumB2:
        mov     word ptr es:[di-1],80CDh
Loc10   equ     $ - 1
        inc     di
        mov     IP2,di
        call    Display0

FindReloc:
; also find relocation code, ADD ES:[DI],BX = 26 01 1D
        mov     cx,0300h
        cld
        mov     al,26h
RepeatReloc:
        cld
REPNE   SCASB
        jcxz    NoReloc
        cmp     word ptr es:[di],1D01h
        jne     RepeatReloc
        jmp     FoundReloc
NoReloc:
        mov     dx,OFFSET ErrMsg5
        jmp     short DebugErr
FoundReloc:
; put int 03h at the relocation code
        mov     byte ptr es:[di-1],90h
        mov     word ptr es:[di],80CDh
Loc11   equ     $ - 1
        inc     di
        inc     di
        mov     IP3,di
        call    Display0

; find the 2nd RETF
        mov     al,0CBh
        mov     cx,0300h
Repeat2ndRETF:
        cld
REPNE   SCASB
        jcxz    No2ndRETF
        cmp     word ptr es:[di-3],0FB8Bh
        je      Found2ndRETF    ; PKLITE 150
        cmp     word ptr es:[di-3],0F88Bh
        jne     Repeat2ndRETF
        jmp     Found2ndRETF
No2ndRETF:
        mov     dx,OFFSET ErrMsg5
        jmp     short DebugErr
Found2ndRETF:
        mov     byte ptr es:[di-3],90h
        mov     word ptr es:[di-2],80CDh
Loc12   equ     $ - 1
        mov     IP4,di
;        call    Display
        jmp     End80h
NotIP1:
        db      3Dh   ;  <==>    cmp ax,
IP2     dw      0000h
        jne     NotIP2
; second entry into debugging interrupt
; get the load image size, ES:DI - segcode:100
        push    es
        pop     ax
; tmp2:tmp1 will indicate the end of image
        mov     tmp2,ax
        sub     ax,segcode
        mov     highsz,ax
        mov     tmp1,di
        sub     di,0100h
        mov     lowsz,di
;
        cmp     byte ptr SingRET,01h
        jz      YesRET0
        mov     saveBP,bx
;        call    Display
        jmp     End80h
YesRET0:
        mov     saveBX,ss
        jmp     End80h
NotIP2:
;
        db      3Dh   ;  <==>    cmp ax,
IP3     dw      0000h
        jne     NotIP3
; third entry, the relocation code
; don't execute the instruction ADD ES:[DI],BX
;        add     es:[di],bx
; save the relocation table entries
; ES is the current segment, BX is the base, DI is the offset
; readjust ES:DI so that ES=min, DI=max
YesIP3:
        mov     si,RTpoi
        mov     [si],di
        mov     ax,es
        sub     ax,bx
        mov     [si+2],ax
        add     si,4
        mov     RTpoi,si
        sub     si,OFFSET RT
        cmp     si,RTLen
        jb      RTOK
        mov     dx,OFFSET ErrM12
        jmp     DebugErr
RTOK:
;        call    Display
        jmp     End80h
NotIP3:
;
        db      3Dh   ;  <==>    cmp ax,
IP5     dw      0000h
        je      YesIP5
        jmp     NotIP5
YesIP5:
;
; jmp [si+1Ah] in tinyprog 3.3 or 3.6
; jmp [si+12h] in tinyprog 1.0
        mov     ds,saveDS
        cmp     cs:version0,OFFSET TINY33
        jne     NotTINY33
        mov     di,ds:[si+1Ah]  ; return IP
        mov     ax,ds:[si+1Ch]  ; return CS
NotTINY33:
        cmp     cs:version0,OFFSET TINY10
        jne     NotTINY10
        mov     di,ds:[si+12h]  ; return IP
        mov     ax,ds:[si+14h]  ; return CS
NotTINY10:
        mov     [bp],di
        mov     [bp+2],ax
        mov     es,ax
        push    cs
        pop     ds
; another jump
        cmp     byte ptr es:[di],0EBh
        je      YesTP1
NotTinyProg2:
        mov     dx,OFFSET ErrMsg5
        jmp     DebugErr
YesTP1:
        xor     ax,ax
        mov     al,es:[di+1]    ; jump there
        inc     ax
        inc     ax
        add     di,ax
;
        cmp     version0,OFFSET TINY10
        jne     NoExtraRelocEntries
        cld
        mov     al,26h
        mov     cx,0200h
RepeatScanTP1:
REPNE   SCASB
        jcxz    NotTinyProg2
        cmp     word ptr es:[di],0AD01h
        jne     RepeatScanTP1
; found, place a breakpoint
        mov     word ptr es:[di-1],9090h
        mov     byte ptr es:[di+1],90h
        mov     word ptr es:[di+2],80CDh
Loc15_2 equ     $ - 1
        add     di,4
        mov     IP7_2,di
        call    Display0
;
NoExtraRelocEntries:
;
; scan for relocation entries
; see if tinyprog 3.9
        push    di
        mov     al,0D8h
        mov     cx,200h
        cld
RepeatScanTP9:
REPNE   SCASB
        jcxz    NotTinyProg39
        cmp     word ptr es:[di],0F01h
        jne     RepeatScanTP9
        pop     ax
; found, place a bp
;
        mov     word ptr es:[di],80CDh
Loc38   equ     $ - 1
        add     di,2
        mov     IP7,di
        call    Display0
;
        mov     byte ptr cs:ES2DS,00h
        jmp     short Skip3_3_3_6
NotTinyProg39:
        pop     di
;
        cld
        mov     al,26h
        mov     cx,0200h
RepeatScanTP3:
REPNE   SCASB
        jcxz    NotTinyProg2
        cmp     word ptr es:[di],0701h  ; TINYPROG 3.8
        je      FoundTINY1
        cmp     word ptr es:[di],0901h  ; TINYPROG 1.0
        je      FoundTINY1
        cmp     word ptr es:[di],0F01h
        jne     RepeatScanTP3
FoundTINY1:
; found, place a breakpoint
        mov     byte ptr es:[di-1],90h
        mov     word ptr es:[di],80CDh
Loc15   equ     $ - 1
        add     di,2
        mov     IP7,di
        call    Display0

Skip3_3_3_6:
; scan for number of bytes
        cld
        mov     al,0Eh
        mov     cx,020d
RepeatScanTP2:
REPNE   SCASB
NotTinyProg3:
        jcxz    NotTinyProg2_2
        cmp     byte ptr es:[di],1Fh
        jne     RepeatScanTP2
; found, place a breakpoint
        mov     word ptr es:[di-1],80CDh
Loc14   equ     $ - 1
        add     di,1
        mov     IP6,di
        call    Display0
; scan for the far jump to the user code
        cld
        mov     al,2Eh
        mov     cx,0200h
RepeatScanTP4:
REPNE   SCASB
        jcxz    NotTinyProg3
        cmp     word ptr es:[di],000Ch
        jne     RepeatScanTP4
; found, place a breakpoint
        mov     byte ptr es:[di-3],90h
        mov     word ptr es:[di-2],9090h
        mov     word ptr es:[di],80CDh
Loc16   equ     $ - 1
        add     di,2
        mov     IP8,di
;        call    Display
        jmp     End80h
NotTinyProg2_2:
        jmp     NotTinyProg2
NotIP5:
;
        db      3Dh   ;  <==>    cmp ax,
IP6     dw      0000h
        je      YesIP6
        jmp     NotIP6
YesIP6:
; number of bytes, PUSH CS, POP DS
; execute the instruction
        mov     ax,[bp+2]
        mov     saveDS,ax
; number of bytes is ES:DI - segcode:100h
        push    es
        pop     ax
        sub     ax,segcode
        mov     highsz,ax
        sub     di,0100h
        mov     lowsz,di
;        call    Display
        jmp     End80h
NotIP6:
;
;
        db      3Dh   ;  <==>    cmp ax,
IP7     dw      0000h
        je      YesIP7
        jmp     NotIP7
YesIP7:
; relocation entries, add es:[bx],cx (add [bx],cx for 3.9)
; add es:[bx],ax for 3.8, but cx==ax
; add es:[bx+di],cx for TINYPROG 1.0
        mov     si,RTpoi
        mov     ax,es
        test    bx,0FF00h
        jz      Skip100
        sub     bx,0100h
        jmp     short BXOK
Skip100:
        sub     ax,0010h
BXOK:
        cmp     word ptr version0,OFFSET TINY10
        jne     NotTINYPROG10
        add     bx,saveDI
NotTINYPROG10:
        mov     [si],bx
        jmp     short Over39
ES2DS   equ     $ - 1
        mov     ax,cs:saveDS
Over39:
;
        sub     ax,cx
        add     ax,0010h
        mov     [si+2],ax
        add     si,4
        mov     RTpoi,si
        sub     si,OFFSET RT
        cmp     si,RTLen
        jb      RTOK2
        mov     dx,OFFSET ErrM12
        jmp     DebugErr
RTOK2:
;        call    Display
        jmp     End80h
NotIP7:
;
;
        db      3Dh   ;  <==>    cmp ax,
IP7_2   dw      0000h
        je      YesIP7_2
        jmp     NotIP7_2
YesIP7_2:
; relocation entries, add es:[bx],cx
; add es:[bx+di],cx for TINYPROG 1.0
; add es:[di-202h],bp
        mov     si,RTpoi
        mov     bp,saveBP
;
;        mov     di,saveDI
        sub     di,202h + 100h
        mov     [si],di
        mov     ax,es
;        mov     ax,saveES
        sub     ax,bp
        add     ax,0010h
        mov     [si+2],ax
        add     si,4
        mov     RTpoi,si
        sub     si,OFFSET RT
        cmp     si,RTLen
        jb      RTOK2_2
        mov     dx,OFFSET ErrM12
        jmp     DebugErr
RTOK2_2:
;        call    Display
        jmp     End80h
NotIP7_2:
;
;
        db      3Dh   ;  <==>    cmp ax,
IP8     dw      0000h
        je      YesIP8
        jmp     NotIP8
YesIP8:
; jump to user code, jmp far cs:[000Ch]
; get SS:SP and CS:IP
        mov     ax,sp
        add     ax,6
        mov     x10,ax       ; initial SP
        mov     ax,segcode
        mov     bx,ss
        sub     bx,ax
        sub     bx,0010h
        mov     x0E,bx       ; initial offset of SS
        mov     es,[bp+2]       ; decompression code's CS
        mov     ax,es:[000Ch]
        mov     x14,ax       ; initial IP
        mov     ax,es:[000Eh]
        sub     ax,segcode
        sub     ax,0010h
        mov     x16,ax       ; initial offset of CS
        jmp     SaveImage
NotIP8:
;
        db      3Dh   ;  <==>    cmp ax,
IP9     dw      0000h
        je      YesIP9
        jmp     NotIP9
YesIP9:
; first LZEXE entry
; set up the return address, AX=return IP
        pop     bx
        mov     bp,sp
        mov     [bp],ax ; return IP
        mov     di,ax
        mov     ax,[bp+2]       ; flags
        mov     bx,[bp+4]       ; return CS
        mov     es,bx
        mov     [bp+2],bx
        mov     [bp+4],ax
; find number of bytes
LZEXEProcess:
        cld
        push    di
        mov     al,0DAh
        mov     cx,0200h
RepLZEXE2:
REPNE   SCASB
        jcxz    TryOtherLZEXE
        cmp     word ptr es:[di],0FF31h
        jne     RepLZEXE2
        mov     word ptr es:[di],80CDh
Loc18   equ     $ - 1
        add     di,2
        mov     IP10,di
        call    Display0
        pop     ax
        jmp     short FoundLZ
NotLZEXE3:
        jmp     NotLZEXE
Try090:
; v0.90?
        pop     di
        mov     al,0ADh
        mov     cx,0300h
Repeatv090:
REPNE   SCASB
        jcxz    NotLZEXE3
        cmp     es:[di-3],0D231h
        jne     Repeatv090
        mov     word ptr es:[di-3],80CDh
Loc32   equ     $ - 1
        dec     di
        mov     IP10,di
        mov     SingRet,01h     ; LZEXE 090, xor dx,dx instead of xor di,di
        call    Display0
        jmp     short FoundLZ
;
TryOtherLZEXE:
        pop     di
        push    di
        mov     al,01Fh
        mov     cx,0200h
RepLZEXE3Other:
REPNE   SCASB
        jcxz    Try090
        cmp     word ptr es:[di],071Eh
        jne     RepLZEXE3Other
        mov     word ptr es:[di],80CDh
Loc29   equ     $ - 1
        add     di,2
        mov     IP19,di
        call    Display0
; find relocation code for different LZEXE add es:[di],dx
        cld
        mov     al,26h
        mov     cx,0200h
RepLZEXE4Other:
REPNE   SCASB
        jcxz    NotLZEXE2
        cmp     word ptr es:[di],1501h
        jne     RepLZEXE4Other
        mov     byte ptr es:[di-1],90h
        mov     word ptr es:[di],80CDh
Loc30   equ     $ - 1
        add     di,2
        mov     IP20,di
        call    Display0
        pop     ax
        jmp     short FinishLZ
FoundLZ:
; find relocation code
        cld
        mov     al,26h
        mov     cx,0200h
RepLZEXE3:
REPNE   SCASB
        jcxz    NotLZEXE2
        cmp     word ptr es:[di],1D01h
        jne     RepLZEXE3
        mov     byte ptr es:[di-1],90h
        mov     word ptr es:[di],80CDh
Loc19   equ     $ - 1
        add     di,2
        mov     IP3,di       ; reuse old IP
        call    Display0

FinishLZ:
; find end of decompression (same for EXEPACK)
        cld
        mov     al,2Eh
        mov     cx,0200h
RepLZEXE4:
REPNE   SCASB
        jcxz    NotLZEXE2
        cmp     word ptr es:[di],2FFFh
        jne     RepLZEXE4
        mov     byte ptr es:[di-1],90h
        mov     word ptr es:[di],80CDh
Loc21   equ     $ - 1
        add     di,2
        mov     IP11,di
;
;        call    Display
        jmp     End80h
NotLZEXE2:
        jmp     NotLZEXE
NotIP9:
;
        db      3Dh   ;  <==>    cmp ax,
IP10    dw      0000h
        je      YesIP10
        jmp     NotIP10
YesIP10:
; LZEXE
; number of bytes is ES:DI - segcode:100h
        push    es
        pop     ax
        sub     ax,segcode
        mov     highsz,ax
        sub     di,0100h
        mov     lowsz,di
        cmp     SingRet,00h
        jz      v091
        mov     word ptr saveDX,0000h ; xor dx,dx for v090
        jmp     short DoneIP10
v091:
        mov     word ptr saveDI,0000h ; execute xor di,di for v091
DoneIP10:
;        call    Display
        jmp     End80h
NotIP10:
;
        db      3Dh   ;  <==>    cmp ax,
IP11    dw      0000h
        je      YesIP11
        jmp     NotIP11
YesIP11:
        mov     ax,sp
        add     ax,6
        mov     x10,ax       ; initial SP
        mov     ax,segcode
        mov     bx,ss
        sub     bx,ax
        sub     bx,0010h
        mov     x0E,bx       ; initial offset of SS
        mov     es,[bp+2]       ; decompression code's CS
        mov     bx,saveBX
        mov     ax,es:[bx]
        mov     x14,ax       ; initial IP
        mov     ax,es:[bx+2]
        sub     ax,segcode
        sub     ax,0010h
        mov     x16,ax       ; initial offset of CS
        jmp     SaveImage
NotIP11:
;
        db      3Dh   ;  <==>    cmp ax,
IP12    dw      0000h
        je      YesIP12
        jmp     NotIP12
NotDIET2:
        jmp     NotDIET
YesIP12:
; get the starting segment of the user code
        mov     ax,saveES
        mov     base,ax
; execute the instruction
        mov     ax,saveDX
        mov     al,10h
        mov     saveDX,ax
; get the return CS:IP and setup the return
        mov     es,[bp+2]       ; CS
        mov     di,[bp]         ; IP
        mov     ax,es:[di+1]    ; return IP
        mov     [bp],ax
        mov     ax,es:[di+3]    ; return CS
        mov     [bp+2],ax
        mov     es,ax
        mov     di,[bp]
;
DIETcontinue:
; see if it's the DIET w/o relocation items
        cld
        mov     al,8Eh
        mov     cx,200h
        mov     dx,di
; collect bytes here also
RepeatDIET00:
REPNE   SCASB
        jcxz    NotNoReloc__
        cmp     word ptr es:[di],5FC0h
        jne     RepeatDIET00
        mov     word ptr es:[di-1],80CDh
Loc22_3 equ     $ - 1
        inc     di
        mov     IP13_2,di
        mov     byte ptr cs:NoRDIET,1
;        call    Display
;        jmp     End80h
NotNoReloc__:
;
        mov     di,dx
        mov     al,33h
        mov     cx,200h
RepeatDIET0:
REPNE   SCASB
        jcxz    NotNoReloc
        cmp     word ptr es:[di],33FFh
        jne     RepeatDIET0
        mov     word ptr es:[di-1],80CDh
Loc22_2 equ     $ - 1
        inc     di
        mov     IP13,di
        mov     byte ptr cs:NoRDIET,1
;        call    Display
;        jmp     End80h
NotNoReloc:
        mov     di,dx
; find number of bytes
        cld
        mov     al,5Dh
        mov     cx,200h
RepeatDIET2:
REPNE   SCASB
        jcxz    DoNoRelocDIET
;        jcxz    NotDIET2
        cmp     word ptr es:[di],1F0Eh
        jne     RepeatDIET2
        mov     word ptr es:[di],80CDh
Loc22   equ     $ - 1
        add     di,2
        mov     IP13,di       ; reuse old IP
        call    Display0
        mov     byte ptr cs:NoRDIET,0
; setup relocation code
        cld
        mov     al,26h
        mov     cx,0200h
RepDIET3:
REPNE   SCASB
        jcxz    NotDIET2_
        cmp     word ptr es:[di],2F01h
        jne     RepDIET3
        mov     byte ptr es:[di-1],90h
        mov     word ptr es:[di],80CDh
Loc23   equ     $ - 1
        add     di,2
        mov     IP14,di
        call    Display0
DoNOR:
; find the end
        mov     al,0EAh
        cld
        mov     cx,0200h
RepeatDIET3:
REPNE   SCASB
        jcxz    NotDIET3
        cmp     byte ptr es:[di-4],33h
        je      FoundEndofDIET1
        cmp     byte ptr es:[di-3],33h
        je      FoundEndofDIET2
        jmp     short RepeatDIET3
DoNoRelocDIET:
        mov     di,dx
        cmp     byte ptr cs:NoRDIET,1
        je      DoNOR
NotDIET2_:
        jmp     NotDIET2
FoundEndofDIET1:
        mov     byte ptr es:[di-4],90h
FoundEndofDIET2:
        dec     di
        mov     word ptr es:[di-2],80CDh
Loc24   equ     $ - 1
        mov     IP15,di
;        call    Display
        jmp     End80h
NotDIET3:
        jmp     NotDIET
NotIP12:
;
        db      3Dh   ;  <==>    cmp ax,
IP12_2  dw      0000h
        je      YesIP12_2
        jmp     NotIP12_2
YesIP12_2:
; get the starting segment of the user code
        mov     ax,saveES
        mov     base,ax
; execute MOV DL,10 and RETF
        push    ax
        mov     ax,saveDX
        mov     al,10h
        mov     saveDX,ax
        pop     ax
; do the RETF stuff
        pop     ax
        pop     ax
        mov     bp,sp
        mov     ax,[bp+2]
        mov     [bp],ax
        mov     di,ax
        mov     ax,[bp+4]
        mov     [bp+2],ax
        mov     es,ax
        pushf
        pop     ax
        mov     [bp+4],ax
        jmp     DIETContinue
        jmp     End80h
NotIP12_2:
;
;
        db      3Dh   ;  <==>    cmp ax,
IP13    dw      0000h
        je      YesIP13
        jmp     NotIP13
YesIP13:
        cmp     byte ptr cs:NoRDIET,0
        jnz     NoRDIET_
; execute the instruction, mov ds,cs
        mov     ax,[bp+2]
        mov     saveDS,ax
        jmp     short RDIET
NoRDIET_:
        mov     word ptr cs:saveDI,0000h
RDIET:
; get the code size
; number of bytes is ES:DI - base:100h
        mov     ax,saveES
        sub     ax,base
;        mov     highsz,ax
;        mov     lowsz,di

        add     highsz,ax
        add     lowsz,di
        cmp     byte ptr NoRDIET,1
        jne     SkipNoRDIET000
        add     lowsz,215d
SkipNoRDIET000:
; there's an old .EXE header appended at the end of the image
; put as much as possible into lowsz
        mov     cx,4
        mov     ax,lowsz
        shr     ax,cl
        add     highsz,ax
        and     word ptr lowsz,000Fh
        mov     bx,highsz
        test    bx,0F000h
        jz      SkipHigh
        add     lowsz,0FFE0h
        sub     highsz,0FFEh
        jmp     short SkipHigh2
SkipHigh:
        shl     bx,cl
        add     lowsz,bx
        shr     bx,cl
        sub     highsz,bx
SkipHigh2:
; set the segment 1 back, subtract relocations and do backward search for MZ
        mov     ax,lowsz
        mov     cx,4
        shr     ax,cl
        mov     dx,saveES
        mov     es,dx
        cmp     dx,ax
        jna     SkipSubAX
        cmp     word ptr lowsz,0FF00h
        jna     SkipSubAX
        sub     dx,ax
        mov     bx,saveDI
        shr     bx,cl
        add     dx,bx
        mov     es,dx   ; search this segment
SkipSubAX:
        mov     cx,lowsz
        mov     di,cx
        push    es
        mov     es,[bp+2]
;
; number of relocation entries should be equal to that in the header
        mov     si,[bp]
        mov     bx,1
        cmp     byte ptr es:[si],0BEh
        jne     SkipAddBX
        add     bx,3
SkipAddBX:
        cmp     byte ptr Which,08h
        jne     NotDIET145f
        mov     bx,0Bh
NotDIET145f:
        mov     bx,es:[si+bx] ; number of relocation entries from mov cx,xxxx
        cmp     byte ptr cs:NoRDIET,1
        jne     SkipDIET1
        xor     bx,bx
SkipDIET1:
        pop     es
;
        mov     dx,di
;        cmp     byte ptr Which,08h
;        je      SkipDIET2
        cmp     byte ptr cs:NoRDIET,1
        je      SkipDIET2
;
; search for MZ backwards
        mov     al,'Z'
        std
RepeatDIETMem:
REPNE   SCASB
        jcxz    NotDIET4
        cmp     byte ptr es:[di],'M'
        jne     RepeatDIETMem
        cmp     es:[di+06h],bx
        jne     RepeatDIETMem
; get memory size
        mov     ax,es:[di+0Ah]
        mov     x0A,ax
        mov     ax,es:[di+0Ch]
        mov     x0C,ax
        mov     byte ptr DIET145memok,1
SkipDIET2:
; reduce the file size to the end of file
        mov     ax,lowsz
        sub     ax,di
        sub     lowsz,ax
        sub     lowsz,0010h  ; this must be here
;
;        call    Display
        jmp     End80h
NotDIET4:
        mov     di,dx
        jmp     short SkipDIET2
        jmp     NotDIET
NotIP13:
;
;
        db      3Dh   ;  <==>    cmp ax,
IP13_2  dw      0000h
        je      YesIP13_2
        jmp     NotIP13_2
YesIP13_2:
;
        cmp     byte ptr NoRDIET,1
        jne     SkipNoR
        mov     bp,sp
        mov     di,[bp+6]       ; the next instruction is pop di
; number of bytes is ES:DI - base:100h
        mov     ax,saveES
        sub     ax,base
;        add     highsz,ax
        add     lowsz,di
; move everything possible into highsz
        mov     ax,di
        shr     ax,1
        shr     ax,1
        shr     ax,1
        shr     ax,1
        add     highsz,ax
        and     word ptr lowsz,000Fh
; do some mysterious manipulations
        sub     highsz,200h
        and     di,000Fh
        sub     lowsz,di
SkipNoR:
; execute the replaced instruction
        mov     ax,saveAX
        mov     saveES,ax
;
;        call    Display
        jmp     End80h
NotIP13_2:
;
        db      3Dh   ;  <==>    cmp ax,
IP14    dw      0000h
        je      YesIP14
        jmp     NotIP14
YesIP14:
; relocation entries, add es:[bx],bp
        mov     si,RTpoi
        mov     [si],bx
        mov     ax,es
        sub     ax,saveBP
        mov     [si+2],ax
        add     si,4
        mov     RTpoi,si
        sub     si,OFFSET RT
        cmp     si,RTLen
        jb      RTOK3
        mov     dx,OFFSET ErrM12
        jmp     DebugErr
RTOK3:
;        call    Display
        jmp     End80h
NotIP14:
;
        db      3Dh   ;  <==>    cmp ax,
IP15    dw      0000h
        je      YesIP15
        jmp     NotIP15
YesIP15:
        add     sp,6
        mov     ax,sp
        mov     x10,ax       ; SP
        mov     ax,ss
        sub     ax,base
        dec     ax
        mov     x0E,ax       ; SS
        mov     di,[bp]
        mov     es,[bp+2]
        mov     ax,es:[di+1]
        mov     x14,ax       ; IP
        mov     ax,es:[di+3]    ; CS
        dec     ax
        sub     ax,base
        mov     x16,ax
        jmp     SaveImage
NotIP15:
;
        db      3Dh   ;  <==>    cmp ax,
IP16    dw      0000h
        je      YesIP16
        jmp     NotIP16
YesIP16:
; AX has the return IP, CS is on the stack
        pop     ax
        mov     ax,saveAX    ; return IP
        mov     bp,sp
        mov     [bp],ax
        mov     di,ax
        mov     ax,[bp+2] ; flags
        mov     bx,[bp+4] ; return CS
        mov     [bp+2],bx
        mov     es,bx
        mov     [bp+4],ax
;
        cmp     byte ptr Which,7
        jne     NotOPTLINK2
; put a breakpoint at the end
        mov     al,2Eh
        cld
        mov     cx,0200h
RepeatOPT1:
REPNE   SCASB
        jcxz    Unknown2
        cmp     word ptr es:[di],2EFFh
        jne     RepeatOPT1
        mov     byte ptr es:[di-1],90h
        mov     word ptr es:[di],80CDh
Loc33   equ     $ - 1
        add     di,2
        mov     IP22,di
;        call    Display
        jmp     End80h
;
NotOPTLINK2:
; ES:0000h (or ES-1000h:0FFFFh) is where the end of the uncompressed code is
        mov     tmp,es

; find the relocation code
        mov     al,26h
        cld
        mov     cx,0200h
RepeatEP3:
REPNE   SCASB
        jcxz    Unknown2
        cmp     word ptr es:[di],1D01h
        jne     RepeatEP3
        mov     byte ptr es:[di-1],90h
        mov     word ptr es:[di],80CDh
Loc26   equ     $ - 1
        add     di,2
        mov     IP3,di       ; reuse old IP
        call    Display0

; find the end jmp far cs:[bx], reuse LZEXE code
        cld
        mov     al,2Eh
        mov     cx,0200h
RepEP4:
REPNE   SCASB
        jcxz    Unknown2
        cmp     word ptr es:[di],2FFFh
        jne     RepEP4
        mov     byte ptr es:[di-1],90h
        mov     word ptr es:[di],80CDh
Loc27   equ     $ - 1
        add     di,2
        mov     IP17,di
;        call    Display
        jmp     End80h
;
Unknown2:
        jmp     Unknown666
NotIP16:
;
        db      3Dh   ;  <==>    cmp ax,
IP17    dw      0000h
        je      YesIP17
        jmp     NotIP17
YesIP17:
; get size for EXEPACK and then return (same as LZEXE return)
        mov     word ptr lowsz,0000h
        mov     ax,tmp
        mov     bx,saveDS
        sub     ax,bx
        sub     ax,10
        mov     highsz,ax
;

        jmp     YesIP11
NotIP17:
;
;
        db      3Dh   ;  <==>    cmp ax,
IP18    dw      0000h
        je      YesIP18
        jmp     NotIP18
YesIP18:
; some other kind of LZEXE
; execute mov bp,[000Ah]
        mov     es,saveDS
        mov     ax,es:[000Ah]
        mov     saveBP,ax
; reset return address
        pop     ax
        pop     ax
        mov     bp,sp
        mov     ax,[bp] ; flags
        mov     bx,[bp+4] ; CS
        mov     [bp+4],ax
        mov     ax,[bp+2] ; IP
        mov     [bp+2],bx
        mov     es,bx
        mov     [bp],ax
        mov     di,ax
        jmp     LZEXEProcess
NotIP18:
;
        db      3Dh   ;  <==>    cmp ax,
IP19    dw      0000h
        je      YesIP19
        jmp     NotIP19
YesIP19:
; some other kind of LZEXE
; number of bytes
; execute push ds, pop es
        mov     ax,saveDS
        mov     saveES,ax
        jmp     YesIP10
NotIP19:
;
;
        db      3Dh   ;  <==>    cmp ax,
IP20    dw      0000h
        je      YesIP20
        jmp     NotIP20
YesIP20:
; some other kind of LZEXE
; relocation add es:[di],dx in old LZEXE add es:[di],bx
        mov     bx,saveDX
        jmp     YesIP3
NotIP20:
;
;
        db      3Dh   ;  <==>    cmp ax,
IP21    dw      0000h
        je      YesIP21
        jmp     NotIP21
YesIP21:
; first entry into PKLITE 1.00 gamebytes
; AX has the return IP, CS is on the stack
        pop     ax
        mov     ax,saveAX
        mov     bp,sp
        mov     [bp],ax         ; return IP
        mov     di,ax
        mov     ax,[bp+2]       ; flags
        mov     bx,[bp+4]       ; return CS
        mov     es,bx
        mov     [bp+4],ax
        mov     [bp+2],bx
        jmp     ResetDone
;
;        jmp     End80h
NotIP21:
;
        db      3Dh   ;  <==>    cmp ax,
IP22    dw      0000h
        je      YesIP22
        jmp     NotIP22
YesIP22:
; OPTLINK end
        push    ax      ; return IP
;
;        push    es
        push    bx
        pop     ax
        sub     ax,segcode
        mov     highsz,ax
        sub     di,0100h
        mov     lowsz,di
;
        mov     ax,sp
        add     ax,6
        add     ax,2    ; for OPTLINK
        mov     x10,ax       ; initial SP
        mov     ax,segcode
        mov     bx,ss
        sub     bx,ax
        sub     bx,0010h
        mov     x0E,bx       ; initial offset of SS
        mov     es,[bp+2]       ; decompression code's CS
        pop     bx      ; return IP
        mov     bx,es:[bx]
        mov     ax,es:[bx]
        mov     x14,ax       ; initial IP
        mov     ax,es:[bx+2]
        sub     ax,segcode
        sub     ax,0010h
        mov     x16,ax       ; initial offset of CS
        jmp     SaveImage
;
;        jmp     End80h
NotIP22:
;
;
        db      3Dh   ;  <==>    cmp ax,
IP23    dw      0000h
        je      YesIP23
        jmp     NotIP23
YesIP23:
; OPTLINK  inner SLR
; execute instruction
        mov     dx,saveDX
        mov     saveES,dx
; get the base
        mov     base,dx
        jmp     End80h
NotIP23:
;
;
        db      3Dh   ;  <==>    cmp ax,
IP24    dw      0000h
        je      YesIP24
        jmp     NotIP24
YesIP24:
; OPTLINK  inner SLR
; number of bytes
; execute instruction
        mov     dx,saveDX
        mov     saveDS,dx
;
; get the code size
; number of bytes is ES:DI - base:100h
        mov     ax,saveES
        sub     ax,base
        mov     highsz,ax
        mov     lowsz,di
        jmp     End80h
NotIP24:
;
;
        db      3Dh   ;  <==>    cmp ax,
IP25    dw      0000h
        je      YesIP25
        jmp     NotIP25
YesIP25:
; OPTLINK  inner SLR
; relocation entries, mov bx,ax & xchg es:[di-1],bx
; save relocation entries
; relocation entries, ala add es:[bx],bp
        mov     si,RTpoi
        mov     di,saveDI
        dec     di
; figure out what should be at es:[di-1]
        mov     ax,saveBX
        sub     ax,base
; execute
        mov     bx,es:[di]
        mov     saveBX,bx
;
        mov     es:[di],ax
;
        mov     [si],di
        mov     ax,es
        sub     ax,base
        mov     [si+2],ax
        add     si,4
        mov     RTpoi,si
        sub     si,OFFSET RT
;
        cmp     si,RTLen
        jb      RTOK4
        mov     dx,OFFSET ErrM12
        jmp     DebugErr
RTOK4:
        jmp     End80h
NotIP25:
;
;
        db      3Dh   ;  <==>    cmp ax,
IP26    dw      0000h
        je      YesIP26
        jmp     NotIP26
YesIP26:
; OPTLINK  inner SLR
; AX has the IP
        push    ax      ; return IP
;
        mov     ax,sp
        add     ax,6
        add     ax,2    ; for OPTLINK
        mov     x10,ax       ; initial SP
        mov     ax,segcode
        mov     bx,ss
        sub     bx,ax
        sub     bx,0010h
        mov     x0E,bx       ; initial offset of SS
        mov     es,[bp+2]       ; decompression code's CS
        pop     bx      ; return IP
        mov     bx,es:[bx]
        mov     ax,es:[bx]
        mov     x14,ax       ; initial IP
        mov     ax,es:[bx+2]
        sub     ax,segcode
        sub     ax,0010h
        mov     x16,ax       ; initial offset of CS
        jmp     SaveImage

; jmp cs:[

        jmp     End80h
NotIP26:
;

;
;
;
;
        db      3Dh   ;  <==>    cmp ax,
IP4     dw      0000h
        je      YesIP4
        jmp     NotIP4
YesIP4:
; forth entry, 2nd RETF, save the image at ES:100h into a file and exit
        add     sp,6h
        mov     ax,sp
        add     ax,0004h
        mov     cs:x10,ax       ; initial SP
        mov     ax,cs:segcode
        mov     bx,ss
        sub     bx,ax
        sub     bx,0010h
        mov     cs:x0E,bx       ; initial offset of SS
;
        mov     bp,sp
        mov     ax,[bp]
        mov     cs:x14,ax       ; initial IP
        mov     ax,[bp+2]
        sub     ax,cs:segcode
        sub     ax,0010h
        mov     cs:x16,ax       ; initial offset of CS
;
SaveImage:
        cli
        mov     ax,cs
        mov     ss,ax
        mov     sp,OFFSET sta
        sti
        xor     ax,ax
        push    ax
;
        push    cs
        push    cs
        pop     ds
        pop     es
        call    Restore


; get the number of relocation entries
        mov     ax,RTpoi
        sub     ax,OFFSET RT
        shr     ax,1
        shr     ax,1
        mov     x06,ax  ; number of relocation entries

        call    Optimize        ; optimize the relocation entries

; write the EXE header and the relocation table
        mov     ax,RTpoi
        sub     ax,OFFSET RT
        add     ax,001Ch
        mov     cx,4
        test    ax,000Fh
        jz      SkipOneLine
        add     ax,0010h
SkipOneLine:
        shr     ax,cl
        mov     x08,ax
        shl     ax,cl
        mov     cx,ax ; size of the .EXE header
        mov     tmp,cx
;
; check the PSP for 'pk' signature or other stuff
        cmp     Which,00h
        je      PutExtra
        jmp     DontPutExtra
PutExtra:
        push    cs
        pop     ds
        mov     es,segcode
        mov     cx,es:[5Ch] ; get the stuff from PSP
Kludge  equ     $
        jcxz    DontPutExtra2
        jmp     short PutExtra0
DontPutExtra2:
        jmp     DontPutExtra
PutExtra0:
;
; increase load image (file) size by 18d bytes
        push    cx
        mov     cx,4
        mov     ax,lowsz
        shr     ax,cl
        add     highsz,ax
        mov     ax,lowsz
        and     ax,000Fh
        add     ax,18d  ; extra bytes
        mov     lowsz,ax
        pop     cx

; put extra code at the end of the image, adjusting the size and CS:IP
; the end of image is stored in tmp2:tmp1
        mov     es,tmp2
        mov     di,tmp1
        mov     word ptr es:[di],06C7h  ; mov
        mov     word ptr es:[di+2],005Ch; [005Ch],
        mov     es:[di+4],cx            ; cx    == signature code
        mov     word ptr es:[di+6],0C88Ch ; mov ax,cs
        mov     byte ptr es:[di+8],2Dh    ; sub ax,_es_ - (_x16_ + segcode)
        mov     ax,es
        sub     ax,x16
        sub     ax,segcode
        mov     es:[di+9h],ax            ;
        mov     word ptr es:[di+0Bh],0B850         ; push ax & mov ax,
        mov     ax,x14
        mov     es:[di+0Dh],ax           ; _x14_
        mov     word ptr es:[di+0Fh],0CB50h       ; push ax
                                        ; retf

; check whether a jump could be used
; should be in the same segment
        mov     ax,tmp1
        mov     cx,4
        shr     ax,cl
        add     tmp2,ax
        and     word ptr tmp1,000Fh
        mov     ax,tmp2
        sub     ax,segcode
        sub     ax,x16  ; must be less than 0FFFh, 1 segment
        cmp     ax,0FFFh
        jnb     DontPutLess
        shl     ax,cl   ; offset
        add     ax,tmp1
        sub     ax,100h
        mov     bx,x14
        mov     x14,ax
        add     ax,9d
        mov     byte ptr es:[di+6],0E9h
        sub     ax,bx
        neg     ax
        mov     word ptr es:[di+7],ax

;
; decrease image (file) size
        sub     lowsz,9d
        jmp     short ResetCSDone
DontPutLess:
; reset the CS:IP
        sub     di,0100h
        mov     x14,di
        mov     ax,es
        sub     ax,segcode
        mov     x16,ax
ResetCSDone:
        mov     ds,segcode
        mov     ax,ds:[005Ch]
        push    cs
        pop     ds
        mov     PKCode,ax
DontPutExtra:
;
        push    cs
        pop     es

;
; determine the size of the file
        mov     ax,lowsz
        mov     cx,4
        shr     ax,cl
        mov     bx,highsz
        add     bx,ax
        mov     newexe,bx       ; the size of load image
        add     bx,x08
        mov     ax,lowsz
        and     ax,000Fh
        mov     x02,ax
        push    bx
        mov     freehi,bx
;
; kinda specify min memory for PKLITE only and PKLITE 1.00
;
        cmp     byte ptr Which,06h
        je      PKLITEMinMem
        cmp     byte ptr Which,00h       ; 00=pklite, 01=tinyprog
        jne     SkipMinMem
PKLITEMinMem:
        mov     dx,needPK
        sub     dx,bx   ; BX has the load image +/- 10h bytes.. + header size
        add     dx,x08
        add     dx,000Fh
        mov     x0A,dx
; check if this number is reasonable
        mov     cx,normMin
        jcxz    SkipMinMem
        cmp     dx,cx
        jb      SkipMinMem ; calculated PKLITE less than normal,very suspicious
        mov     ax,normMin
        mov     x0A,ax
        mov     ax,normMax
        mov     x0C,ax
SkipMinMem:
;
        pop     bx
        mov     ax,bx
        mov     bx,0020h
        xor     dx,dx
        div     bx
        mov     x04,ax
        mov     cx,4
        shl     dx,cl
        add     x02,dx
        cmp     x02,0000h
        jz      Skipx04
        inc     word ptr x04
Skipx04:

        cmp     byte ptr Which,09h      ; SLR
        je      UseLogicalMem
        cmp     byte ptr Which,08h      ; DIET 145
        je      UseLogicalMem
        cmp     byte ptr Which,07h      ; OPTLINK
        je      UseLogicalMem
        cmp     byte ptr NoRDIET,1      ; no relocation DIET
        jne     SkipLogicalMem
UseLogicalMem:
        cmp     byte ptr DIET145memok,1
        je      SkipLogicalMem
        mov     ax,newexe
        sub     ax,oldexe
        sub     x0A,ax
SkipLogicalMem:
;
; memory for TINYPROG
        cmp     Which,01h
        jne     SkipMM3
        mov     ax,newexe
        sub     ax,oldexe
        sub     x0A,ax
        add     x0A,5
SkipMM3:

;
        cmp     byte ptr Which,05h       ; hacked LZEXE
        je      UseLZEXE
; try to determine memory needed for LZEXE file
        cmp     Which,02h       ; 02=LZEXE
        jne     SkipMM2
UseLZEXE:
        mov     ax,newexe
        sub     ax,oldexe
        mov     bx,needLZ
        mov     ax,x0A
        mov     cx,oldmin; oldmin
        cmp     bx,ax
        je      SkipMM2_0
        sub     x0A,ax  ; newmin=oldmin-(newexe-oldexe) ?
SkipMM2_0:
        sub     cx,ax
        mov     dx,x0C  ; oldmax
        cmp     dx,0FFFFh
        je      SkipMM2
        sub     dx,cx   ; newmax=oldmax-(oldmin-newmin)
        mov     x0C,dx  ; newmax
SkipMM2:

; check whether the load size and memory are ok
        cmp     byte ptr Which,05h
        jne     NotHacked
        mov     ax,x04
        mov     cx,5
        shl     ax,cl   ; load image size in paragraphs
        mov     bx,8700h ; assume maximum memory (552Kbytes)
        sub     bx,ax
        cmp     bx,x0A  ; memory needed
        ja      NotHacked
        mov     ax,newexe
        sub     ax,oldexe
        sub     x0A,ax
NotHacked:

;
; memory for EXEPACKed file
        cmp     Which,04h
        jne     NotEXEPACKM
; newmin=oldmin-(newexe-oldexe) ?
        mov     ax,newexe
        sub     ax,oldexe
        mov     bx,oldmin
        sub     bx,ax
        mov     x0A,bx
NotEXEPACKM:

;
; check if the drive has enough free space
; check if the file is on another drive
;
        mov     di,fileb
        xor     dx,dx
        cmp     byte ptr [di+1],':'
        jne     SameDrive
        mov     dl,[di]
        and     dl,5Fh  ; uppercase
        sub     dl,40h  ; A=1, B=2 , etc.
SameDrive:
        mov     ah,36h
        int     21h
        xor     dx,dx
        mul     bx
; ax has the number of free sectors
        push    ax
        mov     dx,cx
        mov     cx,4
        shr     dx,cl
; dx has the number of bytes per sector / 10h
        mov     bx,dx
        mov     ax,freehi       ; the space file needs (bytes/10h)
        inc     ax
        xor     dx,dx
        div     bx
; ax has the number of sectors need to save the file
        pop     bx
        cmp     bx,ax
        ja      EnoughDiskSpace
        mov     dx,OFFSET ErrM16
        jmp     DebugErr
EnoughDiskSpace:

        push    cs
        pop     es

; set int 24h
        mov     ax,2524h
        mov     dx,OFFSET int24h
        int     21h

; create a file
        mov     ah,5Bh
        mov     dx,outfb
        xor     cx,cx
        int     21h
        jnc     CreateOK
        cmp     al,50h
        jne     NotExist
        cmp     outfe,0000h
Overwrite equ $
        je      CreateOK        ; input = output
        mov     dx,OFFSET ErrM19
        jmp     DebugErr
NotExist:
        mov     dx,OFFSET ErrM11
        jmp     DebugErr
CreateOK:
        mov     FH,ax

; close file
        mov     ah,3Eh
        mov     bx,FH
        int     21h

; create/truncate
        mov     ah,3Ch
        mov     dx,OFFSET tmpfile
        xor     cx,cx
        int     21h
        mov     FH,ax
        jc      OpenWError

; close file
        mov     ah,3Eh
        mov     bx,FH
        int     21h

; open file for writing
        mov     ax,3D01h
        mov     dx,OFFSET tmpfile
        int     21h
        jnc     OpenWOK
OpenWError:
        mov     dx,OFFSET ErrM11
        jmp     DebugErr
OpenWOK:
        mov     FH,ax

; check if min memory is more than old min mem
        mov     ax,oldmin
        cmp     ax,x0A
        jnb     SkipOldMin
        mov     x0A,ax
SkipOldMin:

; check if minimum memory requirement is more than maximum! use max then..
        mov     ax,x0C
        cmp     ax,x0A
        jnb     SkipMaxMin
        mov     x0A,ax
SkipMaxMin:

;
; now write all the stuff in the header
        mov     cx,tmp
        mov     ah,40h
        mov     bx,FH
        mov     dx,OFFSET EXE
        int     21h
        jc      WriteError2

; write to the file
        mov     ax,segcode
        add     ax,0010h
        mov     es,ax
KeepWriting:
        mov     cx,lowsz
        cmp     word ptr highsz,0000h
        jz      NotOverSeg
; readjust high and low size of the file
        mov     ax,lowsz
        mov     cx,0004h
        shr     ax,cl
        add     highsz,ax
;
        and     word ptr lowsz,000Fh
        test    word ptr highsz,0F000h
        jnz     OverSeg
        mov     cx,0004h
        mov     ax,highsz
        shl     ax,cl
        add     cs:lowsz,ax
        mov     word ptr highsz,0000h
        mov     cx,lowsz
        jmp     short NotOverSeg
WriteError2:
        jmp     short WriteError
OverSeg:
        sub     highsz,1000h
        mov     cx,0FFFFh
NotOverSeg:
        mov     ah,40h
        mov     bx,cs:FH
        xor     dx,dx
        push    es
        pop     ds
        push    cx
        int     21h
        pop     cx
        jc      WriteError
        cmp     ax,cx
        jne     WriteError
        cmp     cx,0FFFFh
        jne     WriteOut
        mov     ah,40h
        mov     bx,cs:FH
        mov     dx,0FFFFh       ; write one more byte
        mov     cx,1            ; at the segment connection
        int     21h             ;
        push    cs
        pop     ds
        jc      WriteError
        cmp     ax,1
        je      WriteOK
WriteError:
        mov     dx,OFFSET ErrM11
        jmp     DebugErr
WriteOK:
        mov     ax,es
        add     ax,1000h
        mov     es,ax
        jmp     KeepWriting
WriteError3:
        jmp     short WriteError
WriteOUT:

        push    cs
        pop     ds


; set file time and date
        mov     ax,5701h
        mov     bx,FH
        mov     cx,time
        mov     dx,date
FILEDATE:
        int     21h

; close file
        mov     ah,3Eh
        mov     bx,FH
        int     21h

        push    cs
        push    ds
; copy the overlay data if needed
        cmp     byte ptr OVR,00h
Overlay equ     $
        jz      NoOverlayData
; open the original for reading
        mov     ax,3D00h
        mov     dx,fileb
        int     21h
        mov     FH,ax
; open the temp file for writing
        mov     ax,3D01h
        mov     dx,OFFSET tmpfile
        int     21h
        mov     tmp,ax

; move the file pointer to the end of the temp file
        mov     ax,4202h
        mov     bx,tmp
        xor     cx,cx
        xor     dx,dx
        int     21h

; move file pointer to the end of the image of the original file
        mov     ax,4200h
        mov     bx,FH
        mov     cx,OvrHigh
        mov     dx,OvrLow
        int     21h

CopyOverlay:
; read the overlay
        mov     ah,3Fh
        mov     bx,FH
        mov     cx,9000h
        mov     dx,OFFSET RT    ; overwrite the relocation table
        int     21h

; write the overlay
        mov     bx,tmp
        mov     cx,ax
        push    ax
        mov     ah,40h
        mov     dx,OFFSET RT
        int     21h
        jc      WriteError3
;
        pop     dx
        cmp     ax,dx
        jne     WriteOVRError2
        cmp     dx,9000h
        je      CopyOverlay
        jmp     short DoneCopying
WriteOVRError2:
        jmp     WriteOVRError
DoneCopying:
; close the files
        mov     ah,3Eh
        mov     bx,FH
        int     21h
;
        mov     ah,3Eh
        mov     bx,tmp
        int     21h
NoOverlayData:
;
Backup:
        jmp     short NoBackup
; check whether there's a need for a backup copy
        mov     ax,fileb
        cmp     ax,outfb        ; is the source filename the same as target?
        jne     NoBackup        ; no, don't make a backup copy

; delete the tempf2
        mov     ah,41h
        mov     dx,OFFSET tmpf2
        int     21h
        jnc     DeletedOK
        cmp     al,2    ; no such file?
        je      DeletedOK
NotDeleted:
        mov     dx,OFFSET ErrMsg3
        jmp     Error
DeletedOK:

; rename the original to the tempfile2
        mov     dx,outfb
        mov     di,OFFSET tmpf2
        push    cs
        pop     es
        mov     ah,56h
        int     21h
; change the extension
        mov     si,filee
        mov     word ptr [si-2],'KA'
        mov     byte ptr [si-3],'B'

; rename the tempfile2 to the original.BAK
        mov     dx,OFFSET tmpf2
        mov     di,outfb
        mov     ah,56h
        int     21h
        jc      NotDeleted

; change the extension back
        mov     word ptr [si-2],'EX'
        mov     byte ptr [si-3],'E'
        jmp     short DontDelete
NoBackup:
; delete the outfb
        mov     ah,41h
        mov     dx,outfb
        int     21h
        jc      NotDeleted
DontDelete:

; rename the file to the output file (outfb)
        mov     dx,OFFSET tmpfile
        mov     di,outfb
        push    cs
        pop     es
        mov     ah,56h
        int     21h
        jc      NotDeleted

        jmp     Exit
WriteOVRError:
        mov     dx,OFFSET ErrM16
        jmp     Error
NotIP4:
;
End80h:
        call    Display0
;
        push    cs
        pop     ds
;
        mov     di,saveDI
        mov     si,saveSI
        mov     es,saveES
        mov     dx,saveDX
        mov     cx,saveCX
        mov     bx,saveBX
; set flags
        mov     ax,savef
        mov     bp,sp
        mov     [bp+4],ax
;
        mov     bp,saveBP
        mov     ax,saveAX
        mov     ds,saveDS
;
        iret
;
VCPI386 PROC    Near
        call    ID
        cmp     al,3
        jnb     OK386CPU
        mov     ah,09h
        mov     dx,OFFSET MsgNot386
        int     21h
Exit386:
        mov     byte ptr ds:ChkComp,2
        stc
        ret
OK386CPU:
        cmp     byte ptr ds:v86flag,0
        jz      ExitVCPI386
        mov     ax,0DE00h
        int     67h
        or      ah,ah
        jz      ExitVCPI386
        mov     ah,09h
        mov     dx,OFFSET WarnnoVCPI
        int     21h
        jmp     short Exit386
ExitVCPI386:
        clc
        ret
VCPI386 ENDP
;
;
PKCodeAdded PROC  Near
        mov     ah,02h
        mov     dl,0Dh
        int     21h
        mov     dl,0Ah
        int     21h
        mov     dl,''''
        int     21h
; display the PK Code
        mov     dx,PKCode
        mov     ah,02h
        int     21h
        xchg    dh,dl
        int     21h
;
        mov     dx,OFFSET SigCode
        mov     ah,09h
        push    cs
        pop     ds
        int     21h
        ret
PKCodeAdded     ENDP
;
;
Display0 PROC    Near
; check the Ctrl-Break flag
        cmp     byte ptr cs:Ctrl,00h
        jz      SkipCtrlBreak
;
GetOut:
        push    cs
        pop     ds
        call    Restore
; clear keyboard (DOS) buffer
        mov     ah,0Ch
        int     21h
        mov     ah,09h
        mov     dx,OFFSET ExitMsg
        int     21h
        add     sp,2
        jmp     Quit
;
off21h  dw      0000h
seg21h  dw      0000h
;
SkipCtrlBreak:
        push    ax
        push    bx
        push    dx
        push    ds
;
;        mov     bx,Epoi
;        inc     bx
;        cmp     bx,3
;        jna     EOK
;        xor     bx,bx
;EOK:
;        mov     Epoi,bx
;        add     bx,OFFSET EMsg
;        mov     ah,0Eh
;        mov     al,08h
;        int     10h
;        mov     al,ds:[bx]
;        int     10h
        call    setborder
;
; int 21h
; check the keyboard
        pushf
        mov     ah,01h
        int     16h
        jz      NoKeys
        cmp     al,03h  ; Ctrl-Break
        je      GetOut
        cmp     al,1Bh  ; Esc
        je      GetOut
NoKeys:
        popf
;
        pop     ds
        pop     dx
        pop     bx
        pop     ax
        ret
Display0 ENDP
;
FoundM  PROC    Near
; a string is pointer to by DS:DX and DS:DI
; the first one is the compression method, the second is what is found
        push    ax
        push    dx
;
        cmp     byte ptr ChkComp,2
        je      YesAnother
        push    dx
        mov     ah,09h
        mov     dx,OFFSET FoundMsg
        int     21h
        pop     dx
        int     21h
        mov     dx,version0
        cmp     dx,0
        je      NoVersion
        push    dx
        push    ax
        mov     ah,02h
        mov     dl,' '
        int     21h
        pop     ax
        pop     dx
        int     21h
NoVersion:
        mov     dx,sign
        cmp     dx,0
        je      NoSignature
        push    dx
        mov     dx,OFFSET WithSign
        int     21h
        pop     dx
        int     21h
        mov     dx,versig
        cmp     dx,0
        je      NoVersionSig
        push    dx
        push    ax
        mov     ah,02h
        mov     dl,' '
        int     21h
        pop     ax
        pop     dx
        int     21h
NoVersionSig:
NoSignature:
        mov     dx,OFFSET EndStr
        int     21h
        jmp     short ExitFoundM
YesAnother:
;        cmp     di,OFFSET IniMsg
;        jne     ExitFoundM
;
        push    dx
        mov     ah,09h
        mov     dx,OFFSET ReUseMsg
        int     21h
        pop     dx
        int     21h
        mov     dx,OFFSET StillCM
        int     21h
ExitFoundM:
        pop     dx
        pop     ax
        ret
FoundM  ENDP
;
ROM     Proc    Near
        pushf
        push    ax
        push    cx
        push    di
        push    ds
        push    es

; scan ROM BIOS for IRET (CFh) and set int01h and int03h
        mov     ax,0F000h
        mov     es,ax
        mov     cx,0FFFFh
        mov     ax,00CFh
        xor     di,di
        cld
REPNE   SCASB
        jcxz    DontSet
; found, check if it's ROM
        dec     di
        mov     es:[di],ah
        mov     ah,es:[di]
        mov     es:[di],al
        cmp     ah,al
        jne     DontSet
; set
        xor     ax,ax
        mov     ds,ax
        mov     ax,0F000h
        cli
        mov     ds:[01*4+2],ax
        mov     ds:[03*4+2],ax
        mov     ds:[01*4],di
        mov     ds:[03*4],di
        sti
DontSet:
;
        pop     es
        pop     ds
        pop     di
        pop     cx
        pop     ax
        popf
        ret
ROM     ENDP
;
saveAX  dw      0000h
saveBX  dw      0000h
saveCX  dw      0000h
saveDX  dw      0000h
saveDS  dw      0000h
saveES  dw      0000h
saveSI  dw      0000h
saveDI  dw      0000h
saveBP  dw      0000h
savef   dw      0000h
;
;
Optimize PROC   Near
        push    ax
        push    bx
        push    cx
        push    dx
        push    si
        push    di
        push    bp
        push    ds
;
        push    cs
        pop     ds
        mov     si,OFFSET RT
        mov     cx,ax   ; AX has the number of relocation entries
        jcxz    ExitOptimize
        cld
RepeatOptimize:
        mov     di,si
        lodsw
        mov     dx,ax
        lodsw
        mov     bp,ax
;
        cmp     bp,0
        jz      DontOptimize
        push    dx
        add     dx,10h
        pop     dx
        jc      DontOptimize
;
        mov     bx,bp
; find out how much can fit into low
        mov     ax,-1
        sub     ax,dx
;
        push    cx
        mov     cx,4
        shr     ax,cl
        pop     cx
;
; AX has how much can fit, BX has how much there is
        push    ax
        sub     ax,bx
        pop     ax
        jnc     FitAll
; leave only 1000h's in high
        mov     ax,dx
;
        push    cx
        mov     cx,4
        shr     ax,cl
        pop     cx
;
        mov     bx,bp
        add     bx,ax
        and     bx,0F000h
        mov     ax,bp
        sub     ax,bx
        shl     ax,1
        shl     ax,1
        shl     ax,1
        shl     ax,1
        mov     bp,bx
        add     dx,ax
        jmp     short WriteOptimized
FitAll:
; BX should have as much as will fit
        mov     ax,bx
        shl     ax,1
        shl     ax,1
        shl     ax,1
        shl     ax,1
        add     dx,ax
        sub     bp,bx
;
WriteOptimized:
;
; store bp:dx
; write the optimized stuff back
        mov     ax,dx
        stosw
        mov     ax,bp
        stosw
DontOptimize:
;
        loop    RepeatOptimize
ExitOptimize:
;
        pop     ds
        pop     bp
        pop     di
        pop     si
        pop     dx
        pop     cx
        pop     bx
        pop     ax
        ret
Optimize ENDP
;
SetTrap PROC    Near
; set interrupt table to trap interrupts
        push    ax
        push    bx
        push    cx
        push    di
        push    ds
        push    es
;
        xor     ax,ax
        mov     ds,ax
        mov     di,20h*4h
        mov     cx,8    ; DOS interrupts 20h-27h
;        mov     cx,1    ; DOS interrupts 20h-27h
        mov     ax,cs
        cli
RepeatTrap:
        cmp     di,23h*4h
        je      SkipTrap
        mov     ds:[di],OFFSET Trap
        mov     ds:[di+2],ax
SkipTrap:
        add     di,4
        loop    RepeatTrap
        sti
;
        push    cs
        pop     ds

; set our interrupt
        mov     bx,0080h
Loc2    equ     $ - 2
        mov     cx,2
        shl     bx,cl
        xor     ax,ax
        mov     ds,ax
        mov     ax,OFFSET int80h
        mov     ds:[bx],ax
        push    cs
        pop     ax
        mov     ds:[bx+2],ax
;
        pop     es
        pop     ds
        pop     di
        pop     cx
        pop     bx
        pop     ax
        ret
SetTrap ENDP
;
;
DispDec PROC    Near
; display a number from DX:AX in decimal
; sets a carry if the number is too large
        push    ax
        push    bx
        push    cx
        push    dx
        push    di
;
        mov     di,OFFSET buff6 + 6
;
        cmp     dx,9
        jna     ConvOK
        mov     dx,OFFSET Overflow
        stc
        jmp     short QuitConv0
ConvOK:
;
        mov     bx,10d
        mov     cx,6
Conv0:
        div     bx
        add     dl,30h
        dec     di
        mov     [di],dl
        cmp     ax,0
        je      ExitConv0
        xor     dx,dx
        loop    Conv0
ExitConv0:
        mov     dx,di
        clc
QuitConv0:
        pushf
        mov     ah,09h
        int     21h
        popf
        pop     di
        pop     dx
        pop     cx
        pop     bx
        pop     ax
        ret
;
buff6   db      6 dup(0),'$'
Overflow db     '+++$'
;
DispDec ENDP
;
;
Subtr   PROC    Near
; performs DX:AX-CX:BX, assuming DX:AX > CX:BX
        clc
        sub     ax,bx
        jnc     NoShift
        dec     dx
NoShift:
        sub     dx,cx
; if carry is set the number is negative
        jns     NotNeg
        not     dx
        neg     ax
NotNeg:
        ret
Subtr   ENDP
;
Info    PROC    Near
; DI message pointer
; DX:AX number
        push    dx
        push    ax
        mov     dx,di
        mov     ah,09h
        int     21h
        pop     ax
        pop     dx
        call    DispDec
        ret
Info    ENDP
;
DispInfo0 PROC  Near
        push    ax
        push    bx
        push    cx
        push    dx
        push    di
        push    ds
;
        push    cs
        pop     ds
; displays info about compressed file
;
        mov     di,OFFSET SzMsg
;
        mov     dx,fszhi
        mov     ax,fszlo
        call    Info
;
        call    CPUInfo
        mov     ah,02h
        mov     dl,0Dh
        int     21h
        mov     dl,0Ah
        int     21h
;
        pop     ds
        pop     di
        pop     dx
        pop     cx
        pop     bx
        pop     ax
;
        ret
DispInfo0 ENDP
;
DispInfo PROC   Near
        push    ax
        push    bx
        push    cx
        push    dx
        push    di
        push    ds
;
        push    cs
        pop     ds
;
        mov     di,OFFSET NewSzMsg
        mov     dx,fszhi
        mov     ax,fszlo
        call    Info
;
        mov     di,OFFSET RelMsg
        xor     dx,dx
        mov     ax,x06
        call    Info
;
;        mov     di,OFFSET HdrMsg
;        mov     ax,x08
;        mov     dx,ax
;        mov     cx,4d
;        shl     ax,cl
;        mov     cx,12d
;        shr     dx,cl
;        call    Info
;
        mov     di,OFFSET OvrMsg
;
        mov     dx,x04
        cmp     word ptr x02,0
        je      SkipDecPage
        dec     dx
SkipDecPage:
        mov     ax,dx
        mov     cx,9d
        shl     ax,cl
        add     ax,x02
        mov     cx,7d
        shr     dx,cl
        mov     cx,dx
        mov     bx,ax
        mov     dx,fszhi
        mov     ax,fszlo
        call    Subtr
        call    Info
;
        pop     ds
        pop     di
        pop     dx
        pop     cx
        pop     bx
        pop     ax
        ret
DispInfo ENDP
;
PKVerSig:
PKMaj   db      0,'.'
PKMin   db      0,0
XL      db      0,0
        db      '$'
;
TINY10  db      '1.0$'
TINY33  db      '3.[3689]$'; 3.3/3.6/3.8/3.9 all look the same at this point
LZEXE90 db      '0.90$'
LZEXE91 db      '0.91$'
PKLITE100 db    '1.00$'
PKLITE114 db    '1.14X+/1.20X$'
PKLITE193a db   '1.93a/1.20X$'
PKLITE150 db    '1.50$'
DIET100 db      '1.00$'
DIET120 db      '1.20$'
DIET144 db      '1.43/1.44$'
DIET145 db      '1.45f$'
;
version0 dw      0000h
versig  dw      0000h
;
WithSign db     ', header id: $'
FoundMsg:
        db      0Dh,0Ah
        db      'Compressed with    : $'
RelMsg:
        db      0Dh,0Ah
        db      'Relocation entries : $'
;HdrMsg:
;        db      0Dh,0Ah
;        db      'Header size (bytes): $'
OvrMsg:
        db      0Dh,0Ah
        db      'Overlay size       : $'
SzMsg:
        db      0Dh,0Ah
        db      'File size          : $'
NewSzMsg:
        db      0Dh
        db      'New file size      : $'
;
MsgP4   db      0Dh,0Ah,'į Bypassing Protect 4.0 encryption...$'
MsgP5   db      0Dh,0Ah,'į Bypassing Protect 5.0 encryption...$'
MsgNot386 db    0Dh,0Ah,'You need a 386 to unpack Protect! Aborted.',0Dh,0Ah,'$'
WarnnoVCPI db    0Dh,0Ah,0Dh,0Ah,'V86 without VCPI! Aborted.',0Dh,0Ah,'$'
PDone   db      '  ok.$'
;
ErrMsg  db      0Dh,0,0Dh,0Ah,'ERROR: ',24h
ErrMsg1 db      'invalid option',24h
ErrMsg2 db      'can''t read input file',24h
ErrMsg3 db      'can''t save the file (read only?)',24h
ErrMsg5 db      'unknown decompression code',24h
ErrMsg9 db      'not enough memory',24
ErrM11  db      'can''t write output file',24h
ErrM12  db      'too many relocation entries',24h
ErrM13  db      'not compressed with any known program',24h
ErrM14  db      'not an .EXE file',24h
ErrM15  db      'caught program interrupt',24h
ErrM16  db      'not enough disk space, file not written',24h
EndStr  db      0Dh,0Ah,24h
ErrM19  db      'output file exists (use -o)',24h
SigCode db      ''' signature code added',24h
;
PKMsg   db      'PKLITE',24h
TPMsg   db      'TINYPROG',24h
LZMsg   db      'LZEXE',24h
DIETMsg db      'DIET',24h
EXEPMsg db      'EXEPACK',24h
LZHMsg  db      'PROPACK',24h
OPTMsg  db      'OPTLINK',24h
SLRMsg  db      'OPTLINK relocation-shrinker',24h
Prot4Msg db     0Dh,0Ah,0Dh,0Ah
        db      'Protect 4.0+ encryption detected in the output file.$'
Prot5Msg db     0Dh,0Ah,0Dh,0Ah
        db     'Protect 5.0+ encryption detected in the output file.$'
;
ReUseMsg db     0Dh,0Ah
        db      0Dh,0Ah
        db      24h
StillCM db      ' compression detected in the output file.',24h
ExitMsg db      0Dh,0Ah,'Aborted.',24h
;
tmpfile db      '________.TM1',00h
tmpf2   db      '________.TM2',00h

;
; .EXE header and the relocation table
EXE:
x00     db      'MZ'
x02     dw      0000h   ; bytes on the last page of the image
x04     dw      0000h   ; number of 512-byte pages including the last
x06     dw      0000h   ; number of relocation entries
x08     dw      0000h   ; size of the header in paragraphs
x0A     dw      0000h   ; minimun amount of memory needed for the program
x0C     dw      0000h   ; maximum amount (in paragraphs)
x0E     dw      0000h   ; offset of SS
x10     dw      0000h   ; initial SP
x12     dw      0000h   ; checksum
x14     dw      0000h   ; initial IP
x16     dw      0000h   ; offset of CS
x18     dw      001Ch   ; offset of the relocation table in the file
x1A     dw      0000h   ; overlay number (0 for root)
;
RT      db      00h,00h,00h,00h     ; relocation table
RTLen   equ     12000d*4d
;
buff    label   word
buffer  equ     buff + RTLen
buffer2 equ     buff + RTLen + 110h
        dw      0000h
EOP000:
;
        db      0Dh,0Ah
Msg:
        db      'Ŀ',0Dh,0Ah
        db      ' UX 0.55 SOURCE, Executable File Expander, coded by Misha  April 2, 1996  ',0Dh,0Ah
        db      'Ĵ',0Dh,0Ah
        db      '  PROTECT 4.0/5.0  OPTLINK  PKLITE  LZEXE  TINYPROG  EXEPACK  DIET   ',0Dh,0Ah
        db      'Ĵ',0Dh,0Ah
        db      ' FULL ASM SOURCE CODE INCLUDED! (C)Copyright Misha [UCF] 1992-1996         ',0Dh,0Ah
        db      'Use in any commercial product without paying the license fee is prohibited!',0Dh,0Ah
        db      ''
        db      0Dh,0Ah,'$'
;
HelpMsg:
        db      'usage: UX [options] [d:][\path]Infile [[d:][\path][Outfile]]'
        db      0Dh,0Ah
        db      'options are:'
        db      0Dh,0Ah
        db      '  -% = don''t change border color while unpacking'
        db      0Dh,0Ah
        db      '  -0 = skip CPU/speed test'
        db      0Dh,0Ah
        db      '  -1...9 = the ''lucky numbers'' for Protect 5.0 (read the .DOC)'
        db      0Dh,0Ah
        db      '  -b = make backup .BAK file of the original'
        db      0Dh,0Ah
        db      '  -f = force Protect 5.0 decryption'
        db      0Dh,0Ah
        db      '  -i = intro/INFO'
        db      0Dh,0Ah
        db      '  -k = omit PK signature code added on some files'
        db      0Dh,0Ah
        db      '  -o = overwrite output file if it exists'
        db      0Dh,0Ah
        db      '  -r = remove overlay data'
        db      0Dh,0Ah
        db      '  -u = update file time/date to current time/date'
        db      0Dh,0Ah
        db      '  -z = try this (Protect5) if ''lucky numbers'' alone don''t help'
        db      24h
;
Mess    db      'SOURCE  INCLUDED',0
Mess2   db      'Coded by Misha',0
shift   dw      2
ScrollS dw      2
;
IMessage:
        db      ' '
        db      '[ scrolly speed: '
curr_speed      db      0
        db      '   press +/- to adjust ]        '
        db      'Greetings and salutations. '
        db      '      '
        db      'This is a source release of the infamous UX EXE file unpacker. :) '
        db      '      '
        db      'It''s no longer supported, '
        db      'but since its creation has inspired some people, '
        db      'the rest of the public should have a chance to learn '
        db      'or get confused like hell by the 150K ASM file ;). '
        db      '      '
        db      'All you''re asked for is an occasional greet and credit '
        db      'where it''s due. '
        db      '      '
        db      'Brief history: UX was started several years ago when UNP '
        db      'was nowhere in sight and DISLITE ruled the unpacking world. '
        db      '      '
        db      'The code is a mess right now (I don''t wanna hear anything '
        db      'about my coding style -- I was just learning). '
        db      'NOW I actually KNOW how I SHOULD''VE coded it. '
        db      '      '
        db      'There''s still some interest in unpacking/decrypting tools '
        db      '(which is a bit strange), and someone may want to make an .OBJ '
        db      'to work with patching programs -- it''s up to you.. '
        db      '      '
        db      'I hope you find this file useful, but '
        db      'whatever you do -- have fun!..       '
        db      '           '
        db      '>>'
        db      0
;
Intro   PROC    Near
;
; PUSHA
        push    ax
        push    bx
        push    cx
        push    dx
        push    si
        push    di
        push    ds
        push    es
        push    bp
;
; check for VGA
        mov     ax,1A00h
        int     10h
        cmp     al,1Ah
        je      VGA
NotVGA:
        jmp     ExitIntro
VGA:
        cmp     bl,07h
        jb      NotVGA
;
;
FadeOUT PROC    Near
        call    WaitVGA
; kill the screen
;
        mov     cx,2Ah
RepeatKilling:
        mov     dx,3C8h
        mov     al,07h
        out     dx,al
        inc     dx
        mov     ax,cx
        dec     ax
        out     dx,al
        jmp     short $ + 2
        out     dx,al
        jmp     short $ + 2
        out     dx,al
;
        call    WaitVGA
        loop   RepeatKilling
FadeOut ENDP
;
        mov     ax,0A000h
        mov     es,ax
        mov     ax,0013h
        int     10h
;
;
;        jmp     DoneIMessage

; get the 8x16 fonts
        mov     ax,1130h
        mov     bx,0600h
        int     10h
;
        mov     segfont,es
        mov     offfont,bp
;
        call    WaitVGA
;

        mov     di,StartM+320d*MessLine
        mov     si,OFFSET Mess
RepeatLetters2:
        lodsb
        cmp     al,0
        je      DoneIMessage2
        cmp     al,' '
        je      SkipDL2
        mov     bl,Color1
        call    Letter
        push    di
        mov     bl,Color2
        add     di,319d
        call    Letter
        pop     di
SkipDL2:
        add     di,17d
        jmp     short RepeatLetters2
;
DoneIMessage2:
;
;
        mov     si,StartM2+320d*MessLine2
        mov     di,OFFSET Mess2
RepeatLetters:
        mov     al,ds:[di]
        inc     di
        cmp     al,0
        je      DoneIMessage
        cmp     al,' '
        je      SkipDL
        call    DLetter
SkipDL:
        add     si,17d+320*0d
        jmp     short RepeatLetters
;
DoneIMessage:
;
        push    cs
        pop     es
;
; create stars
        mov     di,OFFSET StarsPos
;        mov     di,si
        mov     ax,0040h
        mov     es,ax
;        push    0040h
;        pop     es
        mov     bx,es:[006Ch]
        mov     cx,StarNum
        push    ds
        pop     es
RepeatRS:
        rol     bx,1
        mov     ax,bx
        sub     ax,cx
        and     ah,00000001b
        pushf
        cmp     ax,319d
        jb      StarOK
        sub     ax,319d
StarOK:
        popf
        stosw
        loop    RepeatRS
;
;

; do the stars
        mov     ax,0A000h
        mov     es,ax
;
RepeatAgain:

;        jmp     DoneStars

        mov     bl,scount
        inc     bl
        cmp     bl,3
        jna     scountOK
        mov     bl,1
scountOK:
        mov     scount,bl
;
        mov     al,scount
        cmp     al,1
        je      SkipSkipping
;
        cmp     al,2
        jne     Not2
        mov     ah,count2
        inc     ah
        cmp     ah,2
        jne     Not2_
        xor     ah,ah
Not2_:
        mov     count2,ah
        je      SkipSkipping
Not2:
        cmp     al,3
        jne     Not3
        mov     ah,count3
        inc     ah
        cmp     ah,4
        jne     Not3_
        xor     ah,ah
Not3_:
        mov     count3,ah
        je      SkipSkipping
Not3:
        jmp     short SkipStar0
;
SkipStar0:
        jmp     SkipStar
;
ChooseColor PROC        Near
        mov     ah,scount
;
        cmp     ah,1
        jne     NotS1
        mov     ah,StarColor
        ret
NotS1:
        cmp     ah,2
        jne     NotS2
        mov     ah,StarColor2
        ret
NotS2:
        cmp     ah,3
        jne     NotS3
        mov     ah,StarColor3
        ret
NotS3:
        ret
ChooseColor ENDP
;
SkipSkipping:
;
;        mov     ax,IWhich
;        shr     ax,1
;        jnc     SkipSkipping
;        cmp     byte ptr flag,0
;        jz      SkipSkipping
;        jmp     SkipStar
;SkipSkipping:
; get the pointers for the current star
        mov     ax,IWhich
;
        mov     si,OFFSET StarsColor
        add     si,ax
        mov     ColorP,si
        mov     ah,ds:[si]
        push    ax
        mov     ax,IWhich
        mov     si,OFFSET OldsPos
        shl     ax,1
        add     si,ax
        mov     OldP,si
        mov     bx,ds:[si]      ; OldPos
        mov     si,OFFSET StarsPos
        add     si,ax
        mov     NewP,si
        pop     ax
;

; delete the old star
        mov     al,es:[bx]
        cmp     al,StarColor
        je      Delete
        cmp     al,StarColor2
        je      Delete
        cmp     al,StarColor3
        je      Delete
        cmp     al,0
        jne     SkipDeleting
Delete:
        mov     es:[bx],ah
SkipDeleting:
;
        mov     si,NewP
        mov     bx,ds:[si]
        add     bx,Line
        add     bx,WAdd
;
        mov     al,es:[bx]
;        cmp     al,44h
;        je      New
        cmp     al,0
        jne     NoNew
New:
        mov     si,OldP
        mov     ds:[si],bx
        mov     si,ColorP
        mov     ds:[si],al
;
;        mov     ah,StarColor
;        mov     dx,IWhich
;        shr     dx,1
;        jnc     ColorOK
;        mov     ah,StarColor2
;ColorOK:
;
        call    ChooseColor
; return current star color in ah
        mov     es:[bx],ah
NoNew:
        sub     bx,Line
        sub     bx,WAdd
        add     bx,Speed
;
        cmp     bx,320d
        jb      PosOK
        sub     bx,320d
PosOK:
        mov     si,NewP
        mov     ds:[si],bx
;
SkipStar:
;
        mov     ax,IWhich
        inc     ax
        cmp     ax,StarNum
        jb      IWhichOK
        xor     ax,ax
        xor     byte ptr flag,1
;
        call    Scroll
;
        mov     bx,shift
        mov     ScrollS,bx
        add     bl,30h
        mov     curr_speed,bl
;
;
IWhichOK:
        mov     IWhich,ax
        xor     dx,dx
        mov     bx,320d*Spacing
        mul     bx
        mov     WAdd,ax
;
DoneStars:

;
        mov     ax,0100h
        int     16h
        jz      RepeatAgain2
        xor     ax,ax
        int     16h
;
        cmp     al,2Bh
        jne     NotPlus
        mov     ax,cs:shift
        inc     ax
        cmp     ax,MaxS+1
        jne     SpeedOK
        mov     ax,MaxS
        jmp     short SpeedOK
NotPlus:
        cmp     al,2Dh
        jne     NotMinus
        mov     ax,cs:shift
        dec     ax
        cmp     ax,MinS-1
        jne     SpeedOK
        mov     ax,MinS
SpeedOK:
        mov     cs:shift,ax
RepeatAgain2:
        jmp     RepeatAgain
NotMinus:
;
ExitIntro:
;
        mov     ax,0003h
        int     10h
;
        mov     ax,0C00h
        int     21h
;
; POPA
        pop     bp
        pop     es
        pop     ds
        pop     di
        pop     si
        pop     dx
        pop     cx
        pop     bx
        pop     ax
;
;
        ret
;
;
DLetter PROC    Near
; ES:BP points to the font buffer
; CX has the bytes per char
; DL = # of rows
; SI is the position in the buffer
; AL has the letter
; PUSHA
        push    ax
        push    bx
        push    cx
        push    dx
        push    si
        push    di
        push    ds
        push    es
        push    bp
;
;
        xor     bx,bx
        mov     bl,10h
        mov     di,si
        add     di,23d
Repeat1:
        call    IDelay
;
        call    Letter
        inc     bl
        cmp     bl,1Fh
;        cmp     bl,18h
        je      Stop1
        sub     di,2
        add     di,320d
        jmp     Repeat1
;
Stop1:
        mov     bl,44h
        call    Letter
;
        push    di
        mov     bl,36h
        add     di,319d
        call    Letter
        pop     di
;
        add     si,23d
        mov     ah,10h
        mov     cx,20d
KillRepeat:
        call    IDelay
;
        call    KillC
        add     si,320d
        sub     si,2
        add     ah,1
        loop    KillRepeat
;
; POPA
        pop     bp
        pop     es
        pop     ds
        pop     di
        pop     si
        pop     dx
        pop     cx
        pop     bx
        pop     ax
;
        ret
;
DLetter ENDP
;
Letter  PROC    Near
; draw a letter
; PUSHA
        push    ax
        push    bx
        push    cx
        push    dx
        push    si
        push    di
        push    ds
        push    es
        push    bp
;
        push    ds
        push    es
;
; AL = the letter, BL = the color, DI = the offset in the video buffer
;
        mov     cx,16d
;
        xor     ah,ah
        mul     cx
        mov     si,ax
        add     si,bp
;
; use ES for video buffer, DS for the table
        push    es
        pop     ds
;
        mov     ax,0A000h
        mov     es,ax
; now DS:SI points at the letter
        cld
INextByte:
        lodsb
        push    cx
        mov     cx,8
IRepeatBits:
        sal     al,1
        jnc     ISkipBit
        mov     es:[di],bl
        mov     bh,bl
        mov     es:[di+1],bx
        mov     es:[di+320d],bl
        mov     es:[di+321d],bx
Skip2:
;
ISkipBit:
        add     di,2
        loop    IRepeatBits
        pop     cx
;
        add     di,(320d-8d-8d)+320d
        loop    INextByte
;
        pop     es
        pop     ds
; POPA
        pop     bp
        pop     es
        pop     ds
        pop     di
        pop     si
        pop     dx
        pop     cx
        pop     bx
        pop     ax
;
        ret
Letter  ENDP
;
WaitVGA PROC    Near
        pushf
        push    ax
        push    dx
        mov     dx,3DAh
Test1AgainVGA:
        in      al,dx
        test    al,8
        jnz     Test1AgainVGA
Test2AgainVGA:
        in      al,dx
        test    al,8
        jz      Test2AgainVGA
;
        pop     dx
        pop     ax
        popf
        ret
WaitVGA ENDP
;
IDelay   PROC    Near
; delays the computer
        push    ax
        push    cx
        push    dx
;
        mov     ax,8600h
        xor     cx,cx
        mov     dx,0FFFFh / 30d ; 1/30d second
        int     15h
;
        pop     dx
        pop     cx
        pop     ax
        ret
IDelay   ENDP
;
KillC   PROC    Near
; kills color in AH in the area
; SI is the beginning of the video buffer
        push    ax
        push    cx
        push    si
        push    ds
;
        push    ax
        mov     ax,0A000h
        mov     ds,ax
        pop     ax

        cld
;
        mov     cx,Area
YArea:
        push    cx
        mov     cx,Area
        push    si
XArea:
;
        lodsb
        cmp     ah,al
        jne     NotE
        mov     byte ptr ds:[si-1],00h
NotE:
;
        loop    XArea
        pop     si
        add     si,320d
        pop     cx
        loop    YArea

;
        pop     ds
        pop     si
        pop     cx
        pop     ax
        ret
KillC   ENDP
;
Scroll  PROC    Near
; scrolling Imessage
; scroll the bottom lines of the video buffer
;
        push    ax
        push    cx
        push    si
        push    di
        push    ds
        push    es
;
        push    cs
        pop     ds
;
        inc     byte ptr flag2
        cmp     byte ptr flag2,ScrollDelay
        jb      SkipScroll
        mov     byte ptr flag2,0
;
        push    cs
        pop     es

; scroll the phony buffer
;        mov     di,320d*199d
        mov     di,OFFSET Phony + 320d*(ScrollNum-1)
        cld
;
        mov     cx,ScrollNum
RepeatS:
        push    cx
;
        mov     si,di
        add     si,ScrollS
;
;        mov     cx,320d/2
        mov     cx,320d
        sub     cx,ScrollS
;
        push    di
Safe1:
;REP     MOVSW
REP     MOVSB
        jcxz    Next1
        loop    Safe1
Next1:
        pop     di
        sub     di,320d
;
        pop     cx
        loop    RepeatS
;
        call    SLetter
; copy the phony buffer to the video buffer

        mov     ax,0A000h
        mov     es,ax
        mov     si,OFFSET Phony
        mov     di,320d*200d-ScrollNum*320d
        mov     cx,320d*ScrollNum/2
        cld
        call    WaitVGA
        cli
Safe2:
REP     MOVSW
        jcxz    Next2
        loop    Safe2
Next2:
        sti
;
SkipScroll:
;
        pop     es
        pop     ds
        pop     di
        pop     si
        pop     cx
        pop     ax
        ret
Scroll  ENDP
;
;
SLetter PROC    Near
; PUSHA
        push    ax
        push    bx
        push    cx
        push    dx
        push    si
        push    di
        push    ds
        push    es
        push    bp
;
        push    ds
        push    es
;
        mov     di,OFFSET Phony + 320d
        sub     di,cs:ScrollS
;
        mov     cx,cs:ScrollS
        cmp     cx,0
        jne     RepeatScrolling
        jmp     ExitSLetter
RepeatScrolling:
        push    cx
        push    di
;
        mov     es,cs:segfont
        mov     bp,cs:offfont
        mov     si,cs:MsgPoi
        mov     al,cs:[si]
;
; AL = the letter, BL = the color, DI = the offset in the video buffer
;
        push    cs
        pop     ds
;
        mov     bl,LColor
        mov     cx,16d
;
        xor     ah,ah
        mul     cx
        mov     si,ax
        add     si,bp
;
; use ES for video buffer, DS for the table
        push    es
        pop     ds
;
        push    cs
        pop     es
;
; now DS:SI points at the letter
        cld
SNextByte:
        lodsb
        push    cx
        mov     cl,cs:Turn
        sal     al,cl
        pop     cx
        push    cx
        mov     cx,1
SRepeatBits:
        mov     bh,bl
        sal     al,1
        jc      SSkipBit
        mov     bh,0
SSkipBit:
        mov     es:[di],bh
;
        add     di,1
        loop    SRepeatBits
        pop     cx
;
        add     di,320d-1
        loop    SNextByte
;
        push    cs
        pop     ds
;
        mov     al,Turn
        inc     al
        cmp     al,8
        jb      TurnOK
;
        xor     al,al
        mov     si,MsgPoi
        inc     si
        mov     ah,[si]
        cmp     ah,0FFh ; ?
        jne     Not0FFh
; if 0FFh, the next value is new color
        inc     si
        mov     ah,[si]
        cmp     ah,0
        jne     Not0Color
        mov     ah,saveColor
Not0Color:
        push    ax
        mov     al,LColor
        mov     saveColor,al
        pop     ax
        mov     LColor,ah
        inc     si
        mov     ah,[si]
Not0FFh:
;
        cmp     ah,0
        jne     IMessageOK
        mov     si,OFFSET IMessage
        mov     ah,OldLColor
        xor     ah,XORColor
        mov     LColor,ah
        mov     OldLColor,ah
IMessageOK:
        mov     MsgPoi,si
TurnOK:
        mov     Turn,al
;
;
        pop     di
        pop     cx
        inc     di
        loop    RepeatScrolling0
        jmp     short ExitSLetter
;
RepeatScrolling0:
        jmp     RepeatScrolling
;
ExitSLetter:
        pop     es
        pop     ds
; POPA
        pop     bp
        pop     es
        pop     ds
        pop     di
        pop     si
        pop     dx
        pop     cx
        pop     bx
        pop     ax
;
;
        ret
SLetter ENDP
EOP0:
MsgPoi  dw      OFFSET IMessage ; message pointer
;
;
; star tables
; star positions
StarsPos:
        db      3d*70d dup(0)
; old star positions
OldsPos:
        dw      StarNum+1 dup(0)
; old colors for stars
StarsColor:
        db      StarNum+1 dup(0)
;
LColor  db      0Eh
OldLColor  db      0Eh
saveColor db    0
flag2   db      0
;
count2  db      0
count3  db      0
;
Turn    db      0
;
IWhich   dw      0000h ; which star is updated
WAdd    dw      0000h
scount  db      0
;
OldP    dw      0000h
NewP    dw      0000h
ColorP  dw      0000h
Line    dw      0 ;320d*31d
flag    db      0
segfont dw      0000h
offfont dw      0000h
;saveSI  dw      0FA02h
;saveDI  dw      320d*180d+10d
;
;InitVGA PROC    Near
;; enable VGA, might be necessary
;        mov     dx,3DA
;        in      al,dx
;        mov     dx,3C0h
;        in      al,dx
;        and     al,11011111b    ; clear bit 5
;        out     dx,al
;        mov     dx,3D4h
;        in      al,dx
;        and     al,01111111b
;        out     dx,al
;        ret
;InitVGA ENDP
;
;
CPUInfo PROC    Near
        mov     ah,09h
        mov     dx,OFFSET CPUM
        int     21h
        push    bx
        push    cx
        call    ID
        pop     cx
        pop     bx
        add     byte ptr ds:PType,al
        mov     dx,OFFSET Processor
        cmp     al,0
        jnz     Not8086_
        inc     dx
        mov     byte ptr ds:[Processor+1],'8'
Not8086_:
        mov     ah,09h
        int     21h
        cmp     byte ptr ds:v86flag,0
        jz      NotV86M
        mov     dx,OFFSET v86m
        int     21h
NotV86M:
;
        call    Space
        mov     ah,02h
        mov     dl,'/'
        int     21h
        call    Space
; determine speed
        mov     al,10111000b
        out     43h,al
        jmp     short $ + 2
        in      al,61h
        or      al,1
        out     61h,al  ; launch the counter ?
        xor     ax,ax
        out     42h,al  ; LSB
        jmp     short $ + 2
        out     42h,al  ; MSB
        jmp     short $ + 2
;
rept    1500d
        clc
endm
;
        in      al,42h
        jmp     short $ + 2
        xchg    ah,al
        in      al,42h
        jmp     short $ + 2
        xchg    ah,al
        neg     ax
;
        mov     cx,ax
        mov     ax,ds:magic
        xor     dx,dx
        div     cx
        mov     di,OFFSET CPUSpeed
        call    Decimal
        mov     dx,di
        mov     ax,word ptr ds:[swap-1]
        xchg    ah,al
        mov     word ptr ds:[swap-1],ax
        mov     ah,09h
        int     21h
;
;        call    ECache
;
        ret
;
Decimal PROC    Near
; converts a number in AX to a decimal ASCII representation and places
; 5 decimal digits at DS:DI
;
        push    ax
        push    bx
        push    cx
        push    dx
;        push    di
;
        mov     bx,10d
        add     di,5d
        mov     cx,5d
More:
        dec     di
        xor     dx,dx
        div     bx      ; DX = remainder, AX = quotient
        add     dl,30h
        mov     [di],dl
        or      ax,0
        loopnz    More
;
;        pop     di
        pop     dx
        pop     cx
        pop     bx
        pop     ax
;
        ret
Decimal ENDP
;
ID      PROC    Near
; official Intel check (?)
; returns 0,2,3,4 in ax
;
        pushf
        pop     ax
        and     ax,0FFFh        ; bits 12-15 are always set on 8086
        push    ax
        popf
        pushf
        pop     ax
        and     ax,0F000h
        cmp     ax,0F000h
        jne     Not8086
; check for 80186
        mov     ax,1
        mov     cl,32d
        shl     ax,cl
        cmp     ax,0
        jnz     i80186  ; 80186 doesn't shift at all
        xor     ax,ax
i80186:
        ret
Not8086:
        pushf
        pop     ax
        or      ax,0F000h       ; bits 12-15 are always clear on 286
        push    ax
        popf
        pushf
        pop     ax
        and     ax,0F000h
        jnz     Not286
        mov     ax,2
        ret
Not286:
; 386 CPU check
; the AC bit, #18, is a new bit introduced int the EFLAGS register on the 486
; to generate alignment faults.  It can be set on the 486 but not on the 386.
        mov     bx,sp               ;save old value
        and     sp,not 3    ;make sure we don't generate an alignment fault
.386P
;
        smsw    ax
        test    al,1
        jz      NotV86
        mov     byte ptr ds:v86flag,1
NotV86:
;
        pushfd
        pop     eax
        mov     ecx,eax
        xor     eax,40000h
        push    eax
        popfd
        pushfd
        pop     eax
        xor     eax,ecx             ;if AC bit can't be changed, cpu is 386
        mov     ax,3
        jz      found3
        inc     ax              ; ax=4 (486)
        jmp     short CheckPentium
found3:
        push    ecx
        popfd                   ;restore flags to original state
        mov     sp,bx               ;restore stack pointer
        ret
CheckPentium:
; now see if it's a Pentium
        mov     eax,ecx
        xor     eax,200000h
        push    eax                        ; transfer EAX to EFLAGS
        popfd
        pushfd                          ; transfer EFLAGS back to EAX
        pop     eax
        xor     eax,ecx                     ; ID bit fliped?
        mov     ax,4
        jz      found4                  ; if no, CPU is 486
        inc     ax                      ; processor type 5, CPU is 586
found4:
        push    ecx
        popfd                   ;restore flags to original state
.8086
        mov     sp,bx               ;restore stack pointer
;
        ret
;
CRLF    PROC    Near
        mov     ah,02h
        mov     dl,0Dh
        int     21h
        mov     dl,0Ah
        int     21h
        ret
CRLF    ENDP
;
Space   PROC    Near
        mov     ah,02h
        mov     dl,20h
        int     21h
        ret
Space   ENDP
;
;DCache  PROC    Near
;; disable 486 cache
;.386P
;        cmp     byte ptr ds:v86flag,0
;        jz      NotV86_
;        ret
;NotV86_:
;        mov     eax,cr0
;        or      eax,60000000h  ; bits 30 & 29 set
;        mov     cr0,eax
;;        invd
;        db      0Fh,08h
;        mov     byte ptr ds:cache,1
;        ret
;DCache  ENDP
;;
;ECache  PROC    Near
;; enable 486 cache
;        cmp     byte ptr ds:cache,1
;        jne     ExitECache
;        cmp     byte ptr ds:v86flag,0
;        jz      NotV86_2
;ExitECache:
;        ret
;NotV86_2:
;;        invd
;        db      0Fh,08h
;        mov     eax,cr0
;        and     eax,9FFFFFFFh  ; bits 30 & 29 clear
;        mov     cr0,eax
;        mov     byte ptr ds:cache,0
;        ret
;ECache  ENDP
;
ID      ENDP
;
magic   dw      53694d ;  =(3000d*1.19318)*10d
CPUM    db      9,9,9,'CPU: ',24h
;
v86m    db      ' - v86$'
Processor:
        db      '80'
PType   db      '086'
        db      24h
CPUSpeed   db      5 dup('0')
swap    db      '. MHz'
;        db      0Dh,0Ah
        db      24h
v86flag db      0       ; 0 = real mode, 1 = v86
;cache   db      0       ; 0 = cache on, 1 = off
CPUInfo ENDP
;
; scroll this buffer
Phony:
        db      320d*ScrollNum dup(0)
        db      10h dup(0)
;
Intro   ENDP
;
;
EOP:
CODE    ENDS
END     UX_UX_UX
