# Makefile for all IBM huffman variants
# Needed:
# Borland's make utility
# Borland Pascal 7.0 or higher

# Optional:
# (Not necessary for compilation)
# ScanHelp by D.J. Murdoch only necessary if you plan to better comment src.
# Words conversion utility by Joe Jared

#.silent

#Huffman conditionals for this version

#JARED	=JARED 		# Never implement!!!  this is strictly for release purposes
NVAL = 1000			# size of string buffer
FVAL = 60			# size of look-ahead buffer

LVERMAJOR  = 0		# Major portion of Version
LVERMINOR  = 31		# Minor portion of Version

#DEBUGMODE = 1		# For debugmode operations.
# MAPMODE= 1		# Extended debugging

PROTMODE = 1		# for Dos protected mode implementation
#WINDOWS=1			# For Windows based programs

# Turbo Pascal directories
#TPEXE	= $(BP)\bin

!include $(BP)\units\units.def

# units.def
#
Targets: lz.exe testlzo.exe
#	mafs
#	totals
#	wintest
# libraries totals.exe mafs.exe x.exe

#totals.exe: $(UNITS)\strnttt5$(TPUEXT) $(UNITS)\dosini$(TPUEXT)

# dosini

lz.exe: $(UNITS)\lzh$(TPUEXT)

testlzo.exe: $(UNITS)\lzo$(TPUEXT)

$(UNITS)\lzo$(TPUEXT): $(UNITS)\lzh$(TPUEXT)

tstbdsk.exe: $(UNITS)\bdisk$(TPUEXT)
#
#Dependencies
	!include $(LIBS)\library.mak
# units.mak
	!include $(UNITS)\units.mak

#$(UNITS)\lzh$(TPUEXT): $(PASINC)\lzh.inc $(OBJ)\lzhasm.obj

$(PASINC)\lzh.inc: makefile.mak
	copy &&!
const
	{ This file created by Borland's MAKE utility }
	EngineVer = '$(LVERMAJOR).$(LVERMINOR)';
	{ Version of Huffman compression engine}
	{ Note: Actual include file is generated by borland's Make utility}
	N	  = $$(NVAL) ; {Size of string buffer}
	F	  = $(FVAL)	    ; {60 Size of look-ahead buffer}
	{These constants are hard coded into LZHASM.OBJ}
! $@

#
	!if $d(JARED)
release: tplzh$(LVERMAJOR)$(LVERMINOR).zip

tplzh$(LVERMAJOR)$(LVERMINOR).zip: makefile.mak file_id.diz\
	$(UNITS)\lzh.pas lz.pas $(OBJ)\lzhasm.obj $(UNITS)\lzo.pas\
	testlzo.pas	$(PASINC)\lzh.inc tplzh.hst TPLZH.DOC\
	$(UNITS)\lzo.tph $(UNITS)\lzh.tph lzhasm.inc\
	$(UNITS)\units.mak $(UNITS)\units.def
	words &&!
 $?
! release.lst
	!if $d(DEBUGMODE)
		echo release failed DEBUGMODE defined in makefile.mak
	!else
	pkzip -ex -a -P $@ @release.lst
	!endif

	!endif
file_id.diz: makefile.mak
	copy &&!
Huffman Compression Engine v$(LVERMAJOR).$(LVERMINOR) IBM Version
By:  Joe Jared,1:103/301@Fidonet.Org and others
Aka: JoeJared@webworldinc.com
Internet FTP://webworldinc.com/joejared/tplzh???.zip
Atari ST/TT/JAGUAR & SNES available (For licenced developers only)
UPDATES: DPMI mode now supported Borland help files included with this release.
Windows support added.
! $@

# This section should only be enabled if you have lzhasm.asm
!if $d(JARED)
$(OBJ)\lzhasm.obj: LZHASM.inc

LZHASM.inc: makefile.mak
	copy &&!
;	 This file created by Borland's MAKE utility
; This file is not needed by end users but shows how you can
; use make to create interface files between languages.

threshold  	equ 2	       ;  {define from pwb or /dthreshold=
n			equ $(NVAL)h	      ; {size of string buffer}
f			equ $(FVAL)		     ; {size of look-ahead buffer}

! $@
!endif


$(UNITS)\lzo.tph: $(UNITS)\lzh$(TPUEXT)

