{
RLE96
(c) 1996 Jaromr Koutek

De/kompriman program, pouvajc metodu RLE.

RLEngine.PAS

Hlavn (de)kompriman procedury RLE:
Voln PackNUnPack s parametry:
What: True - komprimace, False - dekomprimace.
PInStream: vstupn soubor.
POutStream: vstupn soubor.
InSize: kolik se m z PInStream st bajt (nem ukonovac znak).
CRC: vrac kontroln souet.
rINSize: vrac kolik se peetlo.
rOUTSize: vrac kolik se zapsalo.

Pakovn RLE:

67 5A ED ED ED 56 56    00 01 02 33 33 33 33 33 33

-- -- -------- -------- -- -- -- -----------------
|| || || || || || || || || || || || || ||
VV VV VV VV VV VV VV VV VV VV VV VV VV VV

67 5A ED ED 03 56 56 02 00 01 02 33 33 06

To znamen, e za sebou se opakujc bajty XY ulo jako pospoupnost
XY XY <poet bajt>. Jedin (znan) nevhoda tto metody je
v tom, e 2 stejn bajty, ped a za ktermi jsou jin hodnoty,
ulo jako 3 bajty: teba 34 56 56 34 se mus uloit jako (34) 56 56 02 (34).
Maximaln poet bajt, kter po sob mohou nsledovat, je asi 255,
pokud je jich vc, rozlo se na nkolik s potem pod 256.

Pi jinm typu komprese je teba pouze zmnit tuto proceduru, ostatn
funkce program (pakovn adres atd.) zstanou nezmnny.
}

unit  RLEngine;

interface

uses
  Objects;

procedure PackNUnPack(What: Boolean; PInStream, POutStream: PStream; InSize: Longint;
  var CRC, rINSize, rOUTSize: Longint);
{What=True: zkomprimuje z PInStream na POutStream, z PInStream nate InSize byt
What=False: dekomprimuje z PInStream na POutStream, z PInStream nate InSize byt}

implementation

uses
  RLEBuffer, RLEWork;

const
  MaxRLEngth = 255;

procedure PackNUnPack(What: Boolean; PInStream, POutStream: PStream; InSize: Longint;
  var CRC, rINSize, rOUTSize: Longint);
{What=True: zkomprimuje z PInStream na POutStream, z PInStream nate InSize byt, vstup CRC
What=False: dekomprimuje z PInStream na POutStream, z PInStream nate InSize byt, vstup CRC}

  var
    POut: POutBuffer;
    PBuf: PBuffer;
    First: Boolean;
    Size: Word;
    Len: Byte;
    I: Word;
    Now, Last: Byte;
    T: TWork;

  procedure PackProc;
  {Pracuje tak, e si pamatuje, co se zapsalo pedtm (Last), ulo naten
  (Now), a pokud je to stejn jako pedchoz (Now=Last), tak to vyhledv dl
  stejn bajty (Now nebo Last) a pak zape jejich poet (Len). Pak
  ozna Last tak, aby pi dalm kroku nebylo stejn jako Now.}
    begin
      while I<Size do begin
        {- pokud je to poprv, ozna Now tak, aby se dl nemohlo stt, e by
        Now=Last -}
        if First then begin
          Last:=PBuf^[I]+1; {aby to zaruen nebylo}
          First:=False;
        end
        else
        {- jinak ulo pedchoz byte -}
          Last:=Now;
        Now:=PBuf^[I];
        Inc(I);
        {- nezkomprimovan data -}
        POut^.Put(Now);
        CRC:=CRC+Longint(Now xor (Last+Byte(CRC)));
        {- opakovan => budeme komprimovat data -}
        if Last=Now then begin
          {- ulome I -}
          Len:=1;
          {- dokud jsou tam stejn bajty a je co natat -}
          while (I<Size) and (Now=PBuf^[I]) and (Len<MaxRLEngth) do begin
            Inc(I);
            Inc(Len);
          end;
          {- zapeme na vstup -}
          POut^.Put(Len);
          CRC:=CRC+Longint(Len xor (Last+Byte(CRC)));
          {- a ozname, e jsme zase na zatku}
          First:=True;
        end;
        {- dal -}
      end;
    end;


  procedure UnPackProc;
  {Postupn te (Now) a porovnv s pedchozm (Last). Pokud jsou stejn
  (Now=Last), znamen to, e dal bajt uruje poet stejnch bajt (Len).}
    begin
      while I<Size do begin
        {- pokud je to poprv, ozna Now tak, aby se dl nemohlo stt, e by
        Now=Last -}
        if First then begin
          Last:=PBuf^[I]+1; {aby to zaruen nebylo}
          First:=False;
        end
        else
        {- jinak ulo pedchoz byte -}
          Last:=Now;
        Now:=PBuf^[I];
        CRC:=CRC+Longint(Now xor (Last+Byte(CRC)));
        Inc(I);
        {- nezkomprimovan data -}
        if Last<>Now then
          POut^.Put(Now)
        {- opakovan => zkomprimovan data -}
        else begin
          {- dal byte oznauje dlku -}
          if I=Size then begin
            {- jsme na konci bufferu => nateme jet jeden byte, mus tam bt -}
            PInStream^.Read(Len, SizeOf(Len));
            InSize:=InSize-1; {naetli jsme o bajt vc, tak to musme oznait}
          end
          else begin
            {- jinak je to v podku, v bufferu je i dlka -}
            Len:=PBuf^[I];
            Inc(I);
          end;
          CRC:=CRC+Longint(Len xor (Last+Byte(CRC)));
          {- zapeme na vstup -}
          POut^.FillBuffer(Now, Len);
          {- a ozname, e jsme zase na zatku}
          First:=True;
        end;
        {- dal -}
      end;
    end;

  {- zatek PackNUnPack -}
  {pro oba smry je to tady stejn}
  begin
    CRC:=0; {CRC je na zatku 0}
    POut:=New(POutBuffer, Init(POutStream));
    PBuf:=New(PBuffer);
    First:=True;
    T.Init(InSize, False);

    while InSize<>0 do begin
      {- nate kousek souboru do pamti}
      if InSize>MaxBufferSize then
        Size:=MaxBufferSize
      else
        Size:=InSize;
      InSize:=InSize-Longint(Size);
      PInStream^.Read(PBuf^, Size);
      T.Show(InSize);
      {- hlavn cyklus -}
      I:=0;
      if What then
        PackProc
      else
        UnPackProc;
    end;
    POut^.Flush;

    {- zapeme, na kolik jsme to spakovali/rozpakovali -}
    rINSize:=T.MaxValue;
    rOUTSize:=POut^.StreamSize;

    {- ve zrume -}
    T.Done;
    Dispose(PBuf);
    Dispose(POut, Done);

  end;

end.


