{
RLE96
(c) 1996 Jaromr Koutek

De/kompriman program, pouvajc metodu RLE.

RLEFiles.PAS
Pouv hlavn program RLE.PAS.
Obsahuje hlavn st programu, kter vyhledv soubory a te/zapisuje je.
}

unit RLEFiles;

interface

type
  cmdS= (cmdPack, cmdPackDir, cmdPackEDir, cmdTest, cmdUnpack, cmdUnpackE, cmdInvalid);
{
cmdPack     - komprimuje jenom soubory (kter vyhovuj masce z SFiles)
              v adresi urenm SFiles
cmdPackDir  - komprimuje podobn jako cmdPack, ale navc komprimuje soubory
              uren maskou i v podadresch.
cmdPackEDir - jako cmdPackDir, ale navc ukld celou strukturu adres,
              a ji se tam njak soubory vyhovujc masce nachzej nebo
              ne.
cmdTest     - dekomprimuje soubory "nikam" a pi tom kontroluje kontroln
              souet, take (v idelnm ppad) zjist, zda spakovan soubor
              nen pokozen.
cmdUnpack   - dekomprimuje soubory vyhovujc masce a pitom pro n vytv
              odpovdajc adrese, tzn. e nevytv przdn adrese.
cmdUnpackE  - jako cmdUnpack, ale navc vytv vechny uloen adrese, bez
              ohledu na to, zda v nich njak soubory jsou nebo ne.
cmdInvalid  - pouv RLE.PAS, pro inicializaci, aby zjistil, zda byl nkter
              z pedchzejch parametr pouit.
}
procedure UPackFiles(const SPacked, SFiles: String; Cmd: cmdS);
{
SPacked - KAM se m komprimovat/ODKUD se bude dekomprivat, me se zadat
          cel cesta (teba C:\XXX\YX\TTT.RLE).
SFiles  - CO se m de/komprimovat - rozdl se na 2 sti: cestu a jmno
          souboru. Na cestu se budou dekomprimovat soubory uren jmnem.
Cmd     - CO se m vbec dlat, viz popis cmdS.
}

implementation

uses
  Objects,
  Dos,
  RLEngine,
  RLEWork,
  RLEWild;

procedure MakePath(const S: String);
  {vytvo celou cestu ze S, tzn. vechny (neexistujc) adrese.
  S obsahuje teba C:\RATATA\BLEBLE\KUKU\, pak se procedura
  pokus vytvoit nejdv C:\RATATA, pak C:\RATATA\BLEBLE atd.
  }
  var
    S2: String;
    Pos: Byte;
    C: Char;
  begin
    {$I-}
    S2:='';
    for Pos:=1 to Length(S) do begin
      C:=S[Pos];
      if C='\' then
        MkDir(S2);
      S2:=S2+C;
    end;
    Byte(C):=IOResult; {hmmmmmmmmmm}
    DosError:=0;
    {$I+}
  end;

type
  TFHeader = object
    Magic: Longint;
    Name: FNameStr;
    Length: Longint;
    CRC: Longint;
    {
    Hlavika v spakovanm souboru.
    Magic - pro uren, jestli je to soubor nebo adres, viz MagicXXXX.
    Name - jmno souboru nebo adrese.
    Length - (jen pokud je Magic=MagicFile) dlka _spakovanho_ souboru
    CRC - (jen pokud je Magic=MagicFile) "kontroln" souet
    Sprvn "objektov" by tady asi mly bt metody
    Load a Store a pak to do streamu ukldat pes Put a Get, ale pro tento
    ppad dost zbyten, streamy jsou tady pouity hlavn pro snadn
    operaci s pointry a taky je tady jednou vyuita _velmi_ jednoduch
    ddinost (i kdy hodn kared, ale el svt prostedky ;-).
    }
  end;

const
  {Pro pouit v TFHeader.Magic}
  MagicFile = $0AC0FFEE; {COFFEE}
  {Pokud TFHeader.Magic=MagicFile, tak to znamen, e za hlavikou je
  TFHeader.Length bajt spakovanho souboru
  s nzvem TFHeader.Name a s "kontrolnm" soutem TFHeader.Length.}
  MagicDir  = $F5417051; {telefon dom :-), cel je ++42 +68 5417051}
  {Pokud TFHeader.Magic=MagicDir, tak to znamen, e dal soubory a po
  hlaviku MagicBack jsou uloeny v podadresi TFHeader.Name.}
  MagicBack = $60933333; {32 K/min ;-)}
  {Pokud TFHeader.Magic=MagicBack, tak to znamen, e se z podadrese
  vracme na pedchzejc rovn, tj. nco jako "..".}

type
  {Pro pkaz cmdTest, zde pouito pro "bezedn mec" nebo "hladovou jmu",
  nco jako null nebo /dev/null, udlno tak, e se oteve nesmysln stream
  pro ten a piad se mu Status stError, m jsou vecny operace zakzny
  (nelo pout pmo TStream, protoe ten m nadefinovny abstraktn metody,
  a vyhod to chybu voln abstraktn metody. To by lo obejt pepsnm
  metod Write, Read, Seek, GetPos atd., ale je to zbyten, kdy se to
  d udlat takto).}
  PDummyStream = ^TDummyStream;
  TDummyStream = object(TDosStream)
    constructor Init;
  end;

constructor TDummyStream.Init;
  begin
    inherited Init('.', stOpenRead);
    {Jedin problm je v tom, e pokud by se opravdu podailo (co nejde)
    tento soubor otevt a OS by na nj dal zmek, tak pak tento soubor
    nejde nap. smazat; toto ve se ale v prosted DOS/WinDOSw neme stt.}
    Status:=stError;
  end;

function ShowIOError(S: PStream): String;
{vrac slo chyby jako String}
  begin
    ShowIOError:='('+FStr(S^.Status)+','+FStr(S^.ErrorInfo)+')';
  end;

procedure PackFiles(POutStream: PStream; Files: String; const NotPack: String;
  Command: cmdS; var SINSize, SOUTSize: Longint; var FilesCount: Integer);
  {Pakovan (soubor i adres, podle Command), vol se rekurzvn pro
  podadrese:
  POutStream - stream, do kterho se bude pakovat. Na konci jej nezavr!
  Files - maska a adres, ze kterho se bude pakovat.
  NotPack - jmno souboru, kter se nem pakovat (= kam se pakuje).
  Command - pkaz, co se m dlat: pakovat, pakovat s adresi a nebo i s przdnmi adr.
  SINSize - vrac velikost petench dat (nespakovanch soubor).
  SOUTSize - vrac velikost zapsanch dat (spakovanch).
  FilesCount - vrac poet spakovanch soubor.
  }
  var
    FilesPath: PathStr;
    FilesName: FNameStr;

  procedure PackOne(const Name: String);
    {spakuje jeden soubor Name}
    var
      PIN: PStream;
      TOF: TFHeader;
      POS, POS2: Longint;
      rINSize, rOUTSize: Longint;
    begin
      PIN:=New(PDosStream, Init(FilesPath+Name, stOpenRead));
      if PIN^.Status=stOK then begin
        POS:=POutStream^.GetPos; {ulome pozici}
        {--- zpis hlaviky ---}
        TOF.Magic:=MagicFile;
        TOF.Name:=Name;
        TOF.Length:=PIN^.GetSize;
        POutStream^.Write(TOF, SizeOf(TOF));
        {--- vlastn pakovn ---}
        CWrite('`f'+FilesPath+TOF.Name+' ');
        PackNUnPack(True, PIN, POutStream, TOF.Length, TOF.CRC, rINSize, rOUTSize);
        {--- znovu zpis hlaviky ---}
        POS2:=POutStream^.GetPos; {znovu ulome pozici}
        POutStream^.Seek(POS); {na hlaviku}
        TOF.Length:=POS2-POS-SizeOf(TOF); {sice je to v rINSize, ale kdo v...}
        POutStream^.Write(TOF, SizeOf(TOF)); {zapeme novou dlku}
        POutStream^.Seek(POS2); {a jsme zase na konci}
        {--- kontrola ---}
        if (PIN^.Status=stOK) and (POutStream^.Status=stOK) then begin
          CWriteLn(#8#8#8#8#8'`a'+FStr(100*rOUTSize div rINSize)+'`c% `aOK');
          SINSize:=SINSize+rINSize;
          SOUTSize:=SOUTSize+rOUTSize;
          Inc(FilesCount);
        end
        else
          if POutStream^.Status<>stOK then
            WError('Nelze zapisovat do vstupnho souboru '+ShowIOError(POutStream)+'.');
          if PIN^.Status<>stOK then
            WError('Nelze st ze vstupnho souboru '+ShowIOError(PIN)+'.');
      end
      else
        CWriteLn('`f'+NAME+' `Chyba: `9Nejde otevt soubor '+ShowIOError(PIN)+'.');
      Dispose(PIN, Done);
    end;

    procedure PackDir(const Name: String);
      {spakuje adres Name, tzn. e ulo e se pakuje adres Name
      a pak spakuje vechno v nm, co vyhovuje masce}
      var
        TOF: TFHeader;
        OldFilesCount: Integer;
      begin
        {--- zpis hlaviky ---}
        TOF.Magic:=MagicDir;
        TOF.Name:=Name;
        TOF.Length:=0;
        TOF.CRC:=0;
        POutStream^.Write(TOF, SizeOf(TOF)); {hlavika adrese}
        OldFilesCount:=FilesCount;

        PackFiles(POutStream, FilesPath+Name+'\'+FilesName, NotPack, Command,
          SINSize, SOUTSize, FilesCount);
          {--- rekurzivn voln pro podadres ---}
        if (Command=cmdPackDir) and (OldFilesCount=FilesCount) then
          {nebyl dn soubor a my nemme pakovat przdn podadrese}
          with POutStream^ do begin
            Seek(GetPos-SizeOf(TOF));
            {posuneme se zptky}
            Truncate;
            {a zrume, co jsme zapsali}
          end
        else begin
          if FilesCount=OldFilesCount then
            CWriteLn('`f'+FilesPath+TOF.Name+'\');
            {vpis przdnho podadrese}
          TOF.Magic:=MagicBack;
          POutStream^.Write(TOF, SizeOf(TOF));
          {zptky na ..}
        end;
      end;

  var
    DirInfo: SearchRec;
    Stf1, Stf2: FNameStr;
  {--- zatek PackFiles ---}
  begin
    DosError:=0;
    FSplit(Files, FilesPath, Stf1, Stf2); {mus se dlat pokad znovu}
    FilesName:=Stf1+Stf2;
    {--- nejdv soubory ---}
    FindFirst(Files, ReadOnly or Hidden or SysFile or Archive, DirInfo);
    {pozor! vrac JENOM jmno souboru -> mus se doplnit cesta}
    while DosError=0 do begin
      if FilesPath+DirInfo.Name<>NotPack then {tam to strkme, to nebudem pakovat}
        PackOne(DirInfo.Name);
      FindNext(DirInfo);
    end;
    DosError:=0;
    if (Command=cmdPackDir) or (Command=cmdPackEDir) then begin
      {--- a te adrese ---}
      FindFirst(FilesPath+'*.*', ReadOnly or Hidden or SysFile or Archive or Directory, DirInfo);
      while DosError=0 do begin
        if ((DirInfo.Attr and Directory)<>0) and
          (DirInfo.Name<>'.') and (DirInfo.Name<>'..') then {je to adres}
          PackDir(DirInfo.Name);
        FindNext(DirInfo);
      end;
      DosError:=0;
    end;
  end;

procedure UnPackFiles(PInStream: PStream; Files: String; Command: cmdS;
  var SINSize, SOUTSize: Longint; var FilesCount: Integer);
  {rozpakuje/testuje; vol se rekurzvn:
  PInStream - odku se m depakovat. Na konci nezavr!
  Files - cesta a maska pro soubory.
  Command - cmdTest = testovn, cmdUnPack = depakovn atd.
  SINSize - vrac velikost petench dat (spakovanch soubor).
  SOUTSize - vrac velikost zapsanch dat (rozpakovanch).
  FilesCount - vrac kolik soubor se skuten rozpakovalo.
  }
  var
    UnPackFlag: Boolean; {jestli se m vytvet adres, poprv}
    TOF: TFHeader; {pro hlaviku}
    FilesPath: PathStr; {cesta k souborm, kter se budou depakovat}
    FilesName: FNameStr; {maska soubor, kter se budou depakovat}

  procedure UnPackOneFile;
    {rozpakuje jeden soubor, kter je zadan v TOF.Name}
    var
      POUT: PStream;
      CRC: Longint;
      rINSize, rOUTSize: Longint;
      I: Byte;
    label
      ThisJumpIsNotForDummies;
    begin
      if WildC(TOF.Name) then begin {vyhovuje masce}
        if (Command=cmdUnpack) and (not UnPackFlag) then begin {jet se tady nic nerozpakovalo}
          {pokud byl pkaz cmdUnpackE, pak u se adres vytvoil a navc je
          nastaveno UnPackFlag}
          MakePath(FilesPath); {vytvoen adrese FilesPath}
          UnPackFlag:=True; {aby se pt u nevytvel}
        end;
        if Command=cmdTest then
          POUT:=New(PDummyStream, Init) {nepkn, vytvo se "imaginrn" stream}
        else begin
          POUT:=New(PDosStream, Init(FilesPath+TOF.Name, stOpenRead));
          if POUT^.Status<>stInitError then
            if not Question('`7Soubor `f'+FilesPath+TOF.Name+' `7u existuje, chcete jej pepsat') then begin
              goto ThisJumpIsNotForDummies; {nepkn skok ve strukturovanm programovn, e ;-)}
            end;
          Dispose(POUT, Done);
          POUT:=New(PDosStream, Init(FilesPath+TOF.Name, stCreate));
        end;
        if (Command<>cmdTest) and (POUT^.Status<>stOK) then begin
          CWriteLn('`e'+TOF.Name+' `4Chyba: `9Nejde vytvoit soubor '+ShowIOError(POUT)+'.');
          ThisJumpIsNotForDummies:
          with PInStream^ do
            Seek(GetPos+TOF.Length); {chyba, posuneme se na dal soubor}
        end
        else begin {POUT.Status=stOK}
          {--- vlastn depakovn ---}
          CWrite('`f'+FilesPath+TOF.Name+' '); {rozpakujeme}
          PackNUnPack(False, PInStream, POUT, TOF.Length, CRC, rINSize, rOUTSize);
          {--- vpis hlky a kontrola CRC ---}
          CWrite(#8#8#8#8#8);
          if ((Command=cmdTest) or (POUT^.Status=stOK)) and (PInStream^.Status=stOK) then
            if CRC=TOF.CRC then begin
              CWriteLn('`aOK  ');
              SINSize:=SINSize+rINSize;
              SOUTSize:=SOUTSize+rOUTSize;
              Inc(FilesCount);
            end
            else
              WError('patn kontroln souet.')
          else begin
            if (Command<>cmdTest) and (POUT^.Status<>stOK) then
              WError('Nelze zapisovat do vstupnho souboru '+ShowIOError(POUT)+'.');
            if PInStream^.Status<>stOK then
              WError('Nelze st ze vstupnho souboru '+ShowIOError(PInStream)+'.');
          end;
        end;
        Dispose(POUT, Done);
      end {not WildC}
      else begin
        CWrite('`7'+FilesPath+TOF.Name+#13); {peskakujeme}
        with PInStream^ do         {nespluje podmnky}
          Seek(GetPos+TOF.Length);  {posuneme se na dal soubor}
      end;
    end;

    procedure UnPackDir;
      {rozbal adres TOF.Name - zavol UnPackFiles s navc pidanm jmnem
      adrese}
      begin
        UnPackFiles(PInStream, FilesPath+TOF.Name+'\'+FilesName, Command,
          SINSize, SOUTSize, FilesCount);
          {voln pro podadres}
      end;

  var
    Size, S2: Longint;
    EXITsw: Boolean;
    Stf1, Stf2: FNameStr;
  {--- zatek UnPackFiles ---}
  begin
    UnPackFlag:=False;
    FSplit(Files, FilesPath, Stf1, Stf2);
    FilesName:=Stf1+Stf2;
    Size:=PInStream^.GetSize;
    EXITsw:=False; {nen konec}
    if Command=cmdUnpackE then begin
      {i przdn adrese, vytvome}
      MakePath(FilesPath); {vytvoen adrese FilesPath}
      UnPackFlag:=True; {aby se pt u nevytvel}
    end;
    repeat
      S2:=PInStream^.GetPos;
      if Size<>S2 then begin
        PInStream^.Read(TOF, SizeOf(TOF));
        {peteme hlaviku a podle n se zachovme}
        if PInStream^.Status=stOK then
          if TOF.Magic=MagicFile then
            UnPackOneFile
          else
            if TOF.Magic=MagicDir then
              UnPackDir
            else
              if TOF.Magic=MagicBack then
                EXITsw:=True {zptky...}
              else begin {TOF.Magic<>MagicXXXX}
                WError('Chybn zdrojov soubor.');
                EXITsw:=True;
              end
        else begin {PInStream^.Status<>stOK}
          WError('Nelze st ze zdrojovho souboru '+ShowIOError(PInStream)+'.');
          EXITsw:=True;
        end;
      end
      else
          EXITsw:=True; {jinak konec souboru}
    until EXITsw;
  end;

procedure UPackFiles(const SPacked, SFiles: String; Cmd: cmdS);

  var
    PS: PStream;
    {pro prci s SPacked}
    SINSize, SOUTSize: Longint;
    {velikost nekomprimovanch a komprimovanch soubor}
    FilesCount: Integer;
    {celkov poet zkomprimovanch soubor}
    S: String; {pro vpis na konci}
    Err: Boolean; {pokud byla njak chyba ji na zatku a nevolali
      jsme Un/PackFiles, pak se nevypisuje zvren patika}
  begin
    {SINSize, SOUTSize a FilesCount se jenom zvyuj, take na zatku mus
    bt nastaveny na 0}
    SINSize:=0;
    SOUTSize:=0;
    FilesCount:=0;
    Err:=False;
    case Cmd of
      cmdPack, cmdPackDir, cmdPackEDir: begin
        CWriteLn('`bKomprimuje se '+SFiles+' do souboru '+SPacked+'.');
        S:='spakovno';
        PS:=New(PDosStream, Init(SPacked, stOpenRead));
        {pokus o oteven souboru, do kterho budeme pakovat}
        with PS^ do
          if (Status=stInitError) or {tzn. e el otevt = chyba, nem existovat}
            ((Status<>stInitError) and Question('`7Soubor `f'+SPacked+' `7u existuje, chcete jej pepsat')) then begin
            Dispose(PS, Done); {zrume...}
            PS:=New(PDosStream, Init(SPacked, stCreate));
            if PS^.Status<>stOK then begin {vytvome/pepeme <soubor>}
              WError('Nelze vytvoit vystupn soubor '+ShowIOError(PS)+' '+SPacked+'.');
              Err:=True;
            end
            else
              PackFiles(PS, SFiles, SPacked, Cmd, SINSize, SOUTSize, FilesCount);
          end
          else
            Err:=True; {existoval a nepovolili jsme pepsn}
        Dispose(PS, Done);
      end;
      cmdUnpack, cmdUnpackE, cmdTest: begin
        if Cmd=cmdTest then begin
          CWriteLn('`bTestuje se soubor '+SPacked+'.');
          S:='testovno';
        end
        else begin
          CWriteLn('`bDekomprimuje se '+SFiles+' ze souboru '+SPacked+'.');
          S:='rozpakovno';
        end;
        PS:=New(PBufStream, Init(SPacked, stOpenRead, 2000));
          {TBufStream, protoe se budeme obas vracet}
        if PS^.Status=stOK then begin {jde otevt...}
          InitWildC(SFiles); {inicializace pro * a ?}
          UnPackFiles(PS, SFiles, Cmd, SINSize, SOUTSize, FilesCount); {soubor jde otevt -> dekomprimace}
        end
        else begin
          WError('Nelze otevt vstupn soubor '+ShowIOError(PS)+' '+SPacked+'.');
          Err:=True;
        end;
        Dispose(PS, Done);
      end;
      else
        Exit; {jistota je jistota, kdyby to nebyl platn pkaz...}
    end;

    if not Err then begin
      CWriteLn('`eCelkem bylo '+S+' `a'+FStr(FilesCount)+'`e soubor.');
      CWriteLn('`eBylo peteno `a'+FStr(SINSize)+'`e byt (v souborech)');
      CWriteLn('`ea zapsno `a'+FStr(SOUTSize)+'`e byt.');
      if SINSize=0 then
        SINSize:=1; {aby to nebylo dlen 0}
      CWriteLn('`fKompriman pomr je `d'+FStr(100*SOUTSize div SINSize)+'`c%`f.');
    end;
    {--- a vypeme poet chyb ---}
    if TotalErrors<>0 then
      CWriteLn('`4Celkem chyb: '+FStr(TotalErrors)+'.');
  end;

end.
