{
RLE96
(c) 1996 Jaromr Koutek

De/kompriman program, pouvajc metodu RLE.


RLEBuffer.PAS - pro WinDOSw je to RLEBUFFE.PAS, poppad RLEBUF~1.PAS...

Definice tdy TOutBuffer:
Vstupn buffer s ke ;-).
Pomoc Put se pidv po jednom bajtu nebo pomoc FillBuffer po nkolika
stejnch bajtech, ale buffer se vyprzdn na disk
jenom kdy je pln nebo kdy se na konci zavol Flush.
Pouv RLEngine.PAS.
}

unit RLEBuffer;

interface

uses

  Objects;


const
  MaxBufferSize = 65535-8; {kolik se vleze do kee}


type

  PBuffer = ^TBuffer;
  TBuffer = array[0..MaxBufferSize] of Byte;

  POutBuffer = ^TOutBuffer;
  TOutBuffer = object(TObject)
  {Popis u metod.}
    StreamSize: Longint;
    constructor Init(AStream: PStream);
    procedure Put(What: Byte);
    procedure FillBuffer(What: Byte; Size: Word);
    procedure Flush;
    destructor Done; virtual;
    private
    Buffer: PBuffer;
    Count: Word;
    Stream: PStream;
    procedure MakeBuffer;
    procedure DoneBuffer;
    procedure CheckSize(Size: Word);
  end;

implementation

constructor TOutBuffer.Init(AStream: PStream);
  {inicializace baftu ;-), v AStream je PStream, do kterho se bude zapisovat}
  begin
    inherited Init;
    Stream:=AStream;
    MakeBuffer;
  end;

procedure TOutBuffer.MakeBuffer;
  {vytvo pole pro buffer v pamti, zabere MaxBufferSize}
  begin
    if Buffer=nil then begin
      Buffer:=New(PBuffer);
      FillChar(Buffer^, SizeOf(TBuffer), 0);
      Count:=0;
    end;
  end;

procedure TOutBuffer.DoneBuffer;
  {zru pole pro buffer v pamti}
  begin
    if Buffer<>nil then begin
      Dispose(Buffer);
      Buffer:=nil; {!@#$% BP !@#$%}
      Count:=0;
    end;
  end;

procedure TOutBuffer.Put(What: Byte);
  {str do bufferu jeden bajt What, pokud je pln, vyprzdn ho}
  begin
    CheckSize(SizeOf(What));
    Buffer^[Count]:=What;
    Inc(Count);
  end;

procedure TOutBuffer.FillBuffer(What: Byte; Size: Word);
  {d do bufferu Size bajt What}
  begin
    CheckSize(Size);
    FillChar(Buffer^[Count], Size, What);
    Inc(Count, Size);
  end;

procedure TOutBuffer.Flush;
  {vyprzdn buffer}
  begin
    if (Buffer<>nil) and (Count<>0) then begin
      Stream^.Write(Buffer^, Count);
      StreamSize:=StreamSize+Longint(Count);
      Count:=0;
    end;
  end;

procedure TOutBuffer.CheckSize(Size: Word);
  {kontroluje, jestli se do bufferu vleze jete Size bajt, kdy ne, tak
  se vyprzdn}
  begin
    if MaxBufferSize-Size<Count then
      Flush;
  end;

destructor TOutBuffer.Done;
  {vyprzdn buffer, zru pole a NEzave Stream}
  begin
    Flush;
    DoneBuffer;
    inherited Done;
  end;

end.
