; RDMC - Reiterative DMC packer de Metalbrain
;
; Copyright (c) 2000-01 Jaime Tejedor Gmez / Metalbrain.
; Reservados todos los derechos.
;
; Versin 0.06b - BETA: USA EL CDIGO FUENTE A TU PROPIO RIESGO
;
; Ncleo DMC original por Pierre Almeras (St0ne)
; Basado en el algoritmo DMC creado por Gordon V. Cormack y Nigel S. Horspool
;
; Para compilarlo, necesitars NASM y el extensor WDOSX. Para tener soporte
;completo de nombres largos, debes recompilar WDOSX reemplazando el archivo
;RDOFF.ASM por el que se incluye.
;
; El ltimo paso es la compresin del ejecutable resultante, pero esto es
;opcional (adems, no se ganan ni 300 bytes), para ello necesitas el
;compresor de ejecutables 32LiTE (ya que UPX no soporta WDOSX).
;
; nasm -f rdf -o RDMC.EXE RDMC006B.NAS
; stubit RDMC.EXE
; del rdmc.bak
; 32lite -best RDMC.EXE
;
; Las nuevas versiones de NASM permiten activar la optimizacin de saltos
;especificando -O1, que produce un ejecutable algo menor, aunque la versin
;0.98 sigue funcionando bien.

BITS 32

_WdosxStart
                pushad
                mov     ax,1684h        ;Funcin
                mov     bx,1            ;Identificador de VM manager
                xor     di,di           ;offset en Modo Real del punto de
                                        ; entrada de la API
                mov     es,di           ;segmento en Modo Real del punto de
                                        ; entrada de la API
                int     2fh             ;Probar
                mov     ax,es
                or      di,ax
                setz    al              ;DOS: AL=1, Windows: AL=0
                dec     eax             ;DOS: AL=0, Windows: AL=255
                mov     [enableLFN],al  ;Deshabilitar nombres largos bajo DOS
                popad
                mov     ah,1
                mov     cx,2000h
                int     10h             ;Deshabilitar cursor
                mov     edx,initmessage
                mov     ah,9
                int     33              ;Poner mensaje inicial
                cmp     esi,4           ;4 argumentos?
                jnz     near Err_ARG    ;No: error de sintaxis
                xchg    esi,edi         ;esi=argv
                lodsd                   ;Pasar del nombre del programa
                lodsd                   ;Coger direccin del comando
                xchg    eax,ebx
                mov     ax,[ebx]        ;Coger comando
                cmp     ax,'c'
                jz      near okcommand
                cmp     ax,'d'
                jnz     near Err_ARG    ;Ni 'c' ni 'd' -> error de sintaxis
okcommand       mov     [command],al    ;Guardar comando
                lodsd                   ;Posicin del nombre de entrada
                push    esi             ;Guardar argv
                push    ds              ;Guardar segmento
                xor     edi,edi         ;edi=0
                mov     esi,eax         ;esi=posicin del nombre del archivo
                mov     ah,48h
                mov     bx,17           ;16*17=272 bytes
                int     33              ;Reservar memoria baja
                jc      near Err_MEMlow ;No hay memoria baja
                mov     es,ax           ;es-> memoria baja pedida
                mov     [segmentlow],ax ;Almacenar segmento
nametodata16    lodsb                   ;Coger byte de la linea de comandos
                stosb                   ;Y almacenarlo en la memoria baja
                cmp     al,0
                jnz     nametodata16    ;Hacerlo hasta encontrar un cero
                xor     esi,esi         ;Nombre de archivo en ds:si
                xor     bx,bx           ;Solo lectura
                xor     cx,cx           ;Sin flags
                mov     dx,1            ;Abrir
                xor     di,di           ;Sin alias hint
                mov     ax,716Ch        ;LFN: Funcin de abrir/crear
                and     ah,[enableLFN]
                push    es
                pop     ds              ;Pon ds=es -> memoria baja
                jz      NOLFN_1         ;Bajo DOS ni lo intentes
                stc                     ;Si no est disponible, carry=1
                int     33              ;Intentar abrir nombre largo
                jnc     infileok        ;ok -> continuar
NOLFN_1         mov     ax,3d00h        ;Funcin clsica de abrir archivo
                mov     edx,esi         ;Nombre en ds:dx
                int     33              ;Abrir nombre corto
                jc      near Err_infile ;Sigue sin poder -> Error
infileok        pop     ds              ;Restaurar segmento de datos 32 bits
                pop     esi             ;Restaurar argv
                mov     [handlein],ax   ;Guardar handle
                lodsd                   ;Direccin del nombre del fichero 2
                xor     edi,edi         ;Volver a borrar edi
                xchg    esi,eax         ;esi->nombre del archivo de salida
                mov     ebp,[esi]       ;Coger comienzo del archivo de salida
nametodata16_2  lodsb
                stosb
                cmp     al,0
                jnz     nametodata16_2  ;Copiar a memoria baja como antes

                xchg    eax,ebp
                cmp     ah,':'          ;Hay unidad en el archivo de salida?
                jnz     nounit          ;No->saltar las 2 lineas siguientes
                mov     [unittmpfile],al;Fijar unidad
                sub     dword [tmpname],2;Aadir unidad al nombre temporal
nounit          mov     [lowmem_tmp],edi
                mov     edx,[tmpname]   ;Coger nombre del archivo temporal
                mov     esi,edx
                mov     ecx,15          ;Longitud de "D:RDMCTMP.$$$",0
                rep     movsb           ;Copy it to low memory too
                mov     ah,3ch
                xor     ecx,ecx         ;Sin atributos
                int     33              ;Crear archivo temporal (nombre corto)
                jc      near Err_outfile2
                mov     [handleout],ax  ;Guardar handle
                mov     ax,0501h        ;Funcin DPMI de pedir memoria
                mov     bx,0045h        ;Digamos 4M+320K
                int     31h             ;Vamos a ello
                jc      near nomemory   ;Error de no hay memoria
                push    bx
                push    cx
                pop     ebp             ;La memoria alojada comienza en ebp
                ;Coger longitud del archivo de entrada
                pushad
                xor     ecx,ecx
                xor     edx,edx
                mov     ax,4202h
                mov     bx,[handlein]
                pushad
                int     33              ;Mover puntero al final -> longitud
                mov     [total],ax      ;en dx:ax
                mov     [total+2],dx    ;Almacenarla
                popad
                dec     eax
                dec     eax
                int     33              ;Mover al principio
                popad
                mov     ebx,fpu         ;ebx apunta a las variables
                mov     [ebx+40],ebp    ;bufferstart
                add     ebp,256*1024    ;+256K  Zona histrica
                mov     [ebx+36],ebp    ;bufferzone
                add     ebp,32768       ;+32K   Buffer de datos no comprimidos
                mov     [ebx+32],ebp    ;buffer2
                mov     [ebx+24],ebp    ;bufferlimit
                add     ebp,32768       ;+32K   Buffer de datos comprimidos
                mov     [ebx+28],ebp    ;bufferlimit2
                push    ds
                pop     es

                fninit                  ;Iniciar coprocesador
                fldcw   [ebx]           ;precisin float, redondeo par
                call    init            ;Iniciar arbol
                mov     [ebx+16],ecx    ;min=0
                mov     dword [ebx+12],01000000h ;Poner max
                cmp     byte[command],'c' ;Si el comando fue 'c'
                jz      near Encoder    ;Vete a comprimir
                ;DESCOMPRIMIR           ;Si no, descomprimimos
                push    eax             
                mov     eax,[ebx+36]
                mov     [ebx+4],eax     ;Pointer = Bufferzone
                mov     eax,[ebx+28]
                mov     [ebx+8],eax     ;Pointer2 = Bufferstart
                pop     eax
e_reinit        xor     ecx,ecx
                add     dword[ebx+44],128  ;Espacio extra para el ltimo cero
e_val           call    loadbyte        ;Coger un byte
                inc     ecx
                jnp     e_val           ;Hacerlo 2 veces mas
                mov     dl,0
e_do_dec        test    dword[ebx-4],255;Probar cada 256 bytes
                jnz     nocheckin_dec   ;Prueba no
                cmp     dword[ebx-8],256;Falla la compresin?
                jna     nocheckin2_dec  ;No falla
                push    ecx             ;Si
                call    init            ;Reiniciar modelo
                add     dword[ebx+44],128 ;Espacio extra para el ltimo cero
                pop     ecx
nocheckin2_dec  ;Poner porcentaje
                pushad
                mov     eax,[ebx-12]    ;Nmero de bytes procesados
                mov     ebx,100
                imul    ebx             ;Multiplicar por 100
                mov     ebx,[total]
                and     ebx,ebx         ;Si el archivo est vacio, no dividir
                jz      nodiv_dec
                div     ebx             ;Ahora el porcentaje est en al
nodiv_dec       mov     ebx,messagepercent+3 ;Lugar donde poner los nmeros
                mov     dl,10           ;Divisor
                mov     cl,3            ;Nmeros por poner
num_dec         cbw                     ;Limpiar AH
                and     al,al           ;Pasar de los ceros a la izquierda
                jz      skipzero_dec
                div     dl              ;Divide por 10
                add     ah,48           ;Numero a caracter
                mov     [ebx],ah        ;Poner caracter
skipzero_dec    dec     ebx             ;Apuntar al siguiente
                loop    num_dec         ;Repetir para 3 cifras
                mov     edx,ebx
                mov     ah,9
                int     33              ;Poner porcentaje
                popad
                mov     [ebx-8],dword 0 ;Borrar partialbytes
nocheckin_dec   mov     cl,08h          ;8 bits por byte
                cmp     edi,[ebx+44]    ;Si se cruza el lmite de memoria
                jnc     near Endit2     ;Era un archivo erroneo
e_for_dec       cmp     dword[esi],8388608 ;Evitar denormales. Estos pueden
                jnc     normal_dec1        ; causar excepciones con la FPU.
                mov     dword[esi],8388608 ; Esto se repetir varias veces en
                                           ; el cdigo
normal_dec1     cmp     dword[esi+4],8388608
                jnc     normal_dec2
                mov     dword[esi+4],8388608
normal_dec2     fld     dword[esi+4]    ;st0=p.c1
                fld     dword[esi]      ;st0=p.c0, st1=p.c1
                fadd    st1,st0         ;st0=p.c0, st1=p.c0+p.c1
                mov     eax,[ebx+12]    ;max
                sub     eax,[ebx+16]    ;max-min
                dec     eax             ;max-min-1
                mov     [ebx],eax    ;[ebx]=mid=max-min-1
                fild    dword[ebx]   ;st0=(max-min-1),st1=p.c0,st2=p.c0+p.c1
                fmulp   st1          ;st0=(max-min-1)*(p.c0),st1=p.c0+p.c1
                fdivrp  st1          ;st0=(max-min-1)*(p.c0)/(p.c0+p.c1)
                fistp   dword[ebx]   ;[ebx]=mid=(max-min-1)*(p.c0)/(p.c0+p.c1)
                ;Ajustar valores al alcanzar lmites
                mov     eax,[ebx]       ;mid
                or      eax,eax         ;Es cero?
                jnz     e_if1_dec
                inc     eax             ;Si -> incrementa
e_if1_dec       add     eax,[ebx+16]    ;mid+=min

                inc     eax             ;mid++
                cmp     eax,[ebx+12]    ;Ha alcanzado el mximo?
                jne     e_if2_dec
                dec     eax             ;Si -> decrementa
e_if2_dec       dec     eax             ;mid--
                cmp     eax,[ebx+20]    ;si (val>=mid)
                jg      e_if6
                mov     [ebx+16],eax    ;min=mid
                mov     dh,1            ;bit=1
                jmp     e_el6
e_if6           mov     [ebx+12],eax    ;max=mid
                mov     dh,0            ;bit=0
                ;Poner bit
e_el6           add     dl,dl
                add     dl,dh           ;c=(c<<1)+bit
                ;Actualizar arbol
up_dec          push    ecx
                mov     ecx,esi
                or      dh,dh
                jz      up1_dec
                add     ecx,4           ;ecx=&(p->count[b])
up1_dec         mov     esi,[ecx+8]     ;esi=(p->next[b])
                ;Ver si se necesita duplicar
                mov     eax,40000000h   ;Threshold=bigthresh
                cmp     dword [ecx],eax ;si (p->count[b] < threshold)
                jl      up2_dec         ; no duplicar
                cmp     dword[esi],8388608
                jnc     normal_dec3
                mov     dword[esi],8388608
normal_dec3     cmp     dword[esi+4],8388608
                jnc     normal_dec4
                mov     dword[esi+4],8388608
normal_dec4     fld     dword [esi]     ;st0=p->next[b]->count[0]
                                        ;nx->c0
                fadd    dword [esi+4]   ;st0+=p->next[b]->count[1]
                                        ;+nx->c1
                fsub    dword [ecx]     ;st0-=p->count[b]
                                        ;-p->cx
                fstp    dword [ebx]     ;[ebx]=(p->next[b]->count[0])+(p->next[b]->count[1])-(p->count[b])
                cmp     [ebx],eax       ;si [ebx] < bigthresh
                jl      up2_dec         ; no duplicar
                ;Duplicacin
                cmp     dword[esi],8388608
                jnc     normal_dec5
                mov     dword[esi],8388608
normal_dec5     cmp     dword[esi+4],8388608
                jnc     normal_dec6
                mov     dword[esi+4],8388608
normal_dec6     fld     dword [esi]     ;st0=nx->c0
                fadd    dword [esi+4]   ;st0=nx->c0+nx->c1
                fdivr   dword [ecx]     ;st0=r=(p->cx)/(nx->c0+nx->c1)
                fld     st0             ;st1=st0=r
                xor     eax,eax
dup_dec         fmul    dword [esi]     ;*p->next[b]->count[0]
                fst     dword [edi]     ;(new->c0)=r*(nx->c0)
                cmp     dword[edi],8388608
                jnc     normal_dec
                mov     dword[edi],8388608
normal_dec      fsubr   dword [esi]
                fstp    dword [esi]     ;(nx->c0)-=r*(nx->c0)
                cmpsd                   ;apuntar a c1
                dec     eax
                jp      dup_dec         ;hacer lo mismo con c1
                movsd                   ;copiar n0 y apuntar a n1
                movsd                   ;copiar n1 y apuntar a new++
                mov     [ecx+8],edi     ;(p->next[b])=new++
                sub     [ecx+8],dword 16;(p->next[b])=new
                ;Actualizar nodo actual
up2_dec         fld1
                fadd    dword [ecx]
                fstp    dword [ecx]     ;(p->count[b])++
                mov     esi,[ecx+8]     ;p = p->next[b];
                pop     ecx
                ;Procesar con el siguiente caracter de entrada
                mov     eax,[ebx+12]    ;max
                sub     eax,[ebx+16]    ;max-min
                cmp     eax,00000100h   ;si max-min>=256
                jge     e_nxt_dec       ;saltar todo esto
                or      dh,dh
                jz      e_if4_dec
                dec     dword [ebx+12]  ;if(bit)max--
e_if4_dec       call    loadbyte        ;Cargar un nuevo byte  
                inc     dword[ebx-8]    ;partialbytes++
                shl     dword[ebx+16],16
                shr     dword[ebx+16],8 ;min = (min << 8) & 0xffff00
                shl     dword[ebx+12],16
                shr     dword[ebx+12],8 ;max = ((max << 8) & 0xffff00 )
                mov     eax,[ebx+12]
                cmp     eax,[ebx+16]    ;si (min >= max)
                jg      e_nxt_dec
                mov     dword[ebx+12],01000000h ;max = 0x1000000;
e_nxt_dec       dec     ecx             ;siguiente bit
                jnz     near e_for_dec  ;bucle for
                mov     al,dl           ;siguiente byte
                ;cdigo de buffer                
                mov     [bufferchar],al ;poner carcter en variable
                pushad                  ;Guardar registros
                xchg    [ebx+4],edi     ;edi<->pointer (datos sin comprimir)
                mov     ecx,[ebx+24]    ;bufferlimit
                cmp     edi,ecx         ;si pointer != bufferlimit
                jnz     writebyte3      ;solo almacenar en memoria
                mov     ah,40h
                mov     edx,[ebx+36]    ;empezar a escribir desde bufferzone
                sub     ecx,edx         ;32K = bufferlimit - bufferzone
                mov     bx,[handleout]  ;handle
                int     33              ;Escribir bloque de 32K
                jc      near Write_ERR  ;Error de escritura
                cmp     eax,ecx         
                jc      near DiskFull   ;Si no se han escrito ecx bytes, el
                                        ; disco est lleno
                mov     esi,[fpu+40]    ;bufferstart
                mov     edi,esi         ;bufferstart
                add     esi,ecx         ;bufferstart+32K
                mov     ecx,edx         ;bufferzone
                sub     ecx,edi         ;bufferzone-bufferstart
                shr     ecx,2           ;ecx est alineado
                rep     movsd           ;mover memoria (dwords)
                mov     edi,[fpu+36]    ;pointer=bufferzone
writebyte3      mov     al,[bufferchar] ;coger nuevo byte
                stosb                   ;almacenarlo en el buffer
                xchg    [fpu+4],edi     ;edi<->pointer
                popad                   ;Restaurar registros
                inc     dword [ebx-4]   ;bytes++
                ;fin de cdigo del buffer
                mov     eax,[ebx+12]    ;max
                dec     eax             ;max-1
                cmp     eax,[ebx+20]    ;si val!=max-1
                jne     near e_do_dec   ;continuar descomprimiendo
                ;alcanzado final parcial
                dec     dword[ebx+4]    ;Pasar del ltimo cero
                dec     dword[ebx-4]    ;Pasar de el tambin en la cuenta de
                                        ; bytes
                call    loadfakebyte    ;Ver si sigue habiendo bytes por
                                        ; procesar
                js      Endit           ;No: hemos acabado
                call    init2           ;Si: hacer un nuevo arbol usando datos
                jmp     e_reinit        ;previos y continuar descomprimiendo
                ;Vaciar buffer de escritura
Endit           xchg    ecx,[ebx+4]     ;ecx=pointer
                mov     edx,[ebx+36]    ;bufferzone
                sub     ecx,edx         ;bytes que quedan por escribir
                mov     ah,40h          ;Decoder: 1 write inline
                push    ebx             ;Guardar ebx
                mov     bx,[handleout]
                int     33              ;Escribir el ltimo bloque
                pop     ebx             ;Restaurar ebx
                jc      near Write_ERR  ;Error de escritura
                cmp     eax,ecx
                jc      near DiskFull   ;Si no se han escrito ecx bytes, el
                                        ; disco est lleno
                mov     edx,decok       ;Apuntar al mensaje final
                jmp     exitgood        ;Salir
                ;COMPRIMIR
Encoder         push    eax
                mov     eax,[ebx+24]
                mov     [ebx+4],eax     ;pointer=bufferlimit
                mov     [ebx+8],eax     ;pointer2=bufferlimit
                pop     eax
e_do_cod        cmp     edi,[ebx+44]    ;si no hemos pasado el lmite
                jc      noproblemo_cod  ;continuar mas abajo
                mov     cl,8            ;contador de 8 bits
                mov     dl,0            ;Cero de coa
                dec     byte[flag]      ;...si flag est activo
                jz      near e_for_cod  ;Si no, continuamos con el final
                ;Final parcial: guardar max-1
                mov     byte[flag],1    ;Resetear flag
                push    ecx             ;Guardar ecx
                mov     eax,[ebx+12]    ;max
                dec     eax             ;max-1
                push    eax             ;guardar en la pila
                shr     eax,16          ;los 8 bits de arriba (23-16)
                call    writebyte       ;escribir
                pop     eax             ;restaurar max-1
                push    eax             ;volver a guardar
                shr     eax,8           ;los 8 bits de enmedio (15-8)
                call    writebyte       ;escribir
                pop     eax             ;los ltimos 8 bits (7-0)
                call    writebyte       ;escribir
                call    init2           ;Hacer un nuevo arbol usando datos
                pop     ecx             ;previos
noproblemo_cod  test    dword[ebx-4],255;Probar cada 256 bytes
                jnz     nocheckin_cod   ;Prueba no
                cmp     dword[ebx-8],256;Falla la compresin?
                jna     nocheckin2_cod  ;No falla
                push    ecx             ;Si
                call    init            ;Reiniciar modelo
                pop     ecx
nocheckin2_cod  mov     [ebx-8],dword 0 ;Resetear partialbytes
                ;Poner porcentaje hecho
                pushad
                mov     eax,[ebx-4]     ;Nmero de bytes procesados
                mov     ebx,100         
                imul    ebx             ;Multiplicar por 100
                mov     ebx,[total]
                and     ebx,ebx         ;Impedir divisin por cero
                jz      nodiv_cod
                div     ebx             ;Dividir por total
nodiv_cod       mov     ebx,messagepercent+3 ;Lugar donde poner los nmeros
                mov     dl,10           ;Divisor
                mov     cl,3            ;3 digitos
num_cod         cbw                     ;Limpiar AH
                and     al,al           ;Pasar de los ceros a la izquierda
                jz      skipzero_cod 
                div     dl              ;Divide por 10
                add     ah,48           ;Nmero a carcter
                mov     [ebx],ah        ;Poner carcter
skipzero_cod    dec     ebx             ;Apuntar al siguiente
                loop    num_cod
                mov     edx,ebx
                mov     ah,9
                int     33              ;Poner porcentaje
                popad
nocheckin_cod   mov     cl,08h          ;contador de 8 bits
                ;Lectura con buffer
                pushad
                xchg    [ebx+4],esi     ;esi<->pointer
                mov     ecx,[ebx+24]    ;bufferlimit
                cmp     esi,ecx         ;pointer==bufferlimit?
                jnz     readbyte        ;no->coger de la memoria
                sub     ecx,[ebx+36]    ;Si - leer un bloque
                push    ecx             ;bufferlimit-bufferzone=32K , guarda
                mov     esi,[ebx+40]    ;bufferstart
                mov     edi,esi         ;bufferstart
                add     esi,ecx         ;bufferstart+bufferlimit-bufferzone
                mov     ecx,[ebx+36]    ;bufferzone
                sub     ecx,edi         ;bufferstart-bufferzone =
                                        ; = nmero de bytes por mover = 256K
                shr     ecx,2           ;ecx est alineado
                rep     movsd           ;mover memoria (dwords)
                mov     ah,3Fh
                mov     bx,[handlein]   ;handle
                pop     ecx             ;Restaurar ecx
                mov     edx,edi         ;Leer en bufferstart
                mov     esi,edx         ;bufferstart, para coger el siguiente
                int     33              ;Leer bloque
                jc      near Read_ERR   ;Error de lectura
                add     edx,eax         ;Nuevo bufferlimit =
                mov     [fpu+24],edx    ; = bufferstart + bytes leidos
                and     ax,ax           ;Si se leyeron 0 bytes
                je      near e_end      ;Fin de archivo -> salir
                ;Fin de lectura con buffer
readbyte        lodsb                   ;Coger byte de la memoria
                inc     dword [fpu-4]   ;Bytes++
lastone         mov     [bufferchar],al ;Poner byte en variable
                xchg    [fpu+4],esi     ;pointer<->esi
                popad                   ;Restaurar registros
                mov     dl,[bufferchar] ;Coger el byte leido en dl
e_for_cod       cmp     dword[esi],8388608
                jnc     normal_cod1
                mov     dword[esi],8388608
normal_cod1     cmp     dword[esi+4],8388608
                jnc     normal_cod2
                mov     dword[esi+4],8388608
normal_cod2     fld     dword[esi+4]    ;st0=p.c1
                fld     dword[esi]      ;st0=p.c0, st1=p.c1
                fadd    st1,st0         ;st0=p.c0, st1=p.c0+p.c1
                mov     eax,[ebx+12]    ;max
                sub     eax,[ebx+16]    ;max-min
                dec     eax             ;max-min-1
                mov     [ebx],eax    ;[ebx]=mid=max-min-1
                fild    dword[ebx]   ;st0=(max-min-1),st1=p.c0,st2=p.c0+p.c1
                fmulp   st1          ;st0=(max-min-1)*(p.c0),st1=p.c0+p.c1
                fdivrp  st1          ;st0=(max-min-1)*(p.c0)/(p.c0+p.c1)
                fistp   dword[ebx]   ;[ebx]=mid=(max-min-1)*(p.c0)/(p.c0+p.c1)
                ;Ajustar valores al alcanzar lmites
                mov     eax,[ebx]       ;mid
                or      eax,eax         ;Es cero?
                jnz     e_if1_cod
                inc     eax             ;Si -> incrementa
e_if1_cod       add     eax,[ebx+16]    ;mid+=min
                inc     eax             ;mid++
                cmp     eax,[ebx+12]    ;Ha alcanzado el mximo?
                jne     e_if2_cod
                dec     eax             ;Si -> decrementa
e_if2_cod       dec     eax             ;mid--
                ;Conseguir nuevo bit
                mov     dh,dl
                dec     ecx
                shr     dh,cl
                inc     ecx
                and     dh,01h          ;bit=(c<<i)&80h
                je      e_if3
                mov     [ebx+16],eax    ;si bit=1 -> min=mid
                jmp     e_el3
e_if3           mov     [ebx+12],eax    ;si bit=0 -> max=mid
e_el3           ;Actualizar rbol
up_cod          push    ecx             ;Guardar ecx
                mov     ecx,esi
                or      dh,dh
                jz      up1_cod
                add     ecx,4           ;ecx=&(p->count[b])
up1_cod         mov     esi,[ecx+8]     ;esi=(p->next[b])
                ;Ver si hace falta duplicar
                mov     eax,40000000h   ;Threshold=bigthresh
                cmp     dword [ecx],eax ;si (p->count[b] < threshold)
                jl      up2_cod         ; no duplicar
                cmp     dword[esi],8388608
                jnc     normal_cod3
                mov     dword[esi],8388608
normal_cod3     cmp     dword[esi+4],8388608
                jnc     normal_cod4
                mov     dword[esi+4],8388608
normal_cod4     fld     dword [esi]     ;st0=p->next[b]->count[0]
                                        ;nx->c0
                fadd    dword [esi+4]   ;st0+=p->next[b]->count[1]
                                        ;+nx->c1
                fsub    dword [ecx]     ;st0-=p->count[b]
                                        ;-p->cx
                fstp    dword [ebx]     ;[ebx]=(p->next[b]->count[0])+(p->next[b]->count[1])-(p->count[b])
                cmp     [ebx],eax       ;si [ebx] < bigthresh
                jl      up2_cod         ; no duplicar
                ;Duplicacin
                cmp     dword[esi],8388608
                jnc     normal_cod5
                mov     dword[esi],8388608
normal_cod5     cmp     dword[esi+4],8388608
                jnc     normal_cod6
                mov     dword[esi+4],8388608
normal_cod6     fld     dword [esi]     ;st0=nx->c0
                fadd    dword [esi+4]   ;st0=nx->c0+nx->c1
                fdivr   dword [ecx]     ;st0=r=(p->cx)/(nx->c0+nx->c1)
                fld     st0             ;st1=st0=r
                xor     eax,eax
dup_cod         fmul    dword [esi]     ;p->next[b]->count[0]
                fst     dword [edi]     ;(new->c0)=r*(nx->c0)
                cmp     dword[edi],8388608
                jnc     normal_cod
                mov     dword[edi],8388608
normal_cod      fsubr   dword [esi]
                fstp    dword [esi]     ;(nx->c0)-=r*(nx->c0)
                cmpsd                   ;point to c1
                dec     eax
                jp      dup_cod         ;hacer lo mismo con c1
                movsd                   ;copiar n0 y apuntar a n1
                movsd                   ;copiar n1 y apuntar a new++
                mov     [ecx+8],edi     ;(p->next[b])=new++
                sub     [ecx+8],dword 16;(p->next[b])=new
                ;Actualizar nodo actual
up2_cod         fld1
                fadd    dword [ecx]
                fstp    dword [ecx]     ;(p->count[b])++
                mov     esi,[ecx+8]     ;p = p->next[b];
                pop     ecx             ;Restaurar ecx
                ;Procesar con el siguiente carcter
                mov     eax,[ebx+12]    ;max
                sub     eax,[ebx+16]    ;max-min
                cmp     eax,00000100h   ;si max-min>=256
                jge     e_nxt_cod       ;saltate esto
                or      dh,dh
                jz      e_if4_cod
                dec     dword [ebx+12]  ;if(bit)max--
e_if4_cod       mov     eax,[ebx+16]    ;min
                shr     eax,16          ;los 8 bits superiores
                call    writebyte       ;escribirlos
                inc     dword[ebx-8]    ;compresbytes++
                shl     dword[ebx+16],16
                shr     dword[ebx+16],8 ;min = (min << 8) & 0xffff00;
                shl     dword[ebx+12],16
                shr     dword[ebx+12],8 ;max = ((max << 8) & 0xffff00 )
                mov     eax,[ebx+12]
                cmp     eax,[ebx+16]    ;si (min >= max)
                jg      e_nxt_cod
                mov     dword[ebx+12],01000000h ;max = 0x1000000;
e_nxt_cod       dec     ecx             ;siguiente bit
                jnz     near e_for_cod  ;bucle for
                jmp     e_do_cod        ;sigue comprimiendo
e_end           xor     eax,eax         ;Actar como si se hubiese leido un
                                        ; ltimo carcter 0...
                dec     byte[flag]      ;...si la bandera est puesta
                jz      near lastone    
                popad                   ;si no, continuar con el final
                mov     eax,[ebx+12]    ;min
                dec     eax             ;min-1
                push    eax             ;guardar en la pila
                shr     eax,16          ;los primeros 8 bits (23-16)
                call    writebyte       ;escribirlos
                pop     eax             ;recuperar eax=min-1
                push    eax             ;Volverlo a guardar
                shr     eax,8           ;los 8 bits de enmedio (15-8)
                call    writebyte       ;escribirlos
                pop     eax             ;recuperar eax=min-1
                call    writebyte       ;escribir los ltimos 8 (7-0)
                ;Vaciar buffer de escritura
                xchg    ecx,[ebx+8]     ;pointer2
                mov     edx,[ebx+32]    ;buffer2
                sub     ecx,edx         ;bytes que quedan por escribir
                mov     ah,40h
                push    ebx             ;guardar ebx
                mov     bx,[handleout]  ;handle
                int     33              ;escribir ltimo bloque
                pop     ebx
                jc      near Write_ERR  ;Error de escritura
                cmp     eax,ecx
                jc      near DiskFull   ;Si no se han escrito ecx bytes, el
                                        ; disco est lleno
                mov     edx,compok
exitgood        pushad
                mov     bx,[handlein]
                mov     ax,5700h        ;Conseguir fecha y hora
                int     33              ; del archivo de entrada
                mov     ah,3eh
                int     33              ;Y cerrarlo
                mov     bx,[handleout]
                mov     ax,5701h        ;Fijar fecha y hora
                int     33              ; en el archivo de salida
                mov     ah,3eh
                int     33              ;Cerrar temporal antes de renombrarlo
                push    ds              ;Borrar el archivo de salida si
                xor     edx,edx         ; exista previamente
                mov     ax,[segmentlow]
                mov     ds,ax           ;Fijar segmento de memoria baja
                xor     esi,esi         ;esi -> nombre del archivo de salida
                mov     ax,7141h        ;Borrar, nueva funcin
                and     ah,[es:enableLFN]
                jz      NOLFN_2         ;Bajo DOS ni lo intentes
                stc                     ;Carry para versiones previas de DOS
                int     33              ;Borrar nombre largo
                jnc     donelfn2
NOLFN_2         mov     ah,41h          ;Borrar nombre corto
                int     33              ;(Si existe. El error se ignora)
donelfn2        push    es
                push    ds
                mov     dx,[es:lowmem_tmp] ;direccin baja de "RDMCTMP.$$$"
                xor     edi,edi         ;edi -> nombre del archivo de salida
                mov     ax,7156h        ;Renombrar con nombres largos
                and     ah,[es:enableLFN]
                pop     es              ;es tambin apunta a la memoria baja
                jz      NOLFN_3         ;Don't try LFN under DOS
                stc                     ;Carry para versiones previas de DOS
                int     33
                jnc     donerename
NOLFN_3         mov     ah,56h          ;Funcin antigua de renombrar
                int     33
                jc      near Err_outfile
donerename      pop     ds              ;Restaurar registros
                pop     es
                popad

                mov     ah,9
                int     33              ;Poner mensaje ok
                mov     edx,uncompsize
                int     33              ;Poner "Tamao original:"
                pushad
                mov     eax,[ebx-4]     ;Nmero de bytes descomprimidos
                call    putnumber       ;Ponerlo
                popad
                mov     edx,compsize    ;Poner "Tamao comprimido:"
                int     33
                pushad
                mov     eax,[ebx-12]    ;Tamao comprimido
                call    putnumber       ;Ponerlo
                popad
                ;Mostrar razones
                mov     eax,[ebx-12]    ;Tamao comprimido
                mov     ebx,10000       ;4 dgitos significativos
                imul    ebx
                mov     ebx,[fpu-4]     ;Tamao sin comprimir
                and     ebx,ebx         
                jz      nodiv_rat       ;Evitar divisin por cero
                div     ebx             ;eax=ratio*10000
                mov     ebp,ratio+14    ;Lugar donde poner los nmeros
                mov     ebx,10          ;Divisor
                mov     cl,5            ;5 cifras
num_rat         xor     edx,edx         ;Limpiar EDX
                and     eax,eax         ;Quitar ceros a la izquierda
                jz      skipzero_rat
                div     ebx             ;Divide por 10
                add     dl,48           ;Nmero a carcter
                mov     [ebp],dl        ;Poner caracter
skipzero_rat    dec     ebp             ;Apuntar al siguiente
                cmp     cl,4
                jnz     nopoint_rat     ;Pasar punto decimal
                dec     ebp
nopoint_rat     loop    num_rat

                mov     eax,[fpu-12]    ;Tamao comprimido
                mov     ebx,80000       ;Ahora bpb (bits por byte)
                imul    ebx
                mov     ebx,[fpu-4]     ;Tamao sin comprimir
                div     ebx             ;ratio
                mov     ebp,ratio+23    ;Lugar donde poner nmeros
                mov     ebx,10
                mov     cl,6            ;mostrar 6 dgitos
num_rat2        xor     edx,edx         ;Borrar EDX
                and     eax,eax         ;Saltar ceros a la izquierda
                jz      skipzero_rat2
                div     ebx             ;Dividir por 10
                add     dl,48           ;De numero a caracter
                mov     [ebp],dl        ;Fijar caracter
skipzero_rat2   dec     ebp             ;Apuntar al siguiente
                cmp     cl,3
                jnz     nopoint_rat2    ;Saltar punto decimal
                dec     ebp
nopoint_rat2    loop    num_rat2
nodiv_rat       mov     edx,ratio
exit2           mov     ah,9
                int     33              ;Mensaje final
                mov     ah,1
                mov     cx,0506h
                int     10h             ;Restaurar cursor
                mov     ax,4C00h        ;Salida sin error
                int     33
exit3           pop     ds
                pop     esi
exit            mov     ah,9
                int     33              ;Mensaje de error
                mov     ah,1
                mov     cx,0506h
                int     10h             ;Restaurar cursor
                mov     ax,4C01h        ;Salida con error
                int     33
nomemory        call    deleteoutfile   ;Borrar archivo de salida
                mov     edx,nomemmess
                jmp     exit            ;Salir con error
Err_ARG         mov     edx,syntax      ;Mensaje de sintaxis
                jmp     exit2
Err_infile      mov     edx,infilemess
                jmp     exit3
Err_outfile     pop     es
                pop     ds
                popad
                call    deleteoutfile
Err_outfile2    mov     edx,outfilemess
                jmp     exit
Err_MEMlow      mov     edx,memlowmess
                jmp     exit3
Endit2          call    deleteoutfile   ;Borrar archivo de salida
                mov     edx,badinfile
                jmp     exit
Write_ERR       mov     edx,errwrite
                jmp     exit
Read_ERR        mov     edx,errread
                jmp     exit
DiskFull        call    deleteoutfile   ;Borrar archivo de salida
                mov     edx,errdiskfull
                jmp     exit
deleteoutfile   mov     bx,[handleout]
                mov     ah,3eh
                int     33              ;Cerrar archivo antes de borrar
                mov     edx,[tmpname]   ;Nombre del archivo temporal
                mov     ah,41h
                int     33              ;Borrar
                ret

writebyte       pushad
                inc     dword[ebx-12]   ;Incrementar tamao comprimido
                xchg    [ebx+8],edi     ;edi<->pointer2
                mov     ecx,[ebx+28]    ;Bufferlimit2
                cmp     edi,ecx         ;si pointer2 != bufferlimit2
                jnz     writebyte2      ; tan solo almacenar en memoria
                pushad
                mov     ah,40h
                mov     edx,[ebx+32]    ;buffer2
                mov     bx,[handleout]  ;handle
                sub     ecx,edx         ;bufferlimit2-buffer2=32K
                int     33              ;Escribir
                jc      Write_ERR       ;Error de escritura
                cmp     eax,ecx
                jc      near DiskFull   ;Si no se han escrito ecx bytes, el
                                        ; disco est lleno
                popad
                mov     edi,[ebx+32]    ;Recomenzar en buffer2
writebyte2      stosb                   ;Guardar byte
                xchg    [ebx+8],edi     ;edi<->pointer2
                popad
                ret

loadbyte        pushad
                xchg    [ebx+8],esi     ;esi<->pointer2
                inc     dword[ebx-12]   ;Incrementar compresbytes
                cmp     esi,[ebx+28]    ;si pointer2 != bufferlimit2
                jnz     readbyte2       ; solo se toma
                pushad
                mov     ah,3Fh
                mov     ecx,[ebx+28]    ;bufferlimit2
                mov     edx,[ebx+32]    ;buffer2
                sub     ecx,edx         ;bufferlimit2-buffer2
                mov     bx,[handlein]
                int     33              ;Leer bloque
                jc      near Read_ERR   ;Error de lectura
                add     edx,eax
                mov     [fpu+28],edx    ;siguiente bufferlimit2 =
                                        ;  buffer2 + bytes leidos
                dec     ax              ;Se han leido bytes?
                popad
                mov     esi,[ebx+32]    ;Recomenzar esi en buffer2
                js      near Endit2     ;No se han leido: Archivo erroneo
readbyte2       lodsb                   ;Tomar byte
                mov     [bufferchar],al ;Guardarlo en la variable
                xchg    [ebx+8],esi     ;esi<->pointer2
                popad
                mov     eax,[ebx+20]    ;val
                shl     eax,16
                shr     eax,8           ;val=(val<<8) & 00FFFF00
                mov     al,[bufferchar]
                mov     [ebx+20],eax    ;val+=getchar()
                ret

loadfakebyte    pushad
                mov     esi,[ebx+28]
                cmp     esi,[ebx+8]     ;si pointer2 != bufferlimit2, no se
                jnz     returning       ; necesita leer archivo -> ret con S=0
                mov     ah,3Fh
                mov     bx,[handlein]
                mov     ecx,1           ;Leer solo un byte
                mov     edx,[bufferchar]
                int     33              ;Leer byte
                jc      near Read_ERR   ;Error de lectura
                dec     ax              ;Si s=1, no hay mas bytes para leer
                js      returning
                mov     ax,4201h
                mov     cx,0ffffh
                xor     edx,edx
                dec     edx
                mov     bx,[handlein]
                int     33              ;Mover el puntero de archivo 1 byte
                                        ;hacia atrs
returning       popad
                ret

                ;Iniciar rbol
init            mov     edi,ebp         ;comienzo de la memoria alojada
                xor     eax,eax
                xor     ecx,ecx
                add     edi,0400000h-260;4 megas, salvar espacio para detectar
                                        ; el lmite dos veces (cada vez pueden
                                        ; duplicarse hasta 8 nodos).
                mov     [ebx+44],edi    ;Fijar lmite
                ;Iniciar nodos[j][i]
                mov     esi,3EA7EF9Eh   ;0.328
                mov     edi,ebp         ;edi=&nodes[0][0] = comienzo de la
                                        ;      memoria alojada
                cdq                     ;EDX=EAX=0
                ;for (j=0;j<256)
                  ;Iniciar i=0..126
flush           mov     eax,edi         ;&nodes[j][0]
                mov     cl,7Fh          ;for (i=0;i<127)
fl1             xchg    eax,esi
                stosd                   ;c0=0.328
                stosd                   ;c1=0.328
                xchg    eax,esi
                add     eax,16
                stosd                   ;n0=&nodes[j][2i+1]
                add     eax,16
                stosd                   ;n1=&nodes[j][2i+2]
                loop    fl1
                  ;Iniciar i=127..255
                mov     eax,ebp         ;&nodes[0][0]
                mov     cl,80h          ;for (i=127;i<255)
fl2             xchg    eax,esi
                stosd                   ;c0=0.328
                stosd                   ;c1=0.328
                xchg    eax,esi
                stosd                   ;n0=&nodes[2*(i-127)][0]
                add     eax,4096
                stosd                   ;n1=&nodes[2*(i-127)+1][0]
                add     eax,4096
                loop    fl2
                ;Bucle de inicio
                add     edi,16          ;j++
                dec     dl
                jnz     flush
                mov     esi,ebp
                ret

init2           call    init            ;Iniciar rbol
                sub     [ebx+4],dword 60000     ;Bytes que se usan hacia atrs
                mov     [ebx+48],dword 60000    ;Contador
                mov     [ebx+16],ecx
                mov     dword [ebx+12],01000000h
                ;fake coder > es exactamente igual al coder, pero sin salida
                ; por lo que no creo que necesite ser comentado de nuevo
e_do_fake_cod   mov     cl,08h
                pushad
                xchg    [ebx+4],esi
                lodsb
                mov     [bufferchar],al
                xchg    [ebx+4],esi
                popad
                mov     dl,[bufferchar] ;c=getchar
e_for_fake_cod  cmp     dword[esi],8388608
                jnc     normal_fak1
                mov     dword[esi],8388608
normal_fak1     cmp     dword[esi+4],8388608
                jnc     normal_fak2
                mov     dword[esi+4],8388608
normal_fak2     fld     dword[esi+4]
                fld     dword[esi]
                fadd    st1,st0
                mov     eax,[ebx+12]
                sub     eax,[ebx+16]
                dec     eax
                mov     [ebx],eax
                fild    dword[ebx]      ;mid=(max-min-1)
                fmulp   st1             ;*(p.c0)
                fdivrp  st1             ;/(p.c0+p.c1)
                fistp   dword[ebx]

                mov     eax,[ebx]
                or      eax,eax
                jnz     e_if1_fak
                inc     eax             ;mid++
e_if1_fak       add     eax,[ebx+16]    ;mid+=min

                inc     eax
                cmp     eax,[ebx+12]
                jne     e_if2_fak
                dec     eax             ;mid--
e_if2_fak       dec     eax

                mov     dh,dl
                dec     ecx
                shr     dh,cl
                inc     ecx
                and     dh,01h          ;bit=(c<<i)&80h

                je      e_if3_fake
                mov     [ebx+16],eax    ;min=mid
                jmp     e_el3_fake
e_if3_fake      mov     [ebx+12],eax    ;max=mid
e_el3_fake

up_fak          push    ecx
                mov     ecx,esi
                or      dh,dh
                jz      up1_fak
                add     ecx,4           ;ecx=&(p->count[b])
up1_fak         mov     esi,[ecx+8]     ;esi=(p->next[b])

;Test if duplication needed
                mov     eax,40000000h
                cmp     dword [ecx],eax
                jl      up2_fak
                cmp     dword[esi],8388608
                jnc     normal_fak3
                mov     dword[esi],8388608
normal_fak3
                cmp     dword[esi+4],8388608
                jnc     normal_fak4
                mov     dword[esi+4],8388608
normal_fak4
                fld     dword [esi]     ;nx->c0
                fadd    dword [esi+4]   ;+nx->c1
                fsub    dword [ecx]     ;-p->cx
                fstp    dword [ebx]
                cmp     [ebx],eax
                jl      up2_fak
;Duplication
                cmp     dword[esi],8388608
                jnc     normal_fak5
                mov     dword[esi],8388608
normal_fak5
                cmp     dword[esi+4],8388608
                jnc     normal_fak6
                mov     dword[esi+4],8388608
normal_fak6
                fld     dword [esi]
                fadd    dword [esi+4]
                fdivr   dword [ecx]     ;r=(p->cx)/(nx->c0+nx->c1)
                fld     st0
                xor     eax,eax
dup_fak         fmul    dword [esi]
                fst     dword [edi]     ;(new->c0)=r*(nx->c0)
                cmp     dword[edi],8388608
                jnc     normal_fak
                mov     dword[edi],8388608
normal_fak

                fsubr   dword [esi]
                fstp    dword [esi]     ;(nx->c0)-=r*(nx->c0)
                cmpsd                   ;apuntar a c1
                dec     eax

                jp      dup_fak         ;hacer lo mismo con c1
                movsd                   ;copiar n0 y apuntar a n1
                movsd                   ;copiar n1 y apuntar a new++
                mov     [ecx+8],edi     ;(p->next[b])=new++
                sub     [ecx+8],dword 16;(p->next[b])=new

;Update current node
up2_fak         fld1
                fadd    dword [ecx]
                fstp    dword [ecx]     ;(p->count[b])++
                mov     esi,[ecx+8]
                pop     ecx

;Process with next input char
                mov     eax,[ebx+12]
                sub     eax,[ebx+16]
                cmp     eax,00000100h   ;max-min<256
                jge     e_nxt_fake_cod
                or      dh,dh
                jz      e_if4_fak
                dec     dword [ebx+12]  ;max--
e_if4_fak       mov     eax,[ebx+16]
                shr     eax,16
common41        shl     dword[ebx+16],16
                shr     dword[ebx+16],8
                shl     dword[ebx+12],16
                shr     dword[ebx+12],8
                mov     eax,[ebx+12]
                cmp     eax,[ebx+16]
                jg      e_nxt_fake_cod
                mov     dword[ebx+12],01000000h
e_nxt_fake_cod  dec     ecx
                jnz     near e_for_fake_cod
                dec     dword[ebx+48]
                jnz     near e_do_fake_cod
                ret

putnumber       mov     ecx,10
ax2dec          push    edx
                xor     edx,edx
                div     ecx             ;Siguiente cifra en DL
                and     eax,eax         ;Si el resultado es 0
                jz      decdone         ;Acabar
                call    ax2dec          ;Si no, continuar con el siguiente
decdone         or      dl,30h          ;Cifra a carcter
                mov     ah,2
                int     21h             ;Poner carcter
                pop     edx             ;Siguiente cifra o antiguo valor
                ret

initmessage     db      "RDMC v0.06b - un packer",13,10,10
                db      "Basado en el algoritmo DMC creado por Gordon V. Cormack y Nigel S. Horspool",13,10
                db      "Cdigo cogido del programa ganador de st0ne en la Hugi Size Compo 7",13,10,10
                db      "Copyright (c) 2000-01 Jaime Tejedor Gmez/Metalbrain  (metalbrain_coder@gmx.net)",13,10
                db      "$"
messagepercent  db      13,"  0% hecho$"
syntax          db      13,10,"Sintaxis: RDMC [c|d] entrada salida",13,10,10
                db      "(c para comprimir, d para descomprimir)",13,10
                db      "$"
infilemess      db      "Archivo de entrada invlido",13,10
                db      "$"
outfilemess     db      13,10,"Archivo de salida invlido",13,10
                db      "$"
nomemmess       db      "No hay suficiente memoria",13,10
                db      "$"
memlowmess      db      "No hay memoria baja",13,10
                db      "$"
decok           db      13,"100",13,10,"Descompresin OK"
                db      "$"
compok          db      13,"100",13,10,"Compresin OK"
                db      "$"
badinfile       db      13,10,"Archivo de entrada incorrecto"
                db      "$"
errread         db      13,10,"Error de lectura!"
                db      "$"
errwrite        db      13,10,"Error de escritura!"
                db      "$"
errdiskfull     db      13,10,"El disco est lleno, no se puede escribir"
                db      "$"
uncompsize      db      13,10,10,"Tamao original:   "
                db      "$"
compsize        db      13,10,"Tamao comprimido: "
                db      "$"
ratio           db      13,10,"Razn:   0.00%, 0.0000 bpb"
                db      "$"
unittmpfile     db      "C:"
tmpfile         db      "RDMCTMP.$$$",0
tmpname         dd      tmpfile
flag            db      1
                ALIGN   4
                dd      0
                dd      0
                dd      0
fpu             dd      000000FDh
                section .bss
                resb    64
lowmem_tmp      resw    2
total           resw    2
command         resw    1
handlein        resw    1
handleout       resw    1
segmentlow      resw    1
bufferchar      resb    1
enableLFN       resb    1

;ebx-12  > compresbytes
;ebx-8   > partialbytes
;ebx-4   > bytes
;ebx     > fpu
;ebx+4   > pointer
;ebx+8   > pointer2
;ebx+12  > min
;ebx+16  > max
;ebx+20  > val
;ebx+24  > bufferlimit
;ebx+28  > bufferlimit2
;ebx+32  > buffer2
;ebx+36  > bufferzone
;ebx+40  > bufferstart
;ebx+44  > limit
;ebx+48  > fakeleft

;ESQUEMA DE BUFFERS EN MEMORIA
;                                bufferzone
;bufferstart                     |       bufferlimit
;|                               |       |
;0K------------------------------256K----288K----384K
;                                        |       |
;                                        |       bufferlimit2
;                                        buffer2
