; RDMC - Reiterative DMC packer by Metalbrain
;
; Copyright (c) 2000-01 Jaime Tejedor Gmez / Metalbrain.
; All rights reserved.
;
; Version 0.06b - BETA: USE SOURCE CODE AT YOUR OWN RISK
;
; Original DMC core by Pierre Almeras (St0ne)
; Based on DMC algorithm created by Gordon V. Cormack and Nigel S. Horspool
;
; To compile you'll need NASM and WDOSX extender. To have complete long
;filenames support, you must recompile WDOSX replacing the included file
;RDOFF.ASM
;
; Last step is compression of resulting executable, but it's optional
;(anyway, we don't even save 300 bytes), to do it you'll need the
;executables packer 32LiTE (UPX doesn't support WDOSX).
;
; nasm -f rdf -o -O1 RDMC.EXE RDMC006B.NAS
; stubit RDMC.EXE
; del rdmc.bak
; 32lite -best RDMC.EXE
;
; Newer versions of NASM allows jump optimization using -O1, that will
;produce a slightly smaller executable, but 0.98 still works fine

BITS 32

_WdosxStart
                pushad
                mov     ax,1684h        ;Function
                mov     bx,1            ;VM manager ID
                xor     di,di           ; di - RM offset of API entry point
                mov     es,di           ; es - RM segment of API entry point
                int     2fh             ;Test
                mov     ax,es
                or      di,ax
                setz    al              ;DOS: AL=1, Windows: AL=0
                dec     eax             ;DOS: AL=0, Windows: AL=255
                mov     [enableLFN],al  ;Disable long filenames under DOS
                popad
                mov     ah,1
                mov     cx,2000h
                int     10h             ;Disable cursor
                mov     edx,initmessage
                mov     ah,9
                int     33              ;Print initial message
                cmp     esi,4           ;Four arguments?
                jnz     near Err_ARG    ;No: syntax error
                xchg    esi,edi         ;Set esi=argv
                lodsd                   ;Skip execpath
                lodsd                   ;Take command address in eax
                xchg    eax,ebx
                mov     ax,[ebx]        ;Get command
                cmp     ax,'c'
                jz      near okcommand
                cmp     ax,'d'
                jnz     near Err_ARG    ;Neither 'c' or 'd' -> syntax error
okcommand       mov     [command],al    ;Store command
                lodsd                   ;Take infile name position
                push    esi             ;Store argv
                push    ds              ;Store segment
                xor     edi,edi         ;edi=0
                mov     esi,eax         ;esi=infile position
                mov     ah,48h
                mov     bx,17           ;16*17=272 bytes
                int     33              ;Get low memory
                jc      near Err_MEMlow ;No low memory -> error
                mov     es,ax           ;es-> taken memory
                mov     [segmentlow],ax ;Store it
nametodata16    lodsb                   ;Take byte from commandline
                stosb                   ;Store it in low memory
                cmp     al,0            
                jnz     nametodata16    ;Do till a zero is found
                xor     esi,esi         ;File name at ds:si
                xor     bx,bx           ;Read-only
                xor     cx,cx           ;No flags
                mov     dx,1            ;Open
                xor     di,di           ;No alias hint
                mov     ax,716Ch        ;LFN: Open/create file function
                and     ah,[enableLFN]
                push    es
                pop     ds              ;Set ds=es ->low memory
                jz      NOLFN_1         ;Don't try LFN under DOS
                stc                     ;If not available, keep carry
                int     33              ;Try to open LFN
                jnc     infileok        ;ok -> continue
NOLFN_1         mov     ax,3d00h        ;Old-style open file function
                mov     edx,esi         ;File name at ds:dx
                int     33              ;Open old style
                jc      near Err_infile ;Still can't -> bad infile name
infileok        pop     ds              ;Restore 32 bit data segment
                pop     esi             ;Restore argv
                mov     [handlein],ax   ;Store infile handle
                lodsd                   ;Take outfile name position
                xor     edi,edi         ;Clear edi again
                xchg    esi,eax         ;esi->outfile name
                mov     ebp,[esi]       ;Take beginning of outfile name
nametodata16_2  lodsb
                stosb
                cmp     al,0
                jnz     nametodata16_2  ;Copy to low memory as infile
                xchg    eax,ebp
                cmp     ah,':'          ;Is there a unit in outfile name?
                jnz     nounit          ;No->skip next
                mov     [unittmpfile],al;Set temporal outfile unit
                sub     dword [tmpname],2;Add unit to temporal outfile
nounit          mov     [lowmem_tmp],edi
                mov     edx,[tmpname]   ;Get temporal outfile name
                mov     esi,edx
                mov     ecx,15          ;"D:RDMCTMP.$$$",0 lenght
                rep     movsb           ;Copy it to low memory too
                mov     ah,3ch
                xor     ecx,ecx         ;No attributes
                int     33              ;Create temporal outfile (short name)
                jc      near Err_outfile2
                mov     [handleout],ax  ;Store outfile handle
                mov     ax,0501h        ;Allocate memory function
                mov     bx,0045h        ;Lets say 4M+320K
                int     31h             ;Go for it
                jc      near nomemory   ;No memory error
                push    bx
                push    cx
                pop     ebp             ;Allocated memory block starts at ebp
                ;Take lenght, store it in total
                pushad                  
                xor     ecx,ecx
                xor     edx,edx
                mov     ax,4202h
                mov     bx,[handlein]
                pushad
                int     33              ;Move file pointer to end, lenght in
                mov     [total],ax      ;dx:ax
                mov     [total+2],dx    ;Store lenght
                popad                   
                dec     eax
                dec     eax
                int     33              ;Move to beginning
                popad
                mov     ebx,fpu         ;ebx pointed variables
                mov     [ebx+40],ebp    ;bufferstart
                add     ebp,256*1024    ;+256K  History zone
                mov     [ebx+36],ebp    ;bufferzone
                add     ebp,32768       ;+32K   Uncompressed data buffer
                mov     [ebx+32],ebp    ;buffer2
                mov     [ebx+24],ebp    ;bufferlimit
                add     ebp,32768       ;+32K   Compressed data buffer
                mov     [ebx+28],ebp    ;bufferlimit2
                push    ds
                pop     es

                fninit                  ;Init copro
                fldcw   [ebx]           ;'float' precision, round even
                call    init            ;Init tree
                mov     [ebx+16],ecx    ;Set min = 0
                mov     dword [ebx+12],01000000h ;Set max value
                cmp     byte[command],'c' ;If command was c
                jz      near Encoder    ;Go to encode file
                ;DECODER                ;Else we'll decode
                push    eax
                mov     eax,[ebx+36]
                mov     [ebx+4],eax     ;Pointer = Bufferzone
                mov     eax,[ebx+28]
                mov     [ebx+8],eax     ;Pointer2 = Bufferstart
                pop     eax
e_reinit        xor     ecx,ecx
                add     dword[ebx+44],128 ;Last zero extra space
e_val           call    loadbyte        ;Get a byte
                inc     ecx
                jnp     e_val           ;Do it 2 more times
                mov     dl,0
e_do_dec        test    dword[ebx-4],255;Test every 256 bytes
                jnz     nocheckin_dec   ;No test
                cmp     dword[ebx-8],256;Was compression failing?
                jna     nocheckin2_dec  ;No fail
                push    ecx             ;Yes
                call    init            ;Reinit model
                add     dword[ebx+44],128;Last zero extra space
                pop     ecx
nocheckin2_dec  ;Print percent
                pushad
                mov     eax,[ebx-12]    ;Number of processed bytes
                mov     ebx,100
                imul    ebx             ;Multiply by 100
                mov     ebx,[total]
                and     ebx,ebx         ;If file is void, don't divide
                jz      nodiv_dec
                div     ebx
nodiv_dec       mov     ebx,messagepercent+3 ;Place to put numbers
                mov     dl,10           ;Divisor
                mov     cl,3            ;Number of ciphers
num_dec         cbw                     ;Clear AH
                and     al,al           ;Skip leading zeros
                jz      skipzero_dec
                div     dl              ;Divide by 10
                add     ah,48           ;Number to char
                mov     [ebx],ah        ;Set char
skipzero_dec    dec     ebx             ;Point to next
                loop    num_dec         ;Repeat for three ciphers
                mov     edx,ebx
                mov     ah,9
                int     33              ;Print percent
                popad
                mov     [ebx-8],dword 0 ;Clear partialbytes
nocheckin_dec   mov     cl,08h          ;8 bits per byte
                cmp     edi,[ebx+44]    ;If edi cross the limit
                jnc     near Endit2     ;It was a bad infile
e_for_dec       cmp     dword[esi],8388608  ;Avoid denormals, that may cause
                jnc     normal_dec1         ; nasty FPU exceptions. This will
                mov     dword[esi],8388608  ; be repeated at many places in
                                            ; the code
normal_dec1     cmp     dword[esi+4],8388608
                jnc     normal_dec2
                mov     dword[esi+4],8388608
normal_dec2     fld     dword[esi+4]    ;st0=p.c1
                fld     dword[esi]      ;st0=p.c0, st1=p.c1
                fadd    st1,st0         ;st0=p.c0, st1=p.c0+p.c1
                mov     eax,[ebx+12]    ;max
                sub     eax,[ebx+16]    ;max-min
                dec     eax             ;max-min-1
                mov     [ebx],eax    ;[ebx]=mid=max-min-1
                fild    dword[ebx]   ;st0=(max-min-1),st1=p.c0,st2=p.c0+p.c1
                fmulp   st1          ;st0=(max-min-1)*(p.c0),st1=p.c0+p.c1
                fdivrp  st1          ;st0=(max-min-1)*(p.c0)/(p.c0+p.c1)
                fistp   dword[ebx]   ;[ebx]=mid=(max-min-1)*(p.c0)/(p.c0+p.c1)
                ;Adjust value when bounds reached
                mov     eax,[ebx]       ;mid
                or      eax,eax         ;Is it zero?
                jnz     e_if1_dec       ;
                inc     eax             ;Then increase
e_if1_dec       add     eax,[ebx+16]    ;mid+=min

                inc     eax             ;mid++
                cmp     eax,[ebx+12]    ;Has it reached max?
                jne     e_if2_dec
                dec     eax             ;Then decrease
e_if2_dec       dec     eax             ;mid--
                cmp     eax,[ebx+20]    ;if (val>=mid)
                jg      e_if6
                mov     [ebx+16],eax    ;min=mid
                mov     dh,1            ;bit=1
                jmp     e_el6
e_if6           mov     [ebx+12],eax    ;max=mid
                mov     dh,0            ;bit=0
                ;Set next bit
e_el6           add     dl,dl
                add     dl,dh           ;c=(c<<1)+bit
                ;Update tree
up_dec          push    ecx
                mov     ecx,esi
                or      dh,dh
                jz      up1_dec
                add     ecx,4           ;ecx=&(p->count[b])
up1_dec         mov     esi,[ecx+8]     ;esi=(p->next[b])
                ;Test if duplication needed
                mov     eax,40000000h   ;Threshold=bigthresh
                cmp     dword [ecx],eax ;if (p->count[b] < threshold)
                jl      up2_dec         ; don't duplicate
                cmp     dword[esi],8388608
                jnc     normal_dec3
                mov     dword[esi],8388608
normal_dec3     cmp     dword[esi+4],8388608
                jnc     normal_dec4
                mov     dword[esi+4],8388608
normal_dec4     fld     dword [esi]     ;st0=p->next[b]->count[0]
                                        ;nx->c0
                fadd    dword [esi+4]   ;st0+=p->next[b]->count[1]
                                        ;+nx->c1
                fsub    dword [ecx]     ;st0-=p->count[b]
                                        ;-p->cx
                fstp    dword [ebx]     ;[ebx]=(p->next[b]->count[0])+(p->next[b]->count[1])-(p->count[b])
                cmp     [ebx],eax       ;if [ebx] < bigthresh
                jl      up2_dec         ; don't duplicate
                ;Duplication
                cmp     dword[esi],8388608
                jnc     normal_dec5
                mov     dword[esi],8388608
normal_dec5     cmp     dword[esi+4],8388608
                jnc     normal_dec6
                mov     dword[esi+4],8388608
normal_dec6     fld     dword [esi]     ;st0=nx->c0
                fadd    dword [esi+4]   ;st0=nx->c0+nx->c1
                fdivr   dword [ecx]     ;st0=r=(p->cx)/(nx->c0+nx->c1)
                fld     st0             ;st1=st0=r
                xor     eax,eax
dup_dec         fmul    dword [esi]     ;*p->next[b]->count[0]
                fst     dword [edi]     ;(new->c0)=r*(nx->c0)
                cmp     dword[edi],8388608
                jnc     normal_dec
                mov     dword[edi],8388608
normal_dec      fsubr   dword [esi]
                fstp    dword [esi]     ;(nx->c0)-=r*(nx->c0)
                cmpsd                   ;point to c1
                dec     eax
                jp      dup_dec         ;do the same whith c1
                movsd                   ;copy n0 and point to n1
                movsd                   ;copy n1 and point to new++
                mov     [ecx+8],edi     ;(p->next[b])=new++
                sub     [ecx+8],dword 16;(p->next[b])=new
                ;Update current node
up2_dec         fld1
                fadd    dword [ecx]
                fstp    dword [ecx]     ;(p->count[b])++
                mov     esi,[ecx+8]     ;p = p->next[b];
                pop     ecx
                ;Process with next input char
                mov     eax,[ebx+12]    ;max
                sub     eax,[ebx+16]    ;max-min
                cmp     eax,00000100h   ;if max-min>=256
                jge     e_nxt_dec       ;skip this
                or      dh,dh
                jz      e_if4_dec
                dec     dword [ebx+12]  ;if(bit)max--
e_if4_dec       call    loadbyte        ;Get a new byte
                inc     dword[ebx-8]    ;partialbytes++
                shl     dword[ebx+16],16
                shr     dword[ebx+16],8 ;min = (min << 8) & 0xffff00
                shl     dword[ebx+12],16
                shr     dword[ebx+12],8 ;max = ((max << 8) & 0xffff00 )
                mov     eax,[ebx+12]
                cmp     eax,[ebx+16]    ;if (min >= max)
                jg      e_nxt_dec
                mov     dword[ebx+12],01000000h ;max = 0x1000000;
e_nxt_dec       dec     ecx             ;next bit
                jnz     near e_for_dec  ;for loop
                mov     al,dl           ;next byte
                ;Buffering code here
                mov     [bufferchar],al ;put char in variable
                pushad                  ;Keep registers
                xchg    [ebx+4],edi     ;edi<->pointer (uncompressed data)
                mov     ecx,[ebx+24]    ;bufferlimit
                cmp     edi,ecx         ;if pointer != bufferlimit
                jnz     writebyte3      ;just put it in memory
                mov     ah,40h
                mov     edx,[ebx+36]    ;Start to write from bufferzone
                sub     ecx,edx         ;32K = bufferlimit - bufferzone
                mov     bx,[handleout]  ;handle
                int     33              ;Write 32K chunk
                jc      near Write_ERR  ;Write error
                cmp     eax,ecx
                jc      near DiskFull   ;ecx bytes not written -> disk full
                mov     esi,[fpu+40]    ;bufferstart
                mov     edi,esi         ;bufferstart
                add     esi,ecx         ;bufferstart+32K
                mov     ecx,edx         ;bufferzone
                sub     ecx,edi         ;bufferzone-bufferstart
                shr     ecx,2           ;ecx is aligned
                rep     movsd           ;move memory (dwords)
                mov     edi,[fpu+36]    ;pointer=bufferzone
writebyte3      mov     al,[bufferchar] ;Take new byte
                stosb                   ;Keep it in buffer
                xchg    [fpu+4],edi     ;edi<->pointer
                popad                   ;Restore registers
                inc     dword [ebx-4]   ;bytes++
                ;end of buffering code
                mov     eax,[ebx+12]    ;max
                dec     eax             ;max-1
                cmp     eax,[ebx+20]    ;if val!=max-1
                jne     near e_do_dec   ;continue decoding
                ;reached partial end
                dec     dword[ebx+4]    ;Skip last zero
                dec     dword[ebx-4]    ;Skip it from bytes count too
                call    loadfakebyte    ;just see if file continues
                js      Endit           ;No: we're finished
                call    init2           ;Make a new tree using previous data
                jmp     e_reinit        ;Then continue decoding
                ;Flush write buffer
Endit           xchg    ecx,[ebx+4]     ;ecx=pointer
                mov     edx,[ebx+36]    ;bufferzone
                sub     ecx,edx         ;bytes left to be written
                mov     ah,40h
                push    ebx             ;Keep ebx
                mov     bx,[handleout]
                int     33              ;Write last chunk
                pop     ebx             ;Restore ebx
                jc      near Write_ERR  ;Write error
                cmp     eax,ecx         
                jc      near DiskFull   ;ecx bytes not written -> disk full  
                mov     edx,decok       ;Point to final message
                jmp     exitgood        ;Exit
                ;ENCODER
Encoder         push    eax
                mov     eax,[ebx+24]
                mov     [ebx+4],eax     ;pointer=bufferlimit
                mov     [ebx+8],eax     ;pointer2=bufferlimit
                pop     eax
e_do_cod        cmp     edi,[ebx+44]    ;if we haven't passed limit
                jc      noproblemo_cod  ;continue
                mov     cl,8            ;8 bits counter
                mov     dl,0            ;Fake zero
                dec     byte[flag]      ;...if flag is active
                jz      near e_for_cod  ;If not, continue with end
                ;Partial end: store max-1
                mov     byte[flag],1    ;reset flag
                push    ecx             ;keep ecx
                mov     eax,[ebx+12]    ;eax=max
                dec     eax             ;max-1
                push    eax             ;keep in stack
                shr     eax,16          ;upper 8 bits (23-16)
                call    writebyte       ;write
                pop     eax             ;restore min-1
                push    eax             ;store it again
                shr     eax,8           ;middle 8 bits (15-8)
                call    writebyte       ;write
                pop     eax             ;last 8 bits (7-0)
                call    writebyte       ;write
                call    init2           ;
                pop     ecx             ;restore ecx
noproblemo_cod  test    dword[ebx-4],255;Test every 256 bytes
                jnz     nocheckin_cod   ;No test
                cmp     dword[ebx-8],256;Is compression failing?
                jna     nocheckin2_cod  ;No fail
                push    ecx             ;Yes
                call    init            ;Reinit model
                pop     ecx
nocheckin2_cod  mov     [ebx-8],dword 0 ;Reset partialbytes
                ;Print percent done
                pushad
                mov     eax,[ebx-4]     ;Get bytes processed
                mov     ebx,100
                imul    ebx             ;Multiply by 100
                mov     ebx,[total]
                and     ebx,ebx         ;Avoid division with void files
                jz      nodiv_cod
                div     ebx             ;Divide by total
nodiv_cod       mov     ebx,messagepercent+3 ;Place to put numbers
                mov     dl,10           ;Divisor
                mov     cl,3            ;3 digits
num_cod         cbw                     ;Clear AH
                and     al,al           ;Skip leading zeros
                jz      skipzero_cod 
                div     dl              ;Divide by 10
                add     ah,48           ;Number to char
                mov     [ebx],ah        ;Set char
skipzero_cod    dec     ebx             ;Point to next
                loop    num_cod
                mov     edx,ebx
                mov     ah,9
                int     33              ;Print percent
                popad
nocheckin_cod   mov     cl,08h          ;8 bits counter
                ;Buffered read
                pushad
                xchg    [ebx+4],esi     ;esi<->pointer
                mov     ecx,[ebx+24]    ;bufferlimit
                cmp     esi,ecx         ;pointer==bufferlimit?
                jnz     readbyte        ;no->just take it from memory
                sub     ecx,[ebx+36]    ;Yes - read a chunk
                push    ecx             ;bufferlimit-bufferzone=32K, keep
                mov     esi,[ebx+40]    ;bufferstart
                mov     edi,esi         ;bufferstart
                add     esi,ecx         ;bufferstart+bufferlimit-bufferzone
                mov     ecx,[ebx+36]    ;bufferzone
                sub     ecx,edi         ;bufferstart-bufferzone=
                                        ;=number of bytes to move=256K
                shr     ecx,2           ;ecx is aligned
                rep     movsd           ;move memory (dwords)
                mov     ah,3Fh
                mov     bx,[handlein]   ;handle
                pop     ecx             ;Restore ecx
                mov     edx,edi         ;Read at bufferstart
                mov     esi,edx         ;bufferstart, to read next byte
                int     33              ;Read chunk
                jc      near Read_ERR   ;Read error
                add     edx,eax         ;New bufferlimit =
                mov     [fpu+24],edx    ; = bufferstart + read bytes
                and     ax,ax           ;If 0 bytes were read
                je      near e_end      ;EOF occured > exit
                ;end of buffering code
readbyte        lodsb                   ;Get byte from memory
                inc     dword [fpu-4]   ;Bytes++
lastone         mov     [bufferchar],al ;Put byte in variable
                xchg    [fpu+4],esi     ;pointer<->esi
                popad                   ;Restore registers
                mov     dl,[bufferchar] ;Get read byte
e_for_cod       cmp     dword[esi],8388608
                jnc     normal_cod1
                mov     dword[esi],8388608
normal_cod1     cmp     dword[esi+4],8388608
                jnc     normal_cod2
                mov     dword[esi+4],8388608
normal_cod2     fld     dword[esi+4]    ;st0=p.c1
                fld     dword[esi]      ;st0=p.c0, st1=p.c1
                fadd    st1,st0         ;st0=p.c0, st1=p.c0+p.c1
                mov     eax,[ebx+12]    ;max
                sub     eax,[ebx+16]    ;max-min
                dec     eax             ;max-min-1
                mov     [ebx],eax    ;[ebx]=mid=max-min-1
                fild    dword[ebx]   ;st0=(max-min-1),st1=p.c0,st2=p.c0+p.c1
                fmulp   st1          ;st0=(max-min-1)*(p.c0),st1=p.c0+p.c1
                fdivrp  st1          ;st0=(max-min-1)*(p.c0)/(p.c0+p.c1)
                fistp   dword[ebx]   ;[ebx]=mid=(max-min-1)*(p.c0)/(p.c0+p.c1)
                ;Adjust value when bounds reached
                mov     eax,[ebx]       ;mid
                or      eax,eax         ;Is it zero?
                jnz     e_if1_cod
                inc     eax             ;Then increase
e_if1_cod       add     eax,[ebx+16]    ;mid+=min
                inc     eax             ;mid++
                cmp     eax,[ebx+12]    ;Has it reached max?
                jne     e_if2_cod
                dec     eax             ;Then decrease
e_if2_cod       dec     eax             ;mid--
                ;Get next bit
                mov     dh,dl
                dec     ecx
                shr     dh,cl
                inc     ecx
                and     dh,01h          ;bit=(c<<i)&80h
                je      e_if3
                mov     [ebx+16],eax    ;if bit=1 -> min=mid
                jmp     e_el3
e_if3           mov     [ebx+12],eax    ;if bit=0 -> max=mid
e_el3           ;Update tree
up_cod          push    ecx             ;Keep ecx
                mov     ecx,esi
                or      dh,dh
                jz      up1_cod
                add     ecx,4           ;ecx=&(p->count[b])
up1_cod         mov     esi,[ecx+8]     ;esi=(p->next[b])
                ;Test if duplication needed
                mov     eax,40000000h   ;Threshold=bigthresh
                cmp     dword [ecx],eax ;if (p->count[b] < threshold)
                jl      up2_cod         ; don't duplicate
                cmp     dword[esi],8388608
                jnc     normal_cod3
                mov     dword[esi],8388608
normal_cod3     cmp     dword[esi+4],8388608
                jnc     normal_cod4
                mov     dword[esi+4],8388608
normal_cod4     fld     dword [esi]     ;st0=p->next[b]->count[0]
                                        ;nx->c0
                fadd    dword [esi+4]   ;st0+=p->next[b]->count[1]
                                        ;+nx->c1
                fsub    dword [ecx]     ;st0-=p->count[b]
                                        ;-p->cx
                fstp    dword [ebx]     ;[ebx]=(p->next[b]->count[0])+(p->next[b]->count[1])-(p->count[b])
                cmp     [ebx],eax       ;if [ebx] < bigthresh
                jl      up2_cod         ; don't duplicate
                ;Duplication
                cmp     dword[esi],8388608
                jnc     normal_cod5
                mov     dword[esi],8388608
normal_cod5     cmp     dword[esi+4],8388608
                jnc     normal_cod6
                mov     dword[esi+4],8388608
normal_cod6     fld     dword [esi]     ;st0=nx->c0
                fadd    dword [esi+4]   ;st0=nx->c0+nx->c1
                fdivr   dword [ecx]     ;st0=r=(p->cx)/(nx->c0+nx->c1)
                fld     st0             ;st1=st0=r
                xor     eax,eax
dup_cod         fmul    dword [esi]     ;p->next[b]->count[0]
                fst     dword [edi]     ;(new->c0)=r*(nx->c0)
                cmp     dword[edi],8388608
                jnc     normal_cod
                mov     dword[edi],8388608
normal_cod      fsubr   dword [esi]
                fstp    dword [esi]     ;(nx->c0)-=r*(nx->c0)
                cmpsd                   ;apuntar a c1
                dec     eax
                jp      dup_cod         ;do the same whith c1
                movsd                   ;copy n0 and point to n1
                movsd                   ;copy n1 and point to new++
                mov     [ecx+8],edi     ;(p->next[b])=new++
                sub     [ecx+8],dword 16;(p->next[b])=new
                ;Update current node
up2_cod         fld1
                fadd    dword [ecx]
                fstp    dword [ecx]     ;(p->count[b])++
                mov     esi,[ecx+8]     ;p = p->next[b];
                pop     ecx             ;Restore ecx
                ;Process with next input char
                mov     eax,[ebx+12]    ;max
                sub     eax,[ebx+16]    ;max-min
                cmp     eax,00000100h   ;if max-min>=256
                jge     e_nxt_cod       ;skip this
                or      dh,dh
                jz      e_if4_cod
                dec     dword [ebx+12]  ;if(bit)max--
e_if4_cod       mov     eax,[ebx+16]    ;min
                shr     eax,16          ;upmost 8 bits
                call    writebyte       ;Write'em
                inc     dword[ebx-8]    ;compresbytes++
                shl     dword[ebx+16],16
                shr     dword[ebx+16],8 ;min = (min << 8) & 0xffff00;
                shl     dword[ebx+12],16
                shr     dword[ebx+12],8 ;max = ((max << 8) & 0xffff00 )
                mov     eax,[ebx+12]
                cmp     eax,[ebx+16]    ;if (min >= max)
                jg      e_nxt_cod
                mov     dword[ebx+12],01000000h ;max = 0x1000000;
e_nxt_cod       dec     ecx             ;next bit
                jnz     near e_for_cod  ;for loop
                jmp     e_do_cod        ;keep compressiong
e_end           xor     eax,eax         ;Act as if a last char 0 was read...
                dec     byte[flag]      ;...if flag is active
                jz      near lastone
                popad                   ;If not, continue with end
                mov     eax,[ebx+12]    ;Get min
                dec     eax             ;min-1
                push    eax             ;keep in stack
                shr     eax,16          ;first 8 bits (23-16)
                call    writebyte       ;write
                pop     eax             ;restore min-1
                push    eax             ;store it again
                shr     eax,8           ;next 8 bits (15-8)
                call    writebyte       ;write
                pop     eax             ;last 8 bits (7-0)
                call    writebyte       ;write
                ;Flush write buffer
                xchg    ecx,[ebx+8]     ;pointer2
                mov     edx,[ebx+32]    ;buffer2
                sub     ecx,edx         ;bytes left to write
                mov     ah,40h          
                push    ebx             ;Keep ebx
                mov     bx,[handleout]  ;handle
                int     33              ;Write 
                pop     ebx             ;Restore ebx
                jc      near Write_ERR  ;Write error
                cmp     eax,ecx         
                jc      near DiskFull   ;ecx bytes not written -> disk full
                mov     edx,compok      ;Message pointer
exitgood        pushad
                mov     bx,[handlein]
                mov     ax,5700h
                int     33              ;Get time&date from infile
                mov     ah,3eh
                int     33              ;And close it
                mov     bx,[handleout]
                mov     ax,5701h
                int     33              ;Set time&date to temporal outfile
                mov     ah,3eh
                int     33              ;Close temporal outfile before rename
                push    ds              ;Now we must erase previous oufile
                xor     edx,edx         ; (only if present, of course)
                mov     ax,[segmentlow]
                mov     ds,ax           ;set low segment
                xor     esi,esi         ;esi==name pointer
                mov     ax,7141h        ;Erase, new function
                and     ah,[es:enableLFN]
                jz      NOLFN_2         ;Don't try LFN under DOS
                stc                     ;Carry flag for prior DOS versions
                int     33              ;Erase LFN
                jnc     donelfn2
NOLFN_2         mov     ah,41h          ;Erase, old function
                int     33              ;Erase DOS (if present, ignore error)
donelfn2        push    es
                push    ds
                mov     dx,[es:lowmem_tmp] ;RDMCTMP.$$$ low address
                xor     edi,edi         ;Outfile name low address
                mov     ax,7156h        ;LFN rename function
                and     ah,[es:enableLFN]
                pop     es              ;Set es to low segment too
                jz      NOLFN_3         ;Don't try LFN under DOS
                stc                     ;Carry flag for prior DOS versions
                int     33
                jnc     donerename
NOLFN_3         mov     ah,56h          ;Old rename function
                int     33
                jc      near Err_outfile
donerename      pop     ds              ;Restore registers
                pop     es
                popad

                mov     ah,9
                int     33              ;Print ok message
                mov     edx,uncompsize
                int     33              ;Print "Original size:"
                pushad
                mov     eax,[ebx-4]     ;Number of uncompressed bytes
                call    putnumber       ;Print it
                popad
                mov     edx,compsize    ;Print "Compressed size:"
                int     33
                pushad
                mov     eax,[ebx-12]    ;Get number of compressed bytes
                call    putnumber       ;Print it
                popad
                ;Show ratios
                mov     eax,[ebx-12]    ;Compressed size
                mov     ebx,10000       ;4 significant digits
                imul    ebx
                mov     ebx,[fpu-4]     ;Uncompressed size
                and     ebx,ebx         
                jz      nodiv_rat       ;Avoid zero division
                div     ebx             ;eax=ratio*10000
                mov     ebp,ratio+13    ;Place to put numbers
                mov     ebx,10          ;Divisor
                mov     cl,5            ;Five digits
num_rat         xor     edx,edx         ;Clear EDX
                and     eax,eax         ;Skip leading zeros
                jz      skipzero_rat
                div     ebx             ;Divide by 10
                add     dl,48           ;Number to char
                mov     [ebp],dl        ;Set char
skipzero_rat    dec     ebp             ;Point to next
                cmp     cl,4
                jnz     nopoint_rat     ;Skip decimal point
                dec     ebp
nopoint_rat     loop    num_rat

                mov     eax,[fpu-12]    ;Compressed size
                mov     ebx,80000       ;bpb ratio now
                imul    ebx
                mov     ebx,[fpu-4]     ;Uncompressed size
                div     ebx             ;Ratio
                mov     ebp,ratio+22    ;Place to put numbers
                mov     ebx,10          ;Divisor
                mov     cl,6            ;6 digits to show
num_rat2        xor     edx,edx         ;Clear EDX
                and     eax,eax         ;Skip leading zeros
                jz      skipzero_rat2
                div     ebx             ;Divide by 10
                add     dl,48           ;Number to char
                mov     [ebp],dl        ;Put char
skipzero_rat2   dec     ebp             ;Point next
                cmp     cl,3
                jnz     nopoint_rat2    ;Skip decimal point
                dec     ebp
nopoint_rat2    loop    num_rat2
nodiv_rat       mov     edx,ratio
exit2           mov     ah,9
                int     33              ;Print final message
                mov     ah,1
                mov     cx,0506h
                int     10h             ;Restore cursor
                mov     ax,4C00h        ;Exit without error
                int     33
exit3           pop     ds
                pop     esi
exit            mov     ah,9            
                int     33              ;Print error message
                mov     ah,1
                mov     cx,0506h
                int     10h             ;Restore cursor
                mov     ax,4C01h        ;Exit with error
                int     33
nomemory        call    deleteoutfile   ;Erase outfile
                mov     edx,nomemmess
                jmp     exit            ;Exit with error
Err_ARG         mov     edx,syntax      ;Syntax message
                jmp     exit2
Err_infile      mov     edx,infilemess
                jmp     exit3
Err_outfile     pop     es
                pop     ds
                popad
                call    deleteoutfile
Err_outfile2    mov     edx,outfilemess
                jmp     exit
Err_MEMlow      mov     edx,memlowmess
                jmp     exit3
Endit2          call    deleteoutfile   ;Erase outfile
                mov     edx,badinfile
                jmp     exit
Write_ERR       mov     edx,errwrite
                jmp     exit
Read_ERR        mov     edx,errread
                jmp     exit
DiskFull        call    deleteoutfile   ;Erase outfile
                mov     edx,errdiskfull
                jmp     exit
deleteoutfile   mov     bx,[handleout]
                mov     ah,3eh
                int     33              ;Close outfile before delete
                mov     edx,[tmpname]   ;Get temporal outfile name
                mov     ah,41h
                int     33              ;Erase
                ret

writebyte       pushad
                inc     dword[ebx-12]   ;Increase compressed size
                xchg    [ebx+8],edi     ;edi<->pointer2
                mov     ecx,[ebx+28]    ;Bufferlimit2
                cmp     edi,ecx         ;If pointer2 != bufferlimit2
                jnz     writebyte2      ;Just store it
                pushad
                mov     ah,40h
                mov     edx,[ebx+32]    ;buffer2
                mov     bx,[handleout]  ;handle
                sub     ecx,edx         ;bufferlimit2-buffer2=32K
                int     33              ;Write
                jc      Write_ERR       ;Write error
                cmp     eax,ecx
                jc      near DiskFull   ;ecx bytes not written -> disk full
                popad
                mov     edi,[ebx+32]    ;restart at buffer2
writebyte2      stosb                   ;Store byte
                xchg    [ebx+8],edi     ;edi<->pointer2
                popad
                ret

loadbyte        pushad
                xchg    [ebx+8],esi     ;esi<->pointer2
                inc     dword[ebx-12]   ;Increase compresbytes
                cmp     esi,[ebx+28]    ;If pointer2 != bufferlimit2
                jnz     readbyte2       ;Just take it
                pushad
                mov     ah,3Fh
                mov     ecx,[ebx+28]    ;bufferlimit2
                mov     edx,[ebx+32]    ;buffer2
                sub     ecx,edx         ;bufferlimit2-buffer2
                mov     bx,[handlein]
                int     33              ;Read chunk
                jc      near Read_ERR   ;Read error
                add     edx,eax
                mov     [fpu+28],edx    ;next bufferlimit2=buffer2+read bytes
                dec     ax              ;Have bytes been read?
                popad
                mov     esi,[ebx+32]    ;Restart esi at buffer2
                js      near Endit2     ;No bytes read: Bad infile
readbyte2       lodsb                   ;Take byte
                mov     [bufferchar],al ;Keep it in variable
                xchg    [ebx+8],esi     ;esi<->pointer2
                popad
                mov     eax,[ebx+20]    ;val
                shl     eax,16
                shr     eax,8           ;val=(val<<8) & 00FFFF00
                mov     al,[bufferchar]
                mov     [ebx+20],eax    ;val+=getchar()
                ret

loadfakebyte    pushad
                mov     esi,[ebx+28]
                cmp     esi,[ebx+8]     ;If pointer2 != bufferlimit2, no need
                jnz     returning       ; to read file -> exit, s flag cleared
                mov     ah,3Fh
                mov     bx,[handlein]
                mov     ecx,1           ;Read just a byte
                mov     edx,[bufferchar]
                int     33              ;Read byte
                jc      near Read_ERR   ;Read error
                dec     ax              ;If s is set, no more bytes to read
                js      returning
                mov     ax,4201h
                mov     cx,0ffffh
                xor     edx,edx
                dec     edx
                mov     bx,[handlein]
                int     33              ;Rewind file
returning       popad
                ret

                ;Init tree
init            mov     edi,ebp         ;start of allocated memory
                xor     eax,eax
                xor     ecx,ecx
                add     edi,0400000h-260;4 megs, keep space to detect limit
                                        ; crossed twice. Each time up to 8
                                        ; nodes may have been duplicated
                mov     [ebx+44],edi    ;Set limit
                ;Init nodes[j][i]
                mov     esi,3EA7EF9Eh   ;0.328
                mov     edi,ebp         ;edi=&nodes[0][0] = start of
                                        ;       allocated memory
                cdq                     ;EDX=EAX=0
                ;for (j=0;j<256)
                  ;Init i=0..126
flush           mov     eax,edi         ;&nodes[j][0]
                mov     cl,7Fh          ;for (i=0;i<127)
fl1             xchg    eax,esi
                stosd                   ;c0=0.328
                stosd                   ;c1=0.328
                xchg    eax,esi
                add     eax,16
                stosd                   ;n0=&nodes[j][2i+1]
                add     eax,16
                stosd                   ;n1=&nodes[j][2i+2]
                loop    fl1
                  ;Init i=127..255
                mov     eax,ebp         ;&nodes[0][0]
                mov     cl,80h          ;for (i=127;i<255)
fl2             xchg    eax,esi
                stosd                   ;c0=0.328
                stosd                   ;c1=0.328
                xchg    eax,esi
                stosd                   ;n0=&nodes[2*(i-127)][0]
                add     eax,4096
                stosd                   ;n1=&nodes[2*(i-127)+1][0]
                add     eax,4096        
                loop    fl2
                ;Init loop
                add     edi,16          ;j++
                dec     dl
                jnz     flush
                mov     esi,ebp
                ret

init2           call    init            ;Init tree
                sub     [ebx+4],dword 60000  ;Lookback bytes
                mov     [ebx+48],dword 60000 ;Counter
                mov     [ebx+16],ecx
                mov     dword [ebx+12],01000000h
                ;fake coder > exactly equal than coder, but without output
                ; so I think there's no need to comment it again.
e_do_fake_cod   mov     cl,08h
                pushad
                xchg    [ebx+4],esi
                lodsb
                mov     [bufferchar],al
                xchg    [ebx+4],esi
                popad
                mov     dl,[bufferchar] ;c=getchar
e_for_fake_cod  cmp     dword[esi],8388608
                jnc     normal_fak1
                mov     dword[esi],8388608
normal_fak1     cmp     dword[esi+4],8388608
                jnc     normal_fak2
                mov     dword[esi+4],8388608
normal_fak2     fld     dword[esi+4]
                fld     dword[esi]
                fadd    st1,st0
                mov     eax,[ebx+12]
                sub     eax,[ebx+16]
                dec     eax
                mov     [ebx],eax
                fild    dword[ebx]      ;mid=(max-min-1)
                fmulp   st1             ;*(p.c0)
                fdivrp  st1             ;/(p.c0+p.c1)
                fistp   dword[ebx]

;Adjust value when bounds reached
                mov     eax,[ebx]
                or      eax,eax
                jnz     e_if1_fak
                inc     eax             ;mid++
e_if1_fak       add     eax,[ebx+16]    ;mid+=min

                inc     eax
                cmp     eax,[ebx+12]
                jne     e_if2_fak
                dec     eax             ;mid--
e_if2_fak       dec     eax

                mov     dh,dl
                dec     ecx
                shr     dh,cl
                inc     ecx
                and     dh,01h          ;bit=(c<<i)&80h

                je      e_if3_fake
                mov     [ebx+16],eax    ;min=mid
                jmp     e_el3_fake
e_if3_fake      mov     [ebx+12],eax    ;max=mid
e_el3_fake

up_fak          push    ecx
                mov     ecx,esi
                or      dh,dh
                jz      up1_fak
                add     ecx,4           ;ecx=&(p->count[b])
up1_fak         mov     esi,[ecx+8]     ;esi=(p->next[b])

;Test if duplication needed
                mov     eax,40000000h
                cmp     dword [ecx],eax
                jl      up2_fak
                cmp     dword[esi],8388608
                jnc     normal_fak3
                mov     dword[esi],8388608
normal_fak3
                cmp     dword[esi+4],8388608
                jnc     normal_fak4
                mov     dword[esi+4],8388608
normal_fak4
                fld     dword [esi]     ;nx->c0
                fadd    dword [esi+4]   ;+nx->c1
                fsub    dword [ecx]     ;-p->cx
                fstp    dword [ebx]
                cmp     [ebx],eax
                jl      up2_fak
;Duplication
                cmp     dword[esi],8388608
                jnc     normal_fak5
                mov     dword[esi],8388608
normal_fak5
                cmp     dword[esi+4],8388608
                jnc     normal_fak6
                mov     dword[esi+4],8388608
normal_fak6
                fld     dword [esi]
                fadd    dword [esi+4]
                fdivr   dword [ecx]     ;r=(p->cx)/(nx->c0+nx->c1)
                fld     st0
                xor     eax,eax
dup_fak         fmul    dword [esi]
                fst     dword [edi]     ;(new->c0)=r*(nx->c0)
                cmp     dword[edi],8388608
                jnc     normal_fak
                mov     dword[edi],8388608
normal_fak

                fsubr   dword [esi]
                fstp    dword [esi]     ;(nx->c0)-=r*(nx->c0)
                cmpsd                   ;point to c1
                dec     eax
                jp      dup_fak         ;do the same whith c1
                movsd                   ;copy n0 and point to n1
                movsd                   ;copy n1 and point to new++
                mov     [ecx+8],edi     ;(p->next[b])=new
                sub     [ecx+8],dword 16

;Update current node
up2_fak         fld1
                fadd    dword [ecx]
                fstp    dword [ecx]     ;(p->count[b])++
                mov     esi,[ecx+8]
                pop     ecx

;Process with next input char
                mov     eax,[ebx+12]
                sub     eax,[ebx+16]
                cmp     eax,00000100h   ;max-min<256
                jge     e_nxt_fake_cod
                or      dh,dh
                jz      e_if4_fak
                dec     dword [ebx+12]  ;max--
e_if4_fak       mov     eax,[ebx+16]
                shr     eax,16
common41        shl     dword[ebx+16],16
                shr     dword[ebx+16],8
                shl     dword[ebx+12],16
                shr     dword[ebx+12],8
                mov     eax,[ebx+12]
                cmp     eax,[ebx+16]
                jg      e_nxt_fake_cod
                mov     dword[ebx+12],01000000h
e_nxt_fake_cod  dec     ecx
                jnz     near e_for_fake_cod
                dec     dword[ebx+48]   ;Count a byte down
                jnz     near e_do_fake_cod ;Keep till it comes to the last
                ret

putnumber       mov     ecx,10          ;Divisor
ax2dec          push    edx
                xor     edx,edx         ;Clear edx
                div     ecx             ;Next cipher in DL
                and     eax,eax         ;If result is zero
                jz      decdone         ;End it
                call    ax2dec          ;And continue with next one
decdone         or      dl,30h          ;Cipher to char
                mov     ah,2
                int     21h             ;Output char
                pop     edx             ;Next cipher to print or old value
                ret

initmessage     db      "RDMC v0.06b - a packer",13,10,10
                db      "Based on DMC algorithm created by Gordon V. Cormack and Nigel S. Horspool",13,10
                db      "Code taken from st0ne's winning entry for Hugi Size Compo 7",13,10,10
                db      "Copyright (c) 2000-01 Jaime Tejedor Gmez/Metalbrain  (metalbrain_coder@gmx.net)",13,10
                db      "$"
messagepercent  db      13,"  0% done$"
syntax          db      13,10,"Syntax: RDMC [c|d] infile outfile",13,10,10
                db      "(c to compress, d to decompress)",13,10
                db      "$"
infilemess      db      "Invalid infile name",13,10
                db      "$"
outfilemess     db      13,10,"Invalid outfile name",13,10
                db      "$"
nomemmess       db      "Not enough memory!",13,10
                db      "$"
memlowmess      db      "Not enough low memory!",13,10
                db      "$"
decok           db      13,"100",13,10,"Decompression OK"
                db      "$"
compok          db      13,"100",13,10,"Compression OK"
                db      "$"
badinfile       db      13,10,"Bad infile!"
                db      "$"
errread         db      13,10,"Read error!"
                db      "$"
errwrite        db      13,10,"Write error!"
                db      "$"
errdiskfull     db      13,10,"Disk full, can't write"
                db      "$"
uncompsize      db      13,10,10,"Original size:   "
                db      "$"
compsize        db      13,10,"Compressed size: "
                db      "$"
ratio           db      13,10,"Rate:   0.00%, 0.0000 bpb"
                db      "$"
unittmpfile     db      "C:"
tmpfile         db      "RDMCTMP.$$$",0
tmpname         dd      tmpfile
flag            db      1
                ALIGN   4
                dd      0
                dd      0
                dd      0
fpu             dd      000000FDh
                section .bss
                resb    64
lowmem_tmp      resw    2
total           resw    2
command         resw    1
handlein        resw    1
handleout       resw    1
segmentlow      resw    1
bufferchar      resb    1
enableLFN       resb    1

;ebx-12  > compresbytes
;ebx-8   > partialbytes
;ebx-4   > bytes
;ebx     > fpu
;ebx+4   > pointer
;ebx+8   > pointer2
;ebx+12  > min
;ebx+16  > max
;ebx+20  > val
;ebx+24  > bufferlimit
;ebx+28  > bufferlimit2
;ebx+32  > buffer2
;ebx+36  > bufferzone
;ebx+40  > bufferstart
;ebx+44  > limit
;ebx+48  > fakeleft

;MEMORY BUFFERS OVERVIEW
;                                bufferzone
;bufferstart                     |       bufferlimit
;|                               |       |
;0K------------------------------256K----288K----384K
;                                        |       |
;                                        |       bufferlimit2
;                                        buffer2
