{$X+,A-,V-}
uses Dos;
{$I MYDOS}
const cbreak:boolean=False;
{$F+}
procedure CtrlBreak;interrupt;
begin
	cbreak:=True;
end;
{$F-}
const	MAX=20000;				{ I/O Buffer size }
	ID:string[3]=#26'QF';			{ ID String }
	copyright:string[59]=
	#10'QuickFileCollection v2.02c(c) 1993-1999 by George G.Lyapko';
	MSG_ERR:string[13]='-error in QFC';
	MSG_OPEN:string[11]='-can''t open';
	MSG_READ:string[11]='-can''t read';
	MSG_WRITE:string[12]='-can''t write';
	TMPNAME:string[7]='QFC.(1)';
type	
	FNameStr=string[12];
	S14=string[14];
	buffer=array [1..MAX] of byte;		{ I/O Buffer }
	header= record
		ID:byte;			{ ID byte (always $1A) }
		size:array [1..3] of byte;	{ Lower 3 bytes of file size }
		time:longint;			{ DOS Date/Time }
		attr:byte;			{ file attribute }
		n:string;
		end;
	pl=^list_stream;		{ pointer to stream }
					{ of names to be processed }
	list_stream=record
			p:pl;		{ pointer to next item }
			s:longint;	{ size of file }
			n:string;	{ file mask }
		end;
	s3=string[3];
	pa=^a_stream;
	a_stream=record			{ pointer to stream }
					{ of archives to be processed }
			p:pa;		{ pointer to next item }
			n:string;	{ archive name }
	end;
var
	vid:string[3];
	h:header;
	b:buffer;
	qfcfile:integer;
        outdir,
        tmpdir:String;
	toname,
	sdd,
	qfcname:String;
	dir:String;
	name:String;
	ext:String;
	sort,				{ sorting flag }
	recurse,			{ recursion flag }
	delflag,			{ deletion flag }
	list,				{ list flag }
	extract,			{ if false - extract, else - collect }
{ if delflag is true and extract false , then move files to collection }
	exist:Boolean;
	pn,
	i:byte;
	ppos:pointer;
	beg:list_stream;
	stream:pl;
	firstarc:a_stream;
	archives:pa;
	x0,				{ Position in file }
	size:longint;			{ Size of file }
	ch,ch1:char;			{ Keyboard input }
	chword:word absolute ch;

procedure FSPlit(p:string;var d:string;var n:string;var e:string);
var I:integer;
begin
     d:='';
     i:=Length(p);
     while (i>=1) and (p[i]<>'\') and (p[i]<>':') do Dec(i);
     if i<>0 then begin
        d:=Copy(p,1,i);
        Delete(p,1,i);
     end;
     i:=Length(p);
     while (i>=1) and (p[i]<>'.') do Dec(i);
     if i<>0 then begin
        n:=Copy(p,1,i-1);
        e:=Copy(p,i,length(p));
     end else begin
         n:=p;
         e:='';
     end;
end;

procedure Halter;
{ Exit procedure for incorrect calls }

begin
	Writeln('Usage: QFC [/Options] QFCfile [HomeDir\] [/Options]',
	' [files] [@list]');
	Writeln(#10'Options:');
	Writeln(' /a or /c - Add/Collect files (Default)');
	Writeln(' /m       - Move files to QFC');
	Writeln(' /r       - Recurse subdirectories');
	Writeln(' /s       - Sort files by extension');
	Writeln(' /e /x /p - EXtract/Parse files from QFC');
	Writeln(' /d       - Delete files from QFC');
	Writeln(' /l or /v - List/View QFC');
	Writeln(' /t<path> - set Temporary path');
	Writeln(#10'QFCfile = QFC file name. Default extension is .QFC');
	Writeln('          Wildcards *,? ok for /explvd');
	Writeln('files   = Names of files to process. Wildcards ok.',
	' Default is ALL files.');
	Writeln('@list   = listfile containing names of files to',
	' operate with');
	Halt(0)
end;

function Count:integer;
var p:list_stream;s1:integer;
begin
	p:=beg;s1:=0;
	while p.p<>nil do begin
		p:=p.p^;Inc(s1);
	end;
	Count:=s1;
end;

function Get(i:integer):pl;
var p:pl;s1:integer;
begin
	p:=@beg;s1:=0;
	while (s1<i) do begin
		p:=p^.p;Inc(s1);
	end;
	Get:=p;
end;

procedure Exchange(i,j:integer);
var pi1,pj1,pi,pj:pl;p:list_stream;
begin
	pi:=Get(i);
	pj:=Get(j);
        if pi<>pj then begin
        	pi1:=Get(i-1);
                pj1:=Get(j-1);
                pi1^.p:=pj;
                pj1^.p:=pi;
                p:=pi^;
                pi^.p:=pj^.p;
                pj^.p:=p.p;
        end;
end;

function Ext1(n:list_stream):String;
var      d:string;n1:String;e:String;
         b:longint;b1:array [0..3] of char absolute b;
begin
        b:=n.s;
	FSPLIt(n.n,d,n1,e);
	n1:=Copy(e,2,3)+b1[3]+b1[2]+b1[1]+b1[0];
        Ext1:=n1;
end;

procedure QuickSort(start,finish:integer);
var left,right:integer;pivot:String;
begin
	left:=start;right:=finish;
	pivot:=Ext1(Get((left+right) div 2)^);
	repeat
		while Ext1(Get(left)^)>pivot do Inc(left);
		while Ext1(Get(right)^)<pivot do Dec(right);
		if left<=right then begin
			Exchange(left,right);
			Inc(left);Dec(right);
		end;
	until left>=right;
	if start<right then QuickSort(start,right);
	if left<finish then QuickSort(left,finish);
end;

procedure SortStream;
begin
	QuickSort(1,Count);
end;

procedure AddExtension(var n:String);
{ Adds extension .QFC to filename, if no extension were specified}

var s:String;
begin
	s:=n;while Pos('\',s)<>0 do Delete(s,1,Pos('\',s));
	if Pos('.',s)=0 then n:=n+'.QFC';
end;

function Slash(s:String):String;
{ Adds backslash to directory name }

begin
	if (s[length(s)] in ['\',':']) or (length(s)=0) then Slash:=s else
	Slash:=s+'\';
end;

function DirName(p:String):String;
{ Parse directory from full pathname }

var d:String;n:String;e:String;
begin 
	FSplit(p,d,n,e);
	DirName:=d
end;

function ExistFile(n:String):boolean;
{ True if file n exists, else False }

begin
	ExistFile:=GetFileAttr(n)<>$FF;
end;

function CopyFile(n:string;handle:integer):boolean;
{ Copy file named "n" to handle }

var inf,x:integer;
begin
	if delflag then Write('Mov') else Write('Add');
	Write('ing file ',n,' '); CopyFile:=False;
	inf:=OpenFile(n,FOR_READ);
	if inf=-1 then begin Writeln(MSG_OPEN);Exit; end;
	x:=ReadFile(inf,@b,SizeOf(buffer));
	while x>0 do begin
		if WriteFile(handle,@b,x)<>x then begin
			CloseFile(inf);	Writeln(MSG_WRITE); Exit;
		end;
		Write('+');
		x:=ReadFile(inf,@b,SizeOf(buffer));
	end;
	Writeln;
	CloseFile(inf);
	if delflag then Unlink(n);
	CopyFile:=True;
end;

function GetHeader(f1:integer):boolean;
{ Checks for valid QFC-header, and initialize name,ext,size variables }

var i:byte;
begin
	GetHeader:=False;
	if h.ID<>26 then Exit; 
	GetHeader:=True;
	FSplit(h.n,dir,name,ext);
	size:=0; Move(h.size,size,3); if list then Exit;
	dir:=Slash(dir);
	{ Seek to next header }
	x0:=LSeek(f1,0,FROM_CURRENT)+size;
end;

procedure SplitName(p:String;var d:String;var n:String);
var n1:String;e:String;
begin
	FSPlit(p,d,n1,e);n:=n1+e;
end;

procedure AddToList(s:String);forward;


function Tocka(s:String):String;
var d:String;n:String;e:String;
begin
	FSplit(s,d,n,e);
	if length(e)=0 then Tocka:=s+'.' else Tocka:=s;	
end;

{$IFNDEF V12}
{$L Equal}
function Equal0(s,m: String):boolean;external;
{$ELSE}
function Equal0(s,m: String):boolean;
var	i,j,i1,j1,i2:integer;
	m1:String;
begin
	i:=Pos('?',m);j:=Pos('*',m);
	if ((i<j)or(j=0))and(i>0) then begin
		if i>1 then begin
			if Copy(s,1,i-1)=Copy(m,1,i-1) then begin
				Delete(s,1,i);Delete(m,1,i);Equal0:=Equal0(s,m);
			end else Equal0:=false;
		end else begin
			Delete(s,1,i);Delete(m,1,i);Equal0:=Equal0(s,m);
		end;
	end else if ((j<i)or(i=0))and(j>0) then begin
		if j>1 then begin
			if Copy(s,1,j-1)=Copy(m,1,j-1) then begin
				Delete(s,1,j-1);Delete(m,1,j);
				j1:=Pos('*',m);i1:=Pos('?',m);
				if ((i1<j1)or(j1=0))and(i1>1) then begin
					m1:=m; i2:=Pos(Copy(m,1,i1-1),s);
					if i2<>0 then begin
						Delete(s,1,i2+i1-2);
						Delete(m,1,i1-1);
						if Equal0(s,m) then Equal0:=true
						else Equal0:=Equal0(s,m1);
					end else Equal0:=false;
				end else
				if ((j1<i1)or(i1=0))and(j1>1) then begin
					m1:=m; i2:=Pos(Copy(m,1,j1-1),s);
					if i2<>0 then begin
						Delete(s,1,i2+j1-2);
						Delete(m,1,j1-1);
						if Equal0(s,m) then Equal0:=true
						else Equal0:=Equal0(s,m1);
					end else Equal0:=false;
				end else if (i1=0)and(j1=0) then Equal0:=
				m=Copy(s,Length(s)-Length(m)+1,Length(m));
			end else Equal0:=false;
		end else begin
			Delete(m,1,j);
			j1:=Pos('*',m);i1:=Pos('?',m);
			if ((i1<j1)or(j1=0))and(i1>1) then begin
				m1:=m;i2:=Pos(Copy(m,1,i1-1),s);
				if i2<>0 then begin
					Delete(s,1,i2+i1-2);
					Delete(m,1,i1-1);
					if Equal0(s,m) then Equal0:=true
					else Equal0:=Equal0(s,m1);
				end else Equal0:=false;
			end else if ((j1<i1)or(i1=0))and(j1>1) then begin
				m1:=m; i2:=Pos(Copy(m,1,j1-1),s);
				if i2<>0 then begin
					Delete(s,1,i2+j1-2);
					Delete(m,1,j1-1);
					if Equal0(s,m) then Equal0:=true
					else Equal0:=Equal0(s,m1);
				end else Equal0:=false;
			end else if (i1=0)and(j1=0) then
			Equal0:=m=Copy(s,Length(s)-Length(m)+1,Length(m));
		end;
	end else if (i=0)and(j=0) then Equal0:=m=s;
end;
{$ENDIF}

procedure AddName(d:String;s:MySearchRec);
var p:list_stream;s1:string;
begin
	s1:=d+s.name;
	p:=beg;
	while p.p<>nil do begin
		p:=p.p^;if s1=p.n then Exit;
	end;
	if MaxAvail<length(s1)+1+4+4 then Exit;
	GetMem(stream^.p,length(s1)+1+4+4);
	stream^.p^.n:=s1;
	stream^.p^.s:=s.size;
	stream:=stream^.p;
	stream^.p:=nil;
end;

function UpStr(s:String):String; var i:byte;{ converts string to uppercase }
begin	for i:=1 to length(s) do s[i]:=UpCase(s[i]); UpStr:=s end;

procedure AddRecurse(mask:String);
{ Adds file names matching mask to list stream with recursion }
var	s:MySearchRec;d:String;n:String;
begin
	SplitName(mask,d,n);s.dir:=d;
	FindFirstLFN(d+'*.*',$37,s);
	while foundLFN do begin
		if (s.name[1]<>'.') and (s.name<>TMPNAME) and (s.name<>qfcname)
		then
		if (s.attr and Directory)<>0 then
			AddToList(d+s.name+'\'+n)
		else if Equal0(UpStr(Tocka(s.name)),UpStr(n)) then AddName(d,s);
		FindNextLFN(s.handle,s);
	end;
	TerminateFind(s);
end;

procedure AddNoRecurse(mask:String);
{ Adds file names matching mask to list stream without recursion }
var	s:MySearchRec;d:String;n:String;
begin
	SplitName(mask,d,n);s.dir:=d;
	FindFirstLFN(mask,$27,s);
	while foundLFN do begin
		if (s.name<>TMPNAME) and (s.name<>qfcname) then AddName(d,s);
		FindNextLFN(s.handle,s);
	end;
	TerminateFind(s);
end;

procedure AddToList(s:String);
begin
	if recurse then AddRecurse(s) else AddNoRecurse(s);
end;

procedure CreateList;{ Creates list stream of filenames to be processed }
var list_file:text;s:String;
begin

{ No masks specified - assume all files in current directory }
	if pn=0 then AddToList('*.*')
	else while pn<=ParamCount do begin
		s:=UpStr(ParamStr(pn));
		if not (s[1] in ['-','/']) then
		if s[1]<>'@' then AddToList(s)
		else begin
{Get masks from list-file}
			Delete(s,1,1);
			Assign(list_file,s);
			{$I-}Reset(list_file);{$I+}
			if IOResult=0 then begin
				while not eof(list_file) do begin
					Readln(list_file,s);
					AddToList(UpStr(s));
				end;
				Close(list_file);
			end;
		end;
		Inc(pn);
	end;
        if sort then SortStream;
end;

function Add(ns:string;handle:integer):boolean;
{ Add files to collection "handle"}

var s:MySearchRec;d:String;n:String;
begin
	Add:=False;s.dir:=DirName(ns);
	FindFirstLFN(ns,$27,s);
	TerminateFind(s);
	if foundLFN and (s.name<>qfcname) and (s.name<>toname) and
	(s.name<>TMPNAME)
	then begin
{Create QFC header}
		h.attr:=s.attr; h.time:=s.datetime; Move(s.size,h.size,3);
		h.n:=ns;
		if WriteFile(handle,@h,SizeOf(header)-SizeOf(string)+length(h.n)+1)<>
			SizeOf(header)-SizeOf(string)+length(h.n)+1 then Exit;
{Reset System and Hidden attributes}
		if s.attr and 6<>0 then SetFileAttr(ns,0);
{Copy file to collection}
		if CopyFile(ns,handle) then Add:=True;
{Reset attributes to original}
		SetFileAttr(ns,s.attr);
	end;
end;

function Match:boolean;
{Checks if file dir+name+ext already present in stream}
var p:list_stream;s:String;d:String;n:String;E:String;
begin
	Match:=True;
	p:=beg;
	while p.p<>nil do begin
		p:=p.p^;
		s:=p.n;
		FSplit(s,d,n,e);
		Delete(e,1,1);
		if (dir=d) and (name=n) and (ext=e) then Exit
	end;
	Match:=False;
end;

function QFCMatch:boolean;
var i:byte;list_file:text;s:String;d:String;n1:String;e1:String;
begin
	QFCMatch:=True; i:=pn;
	while i<=ParamCount do begin
		s:=UpStr(ParamStr(i));
		if not (s[1] in ['-','/']) then begin
			if s[length(s)]='\' then outdir:=s;
			if s[1]<>'@' then begin
				FSplit(s,d,n1,e1);
				if e1='' then e1:='.';
				if Equal0(UpStr(dir+name+ext),
				UpStr(Slash(d)+n1+e1)) then Exit;
			end else begin
				Delete(s,1,1);
				Assign(list_file,s);
				{$I-}Reset(list_file);{$I+}
				if IOResult=0 then begin
					while not eof(list_file) do begin
						Readln(list_file,s);
						s:=UpStr(s);
			if s[length(s)]='\' then outdir:=s;
						FSplit(s,d,n1,e1);
						if e1='' then e1:='.';
						if Equal0(UpStr(dir+name+ext),
						UpStr(Slash(d)+n1+e1)) then Exit;
					end;
					Close(list_file);
				end;
			end;
		end;	
		Inc(i);
	end; QFCMatch:=False;
end;

function GetFromOld(toname:string):boolean;label l1,l2;
var arcfile:integer;x:longint;
begin
	GetFromOld:=False;
	arcfile:=OpenFile(toname,FOR_READ);
	if arcfile=-1 then begin Writeln(MSG_OPEN); Exit; end;
	if ReadFile(arcfile,@vid[1],3)<>3 then begin
		Writeln(MSG_READ); goto l1;
	end;
	if vid<>id then goto l2;
	while ReadFile(arcfile,@h,SizeOf(header)-SizeOf(string)+1)=SizeOf(header)-SizeOf(string)+1 do
	begin
		if ReadFile(arcfile,@h.n[1],length(h.n))<>length(h.n) then goto l2;
		if not GetHeader(arcfile) then begin
l2:			Writeln(MSG_ERR); goto l1
		end;
		if (not extract and not Match(*dir,name,ext*))
                or (extract and not QFCMatch)
		then begin
			if WriteFile(qfcfile,@h,SizeOf(header)-SizeOf(string)+length(h.n)+1)<>
			SizeOf(header)-SizeOf(string)+length(h.n)+1 then begin
				Writeln(MSG_READ);
				goto l1
			end;
			x:=ReadFile(arcfile,@b,SizeOf(buffer));
			while size>0 do begin
				if x>size then x:=size;
				if WriteFile(qfcfile,@b,x)<>x then begin
					Writeln(MSG_WRITE);
					goto l1
				end;
				Dec(size,x);
				x:=ReadFile(arcfile,@b,SizeOf(buffer));
			end;
		end else if extract then Writeln('Deleting ',dir,
		name,(*'.',*)ext);
		LSeek(arcfile,x0,FROM_BEGIN);
	end; GetFromOld:=True;
l1:	CloseFile(arcfile);
end;

function SameDrive(s,s1:String):boolean;
{ Checks if s and s1 are on same drive }
var i,i1:byte;d,d1:char;
begin
	SameDrive:=True; i:=Pos(':',s); i1:=Pos(':',s1);
	if i=0 then d:=GetDisk else d:=s[Pred(i)];
	if i1=0 then d1:=GetDisk else d1:=s1[Pred(i1)];
	if d<>d1 then SameDrive:=False;
end;

function Rename(s,s1:String):boolean;label l1;
var file1,file2,x:integer; arcn:String; 
begin	Rename:=False;
	if not SameDrive(s,s1) then begin
		arcn:=DirName(s1)+TMPNAME;
		Write('Copying TMP to QFC ');
		file1:=OpenFile(s,FOR_READ);
		file2:=OpenFile(arcn,FOR_WRITE);
		if (file1=-1) or (file2=-1) then goto l1;
		x:=ReadFile(file1,@b,SizeOf(buffer));
		while x>0 do begin
			if WriteFile(file2,@b,x)<>x then begin 
l1:				CloseFile(file1); CloseFile(file2);
				Unlink(s); Unlink(arcn);
				Writeln('Can''t copy',
				' tmp-file to target directory');
				Exit;
			end;
			Write('+');
			x:=ReadFile(file1,@b,SizeOf(buffer));
		end;
		Writeln;
		CloseFile(file1); CloseFile(file2); Unlink(s);
		s:=arcn;
	end;
        Unlink(s1); RenFile(s,s1);
end;

procedure DeleteF;
begin
	qfcname:=toname;
	toname:=tmpdir+TMPNAME;
	qfcfile:=OpenFile(toname,FOR_WRITE);
	if qfcfile=-1 then begin
		Writeln(MSG_OPEN); Exit
	end;
	if WriteFile(qfcfile,@vid[1],3)<>3 then begin
		Writeln(MSG_WRITE); Exit
	end;
	if not GetFromOld(qfcname) then begin
		CloseFile(qfcfile); Unlink(toname); Exit
	end;
	CloseFile(qfcfile); Rename(toname,qfcname);
end;

procedure Merge;
label l1,l2;
begin
	Writeln('Processing collection ',toname);
        CreateList;
	exist:=ExistFile(toname);
	if exist then qfcname:=tmpdir+TMPNAME else qfcname:=toname;
	qfcfile:=OpenFile(qfcname,FOR_WRITE);
	if qfcfile=-1 then begin Writeln(MSG_OPEN); Exit end;
	if WriteFile(qfcfile,@vid[1],3)<>3 then begin
		Writeln(MSG_WRITE); goto l1
	end;
	if exist and not GetFromOld(toname) then begin
l1:		CloseFile(qfcfile); Unlink(qfcname); Exit;
	end;
	stream:=@beg;
	while stream^.p<>nil do begin
		stream:=stream^.p;
		Add(stream^.n,qfcfile);
		if cbreak then begin
			Writeln('Aborted by user');
			goto l2;
		end;
	end;
l2:	CloseFile(qfcfile);
	if exist then Rename(qfcname,toname);
end;

function Null(s:word):s3;
var s1:s3;
begin
	Str(s:2,s1);
	if s1[1]=' ' then s1[1]:='0';
	Null:=s1;
end;

procedure View;label l1,l2;
const month:array [0..15] of S3=(' 00','Jan','Feb','Mar','Apr','May',
	'Jun','Jul','Aug','Sep','Oct','Nov','Dec',' 13','XIV',' XV');
var	i:byte;
	n:string;
	kol:integer;
	allsize:longint;
        dt:DateTime;
begin
	qfcfile:=OpenFile(toname,FOR_READ);
	if qfcfile=-1 then begin Writeln(MSG_OPEN); Exit end;
	if ReadFile(qfcfile,@vid[1],3)<>3 then begin
		Writeln(MSG_READ); goto l1;
	end;
	if vid<>id then goto l2;
        Writeln(#10'Content of collection ',toname,#10);
	Writeln('  Size      Date       Time   Attr Name');
	Writeln('-------- ----------- -------- ---- -----------------------------------------');
        kol:=0;
        allsize:=0;
	while ReadFile(qfcfile,@h,SizeOf(header)-SizeOf(string)+1)=
	SizeOf(header)-SizeOf(string)+1 do
	begin
		if ReadFile(qfcfile,@h.n[1],length(h.n))<>length(h.n) then goto l2;
		if not GetHeader(qfcfile) then begin
l2:			Writeln(MSG_ERR);
l1:			CloseFile(qfcfile); Exit;
		end;
                UnpackTime(h.time,dt);
		if (pn=0) or QFCMatch then begin
			Write(size:8,dt.day:3,'-',
			MONTH[dt.month]:3,'-',dt.year:4,
			dt.hour:3,':',Null(dt.min),':',Null(dt.sec),' ');
                	if h.attr and 1<>0 then Write('r') else Write('-');
                	if h.attr and 2<>0 then Write('h') else Write('-');
                	if h.attr and 4<>0 then Write('s') else Write('-');
                	if h.attr and 32<>0 then Write('a') else Write('-');
			Writeln(' ',h.n);
                	Inc(kol);
                	Inc(allsize,size);
                end;	
		LSeek(qfcfile,size,FROM_CURRENT);
	end;
	Writeln('-------- ----------- -------- ---- -----------------------------------------');
        Writeln(allsize:10,' bytes in ',kol,' file(s)');
        Writeln;
	CloseFile(qfcfile);
end;

procedure TryCreateDir(s:string);
var	d:String;n:String;se:Mysearchrec;
begin
	SplitName(s,d,n);
	if d[length(d)]='\' then Dec(d[0]);
        if length(d)<>0 then begin
        	FindFirstLFN(d,AnyFile,se);
	        if not foundLFN then begin
			TryCreateDir(d);
			{$I-}MkDir(d);{$I+}
			Writeln('Creating ',d);
                end;
                TerminateFind(se);
        end;
end;

procedure Parse;
label l1,l2,l3,l4;
var	i:byte; 
	outf,x:integer;
        s:MySearchrec;
        arcn:String;
begin
	qfcfile:=OpenFile(toname,FOR_READ);
	if qfcfile=-1 then begin Writeln(MSG_OPEN); Exit end;
	if ReadFile(qfcfile,@vid[1],3)<>3 then begin
		Writeln(MSG_READ); goto l2;
	end;
	if vid<>id then goto l4;
	while ReadFile(qfcfile,@h,SizeOf(header)-SizeOf(string)+1)=SizeOf(header)-SizeOf(string)+1 do
	begin
		if ReadFile(qfcfile,@h.n[1],length(h.n))<>length(h.n) then goto l4;
		if not GetHeader(qfcfile) then begin
l4:			Writeln(MSG_ERR); goto l2;
		end;
		if (pn=0) or QFCMatch then begin
			if recurse then
			arcn:=outdir+dir+name+ext
			else
			arcn:=outdir+name+ext;
			FindFirstLFN(arcn,$27,s);
			TerminateFind(s);
			if foundLFN then begin
					Write('File ',arcn,' already exists.');
l3:					Write('Do you wish to write it over(y/n)?');
				asm
					mov ah,1
					int 16h
					mov ah,0
					int 16h
					mov word ptr chword,ax
				end;
				Writeln(ch);
				if not (ch in ['n','N','Y','y']) then goto l3;
				if UpCase(ch)='N' then begin
					Writeln('Skipped.'); goto l1;
				end else SetFileAttr(arcn,0);
			end;
			outf:=OpenFile(arcn,FOR_WRITE);
			if outf=-1 then begin
				TryCreateDir(arcn);
				outf:=OpenFile(arcn,FOR_WRITE);
				if outf=-1 then begin
					Writeln(arcn,MSG_OPEN,'.Skipping');
					goto l1;
				end;
			end;
			Write('Parsing file ',arcn);
			x:=ReadFile(qfcfile,@b,SizeOf(buffer));
			while size>0 do begin
				if x>size then x:=size;
				if WriteFile(outf,@b,x)<>x then begin 
					CloseFile(outf);
					Writeln(MSG_WRITE,
					'.Disk full?');
					Unlink(arcn); goto l1;
				end;
				Write('+');
				Dec(size,x);
				x:=ReadFile(qfcfile,@b,SizeOf(buffer));
			end;
			Writeln('OK');
			CloseFile(outf);
			outf:=OpenFile(arcn,FOR_READ);
			SetFDT(outf,h.time);
			CloseFile(outf);
			SetFileAttr(arcn,h.attr);
		end;	
l1:		LSeek(qfcfile,x0,FROM_BEGIN);
	end;
l2:	CloseFile(qfcfile);
end;

var ss:MySearchRec;

begin
	vid:=id;
{$IFNDEF VER70}
	extract:=False;				{by default - add files}
	list:=False; 
	delflag:=False;
	toname:='';				{Archive file name}
	tmpdir:='';				{no temporary path}
	outdir:='';				{no output directory}
	pn:=0;
	beg.p:=nil;
	firstarc.p:=nil;
{$ENDIF}
	win95:=True;
{Detect LFN availability}
	asm
		mov	ax,7147h
		xor	dl,dl
		mov	si,Offset sdd
		int	21h
		cmp	ax,7100h
		jne	@@1
		mov	byte ptr win95,0
	@@1:
	end;
	i:=1;
	Writeln(copyright);Writeln;		{Write (c) message}

{Analize parameter string}
	while i<=ParamCount do begin
		sdd:=UpStr(ParamStr(i));
		if sdd[1] in ['/','-'] then begin
			case UpCase(sdd[2]) of
			'P','X','E':extract:=True;
			'A','C':;
			'R':recurse:=True;
			'S':sort:=True;
			'M':delflag:=True;
			'D':begin delflag:=True; extract:=True end;
			'L','V':list:=True;
			'T':tmpdir:=Slash(sdd);
			else Halter;
			end;
		end else if toname='' then begin
			toname:=sdd;			{archive name}
			AddExtension(toname);		{add .QFC if it is needed}
		end else
                if pn=0 then
                if (sdd[length(sdd)]='\') or (sdd[length(sdd)]=':')
                then outdir:=sdd 	{output directory}
                else pn:=i;				{here begins file masks}
                Inc(i);
	end;
	if toname='' then Halter;			{no archive name}
	SetIntVec($1B,Addr(CtrlBreak));	
	SetIntVec($23,Addr(CtrlBreak));	

        {Set ID byte}
	h.id:=$1A; 
	stream:=@beg;
	archives:=@firstarc;
	if (not list) and (not extract) then Merge else begin
		sdd:=DirName(toname);

		FindFirstLFN(toname,$21,ss);
		while foundLFN do begin
			if MaxAvail>=Succ(Length(sdd+ss.name)+SizeOf(pointer))
			then begin
				GetMem(archives^.p,
				Succ(Length(sdd+ss.name)+SizeOf(pointer)));
				archives^.p^.n:=sdd+ss.name;
				archives:=archives^.p;
		                archives^.p:=nil;
			end;
			FindNextLFN(ss.handle,ss);
		end;
		TerminateFind(ss);

                archives:=@firstarc;
		if firstarc.p<>nil then
		while archives^.p<>nil do begin
			toname:=archives^.p^.n;
			Writeln('Processing collection ',toname);
			if list then View else 
			if delflag then DeleteF else Parse;
			archives:=archives^.p;
		end else Writeln('File ',toname,' not found');
	end
end.
