

                                                              QAZ v3.61
                                       by Robert Rothenburg Walking-Owl
                             Copyright (c)1993,1994 All Rights Reserved


                                                                      A 
                                                              No-Frills
                                                           User's Guide 
                                                             and Manual



                                    "No archiver too obscure... almost"


(1) License and Distribution
-----------------------------------------------------------------------
Individuals and institutions have the right to use this software freely
so long as it is neither modified nor distributed for profit.

If you want to include QAZ as part of a shareware or commercial package,
please contact me at the postal address below.

(2) Contacting the Author
-----------------------------------------------------------------------
Although no registration is required (as the author is unsure of a per-
manent address for the next couple of years) voluntary donations are
accepted.  Preferrably a post-card or e-mail if nothing else.

The author (myself) can be reached at:

(electronic)    rrothenb.ic.sunysb.edu

(post)          Robert Rothenburg Walking-Owl
                P.O. Box 1327
                South Stony Brook, NY 11790 USA

If you have any suggestions or bug-reports, please let me know.

If you have any questions about the utilities supported by QAZ (such
as where to get copies?, or what is this utility?) please ask around
on various e-networks or local BBS systems first.

(3) Legal Miscellanea
-----------------------------------------------------------------------
Being free, the author makes no guarantees or warrantees as to the use,
misuse or abuse of this software.  The author shall not be held respon-
sible for damage to (or improvement of) data, time, finance, ideologies
et cetera in association with the use of this program (QAZ).

The author also makes no gurantees that QAZ will correctly identify and
handle everything (it's impossible).  However, much effort and time has
been put into making QAZ as complete and powerful as possible.

Users of this utility take all responsibility for the licensing requir-
ements of associated software(s) used in conjunction with QAZ.

The various archive formats and utilities, as well as operating systems
and other softwares are the respected trademarks or copyrights of the
various people and-or corporations that own whatever rights there are to
their respective products, etc.

QAZ being free software, its author is under no obligation to provide
support, and may change various aspects of this software from version
to version.

(4) What is QAZ?
-----------------------------------------------------------------------
"QAZ" stands for Q-A-Z, the leftmost three keys on a standard American
QWERTY-style keyboard (I couldn't think up a better name for it at the
time).

QAZ is an "almost universal archive viewer".  It will recognize, if not
view, most compressed- or archive(r)-file formats, specifically in the
DOS platform, although other types (from the Amiga, Macintosh and Unix)
are recognized as well.  (See the file WHICHARC.TXT for more details.)

QAZ is also capable of searching a drive for archives which contain a
specified set of files, or of returning exit codes identifying the file
type or attributes of the file (such as whether an archive contains AV
information or password-protected files) which can be used by other
software.

The output of QAZ is to standard-output, which means it can be used as
an online BBS viewing utility. The format of the listing is very cust-
omizable to suit users' individual tastes.

Note that the default date and time format settings should conform to
the DOS defaults on users' native systems, unless reconfigured by the
user.

(5) General Usage:
-----------------------------------------------------------------------
If you run QAZ with no options (or with the -H option), you should get 
the on-line help screen, which gives the general syntax of the options
along with a few examples.

QAZ can be run in "vanilla" mode with no options: QAZ filename (as an 
example, QAZ FOOBAR.LZH.  QAZ will also accept wildcards, and given the
options, can even span an entire disk searching for archives which con-
tain specified files (by names, dates or sizes). QAZ can even apply the
search-specs to files not in archives.

(6) File-Specifications:
-----------------------------------------------------------------------
QAZ handles filespecs differently for versions 3.41 and later. Some of
the special variants used by QAZ are no longer supported: they have not
been "documented" in QAZ since v2 as I have been meaning to change them
for a while.

QAZ accepts the DOS standard wildcard characters ('*' and '?') although
the "undocumented" DOS wildcards are no longer supported.  However, the
asterisk ('*') need not be limited to the last character of a field: a
filespec such as "*READ*" is acceptable: this gives QAZ more flexibility
when handling filenames from non-DOS formats (Unix, Mac or Amiga).

Sets are also supported to a limited degree: "[abce]" is valid, as well
as "[a-e]" (ie, set-ranges). Not-sets (ie, "[^abc]" are supported to a
limited degree also.

QAZ does accept "not-specs", thus "^*.TXT" refers to all files but
"*.TXT" files.  (Note that if you use 4DOS, this will not work if the
COMPOUND specifier is set to '^'.)

Filespecs may be given in quotes, should you need to include spaces
for Macintosh filenames.  The filespecs are not case-sensitive.

(7) Meaning of the Options:
-----------------------------------------------------------------------
Following is a "quick-and-dirty" summary of the options. Since QAZ does
not write to any files (unless redirected) it's safe to play around with
them to get a feel for the program and even discover a few funky things
you can do wuth it.

QAZ also has an on-line help feature: use QAZ -H for a fast summary of
commands.

The option letters can be preceed by either a dash ('-') or a backslash
('/'), so use whichever you are most comforatble with. 

(8) Listing in ANSI Color                       -A[+|-]{ADILONR}={code}
-----------------------------------------------------------------------
Enables (-a+) or disables (-a-) ANSI codes for color (for in online/BBS 
usage). Requires a suitable ANSI-driver (like ANSI.SYS) to be installed
for the console or the device the output is being piped to.

Since QAZ v3.30a, ANSI colors can now be redefined:

  QAZ -A+                  Enables and resets colors to their defaults.
                    
  QAZ -Ax={code}           Defines field 'x' to 'code', where 'x' can be 
                           any of the following codes (defaults shown):

  QAZ -AL=1;40;37          Cutline to white
      -AN=1;40;33          Name to yellow
      -AD=1;40;32          Date/time to green
      -AR=1;40;35          Ratio to violet
      -AA=1;40;36          Archived to cyan
      -AO=1;40;31          Original to bright red
      -AI=1;40;34          Info to bright blue
  
The fields generally coincide with the all of the -V fields, except the
-VC comment, of course. Consult your DOS manual for more information on 
the ANSI escape codes.  QAZ requires only the numbers and no other ANSI 
commands.

(9) Bare Listing                                                -B[+|-]
-----------------------------------------------------------------------
Enables the bare listing format, similar to the /B switch in DOS DIR.
It can be used to generate picklists along with the -MQ option.

(10) Customize Miscellaneia (Character Codes)           -C[DLMTW]{code}
-----------------------------------------------------------------------
Changes the ASCII code for the cutline (-CL) or mark (-CM) characters: 
ie., use -CL61 for '=' as the cut-line (the lines separating the file-
listings from the field header and totals).  

The "code" may be a a decimal, hexidecimal, octal or binary number.
The following examples all set the mark character to an asterisk:

  QAZ -CM42                Sets the mark char to '*' (default is 0xfe).
      -CM$2a               (Same as above, in hexidecimal.)
      -CM0x2a              (Same as above, in hexidecimal.)
      -CM052               (Same as above, in octal.)
      -CM0b101010          (Same as above, in binary.)

  QAZ -CD{code}            Sets the date-separation character, which       
                           overrides the system's native country code
                           settings.  The -D option will use this as
                           the date-separator also.
      
      -CT{code}            Sets the time-separator character. Same as
                           -CD in that the country code settings and
                           what the -D and -DH options use us changed.
                   
      -CW{length}          Sets the length of the cut-line (same as
                           the -WL{length} option.

(11) Searching files by Date and-or Time             -D[H]{from}[,]{to}
-----------------------------------------------------------------------
Lists files between specified dates. The date is formatted based on -DF 
or native country-code settings of your machine, ie, MM-DD-YY, DD-MM-YY 
or YY-MM-DD, corresponding to the same format QAZ will output a listing 
of the archive as (also the same format generated by DOS DATE).

Giving a date (and-or time) with no comma tells QAZ to list only files
with that date.  A date before the comma gives an earliest date, and
after the comma the latest date.  In other words,

  QAZ -D{date}             Views all files in an archive with given date.
      -D{date},            Views all files dated given date and after.
      -D,{date}            Views all files dated up to given date.
      -D{from},{to}        Views all files dated between given dates.

      -D-                  Disables date filtering.
      
      -D+                  Views all files with today's date.
      -D+{age}             Views all files {age} days old
      -D+{age},            Views all files within {age} days old.

Times may also be appended to a date: -D7-4-91;12:37. The times may be
in 24-hour format or 12-hour with an 'a' or 'p' (as in 12:37p) after-
wards to indicate morning or evening.  If you like, you may put in a
value for the seconds field (ie, -D7-4-91;12:37:24) if you are sure of
the exact value.

Using the -DH option, you can set a separate filter for times (and not 
dates).

Multiple date-time filters are allowed.  Thus,

  QAZ FOO.LIB -D,5-1-92 -D3-23-93,4-27-93  
  
views all files in FOO.LIB dated before May 2, 1992 and files between 
March 23 and April 27, 1993 (using American-style date formats).

You may also use "verbose" month names with the -D filter:

  QAZ FOO.LIB -D,May-1-94

Note that QAZ expects European- and Japanese-style dates in the proper
format (same as numerical dates).

You may also use wildcard days-of-the-month: if you want to list all                  
files during January, 1992, you can use the following:

  QAZ FOO.LIB -D1-1-92,1-3292                           or,
  QAZ FOO.LIB -D1-?-92
                  
Reminder: the -D and -DH options expect the date and time formatted as
          it would appear in the output.  If the date is formatted to 
          DD/MM/YY and you use an option -Dmm-dd-yy then QAZ will find
          no files matching the given specs.

(12) Setting the Date Format                               -DF{DNSV012}
-----------------------------------------------------------------------
This option sets the format of the date shown by QAZ, as well as what
the -D filter expects as input (the default should resemble the native
country-code settings).

  QAZ -DFD                 Resets to the default settings.
      -DFN                 Shows the (English) name of the day-of-the-
                           week alongside the date.
      -DFV                 Enables "verbose" dates (the English name of
                           the month, rather than the numeral).
      -DFS                 Uses short years (YY instead of YYYY).
      -DF0                 Uses American-style dates (MM-DD-YYYY).
      -DF1                 Uses European-style dates (DD-MM-YYYY).
      -DF2                 Uses Japanese-style dates (YYYY-MM-DD).

Note that options can be combined: Using -DFS2 tells QAZ to use short,
Japanese-style dates. Use the -CD option to set the date-separator.

(13) Setting the Time Format                                  -DT[LMNS]
-----------------------------------------------------------------------
Similar to the -DF option, but sets the format of the time of day.

      -DTL                 Sets to long (HH:MM:SS) times (default).
      -DTM                 Sets to military (24-hour) time.
      -DTN                 Sets to natural (12-hour) time.
      -DTS                 Sets to short (HH:MM) times.

Note: -DTN will only enable 12-hour times disabled by -DF0, -DF1 or                  
      -DF2 switches.  -DTM will re-enable 23-hour times disabled by
      the -DTN switch.
                   
(14) Miscellaneous Formatting                               -F{BCFIPU-}
-----------------------------------------------------------------------
The option performs some miscellaneous formatting functions on the list.

  QAZ -F-                  Resets to defaults.
      -FC                  Clips (truncates) filenames.
      -FF                  Uses a two-line display of the archive file-
                           name (with full path) and archiver-type.
      -FI                  Identify directories and volume-labels in
                           ratio field.  Directories will be shown
                           without using -FP, if they are saved as
                           file entries in the archive.
      -FU                  Uses (U)Nix-style path and filenames, with
                           spaces changed to '.'.
      -FP                  Shows filename as Path+File.
      -FB                  Shows the path on a separate line.

Note: Truncated (with -FC) files will be marked unless the -MN (supress
notices) switch is used.

(15) Case Settings                                            -L[LSU+-]
-----------------------------------------------------------------------
Sets the case of filenames (and the output of the listings in general).

      -LL                  For lowercase filenames (same as -L+). 
      -LS                  For "case-sensitive" filenames: case is
                           shown as it appears in archive (default).
      -LU                  For uppercase filenames.

Note: when the case is changed, the file will be marked in the display
unless the -MN (supress notices) switch is used.

(16) Miscellaneous Functions                           -M{CDFINQSX03+-}
-----------------------------------------------------------------------
The operation mode and miscellaneous functions can be set with these
switches.

  QAZ -MD                  Restores defaults (same as -M-).
      -M0                  Tells QAZ *not* to use 32-bit instructions,
                           if run on an 80386/486+ processor.
      -MC                  Reneables CPU identification (use 32-bit
                           instructions if on the right processor).
      -M3                  Force use of 32-bit instructions.

      -ME                  Tells QAZ to use extended rather than conventional
                           memory. For listing archives with 1000 or so files
                           conventional memory is fine on a 640k system. For
                           larger archives, you'll need to enable EMS-Usage.
      
      -MV                  An alternative to the -ME option is to use a
                           "virtual disk" file. QAZ creates a temporary file
                           (in the TEMP or TMP directory) and uses this for
                           much of the work.
      
      -MF                  List forks in some Macintosh archives as
                           separate files with .data and .rsrc extentions.
      -MI                  Identify archive type only: don't list.
      -MN                  Supress notices/messages.             
      -MQ                  Quiet mode (no headers).
      -MS                  List only if selected filespecs are in archive             
                           (specs by name, -D, -DH, -I or -S filters).
      -MX                  For external "debug" mode.  The listing is in             
                           a set hexidecial output which external software
                           can easily read. When combined with the -RA and
                           -RA switches, allows for shells and catalogging
                           utilities to use QAZ powerfully.

Note: the -MT optio was removed from QAZ in v3.30.  To view a BinHex, AR7
or UU/XX-Encoded file, decode it into binary first and then use QAZ to
view it.

(17) Ordering (Sorting) the Listing                     -O[-]{ADNOPRST}
-----------------------------------------------------------------------
Sets the sorting-order of the file listing.

  QAZ -O-                  Disables sorting (natural order, default).
      -OO or -OS           Sort by original file size.
      -OA                  Sort by archived file size.
      -OD                  Sort by date-time stamp.
      -OT                  Sort by time-of-day only (not date).             
      -ON                  Sort by filename.
      -OR                  Sort by compression ratio.
      -OP                  Sort by pathname.
                   
Inserting a '-' before the field tells QAZ to reverse the sort order                   
(ie, QAZ FOO.LIB -O-N to sort names in descending order).

The -OE (sort by file extention) option has been removed in QAZ v3.40a
since it worked awkwardly for non-8.3 filenames, as well as changes in
the filespec handling for QAZ 3.41.
                   
(18) Load Picklists                                  -P[ADPV]{filename}
-----------------------------------------------------------------------
Tells QAZ to use various types of picklists.

  QAZ -PAfilename          Loads a list of archiver specs. Equivalent
                           to using QAZ @filename.
      -PPfilename          Loads a list of specs to use for files
                           within an archive.  Equivalent to using
                           QAZ archive @filename.
      -PDpathname          Loads a picklist of filenames and sizes from
                           the contents of a directory.  Similar to
                           using the following:

                                DIR pathname /B > picklist
                                QAZ archive -PP:picklist

                           Note that QAZ will also include file-sizes
                           with the -S switch as well.

      -PVfilename          Loads a "void-list" of files that QAZ won't
                           touch (in the case of fluke files which may
                           cause QAZ to crash).

Note that the -PVfilename option returns a flag when used with the -RI
option if a file matches the specs on that list: hence, -PV can also be
used to flag the presence of certain files (such as those that might be
listed in "The Hack Report" for some BBS auto-scanning systems).


(19) Loading Options                                        -POfilename
-----------------------------------------------------------------------
Works similar to the picklist (-P) options, except that a file contain-
ing preferred/default options rather than filespecs is loaded.  This is
useful for setting many options which will not fit on a command line
with the QAZCMD variable: it is recommended that you set the QAZCMD var
to -POfilename (ie, -POQAZ.SYS) instead.

The options can be separated by spaces or lines.  Comments are also  
allowed. (See the included QAZ.SYS file for an example.)

Note that filespecs cannot be included in option files: you must use
the appropriate @file, -PA, -PV or -PP picklist options.

(20) Return Code Options                                       -R[ACIV]
-----------------------------------------------------------------------
Tells QAZ to return an exit code of information about the file examined.

  QAZ -R-                  Disables informative return codes (default).
                           No exit code unless file is damaged or abort
                           from -EA option.
      -RA                  Returns a code of "flags" as to whether an
                           archive contained authenticity information,
                           passworded files, is self-extracting, etc.
      -RI                  Returns information identifying the archive
                           type so batch files or external utilities
                           can use QAZ.
      -RC                  Returns a count of the number of files (up
                           to 255) in the archive.
      -RV                  Returns the "version" of the archiver format.
                           
See the later sections of this document for more information on exit/
return codes from these options.

(21) Searching Files by Size                        -S[A]{low}[,]{high}
-----------------------------------------------------------------------
Filter files by size: similar in format to the -D filter, the -S filter
works by original file sizes.  The -SA filter works by archived file
sizes.
                   
  QAZ -S1,                 To view files >= 1 byte.
      -S10k,10k            To view files between 10k- and 16k-bytes.
      -S10240,16384        Same as above.
      -S17347              View files only of 17347 bytes.
      -S,1m                View files under 1-MByte (1024 k-bytes).
      -S,70384             To view files <= 70384 bytes.

Multiple size-ranges can be set in QAZ v3.30a and later. To list all files 
between 10k and 16k or 20k and 32k, use:

  QAZ FOO.LIB -S10k,16k -S20k,32k

The -SA (filter by archived file sizes) works exactly as the -S option.

The -S and -SA options can also accept binary, octal and hexidecimal 
numbers in the following forms:

  $1000                    4096 in hexidecimal
  0x1000                   Same as above
  0b1000                   16 in binary
  01000                    128 in octal [*]

[*] Note: a number preceeded by a '0' indicates to QAZ that it is an 
    octal (base-8) number.  (The exception is with the -D option.)

(22) Set the format of the Ratio                               -SR[0-3]
-----------------------------------------------------------------------
Set the format of the ratios (if viewed).
                   
  QAZ -SR0                 Default (bytes-per-byte ratio).
      -SR1                 for ZIP-style percent compressed.
      -SR2                 for LHARC-style percent of original.
      -SR3                 for bits-per-byte ratio.

(23) Viewing the Directory Tree                          -T[PFD]{depth}
-----------------------------------------------------------------------
View archive by directory tree structure (similar to the TREE command
in DOS).

  QAZ -T or -TP            To view directories.
      -TF                  To view all files and directories.
      -TDx                 To view depth down to x levels (ie, -TD2).

(24) Setting Search Options                    -U{ABDERSTVX} -UI{depth}
-----------------------------------------------------------------------
Sets miscellaneous search modes.

  QAZ -U-                  Default (no recursive searching).
      -UA                  Assume the first filespec is a data-file,
                           not an archive file to search.
      -UB                  Beep when done.
      -US                  Use predefined search specs for common archive
                           extentions.
      -UE                  Use search specs in QAZSPEC variable.
      -UR                  Recurse in subdirectories.
      -UD                  Recurse in all directories of drives C-Z.
      -UD[x-y]             Recurse in all directories of drives x-y.
      -UV                  Verbose search: displays name of directory
                           being searched.
      -UT                  Display approximate search time when done.
      -UX                  Search for files outside (eXternal to) of
                           archives as well.
                   
To search a disk drive for archives which contain a file, use:

  QAZ drive\ -URSV -MSI filespec

The -UD option was added in QAZ v3.33a to recursively search every disk 
drive from C: to Z:.  If a drive is not ready, QAZ will skip it and try 
to search the next one (The -UR switch need not be added with -UD):

  QAZ -UDSAV -MSI filespec

If you would like to change the search range of the -UD option to B: 
through G:, use the following:

  QAZ -UD[B-G]SAV -MSI filespec
                   
Since QAZ no longer requires the archive filespec to be the first argument 
on the command line, the -UA option will tell QAZ to assume that the first 
filespec is a spec to search for, not to search in (if the -UA option occurs
before the first filespec).

QAZ has the limited ability to recursively list archives that are stored 
(uncompressed) inside of other archives, using the -UI option to define 
the internal recursion level (default=0).  For example,

  QAZ FOOBAR.LIB -UI1 -MS

Note that this option only works for some archive formats at the time.
It is experimental and may change or be removed in future versions.

(25) Defining the View                                  -V{ACDHINOPRST}
-----------------------------------------------------------------------
Sets the "fields" to view on the archive, or enables viewing of archive
comments.

  QAZ FOO.LIB -VC          Tells QAZ to show the main archive comment,
                           if the comment is not compressed (as with
                           some formats like HPack, SQZ, etc.).

The -V option can also tell QAZ which "fields" to show in a regular
listing.  The default field is -VO-10A-11R_DT_N, which translates to
(from left to right) Original-size, Archived size, Ratio, Date, Time
and Filename.  The numbers indicate the field width, and the under-
scores tell QAZ to insert a space.

Negative field-widths (-nn) tell QAZ to right-justify the field.
Positive widths (+nn) tell QAZ to left-justify it.  Note that the
width *must* be a two-digit number.

An alternate might be -VN+24O+10A+10_DT

The codes are roughly equivalent to the fields used by the -A and -O
options:

  N                        FileName
  P                        File Path (if -FP option is not used).
  O                        Original Size
  A                        Archived Size
  R                        Ratio
  D                        Date
  T                        Time
  S                        CRC or CheckSum.
  I                        File attributes/Information.
  H                        Host Operating-System (if known/defined).

When fields are shown blank, it is usually because no information is 
defined for that field in the archive, (though in some cases it is 
because no documented information is known).

(26) Wide Listings                                              -W[+|-]
-----------------------------------------------------------------------
For a "wide" listing, of filenames only.  Normally five names per line,
unless filenames are longer, in which case the number per line will be
adjusted automatically.

If the system is in 132-column mode, than the "wide" output will be
adjusted accordingly.

(27) Line Width                                               -WL{code}
-----------------------------------------------------------------------
See the -CW option.

(28) Time Zone                                        -Z[+|-]{GMT-hour}
-----------------------------------------------------------------------
By default, QAZ assumes the time-zone is set in the TZ variable.  You
can manually change what QAZ assumes with this option, however.

  QAZ -Z+                  Use what's defined in TZ variable (default).
      -Z-                  Disable time-zone adjustments (use GMT).
      -Z5                  Sets time-zone to GMT-5 (EST).
      -Z8                  Sets time-zone to GMT-8 (PST)
      -Z-1                 Sets time-zone to GMT+1 (CET).

Useful for Unix or Mac formats which set the time relative to GMT.

(29) Attribute Filtering                                -I{^ADHPRSTVWX}
-----------------------------------------------------------------------
Lists only files which match (somewhat) the defined attributes. Pre-
ceeding an attribute with a carat ('^') tells QAZ *not* to list files
with that attribute set.

  A                        Archive, backup bit                   
  D                        Directory
  H                        Hidden
  P                        Password protected
  R                        File has read-access (*not Read-Only!)
  W                        File has write-access
  S                        File is a System file
  V                        Volume label
  X                        File has eXec attribute (Unix) or is an 
                           APPL (application--Mac).
  T                        File marked as "text" in archive.
  C                        File marked as a "comment"

Multiple attributes are allowable: ie, -IAHRW^D^V.  The default is to 
list all attributes.

(30) Pause between screens                                           -P
-----------------------------------------------------------------------
This option (-P by itself) tells QAZ to pause between screens, to make
viewing large archives easier WHEN USED ON THE HOST CONSOLE. The Pause
option WILL NOT work remotely (as from a BBS) since it waits for a key
directly from the keyboard, and not from STDIN.

The output will be slightly slower, since the output is checked for
newlines and wrap-arounds.

Most BBS's or remote-systems have built-in paging facilities, or some
sort of option for pausing between screens.  When using QAZ as an on-
line archive viewer, or when redirecting the output, DO NOT use this 
option!

QAZ attempts to determine the screen height when pausing. It has been 
tested with 25- 30- 43- and 50-line modes, as well as with 132-column
modes. For some modes or video cards this may not work properly, how-
ever.

(31) Tee output to file                               -Y[+-:]{filename}
-----------------------------------------------------------------------
An alternative to redirecting the output is to "tee" it to a file: thus
you can save the output to a file while still being able to view what
QAZ is doing in realtime (as with recursive searches).

The -P (pause) option does not affect the output of the -Y option.

Only one file may be tee'd to at a time.

If -Y:filename or -Y+filename is used, QAZ will append the output to
the file.  To clobber and existing file, use -Y-filename.

(32) Execute DOS Command if File is Found            -E[AVY-] "command"
-----------------------------------------------------------------------
This function tells QAZ to execute a DOS command if a file is found (ie
it matches the given search specs).  QAZ, if the memory is needed, will
(or should) swap to EMS, XMS or disk.

If an error occurs, QAZ will display a small error message.

  QAZ -E-                  Disables execution of external commands.
  QAZ -EA "command"        Aborts after command is executed, ends search.
  QAZ -EV "command"        Displays the command being executed.
  QAZ -EY "command"        Pipes output (for -P or -Y options).

Suppose you want to search your hard drives for an archive containing
the file LOST.TXT, and have QAZ copy it to the current directory:

  QAZ -UDAX -MSI -E "COPY !!" LOST.TXT

Note that the "!!" is a macro, signifying the name of the file. If the
file is found, or if an archive containing the file is found, they will
be copied to the current directory.

Note: a "bug" is that if QAZ copies the file to the current directory,
      and then continues searching and later finds the copied file in 
      the current directory, it will still run the given command: hence 
      the reason for the -EA option.

Assuming the command called does not prompt for input, you can have QAZ
pipe the command's output for the -P (pause) or -Y (tee) options using
the the -EY switch:

  QAZ *.LZH -EYV "LHA T !!"

Or, if you prefer, you can have QAZ load the command interpreter when
it finds a file:

  QAZ -UR -MSI -E "COMMAND" \*.* FOO.BAR

In the above case, QAZ searches the whole of the current drive for
archives which contain the file FOO.BAR.  When found, QAZ shells to
DOS.  (When done, you would type EXIT to return to QAZ.)

You could also use the -E option to create a list of archives contain-
ing a specified file.  The example below generates a list of archives
with the file "README.*":

  QAZ -UDA -MSIQ -E "ECHO !! >>FOUND.LST" README.*

Note: this option may not work under certain memory managers or system
      configurations, such as QEMM.

(33) Picklists                                                @filename
-----------------------------------------------------------------------
QAZ will read the file as a list of filespecs to use. If it is the first 
non-option argument, QAZ will assume it is a list of archiver-specs.  If 
as any other argument, QAZ will assume it is a list of specs for within 
the file.

Examples,

  QAZ @ARCHIVES.LST
  QAZ C:\ @SEARCH.LST -MSNI -UBRSV

You may also use the -PA and -PP options as equivalents.

(34) Setting the Default Options
-----------------------------------------------------------------------
Environment variable of default options. Use,

  SET QAZCMD=[options]

ie., 

  SET QAZCMD=-LS -FFCB -DFS
  SET QAZCMD=/POQAZ.SYS

(35) Setting Extra Archive Specifications
-----------------------------------------------------------------------
Specs for use with -UE option. ie.,

  SET QAZSPEC=*.SDN *.[7S]PL

Useful for obscure filespecs not included with the -US option.

In QAZ v3.33a, you can also define secondary filespecs from the command 
line by preceeding it with a backwards single-quote. Note a restriction 
is that the spec have the same path as the primary filespec. 

For example, to examine all ZIP and ARJ files in the current directory, 
use:

  QAZ *.ZIP `*.ARJ

Note also that `@PICK.LST is equivalent to -paPICK.LST

(36) Default QAZSPECs with the -US Option
-----------------------------------------------------------------------

*.??Z      Unix Compress/GZip     *.AR[CJK]   ARC/PKARC/PKPAK/ARJ
*.CP[TZ]   CompactPro/CPShrink    *.DWC       DWC
*.EXE      DOS Self-Extractors    *.GZ        GZip
*.HA       HA                     *.H[AY]P    Hamarsoft HAP/Hyper
*.[HZ]PK   HPack or Zi-Lite       *.ICE       ReeveSoft Freeze/LHIce
*.LHA      LHArc (Amiga)          *.[PS]IT    PackIt/StuffIt
*.L[AB]R   Novosielski Libraries  *.LI[BFM]   CoDec/Knowledge Dynamics/Limit
*.LZ[HS]   LHArc/LArc             *.[CM]D     MDCD
*.PAK      PAK/LHArc/Zip          *.SEA       Mac Self-Extracting Archives
*.SHK      ShrinkIt/NuFX          *.SQZ       Squeeze-It/FOXSQZ
*.[RST]AR  RAR/SAR/TAR            *.[MQVYZ]   Voof/Quant./Yabba/Compr./GZip
*.ZIP      Zip                    *.ZOO       Zoo
*.AMG      AMG

Use a picklist or set the QAZSPEC variable to add extra specifications.

Only use the -US option when doing searches, *not* for normal listings
as a default: otherwise every matching filespec in the given directory
will be listed!

Note that in some cases it may be faster to search all files (*.*)
rather than use a large set of picklist specifications.

(37) QAZPATH
-----------------------------------------------------------------------
                   Path for qaz files, default is same path as QAZ.EXE.

                   if QAZ cannot file the -P[AOPV].. files in the current
                   (or given) path, QAZ checks the QAZPATH for the file.


(38) Return Codes given by the -RI option
-----------------------------------------------------------------------
When using the -RI option, QAZ will return an exit code indicating the file 
type.  External programs (such as batch files) can use this information to 
determine what utilities to use on the file.

The following is a list of the return codes:

        Code            Meaning (or archive type)          QAZ Version
        ----            ------------------------           -----------
          0             Unknown file type
          1           * An error has occured (possibly a bad archive)
          2             Memory overflow

         15           * Unidentified/Miscellaneous (Reserved)
         16             Possibly an ASCII (7-bit) text file

         17             AR (Use AR or LHA-compatable)
         18           * AR7 - no longer recognized as of QAZ v3.30a                                           
         19             ARC - v6 or earlier
         20             ARJ
         21             Unix Compress (v4)
         22             Compact Pro                       
         23             Central Point Shrink (CPSHRINK)
         24             Diet (v1)
         25             DWC
         26             MiscroSoft Compress (Use EXPAND)
         27             Unix Freeze (v2)
         28             GNU-Zip
         29             HA
         30             Hamarsoft HAP
         31             Hyper
         32             HPack                                          
         33             ReeveSoft Freeze v1.0 (for Windows)
         34           * (Reserved) 
         35             KBoom (v1.1) File
         36             Novosielski Libraries (LBR files)  
         37           * LArc (Amiga .LHA - Use LHArc)
         38             Knownledge Dynamics Archive         
         39             LHARC
         40             PAK Archive
         41             PGP-Encrypted (v2 or 2.6)
         42             PackIt                              
         43           * PUT (Use LHA-compatable)
         44             Queasy Archive
         45             Slim File
         46             StuffIt! Archive                             
         47             Squeeze-It! (.SQZ) Archive
         48             UltraCompressor II (.UC2)                     
         49             CP/M Squeeze (SQ,SQPC) File
         50             Zip
         51             Zoo
         52             Zi-Lite/ZPack (Usu. SFX)           
         53             Unix Tape Archive (.tar)
         54             SAR
         55             CoDec                             
         56             JRchive                            
         57             LArc (Use LHArc to decompress)     
         58           * BinHex 4.0 - no longer recognized as of QAZ v3.30a                        
         59           * Mac Self-Extracting Archive
         60             Mac DiskDoubler Archive            
         61           * (Reserved)
         62             AMG Archive                        
         63             LIMIT Archive                      
         64             Yabba File                                     
         65             NuFX (ShrinkIt!) Archive                       
         66             MDCD Archive                                   
         67             Splint File                        - QAZ v3.09c
         68             RAR Archive (v1.40.2 or earlier)   - QAZ v3.20a
         69             PowerPacker File                   - QAZ v3.21a
         70             Voof File                          - QAZ v3.30a
         71             7PLUS File                         -  "     "
         72             RAR Archive (v1.50.1 or later)     -  "     "
         73             PKARC/PKPAK Archive (ARC)          -  "     "
         74             ARC (v7.0+)                        -  "     "
         75             SQWEZ (usu. SFX)                   -  "     "
         76             Crush Archive (uncompressed)       - QAZ v3.41
         77             SonArc File                        - QAZ v3.54a
         78             AIN Archive                        -  "     "
         79           * SWFTE TTComp File                  -  "     "
         80             Quantum Archive                    -  "     "
         81             Flash Libraries                    - QAZ v3.60a
         82             COM-Pak Executable-Libraries       -  "     "
         83             XEQ Extecutable Libraries          -  "     "
         84             FOXSQZ (aka DOSSQZ) Archive        -  "     "

        128 .. 140    * Formerly Graphics formats prior to
                        QAZ v2.60a.  They are no longer
                        recognized by QAZ.

        254             Filename is in -PVfile list                    
        255             Syntax Error (Bad Option)

Note: Formats marked with an asterisk (*) are reserved for future versions 
      of QAZ.  Formats marked with a version number are not returned by 
      earlier versions of QAZ.
                      
To suppress output using the -R switch, one can do either of the
following:
                      
      QAZ archname -RI -MQ ^*
      QAZ archname -RI -MQI
      QAZ archname -RI > NUL

For an example of how to use the -R switch from a batch file, look at the 
included file XQAZ.BAT. This file uses QAZ to identify the archive type and 
then attempts to unarchive the file.

(39) Return Codes given by the -RA option
-----------------------------------------------------------------------
Added in this version of QAZ is the -RA option which will return an exit 
code if the file contains authentication information, password-protected 
files or is part of a multi-volume archive. 

(Check the included QAUTH.BAT file.)

In other words, if QAZ returns an exit-code other than 0 for -RA then one 
probably does not want automated system utilities to tamper with the file,  
but have it saved for later examination (if you are a SysOp, for example).

The codes returned by -RA are:

        Bit 0 set (1)   =  Archive may contain AV info.
        Bit 1 set (2)   =  Archive may contain encrypted files.
        Bit 2 set (4)   =  Archive may be part of multi-volume.
        Bit 3 set (8)   =  Self-Extracting archive (DOS).
        Bit 4 set (16)  =  NonDOS "8.3" filenames (QAZ v3.11a or later)
        Bit 5 set (32)  =  Archive in "unit" mode (QAZ v3.31a or later)

        Bit 7 set (128) =  Archive may be damaged.

QAZ v2.60a will no longer return an exit code of 0x01 for the -RI option if 
the archive is damaged, but instead return the identifying code. Use the -RA 
switch to determine if an archive may be damaged.

The -RA option can be used by automated BBS software to check files before 
attempting to convert archive formats or to insert advertisement files. If 
a non-zero value is returned, the SysOp should save the file for later exam-
ination. (Unfortunetly, standard DOS batch files are not capable of perform-
ing sophisticated checks of error-levels.)

(40) Return Codes given by the -RV option
-----------------------------------------------------------------------
This option will return a version number of the archive, with the major
version in the most-significant nibble and the minor version in the least.
In pseudo code:

        exec("qaz.exe " .... " -rv");
        x = exitcode;
        major_version = x div 16;
        minor_version = x mod 16;

The major version should be a number from 0..14.  If it is 15, then it
is unknown.  The minor version should be a number from 0..9. If it is
15, then the minor version is unknown.


(41) Thanks & Ackowledgements
-----------------------------------------------------------------------
This is a partial listing of people who've tested, commented on, con-
tributed information, requested copies, reported bugs, sent software 
to me, crashed their systems in beta-tests, or replied to requests:

  Alan Barclay, John Bragazzi, Jonathan Burt, Roger Burton-West, 
  Timm Erickson, Harald Feldmann, Jeff Gilchrist, Peter Gutmann, 
  Hari Hirvola, Jack Hudgions, Joe Jerszynski, Rob Jung, Todd Kempf,
  Doug Macintosh, Joe Negron, Brian Niegocki, Eugene Roshal,
  Walter Scott, Andrey Spasibozhko, Jorj Strumolo, Sean Turner,
  Nico de Vries, and others...


(42) More Miscellanea, the -MX option:
-----------------------------------------------------------------------
QAZ was originally conceived as a test-utility for an as-yet-unwritten
disk catalog program because I have many archives in a variety of formats.
Hence it became an altogether seperate utility.

The -MX option was added to that other programs can shell out and use
QAZ to identify and generate a "standardized" listing.  So feel free to
write utilities that make use of this feature.

The -MX option outputs the listing in hexidecimal: original size,
compressed/archived size, DOS-attributes, DOS-timestamp, CRC, and
full path.

An example output using the -MXQ option on an archive:

0000022e 0000014b 0020 128ab845 8fe9e874 \README
000030ef 000013aa 0020 1289ac3d 1aed42f4 \COMPRESS.TXT
00002c18 00000ce0 0020 128ab6e8 22454edf SRC\LZSS.C
000040b2 000010cc 0020 1289ac85 4aef3fc1 SRC\LZARI.C
00004fcb 000010e6 0020 1289ad0f 91feb024 SRC\LZHUF.C

The -MX option does not return Host-OS information.

Assume that these are not "absolute" paths.  Files in the current
path are always preceeded by a backslash while subdirectories are
not.

(43) Other Stuff...
-----------------------------------------------------------------------
For detailed information on revision-history or which file-formats QAZ
can recognize, check the WHATSNEW.TXT and WHICHARC.TXT files included
in the release, respectively.


