#ifndef SEE_H
#define SEE_H

#include <crblib/inc.h>
#include <crblib/arithc.h>

typedef struct Context Context;

typedef struct SeeState SeeState;
typedef struct See See;

See *	See_Create(void);
void	See_Destroy(See * see);

SeeState * See_GetState(See * see,uint escapeCount,uint totSymCount,ulong cntx,int order,int numSyms,const Context * context);

void 	See_EncodeEscape(See *see,arithInfo * ari,SeeState * ss,uint escapeCount,uint totSymCount,bool escape);
bool 	See_DecodeEscape(See *see,arithInfo * ari,SeeState * ss,uint escapeCount,uint totSymCount);

void	See_AdjustState(See *see,SeeState *ss,bool escape);

uint	See_GetEscapeP(See *see,SeeState *ss,uint escapeCount,uint totSymCount);

#endif // SEE_H

