#ifndef PPMDET_H
#define PPMDET_H

#include <crblib/inc.h>
#include <crblib/arithc.h>
#include "exclude.h"
#include "context.h"

typedef struct PPMDet PPMDet;

PPMDet * PPMDet_Create(uint Megabytes);

void PPMDet_Destroy(PPMDet * det);

void PPMDet_Update(PPMDet * det,ubyte * backPtr,ubyte *backBase,int sym);

bool PPMDet_Encode(PPMDet * det,arithInfo * ari,
								ubyte * backPtr,ubyte *backBase,int sym,Exclude *exc,Context *context,bool * pUseFull);
bool PPMDet_Decode(PPMDet * det,arithInfo * ari,
								ubyte * backPtr,ubyte *backBase,int *psym,Exclude *exc,Context *context,bool * pUseFull);

uint PPMDet_GetMPSP(PPMDet * det,ubyte * backPtr,ubyte *backBase,Context *context);

#endif // PPMDET_H

