#include "minusone.h"

/*******

order (-1) coder

totally flat probabilities with exclusions

*********/

void encodeOrderMinusOne(uint sym,uint numChars,arithInfo * ari,Exclude * exclude)
{
uint low,tot,i;

	assert( ! isExcluded(exclude,sym) );

	low = 0;
	for(i=0;i<sym;i++)
	{
		if ( ! isExcluded(exclude,i) ) low++;
	}
	tot = low+1;
	for(i=sym+1;i<numChars;i++)
	{
		if ( ! isExcluded(exclude,i) ) tot++;
	}

	arithEncode(ari, low,low+1,tot);
}

uint decodeOrderMinusOne(uint numChars,arithInfo * ari,Exclude * exclude)
{
uint target,i,sym,tot;

	tot = 0;
	for(i=0;i<numChars;i++)
	{
		if ( ! isExcluded(exclude,i) ) tot++;
	}

	target = arithGet(ari,tot);
	arithDecode(ari,target,target+1,tot);

	sym = 0;
	for(;;)
	{
		while( isExcluded(exclude,sym) )
			sym++;
		if ( target == 0 )
			break;
		target--;
		sym++;
	}

return sym;
}

static uint textCharCounts[257] = {
   23,    0,    0,    0,    0,    0,    0,    0,
    3,   59,  397,    0,    0,   13,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   26,    0,    0,    0,    0,
 2249,   23,   39,    5,   17,   37,    1,   65,
   65,   57,   15,   16,  146,  108,  211,   11,
   58,   65,   39,   25,   21,   21,   21,   20,
   24,   23,   41,   58,   10,   17,   16,    8,
   10,   39,   22,   34,   24,   26,   18,   12,
   27,   57,   12,   14,   20,   27,   22,   18,
   29,    2,   24,   33,   52,   15,    6,   12,
    6,    5,    1,   37,   45,    8,    1,    7,
    3,  790,  162,  337,  389, 1273,  238,  202,
  497,  728,   13,   73,  426,  278,  739,  758,
  242,   16,  625,  682,  895,  312,  102,  179,
   47,  178,   16,    5,    3,    5,   17,    0,
    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,
	1 // the escape
};


void encodeOrderMinusOneText(uint sym,arithInfo * ari,Exclude * exclude)
{
uint low,high,tot,i;

	assert( ! isExcluded(exclude,sym) );

	if ( ! textCharCounts[sym] )
	{
		// send an escape
		low = 0;
		for(i=0;i<256;i++)
		{
			if ( ! isExcluded(exclude,i) )
				low += textCharCounts[i];
		}
		tot = high = low + textCharCounts[256];

		arithEncode(ari, low,high,tot);

		encodeOrderMinusOne(sym,256,ari,exclude);
	}
	else
	{

		low = 0;
		for(i=0;i<sym;i++)
		{
			if ( ! isExcluded(exclude,i) )
				low += textCharCounts[i];
		}
		tot = high = low + textCharCounts[sym];
		for(i=sym+1;i<256;i++)
		{
			if ( ! isExcluded(exclude,i) )
				tot += textCharCounts[i];
		}
		tot += textCharCounts[256];

		arithEncode(ari, low,high,tot);
	}
}

uint decodeOrderMinusOneText(arithInfo * ari,Exclude * exclude)
{
uint low,target,i,sym,tot;

	tot = 0;
	for(i=0;i<256;i++)
	{
		if ( ! isExcluded(exclude,i) )
			tot += textCharCounts[i];
	}
	tot += textCharCounts[256];

	target = arithGet(ari,tot);

	sym = low = 0;
	for(;;)
	{
		while( isExcluded(exclude,sym) )
			sym++;
		assert( sym < 257 );
		if ( textCharCounts[sym] )
		{
			if ( target < textCharCounts[sym] )
				break;
			low += textCharCounts[sym];
			target -= textCharCounts[sym];
		}
		sym++;
		if ( sym == 256 )
			break;
	}

	assert( sym < 257 );
	assert( textCharCounts[sym] > 0 );
	assert( ! isExcluded(exclude,sym) );

	arithDecode(ari,low,low + textCharCounts[sym],tot);

	if ( sym == 256 )
	{
		for(i=0;i<256;i++)
		{
			if ( textCharCounts[i] && ! isExcluded(exclude,i) )
				setExcluded(exclude,i);
		}

		sym = decodeOrderMinusOne(256,ari,exclude);
	}	

return sym;
}
