#include "loe.h"
#include "config.h"
#include <crblib/intmath.h>

#define DO_LOE_PENALIZE_NONDET // yep this helps; it's freaky

/*********

todo : weight between several LOE schemes based on performance

eg. rating = LOE_success1 * rating1 + ...

**********/

//------------------------------------------------------
// LOE_ChooseOrder

int LOE_ChooseOrder(Context ** contexts,ulong cntx,int maxOrder,Exclude * exc,See *see,bool useFull)
{
int choseRating,choseOrder;
int rating,order;

	if ( PPMZ2_LOEType == LOETYPE_NONE )
		return maxOrder;

	choseOrder  = 0;
	choseRating = 0;

	for(order=maxOrder;order>=0;order--)
	{
	Context * c;
	ContextData * cd;
	int largestCount,totCount,escapeCount;
	SeeState * ss;

		if ( order == 0 && choseRating == 0 )
			return 0; //early out; this is our only choice

		c = contexts[order];

		if ( ! c || c->full.totSymCount == 0 )
		{
			assert( c->upex.totSymCount == 0 );
			continue;
		}

		if ( useFull && Context_ChooseFull(c,exc,see,cntx) )
			cd = &(c->full);
		else
			cd = &(c->upex);
		
		ContextData_GetExcludedInfo(cd,exc,&totCount,&largestCount,&escapeCount);
		
		if ( totCount == 0 )
			continue;

		assert( largestCount >= 0 );


		#ifdef DO_LOE_PENALIZE_NONDET
		// ask if its det before exclusion or after?
		//  doesn't seem to make much difference
		if ( cd->numSyms > 1 ) // this is before
		//if ( largestCount != totCount ) // this is after
		{
			totCount += escapeCount;
		}
		// note : this makes us a use a different seeState for LOE than we do for coding!
		#endif

		if ( totCount < escapeCount )
			ss = NULL;
		else
			ss = See_GetState(see,escapeCount,totCount,cntx,order,cd->numSyms,c);

		//cd->loeSeeState = ss; //(disabled, see codecntx.c)

		if ( PPMZ2_LOEType == LOETYPE_MPS )
		{
			rating = ((PPMZ2_IntProb_One - See_GetEscapeP(see,ss,escapeCount,totCount))
						* largestCount ) / totCount;
		}
		else 
		{
		int MPSP,MPSB;

			// a little pseudo-entropy
			// better on some files

			// <> todo : track performance of various LOE schemes & make a weighted rating :
			//	full_rating = Sum[i] weight(i) * rating(i)

			MPSP = ((PPMZ2_IntProb_One - See_GetEscapeP(see,ss,escapeCount,totCount))
						* largestCount ) / totCount;

			assert( MPSP > 0 && MPSP < PPMZ2_IntProb_One );

			MPSB = ((PPMZ2_IntProb_Shift<<4) - ilog2x16(MPSP)); // = 16 * log(1/MPSP)
			rating = MPSP * MPSB + ( PPMZ2_IntProb_One - MPSP ) * 128;
			rating = INT_MAX - rating;
		}

		if ( rating > choseRating )
		{
			choseRating = rating;
			choseOrder = order;
		}
	}

return choseOrder;
}
