#include <crblib/inc.h>
#include "exclude.h"

typedef ubyte excludeType;

#define resetVal ((excludeType)(~((excludeType)0)))

struct Exclude
{
	uint numChars;
	uint counter;
	uint tablePaddedLen;
	excludeType * table;
	bool anySet;
};

bool Exclude_IsEmpty(Exclude *E)
{
	return ! E->anySet;
}

Exclude * Exclude_Create(int numChars)
{
Exclude * E;

	E = new(Exclude);
	if ( E == NULL )
		return NULL;

	E->tablePaddedLen = sizeof(excludeType)*numChars;
	E->tablePaddedLen = (E->tablePaddedLen + 31)&(~31);
	
	if ( (E->table = malloc(E->tablePaddedLen)) == NULL )
	{
		destroy(E);
		return(NULL); 
	}
	
	E->numChars = numChars;
	
	Exclude_Reset(E);

return(E);
}

void Exclude_Reset(Exclude * E)
{
	memclear(E->table,E->tablePaddedLen);
	E->counter = 1;
	E->anySet = false;
}

extern void Exclude_Destroy(Exclude * E)
{
	destroy(E->table);
	destroy(E);
}

void Exclude_Clear(Exclude * E)
{
	E->counter ++;
	E->anySet = false;
	if ( E->counter == resetVal )
		Exclude_Reset(E);
}

void Exclude_Set(Exclude * E,int sym)
{
	E->table[sym] = E->counter;
	E->anySet = true;
}

bool Exclude_Test(Exclude * E,int sym)
{
	return ( (bool) ( E->table[sym] == E->counter ) );
}
 
