#ifndef CONTEXT_H
#define CONTEXT_H

#include <crblib/inc.h>
#include <crblib/list.h>
#include "see.h"
#include "exclude.h"

typedef struct Context Context;
typedef struct ContextNode ContextNode;
typedef struct ContextData ContextData;

struct ContextNode
{
	ContextNode * next;
	uword sym,count;
};

/***

sisters, parent & child make this a 3-branch tree :

(n->child->parent == n) ; parent is just redundant

to find the child you want, step onto the child pointer, then
 walk the sisters till you get the ->index you seek

all sisters have the same parent

(semi-hack : the child pointer of the deepest node is actually a PPMDet context!)

***/

struct ContextData
{
	int escapeCount,numSyms,totSymCount,lastSym,largestCount;
	ContextNode * syms;

	SeeState *seeState; //,*loeSeeState;
};

struct Context
{
	LinkNode sisters; //must be at head of struct
	uint index; // to get to me
	int order;
	Context * parent;
	Context * child;

	ContextData upex;
	ContextData full; // <> seems pointsless

	LinkNode LRU;
};

/*******/

Context * Context_Create(Context * parent,uint index);
void Context_Destroy(Context * c);
void Context_DestroyAllContexts(void); // global & naughty, but oh-so-fast

Context * Context_Find(Context *parent,ulong index);

void Context_Update(Context * c ,int sym, ulong cntx, See *see, int codedOrder);

void Context_Halve(Context * c);

ContextNode * ContextNode_Create(void);
void ContextNode_Destroy(ContextNode * n);

void ContextData_Update(ContextData * cntx ,int sym, int order, ulong index, See *see,Context *context);
void ContextData_Halve(ContextData * cntx);

void ContextData_GetExcludedInfo(ContextData *cd,Exclude *exc,int *pTotCount,int *pLargestCount,int *pEscapeCount);

bool Context_ChooseFull(Context *c,Exclude *exc,See *see,ulong cntx);

void ContextData_AddCounts(ContextData *cntx,uint sym,uint count); // does *not* scale down after adding; call Normalize
void ContextData_Normalize(ContextData *cntx);

uint ContextData_GetCodeLen(ContextData *cd,uint sym,int order,ulong index,See * see,
										Context *cntx,Exclude *exc);

#endif // CONTEXTS_H
