#include "codecntx.h"

// if a symbol of count < Novel is excluded, should we subtract from the escape?
//	I think not, since DONT_SEE_EXCLUDED failed

//#define DO_USE_LOE_SEESTATE  // hurts alot ;
								// it should, since LOE does the penalize NonDet
								//	which should be an loe-only thing, not a coding thing

bool CodeContext_EncodeFromContext(arithInfo *ari,Context *cntx,Exclude *exc,See *see,ulong index,int sym,bool * pUseFull)
{
int low,high,tot;
int largest,escape;
ContextNode * n;
SeeState *ss;
ContextData * cd;

	assert( ! isExcluded(exc,sym) );

	if ( cntx->full.totSymCount == 0 )
	{
		assert( cntx->upex.totSymCount == 0 );
		return false;
	}

	if ( *pUseFull && Context_ChooseFull(cntx,exc,see,index) )
		cd = &(cntx->full);
	else
		cd = &(cntx->upex);

	assert( cd->totSymCount > 0 );

	*pUseFull = false; //@@ do this?

	ContextData_GetExcludedInfo(cd,exc,&tot,&largest,&escape);

	if ( tot == 0 ) // no chars unexcluded
		return false;

	low = high = 0;

	for(n = cd->syms;n;n=n->next)
	{
		assert( n->count > 0 );
		if ( ! isExcluded(exc,n->sym) )
		{
			if ( n->sym == sym )
			{
				// found it :
				high = low + n->count;
				assert( high > 0 );
			}
			else if ( high == 0 )
			{
				low += n->count;
			}

			setExcluded(exc,n->sym);
		}
	}

	assert( tot < ari->probMax && high <= tot );

	#ifdef DO_USE_LOE_SEESTATE //{
	ss = cd->loeSeeState;
	#else //}{
	if ( escape > tot ) ss = NULL;
	else ss = See_GetState(see,escape,tot,index,cntx->order,cd->numSyms,cntx);
	#endif //} DO_USE_LOE_SEESTATE 

	if ( high )
	{
		// found it
		See_EncodeEscape(see,ari,ss,escape,tot,false);
		arithEncode(ari,low,high,tot);
		return true;
	}
	else
	{
		See_EncodeEscape(see,ari,ss,escape,tot,true);
		return false;
	}

}

bool CodeContext_DecodeFromContext(arithInfo *ari,Context *cntx,Exclude *exc,See *see,ulong index,int *psym,bool * pUseFull)
{
int low,got,tot,escape,largest;
ContextNode * n;
SeeState *ss;
ContextData * cd;

	if ( *pUseFull && Context_ChooseFull(cntx,exc,see,index) )
		cd = &(cntx->full);
	else
		cd = &(cntx->upex);

	if ( cd->totSymCount == 0 )
		return false;

	*pUseFull = false; //@@

	ContextData_GetExcludedInfo(cd,exc,&tot,&largest,&escape);

	if ( tot == 0 ) // no chars unexcluded
		return false;

	#ifdef DO_USE_LOE_SEESTATE //{
	ss = cd->loeSeeState;
	#else //}{
	if ( escape > tot ) ss = NULL;
	else ss = See_GetState(see,escape,tot,index,cntx->order,cd->numSyms,cntx);
	#endif //} DO_USE_LOE_SEESTATE 

	if ( See_DecodeEscape(see,ari,ss,escape,tot) )
	{
		n = cd->syms;
		while(n)
		{
			setExcluded(exc,n->sym);
			n = n->next;
		}
		return false;
	}

	assert( tot < ari->probMax );

	got = arithGet(ari,tot);
	
	low = 0;

	n = cd->syms;
	while(n)
	{
	int high;
		assert( got >= low );
		if ( ! isExcluded(exc,n->sym) )
		{
			high = low + n->count;
			if ( got < high )
			{
				// found it;

				arithDecode(ari,low,high,tot);
				*psym = n->sym;
				return true;
			}
			low = high;
		}
		n = n->next;
	}

	assert(0); // !! should not get here!
return false;
}
