.\" $Id: cpio.man,v 2.0.0.0 89/10/30 07:37:25 mark Exp Locker: mark $
.TH CPIO 1 "Minnetech Consulting, Inc." ""
.SH NAME
cpio \- copy file archives in and out
.SH SYNOPSIS
.B cpio
.BR \-o [ Bacv ]
.br
.B cpio
.BR \-i [ Bcdfmrtuv ]
.RI [ pattern... ]
.br
.B cpio
.BR \-p [ adlmruv ]
.I directory
.SH DESCRIPTION
The
.B cpio
utility produces and reads files in the format specified by the
.B cpio
.B "Archive/Interchange File Format"
specified in
.IR "IEEE Std. 1003.1-1988" .
.PP
The
.B "cpio -i"
(copy in) utility extracts files from the standard input, which is
assumed to be the product of a previous
.B "cpio -o" .
Only files with names that match
.I patterns
are selected.
Multiple
.I patterns
may be specified and if no
.I patterns
are specified, the default for
.I patterns
is \*, selecting all files.
The extracted files are conditionally created and copied into the
current directory, and possibly any levels below, based upon the
options described below and the permissions of the files will be those
of the previous
.B "cpio -o" .
The owner and group of the files will be that of the current user
unless the user has appropriate privileges, which causes
.B cpio
to retains the owner and group of the files of the previous
.B "cpio -o" .
.PP
The 
.B "cpio -p"
(pass) utility reads the standard input to obtain a list of path names
of files that are conditionally created and copied into the
destination
.I directory 
based upon the options described below.
.PP
If an error is detected, the cause is reported and the
.B cpio
utility will continue to copy other files.
.B cpio
will skip over any unrecognized files which it encounters in the archive.
.PP
The following restrictions apply to the 
.B cpio
utility:
.IP 1 .25i
Pathnames are restricted to 256 characters.
.IP 2 .25i
Appropriate privileges are required to copy special files.
.IP 3 .25i
Blocks are reported in 512-byte quantities.
.SS Options
The following options are available:
.TP .5i
.B \-B
Input/output is to be blocked 5120 bytes to the record.
Can only be used with
.B "cpio -o" 
or
.B "cpio -i"
for data that is directed to or from character special files.
.TP .5i
.B \-a
Reset access times of input files after they have been copied.
When the
.B \-l
option is also specified, the linked files do not have their access
times reset.
Can only be used with
.B "cpio -o"
or
.B "cpio -i" .
.TP .5i
.B \-c
Write header information in ASCII character for for portability.
Can only be used with
.B "cpio -i"
or
.B "cpio -o" .
Note that this option should always be used to write portable files.
.TP .5i
.B \-d
Creates directories as needed.
Can only be used with 
.B "cpio -i" 
or
.B "cpio -p" .
.TP .5i
.B \-f
Copy in all files except those in
.I patterns .
Can only be used with
.B "cpio -i" .
.TP .5i
.B \-l
Whenever possible, link files rather than copying them.
Can only be used with 
.B "cpio -p" .
.TP .5i
.B \-m
Retain previous modification times.
This option is ineffective on directories that are being copied.
Can only be used with
.B "cpio -i" 
or
.B "cpio -p" .
.TP .5i
.B \-r
Interactively rename files.
The user is asked whether to rename
.I pattern
each invocation.
Read and write permissions for
.B "/dev/tty"
are required for this option.
If the user types a null line, the file is skipped.
Should only be used with
.B "cpio -i"
or
.B "cpio -o" .
.TP .5i
.B \-t
Print a table of contents of the input.
No files are created.
Can only be used with
.B "cpio -i" .
.TP .5i
.B \-u
Copy files unconditionally; usually an older file will not replace a
new file with the same name.
Can only be used with
.B "cpio -i"
or
.B "cpio -p" .
.TP .5i
.B \-v
Verbose: cause the names of the affected files to be printed.
Can only be used with
.B "cpio -i" .
Provides a detailed listing when used with the 
.B \-t
option.
.SS Operands
The following operands are available:
.TP 1i
.I patterns
Simple regular expressions given in the name-generating notation of the
shell.
.TP 1i
.I directory
The destination directory.
.SS "Exit Status"
The
.B cpio
utility exits with one of the following values:
.TP .5i
0
All input files were copied.
.TP .5i
2
The utility encountered errors in copying or accessing files or
directories.
An error will be reported for nonexistent files or directories, or
permissions that do not allow the user to access the source or target
files.
.SS
It is important to use the
.B "-depth"
option of the
.B find
utility to generate pathnames for 
.B cpio .
This eliminates problems
.B cpio
could have trying to create files under read-only directories.
.PP
The following command:
.RS
ls | cpio -o > ../newfile
.RE
copies out the files listed by the 
.B ls
utility and redirects them to the file
.B newfile .
.PP
The following command:
.RS
cat newfile | cpio -id "memo/al" "memo/b*"
.RE
uses the output file
.B newfile
from the
.B "cpio -o"
utility, takes those files that match the patterns
.B "memo/al"
and
.B "memo/b*" ,
creates the directories below the current directory, and places the
files in the appropriate directories.
.PP
The command
.RS
find . -depth -print | cpio -pdlmv newdir
.RE
takes the file names piped to it from the
.B find
utility and copies or links those files to another directory
named
.B newdir ,
while retaining the modification time.
.SH FILES
.TP 1i
/dev/tty
used to prompt the user for information when the
.B \-i 
or 
.B \-r
options are specified.
.SH "SEE ALSO"
find(1), pax(1), tar(1), cpio(5), tar(5)
.SH COPYRIGHT
Copyright (c) 1989 Mark H. Colburn.  
.br
All rights reserved.
.PP
Redistribution and use in source and binary forms are permitted
provided that the above copyright notice is duplicated in all such 
forms and that any documentation, advertising materials, and other 
materials related to such distribution and use acknowledge that the 
software was developed by Mark H. Colburn.
.PP
THE SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
.SH AUTHOR
Mark H. Colburn
.br
Minnetech Consulting, Inc.
.br
3232 Aquila Lane
.br
St. Louis Park, MN 55426
.sp
mark@Minnetech.MN.ORG

