





//	This source and compression method apply to GNU General Public License. 
//			Copyright (C) 2008 , 2009 , 2010 and later by Jasenko Dzinleski 

//		This program is free software; you can redistribute it
//	and/or modify it under the terms of the GNU General Public License as
//	published by the Free Software Foundation; either version 2 of the
//	License, or (at your option) any later version. 

//	This program is distributed in the hope that it will be useful, but
//	WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
//	General Public License for more details. 

//	You should have received a copy of the GNU General Public License along
//	with this program; if not, write to the Free Software Foundation, Inc.,
//	51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

//
//			Binary Compression 79
//			written by Dzinleski Jasenko March-July , 2008 , May 2010
//
//			to Maria Dzinleska





#include 	<stdio.h>
#include 	<string.h>
#include 	<math.h>

#define		BuffL				64 	//(128)
#define		BtM				8*256
#define		TBEnd				8

char 		infn[256]="book_sd.txt";
char		outfn[256]="t_.txt";

char		out1fn[256]="1_.mar";
char		out2fn[256]="2_.mar";
char		out3fn[256]="3_.mar";
char		out4fn[256]="4_.mar";

FILE		*f1,*f2,*f3,*f4,*f5,*f6;

int 		ba16[16][16][16][16][2];	int	ba16i=0;

int 		br8_15[16][16][2];		int	br8_15i=0;
int 		br8_14[16][16][2];		int	br8_14i=0;
int 		br8_13[16][16][2];		int	br8_13i=0;
int 		br8_12[16][16][2];		int	br8_12i=0;
int 		br8_11[16][16][2];		int	br8_11i=0;
int 		br8_10[16][16][2];		int	br8_10i=0;
int 		br8_09[16][16][2];		int	br8_09i=0;
int 		br8_08[16][16][2];		int	br8_08i=0;

int		b15=(0xffff>>1)<<1;
int		b14=(0xffff>>2)<<2;
int		b13=(0xffff>>3)<<3;
int		b12=(0xffff>>4)<<4;
int		b11=(0xffff>>5)<<5;
int		b10=(0xffff>>6)<<6;
int		b09=(0xffff>>7)<<7;
int		b08=(0xffff>>8)<<8;

int		r15=(~((0xffff>>1)<<1));
int		r14=(~((0xffff>>2)<<2));
int		r13=(~((0xffff>>3)<<3));
int		r12=(~((0xffff>>4)<<4));
int		r11=(~((0xffff>>5)<<5));
int		r10=(~((0xffff>>6)<<6));
int		r09=(~((0xffff>>7)<<7));
int		r08=(~((0xffff>>8)<<8));

int 		bb16[16][16][16][16][2];		int	bb16i=0;
int 		bb08[16][16][2];			int	bb08i=0;

__int64 	fc=0;
int 		bl08[16][256];				int	bl08i=0;

int		mm[16][3];				
int		md[16][30000][2];			
int		mdi[16];

int		ddf[70000][2];				int	ddfi=0;
bool		sdf[70000];
int		dd[30000][2];				int	ddi=0;
int		ca[BuffL];				int 	cai=0;
bool		br[BtM];				int	bri=0;
bool		bt32_1[32];				int	bt32i_1=0;
bool		bt32_2[32];				int	bt32i_2=0;

__int64 	bitc=0,bc=0,fb=0;
int		bytc=0,bytc1=0;

bool		df=false;
bool		nf=false;
bool		o_f=false;

char		c_l[256]="{[--]}{[hh][ee][cc][dd]}{[AZ][az][09][__][  ][..]}";



int	c_p(char cl_a[256],int ci,bool tf,char r_a[256])
{

	int		a,b,c,d=0;
	
	for(a=0;a<256;++a){r_a[a]='\0';}

	if(tf)
	{
		for(a=0;a<strlen(c_l);++a){
			if(cl_a[a]=='{'){++d;for(b=a+1;b<strlen(cl_a);++b){if(cl_a[b]=='}'){if(d==ci){break;}}}}
			if(b!=strlen(cl_a)){break;}
		}
	}else{
		for(a=0;a<strlen(cl_a);++a){
			if(cl_a[a]=='['){++d;for(b=a+1;b<strlen(cl_a);++b){if(cl_a[b]==']'){if(d==ci){break;}}}}
			if(b!=strlen(cl_a)){break;}
		}
	}

	d=0;for(c=a+1;c<b;++c){r_a[d]=cl_a[c];++d;/*printf("%c",cl_a[c]);*/}

	return(0);

}

int	f_n(char n_infn[256],char n_outfn[256])
{

int		i,j,k,l,m;
char	fn[256];


	f1=fopen(n_infn,"rb");if(f1==NULL){return(0);}
						
	for(j=0;j<256;++j){fn[j]='\0';}
	strcpy(fn,n_infn);
	for(l=0;fn[l]!='.';++l){}for(m=0;out1fn[m]!='.';++m){}
	fn[l]='_';++l;
	for(k=l;k<l+m;++k){fn[k]=out1fn[k-l];}
	fn[k]='.';fn[++k]='m';fn[++k]='a';fn[++k]='r';
	//printf("%s\n",fn);
	for(k=0;k<strlen(fn);++k){out1fn[k]=fn[k];}
						
	for(j=0;j<256;++j){fn[j]='\0';}
	strcpy(fn,n_infn);
	for(l=0;fn[l]!='.';++l){}for(m=0;out2fn[m]!='.';++m){}
	fn[l]='_';++l;
	for(k=l;k<l+m;++k){fn[k]=out2fn[k-l];}
	fn[k]='.';fn[++k]='m';fn[++k]='a';fn[++k]='r';
	//printf("%s\n",fn);
	for(k=0;k<strlen(fn);++k){out2fn[k]=fn[k];}
						
	for(j=0;j<256;++j){fn[j]='\0';}
	strcpy(fn,n_infn);
	for(l=0;fn[l]!='.';++l){}for(m=0;out3fn[m]!='.';++m){}
	fn[l]='_';++l;
	for(k=l;k<l+m;++k){fn[k]=out3fn[k-l];}
	fn[k]='.';fn[++k]='m';fn[++k]='a';fn[++k]='r';
	//printf("%s\n",fn);
	for(k=0;k<strlen(fn);++k){out3fn[k]=fn[k];}

	for(j=0;j<256;++j){fn[j]='\0';}
	strcpy(fn,n_infn);
	for(l=0;fn[l]!='.';++l){}for(m=0;out4fn[m]!='.';++m){}
	fn[l]='_';++l;
	for(k=l;k<l+m;++k){fn[k]=out4fn[k-l];}
	fn[k]='.';fn[++k]='m';fn[++k]='a';fn[++k]='r';
	//printf("%s\n",fn);
	for(k=0;k<strlen(fn);++k){out4fn[k]=fn[k];}

	if(n_outfn!=NULL){strcpy(outfn,n_outfn);o_f=true;}else{outfn[0]='\0';o_f=false;}

	return(0);
}

int	p_r(FILE *fwr,bool br_[BtM],int bri_)
{
	int	i,j,k,l;

	if(bri_!=0)
	{
		j=0;l=7;
		for(i=0;i<bri_;)
		{

			if(i  <bri_){if(br_[i]  ){j|=1<<l;}--l;}else{break;}//{fprintf(f2,"%c",(j&0x00ff));break;}
			if(i+1<bri_){if(br_[++i]){j|=1<<l;}--l;}else{break;}//{fprintf(f2,"%c",(j&0x00ff));break;}
			if(i+1<bri_){if(br_[++i]){j|=1<<l;}--l;}else{break;}//{fprintf(f2,"%c",(j&0x00ff));break;}
			if(i+1<bri_){if(br_[++i]){j|=1<<l;}--l;}else{break;}//{fprintf(f2,"%c",(j&0x00ff));break;}
			if(i+1<bri_){if(br_[++i]){j|=1<<l;}--l;}else{break;}//{fprintf(f2,"%c",(j&0x00ff));break;}
			if(i+1<bri_){if(br_[++i]){j|=1<<l;}--l;}else{break;}//{fprintf(f2,"%c",(j&0x00ff));break;}
			if(i+1<bri_){if(br_[++i]){j|=1<<l;}--l;}else{break;}//{fprintf(f2,"%c",(j&0x00ff));break;}
			if(i+1<bri_){if(br_[++i]){j|=1<<l;}--l;}else{break;}//{fprintf(f2,"%c",(j&0x00ff));break;}

			if(l==-1){fprintf(fwr,"%c",(j&0x00ff));l=7;++bytc1;j=0;++i;}

		}

		bitc+=i;

		if(7-l==1)
		{
			j=0;
			if(br_[-1+bri_]){j|=1<<7;}
			fprintf(fwr,"%c",(j&0x00ff));++bytc1;
		}

		if(7-l==2)
		{
			j=0;
			if(br_[-2+bri_]){j|=1<<7;}
			if(br_[-1+bri_]){j|=1<<6;}
			fprintf(fwr,"%c",(j&0x00ff));++bytc1;
		}

		if(7-l==3)
		{
			j=0;
			if(br_[-3+bri_]){j|=1<<7;}
			if(br_[-2+bri_]){j|=1<<6;}
			if(br_[-1+bri_]){j|=1<<5;}
			fprintf(fwr,"%c",(j&0x00ff));++bytc1;
		}

		if(7-l==4)
		{
			j=0;
			if(br_[-4+bri_]){j|=1<<7;}
			if(br_[-3+bri_]){j|=1<<6;}
			if(br_[-2+bri_]){j|=1<<5;}
			if(br_[-1+bri_]){j|=1<<4;}
			fprintf(fwr,"%c",(j&0x00ff));++bytc1;
		}

		if(7-l==5)
		{
			j=0;
			if(br_[-5+bri_]){j|=1<<7;}
			if(br_[-4+bri_]){j|=1<<6;}
			if(br_[-3+bri_]){j|=1<<5;}
			if(br_[-2+bri_]){j|=1<<4;}
			if(br_[-1+bri_]){j|=1<<3;}
			fprintf(fwr,"%c",(j&0x00ff));++bytc1;
		}

		if(7-l==6)
		{
			j=0;
			if(br_[-6+bri_]){j|=1<<7;}
			if(br_[-5+bri_]){j|=1<<6;}
			if(br_[-4+bri_]){j|=1<<5;}
			if(br_[-3+bri_]){j|=1<<4;}
			if(br_[-2+bri_]){j|=1<<3;}
			if(br_[-1+bri_]){j|=1<<2;}
			fprintf(fwr,"%c",(j&0x00ff));++bytc1;
		}

		if(7-l==0)
		{
			j=0;
			if(br_[-7+bri_]){j|=1<<7;}
			if(br_[-6+bri_]){j|=1<<6;}
			if(br_[-5+bri_]){j|=1<<5;}
			if(br_[-4+bri_]){j|=1<<4;}
			if(br_[-3+bri_]){j|=1<<3;}
			if(br_[-2+bri_]){j|=1<<2;}
			if(br_[-1+bri_]){j|=1<<1;}
			fprintf(fwr,"%c",(j&0x00ff));++bytc1;
		}

	}
	return(bri_);
}

int	p_w(FILE *fw1,int d,bool brw[BtM],int brwi)
{
	int	i,ii=0,j,k,l;

	l=7;j=0;
	for(i=0;i<brwi;)
	{

		if(i+d<brwi-TBEnd){if(brw[i]  ){j|=1<<l;}--l;}else{break;}
		if(i+d<brwi-TBEnd){if(brw[++i]){j|=1<<l;}--l;}else{break;}
		if(i+d<brwi-TBEnd){if(brw[++i]){j|=1<<l;}--l;}else{break;}
		if(i+d<brwi-TBEnd){if(brw[++i]){j|=1<<l;}--l;}else{break;}
		if(i+d<brwi-TBEnd){if(brw[++i]){j|=1<<l;}--l;}else{break;}
		if(i+d<brwi-TBEnd){if(brw[++i]){j|=1<<l;}--l;}else{break;}
		if(i+d<brwi-TBEnd){if(brw[++i]){j|=1<<l;}--l;}else{break;}
		if(i+d<brwi-TBEnd){if(brw[++i]){j|=1<<l;}--l;}else{break;}

		if(l==-1){fprintf(fw1,"%c",(j&0x00ff));++bytc;++bytc1;l=7;j=0;++i;ii=i;}
					
	}if(i==brwi){brwi=0;}else{j=0;for(l=ii;l<brwi;++l){brw[j]=brw[l];++j;}brwi=j;}

	bitc+=i;

	return(brwi);

}

void pr32_(long d,bool b_[32],int b_i)
{

	b_i=0;
	if((((((d&0xff000000)>>24)<<24)>>31)&0x1)==1){b_[b_i]=true;++b_i;}else{b_[b_i]=false;++b_i;}
	if((((((d&0xff000000)>>24)<<25)>>31)&0x1)==1){b_[b_i]=true;++b_i;}else{b_[b_i]=false;++b_i;}
	if((((((d&0xff000000)>>24)<<26)>>31)&0x1)==1){b_[b_i]=true;++b_i;}else{b_[b_i]=false;++b_i;}
	if((((((d&0xff000000)>>24)<<27)>>31)&0x1)==1){b_[b_i]=true;++b_i;}else{b_[b_i]=false;++b_i;}
	if((((((d&0xff000000)>>24)<<28)>>31)&0x1)==1){b_[b_i]=true;++b_i;}else{b_[b_i]=false;++b_i;}
	if((((((d&0xff000000)>>24)<<29)>>31)&0x1)==1){b_[b_i]=true;++b_i;}else{b_[b_i]=false;++b_i;}
	if((((((d&0xff000000)>>24)<<30)>>31)&0x1)==1){b_[b_i]=true;++b_i;}else{b_[b_i]=false;++b_i;}
	if((((((d&0xff000000)>>24)<<31)>>31)&0x1)==1){b_[b_i]=true;++b_i;}else{b_[b_i]=false;++b_i;}

	if((((((d&0x00ff0000)>>16)<<24)>>31)&0x1)==1){b_[b_i]=true;++b_i;}else{b_[b_i]=false;++b_i;}
	if((((((d&0x00ff0000)>>16)<<25)>>31)&0x1)==1){b_[b_i]=true;++b_i;}else{b_[b_i]=false;++b_i;}
	if((((((d&0x00ff0000)>>16)<<26)>>31)&0x1)==1){b_[b_i]=true;++b_i;}else{b_[b_i]=false;++b_i;}
	if((((((d&0x00ff0000)>>16)<<27)>>31)&0x1)==1){b_[b_i]=true;++b_i;}else{b_[b_i]=false;++b_i;}
	if((((((d&0x00ff0000)>>16)<<28)>>31)&0x1)==1){b_[b_i]=true;++b_i;}else{b_[b_i]=false;++b_i;}
	if((((((d&0x00ff0000)>>16)<<29)>>31)&0x1)==1){b_[b_i]=true;++b_i;}else{b_[b_i]=false;++b_i;}
	if((((((d&0x00ff0000)>>16)<<30)>>31)&0x1)==1){b_[b_i]=true;++b_i;}else{b_[b_i]=false;++b_i;}
	if((((((d&0x00ff0000)>>16)<<31)>>31)&0x1)==1){b_[b_i]=true;++b_i;}else{b_[b_i]=false;++b_i;}

	if((((((d&0x0000ff00)>>8)<<24)>>31)&0x1)==1){b_[b_i]=true;++b_i;}else{b_[b_i]=false;++b_i;}
	if((((((d&0x0000ff00)>>8)<<25)>>31)&0x1)==1){b_[b_i]=true;++b_i;}else{b_[b_i]=false;++b_i;}
	if((((((d&0x0000ff00)>>8)<<26)>>31)&0x1)==1){b_[b_i]=true;++b_i;}else{b_[b_i]=false;++b_i;}
	if((((((d&0x0000ff00)>>8)<<27)>>31)&0x1)==1){b_[b_i]=true;++b_i;}else{b_[b_i]=false;++b_i;}
	if((((((d&0x0000ff00)>>8)<<28)>>31)&0x1)==1){b_[b_i]=true;++b_i;}else{b_[b_i]=false;++b_i;}
	if((((((d&0x0000ff00)>>8)<<29)>>31)&0x1)==1){b_[b_i]=true;++b_i;}else{b_[b_i]=false;++b_i;}
	if((((((d&0x0000ff00)>>8)<<30)>>31)&0x1)==1){b_[b_i]=true;++b_i;}else{b_[b_i]=false;++b_i;}
	if((((((d&0x0000ff00)>>8)<<31)>>31)&0x1)==1){b_[b_i]=true;++b_i;}else{b_[b_i]=false;++b_i;}

	if(((((d&0x000000ff)<<24)>>31)&0x1)==1){b_[b_i]=true;++b_i;}else{b_[b_i]=false;++b_i;}
	if(((((d&0x000000ff)<<25)>>31)&0x1)==1){b_[b_i]=true;++b_i;}else{b_[b_i]=false;++b_i;}
	if(((((d&0x000000ff)<<26)>>31)&0x1)==1){b_[b_i]=true;++b_i;}else{b_[b_i]=false;++b_i;}
	if(((((d&0x000000ff)<<27)>>31)&0x1)==1){b_[b_i]=true;++b_i;}else{b_[b_i]=false;++b_i;}
	if(((((d&0x000000ff)<<28)>>31)&0x1)==1){b_[b_i]=true;++b_i;}else{b_[b_i]=false;++b_i;}
	if(((((d&0x000000ff)<<29)>>31)&0x1)==1){b_[b_i]=true;++b_i;}else{b_[b_i]=false;++b_i;}
	if(((((d&0x000000ff)<<30)>>31)&0x1)==1){b_[b_i]=true;++b_i;}else{b_[b_i]=false;++b_i;}
	if(((((d&0x000000ff)<<31)>>31)&0x1)==1){b_[b_i]=true;++b_i;}else{b_[b_i]=false;++b_i;}

}

int	mar79_1(char m_infn[256],char m_outfn[256])
{

	int		i,j,k,l,m,n,p,q;
	int		a,b,c,d;
	int		fbyte,nH,nL;
	int		m15,m14,m13,m12,m11,m10,m09,m08;

	for(i=0;i<16;++i){mdi[i]=0;}

	for(i=0;i<16;++i){for(j=0;j<16;++j){
		br8_15[i][j][0]=-1;
		br8_14[i][j][0]=-1;
		br8_13[i][j][0]=-1;
		br8_12[i][j][0]=-1;
		br8_11[i][j][0]=-1;
		br8_10[i][j][0]=-1;
		br8_09[i][j][0]=-1;
		br8_08[i][j][0]=-1;
	}}

	for(i=0;i<16;++i){for(j=0;j<16;++j){for(k=0;k<16;++k){for(l=0;l<16;++l){
		ba16[i][j][k][l][0]=-1;
	}}}}

	f1=fopen(m_infn,"rb");
	while(!feof(f1))
	{

		nH=getc(f1);if(!feof(f1)){nL=getc(f1);}else{nL=0;}n=((nH<<8)&0xff00)|(nL&0x00ff);

		if(ba16[(n&0xf000)>>12][(n&0x0f00)>>8][(n&0x00f0)>>4][(n&0x000f)>>0][0]==-1)
		{
			ba16[(n&0xf000)>>12][(n&0x0f00)>>8][(n&0x00f0)>>4][(n&0x000f)>>0][0]=ba16i;
			ba16[(n&0xf000)>>12][(n&0x0f00)>>8][(n&0x00f0)>>4][(n&0x000f)>>0][1]=1;
			++ba16i;
		}else{
			++ba16[(n&0xf000)>>12][(n&0x0f00)>>8][(n&0x00f0)>>4][(n&0x000f)>>0][1];
		}		

		if(br8_15[(((n&r15)&0x00f0)>>4)][(((n&r15)&0x000f)>>0)][0]==-1)
		{
			br8_15[(((n&r15)&0x00f0)>>4)][(((n&r15)&0x000f)>>0)][0]=br8_15i;
			br8_15[(((n&r15)&0x00f0)>>4)][(((n&r15)&0x000f)>>0)][1]=1;
			++br8_15i;
		}else{
			++br8_15[(((n&r15)&0x00f0)>>4)][(((n&r15)&0x000f)>>0)][1];
		}
		if(br8_14[(((n&r14)&0x00f0)>>4)][(((n&r14)&0x000f)>>0)][0]==-1)
		{
			br8_14[(((n&r14)&0x00f0)>>4)][(((n&r14)&0x000f)>>0)][0]=br8_14i;
			br8_14[(((n&r14)&0x00f0)>>4)][(((n&r14)&0x000f)>>0)][1]=1;
			++br8_14i;
		}else{
			++br8_14[(((n&r14)&0x00f0)>>4)][(((n&r14)&0x000f)>>0)][1];
		}
		if(br8_13[(((n&r13)&0x00f0)>>4)][(((n&r13)&0x000f)>>0)][0]==-1)
		{
			br8_13[(((n&r13)&0x00f0)>>4)][(((n&r13)&0x000f)>>0)][0]=br8_13i;
			br8_13[(((n&r13)&0x00f0)>>4)][(((n&r13)&0x000f)>>0)][1]=1;
			++br8_13i;
		}else{
			++br8_13[(((n&r13)&0x00f0)>>4)][(((n&r13)&0x000f)>>0)][1];
		}
		if(br8_12[(((n&r12)&0x00f0)>>4)][(((n&r12)&0x000f)>>0)][0]==-1)
		{
			br8_12[(((n&r12)&0x00f0)>>4)][(((n&r12)&0x000f)>>0)][0]=br8_12i;
			br8_12[(((n&r12)&0x00f0)>>4)][(((n&r12)&0x000f)>>0)][1]=1;
			++br8_12i;
		}else{
			++br8_12[(((n&r12)&0x00f0)>>4)][(((n&r12)&0x000f)>>0)][1];
		}
		if(br8_11[(((n&r11)&0x00f0)>>4)][(((n&r11)&0x000f)>>0)][0]==-1)
		{
			br8_11[(((n&r11)&0x00f0)>>4)][(((n&r11)&0x000f)>>0)][0]=br8_11i;
			br8_11[(((n&r11)&0x00f0)>>4)][(((n&r11)&0x000f)>>0)][1]=1;
			++br8_11i;
		}else{
			++br8_11[(((n&r11)&0x00f0)>>4)][(((n&r11)&0x000f)>>0)][1];
		}
		if(br8_10[(((n&r10)&0x00f0)>>4)][(((n&r10)&0x000f)>>0)][0]==-1)
		{
			br8_10[(((n&r10)&0x00f0)>>4)][(((n&r10)&0x000f)>>0)][0]=br8_10i;
			br8_10[(((n&r10)&0x00f0)>>4)][(((n&r10)&0x000f)>>0)][1]=1;
			++br8_10i;
		}else{
			++br8_10[(((n&r10)&0x00f0)>>4)][(((n&r10)&0x000f)>>0)][1];
		}
		if(br8_09[(((n&r09)&0x00f0)>>4)][(((n&r09)&0x000f)>>0)][0]==-1)
		{
			br8_09[(((n&r09)&0x00f0)>>4)][(((n&r09)&0x000f)>>0)][0]=br8_09i;
			br8_09[(((n&r09)&0x00f0)>>4)][(((n&r09)&0x000f)>>0)][1]=1;
			++br8_09i;
		}else{
			++br8_09[(((n&r09)&0x00f0)>>4)][(((n&r09)&0x000f)>>0)][1];
		}
		if(br8_08[(((n&r08)&0x00f0)>>4)][(((n&r08)&0x000f)>>0)][0]==-1)
		{
			br8_08[(((n&r08)&0x00f0)>>4)][(((n&r08)&0x000f)>>0)][0]=br8_08i;
			br8_08[(((n&r08)&0x00f0)>>4)][(((n&r08)&0x000f)>>0)][1]=1;
			++br8_08i;
		}else{
			++br8_08[(((n&r08)&0x00f0)>>4)][(((n&r08)&0x000f)>>0)][1];
		}
	}
	fclose(f1);

	if(nf){printf("\n");}

	for(i=0;i<16;++i){for(j=0;j<16;++j){if(br8_08[i][j][0]!=-1){bl08[8][((i<<4)|j)]= br8_08[i][j][1];}}}
	for(i=0;i<16;++i){for(j=0;j<16;++j){if(br8_09[i][j][0]!=-1){bl08[9][((i<<4)|j)]= br8_09[i][j][1];}}}
	for(i=0;i<16;++i){for(j=0;j<16;++j){if(br8_10[i][j][0]!=-1){bl08[10][((i<<4)|j)]=br8_10[i][j][1];}}}
	for(i=0;i<16;++i){for(j=0;j<16;++j){if(br8_11[i][j][0]!=-1){bl08[11][((i<<4)|j)]=br8_11[i][j][1];}}}
	for(i=0;i<16;++i){for(j=0;j<16;++j){if(br8_12[i][j][0]!=-1){bl08[12][((i<<4)|j)]=br8_12[i][j][1];}}}
	for(i=0;i<16;++i){for(j=0;j<16;++j){if(br8_13[i][j][0]!=-1){bl08[13][((i<<4)|j)]=br8_13[i][j][1];}}}
	for(i=0;i<16;++i){for(j=0;j<16;++j){if(br8_14[i][j][0]!=-1){bl08[14][((i<<4)|j)]=br8_14[i][j][1];}}}
	for(i=0;i<16;++i){for(j=0;j<16;++j){if(br8_15[i][j][0]!=-1){bl08[15][((i<<4)|j)]=br8_15[i][j][1];}}}

	if(nf){printf("\n");}

	f1=fopen(m_infn,"rb");
	nH=getc(f1);nL=getc(f1);n=((nH<<8)&0xff00)|(nL&0x00ff);
	while(!feof(f1))
	{

		if(df){printf("%c %c\n",nH,nL);}
		//printf("%c %c\n",nH,nL);

		for(i=0;i<16;++i){mm[i][0]=0;mm[i][1]=0;mm[i][2]=0;}
		
		mm[8][0]=bl08[8][(n&r08)];
		for(i=0;i<16;++i){for(j=0;j<16;++j){
			if(ba16[(n&0xf000)>>12][(n&0x0f00)>>8][i][j][1]!=-1)
			{mm[8][1]+=ba16[(n&0xf000)>>12][(n&0x0f00)>>8][i][j][1];}
		}}//if(mm[8][1]==0){mm[8][1]=1;}
		//if(df){printf("08.%d %d %e\n",bl08[8][q],m08,((double)m08/(double)bl08[8][q]));}
		mm[8][2]=n;


		mm[9][0]=bl08[9][(n&r09)];
		for(i=0;i<8;++i){for(j=0;j<16;++j){
			if(ba16[(n&0xf000)>>12][(n&0x0f00)>>8][i][j][1]!=-1)
			{mm[9][1]+=ba16[(n&0xf000)>>12][(n&0x0f00)>>8][i][j][1];}
		}}//if(mm[9][1]==0){mm[9][1]=1;}
		//if(df){printf("09.%d %d %e\n",bl08[9][q],m09,((double)m09/(double)bl08[9][q]));}
		mm[9][2]=n;


		mm[10][0]=bl08[10][(n&r10)];
		for(i=0;i<4;++i){for(j=0;j<16;++j){
			if(ba16[(n&0xf000)>>12][(n&0x0f00)>>8][i][j][1]!=-1)
			{mm[10][1]+=ba16[(n&0xf000)>>12][(n&0x0f00)>>8][i][j][1];}
		}}//if(mm[10][1]==0){mm[10][1]=1;}
		//if(df){printf("10.%d %d %e\n",bl08[10][q],m10,((double)m10/(double)bl08[10][q]));}
		mm[10][2]=n;


		mm[11][0]=bl08[11][(n&r11)];
		for(i=0;i<2;++i){for(j=0;j<16;++j){
			if(ba16[(n&0xf000)>>12][(n&0x0f00)>>8][i][j][1]!=-1)
			{mm[11][1]+=ba16[(n&0xf000)>>12][(n&0x0f00)>>8][i][j][1];}
		}}//if(mm[11][1]==0){mm[11][1]=1;}
		//if(df){printf("11.%d %d %e\n",bl08[11][q],m11,((double)m11/(double)bl08[11][q]));}
		mm[11][2]=n;


		mm[12][0]=bl08[12][(n&r12)];
		for(i=0;i<0;++i){for(j=0;j<16;++j){
			if(ba16[(n&0xf000)>>12][(n&0x0f00)>>8][i][j][1]!=-1)
			{mm[12][1]+=ba16[(n&0xf000)>>12][(n&0x0f00)>>8][i][j][1];}
		}}//if(mm[12][1]==0){mm[12][1]=1;}
		//if(df){printf("12.%d %d %e\n",bl08[12][q],m12,((double)m12/(double)bl08[12][q]));}
		mm[12][2]=n;


		mm[13][0]=bl08[13][(n&r13)];
		for(i=0;i<0;++i){for(j=0;j<8;++j){
			if(ba16[(n&0xf000)>>12][(n&0x0f00)>>8][i][j][1]!=-1)
			{mm[13][1]+=ba16[(n&0xf000)>>12][(n&0x0f00)>>8][i][j][1];}
		}}//if(mm[13][1]==0){mm[13][1]=1;}
		//if(df){printf("13.%d %d %e\n",bl08[13][q],m13,((double)m13/(double)bl08[13][q]));}
		mm[13][2]=n;


		mm[14][0]=bl08[14][(n&r14)];
		for(i=0;i<0;++i){for(j=0;j<4;++j){
			if(ba16[(n&0xf000)>>12][(n&0x0f00)>>8][i][j][1]!=-1)
			{mm[14][1]+=ba16[(n&0xf000)>>12][(n&0x0f00)>>8][i][j][1];}
		}}//if(mm[14][1]==0){mm[14][1]=1;}
		//if(df){printf("14.%d %d %e\n",bl08[14][q],m14,((double)m14/(double)bl08[14][q]));}
		mm[14][2]=n;


		mm[15][0]=bl08[15][(n&r15)];
		for(i=0;i<0;++i){for(j=0;j<2;++j){
			if(ba16[(n&0xf000)>>12][(n&0x0f00)>>8][i][j][1]!=-1)
			{mm[15][1]+=ba16[(n&0xf000)>>12][(n&0x0f00)>>8][i][j][1];}
		}}//if(mm[15][1]==0){mm[15][1]=1;}
		//if(df){printf("15.%d %d %e\n",bl08[15][q],m15,((double)m15/(double)bl08[15][q]));}
		mm[15][2]=n;


		for(i=8;i<16;++i)
		{
			//printf("%d %d %d %d\n",i,mm[i][0],mm[i][1],mm[i][2]);
			if(mm[i][1]==0){--i;break;}
		}
		if(mdi[i]==0)
		{
			md[i][mdi[i]][0]=mm[i][2];

			md[i][mdi[i]][1]=0;
			for(j=8;j<=i;++j){md[i][mdi[i]][1]+=(mm[j][0]+mm[j][1]);}
			++mdi[i];
		}else{
			for(k=0;k<mdi[i];++k)
			{
				if(md[i][k][0]==n){break;}
			}
			if(k==mdi[i])
			{
				md[i][mdi[i]][0]=mm[i][2];
				md[i][mdi[i]][1]=0;
				for(j=8;j<=i;++j){md[i][mdi[i]][1]+=(mm[j][0]+mm[j][1]);}
				++mdi[i];
			}else{
				m=0;for(j=8;j<=i;++j){m+=(mm[j][0]+mm[j][1]);}
				if(md[i][k][1]<m){md[i][k][1]=m;}
			}
		}
		
		if(df){printf("%d %d\n",nH,nL);}

		fc+=16;

		nH=getc(f1);if(!feof(f1)){nL=getc(f1);}else{nL=0;}
		n=((nH<<8)&0xff00)|(nL&0x00ff);
	}
	fclose(f1);

	if(nf){for(i=8;i<16;++i){printf(".%02d - %05d.\n",i,mdi[i]);}printf("\n");}

/*

	for(i=8;i<16;++i)
	{
		if(mdi[i]!=0)
		{
			for(j=0;j<mdi[i];++j)
			{
				printf("!%d.%03d.%03d.%d!",i,((md[i][j][0]&0xff00)>>8),(md[i][j][0]&0x00ff),md[i][j][1]);
			}printf("\n");
		}
		
	}

*/

	//printf("\n");

/*
	f2=fopen(m_outfn,"wb");
	for(i=8;i<16;++i)
	{
		if(mdi[i]!=0)
		{
			for(j=0;j<mdi[i];++j)
			{
				//printf("!%d.%03d.%03d.%d!",i,((md[i][j][0]&0xff00)>>8),(md[i][j][0]&0x00ff),md[i][j][1]);
				if(ba16[((md[i][j][0]&0xf000)>>12)][((md[i][j][0]&0x0f00)>>8)][((md[i][j][0]&0x00f0)>>4)][((md[i][j][0]&0x000f)>>0)][0]!=-1)
				{
					printf("%d. %05d %05d %03d\n",i,
					ba16[((md[i][j][0]&0xf000)>>12)][((md[i][j][0]&0x0f00)>>8)][((md[i][j][0]&0x00f0)>>4)][((md[i][j][0]&0x000f)>>0)][1]
					,
					(md[i][j][0]&b11)
					,
					(md[i][j][0]&r11)
					);

					fprintf(f2,"%c%c",(((md[i][j][0]&b11)&0xff00)>>8)
					,
					((md[i][j][0]&b11)&0xff00));		
				}
			}printf("\n");
		}
		
	}
	fclose(f2);
*/

	for(i=8;i<16;++i)
	{
		if(mdi[i]!=0)
		{
			for(j=0;j<mdi[i];++j)
			{
				if(i==8&&(md[i][j][0]&r08)==0)
				{
					for(a=0;a<ddi;++a){if(dd[a][0]==(md[i][j][0]&b08)&&dd[a][1]==i){break;}}
					if(a==ddi){dd[ddi][0]=md[i][j][0]&b08;dd[ddi][1]=i;++ddi;}
				}
				if(i==9&&(md[i][j][0]&r09)==0)
				{
					for(a=0;a<ddi;++a){if(dd[a][0]==(md[i][j][0]&b09)&&dd[a][1]==i){break;}}
					if(a==ddi){dd[ddi][0]=md[i][j][0]&b09;dd[ddi][1]=i;++ddi;}
				}
				if(i==10&&(md[i][j][0]&r10)==0)
				{
					for(a=0;a<ddi;++a){if(dd[a][0]==(md[i][j][0]&b10)&&dd[a][1]==i){break;}}
					if(a==ddi){dd[ddi][0]=md[i][j][0]&b10;dd[ddi][1]=i;++ddi;}
				}
				if(i==11&&(md[i][j][0]&r11)==0)
				{
					for(a=0;a<ddi;++a){if(dd[a][0]==(md[i][j][0]&b11)&&dd[a][1]==i){break;}}
					if(a==ddi){dd[ddi][0]=md[i][j][0]&b11;dd[ddi][1]=i;++ddi;}
				}
				if(i==12&&(md[i][j][0]&r12)==0)
				{
					for(a=0;a<ddi;++a){if(dd[a][0]==(md[i][j][0]&b12)&&dd[a][1]==i){break;}}
					if(a==ddi){dd[ddi][0]=md[i][j][0]&b12;dd[ddi][1]=i;++ddi;}
				}
				if(i==13&&(md[i][j][0]&r13)==0)
				{
					for(a=0;a<ddi;++a){if(dd[a][0]==(md[i][j][0]&b13)&&dd[a][1]==i){break;}}
					if(a==ddi){dd[ddi][0]=md[i][j][0]&b13;dd[ddi][1]=i;++ddi;}
				}
				if(i==14&&(md[i][j][0]&r14)==0)
				{
					for(a=0;a<ddi;++a){if(dd[a][0]==(md[i][j][0]&b14)&&dd[a][1]==i){break;}}
					if(a==ddi){dd[ddi][0]=md[i][j][0]&b14;dd[ddi][1]=i;++ddi;}
				}
				if(i==15&&(md[i][j][0]&r15)==0)
				{
					for(a=0;a<ddi;++a){if(dd[a][0]==(md[i][j][0]&b15)&&dd[a][1]==i){break;}}
					if(a==ddi){dd[ddi][0]=md[i][j][0]&b15;dd[ddi][1]=i;++ddi;}
				}
			}
		}
	}

	if(nf){printf("\nbase number entries:%05d\n",ddi);}

	return(0);

}

int	mar79_2(char m_in1fn[256],char m_out1fn[256],char m_out2fn[256],char m_out3fn[256],char m_out4fn[256])
{

	int		i,j,k,l,m,n,p,q;
	int		a,b,c,d;
	int		fbyte,nH,nL;
	bool		sig;

	for(i=0;i<ddi;++i){ddf[ddfi][0]=i;ddf[ddfi][1]=0;sdf[ddfi]=true;++ddfi;}

	fc=0;
	f2=fopen(m_out1fn,"wb");
	f1=fopen(m_in1fn,"rb");
	nH=getc(f1);nL=getc(f1);n=((nH<<8)&0xff00)|(nL&0x00ff);fc+=16;
	while(!feof(f1))
	{
		for(l=8;l<16;++l){for(j=0;j<mdi[l];++j){if(md[l][j][0]==n){break;}}if(j!=mdi[l]){break;}}
		if(l==16){printf("Index Error...\n");}
		
		if(l==8) {a=n&b08;b=n&r08;}
		if(l==9) {a=n&b09;b=n&r09;}
		if(l==10){a=n&b10;b=n&r10;}
		if(l==11){a=n&b11;b=n&r11;}
		if(l==12){a=n&b12;b=n&r12;}
		if(l==13){a=n&b13;b=n&r13;}
		if(l==14){a=n&b14;b=n&r14;}
		if(l==15){a=n&b15;b=n&r15;}

		m=-1;
		for(i=0;i<ddi;++i)
		{
			if(n>=dd[i][0]){if(m==-1){m=n-dd[i][0];c=i;sig=true;}else{
				if(m>(n-dd[i][0])){m=n-dd[i][0];c=i;sig=true;}}
			}
			if(n<dd[i][0] ){if(m==-1){m=dd[i][0]-n;c=i;sig=false;}else{
				if(m>(dd[i][0]-n)){m=dd[i][0]-n;c=i;sig=false;}}
			}
		}
		for(i=0;i<ddfi;++i){if(ddf[i][0]==c&&ddf[i][1]==m&&sdf[i]==sig){d=i;break;}}
		if(i==ddfi)
		{
			ddf[ddfi][0]=c;ddf[ddfi][1]=m;sdf[ddfi]=sig;
			d=ddfi;++ddfi;
		}
		ca[cai]=d;++cai;
		
		//printf("%d %d %d\n",i,a,b);
		//printf(".%d.",c);

		if(cai>=BuffL)
		{		
			m=-1;
			for(i=0;i<cai;++i)
			{
				pr32_(ca[i] ,bt32_1,bt32i_1);
				p=32;for(a=0;a<32;++a){if(bt32_1[a]){p=a;break;}}
				if(m==-1){m=a;}else{if(m>a){m=a;}}
			}n=m;m=32-m;
			//printf(".%d.",m);

			bri=0;
			pr32_(m ,bt32_1, bt32i_1);
	
			br[bri]=bt32_1[28];++bri;
			br[bri]=bt32_1[29];++bri;
			br[bri]=bt32_1[30];++bri;
			br[bri]=bt32_1[31];++bri;

			for(c=0;c<cai;++c)
			{

				//printf(".%d.",ca[c]);

				pr32_(ca[c] ,bt32_1,bt32i_1);
				p=32;for(a=0;a<32;++a){if(bt32_1[a]){p=a;break;}}
				//printf(".%d.",p-n);
				if(p>n){for(b=n;b<p;++b){br[bri]=false;++bri;}for(b=p;b<32;++b){br[bri]=bt32_1[b];++bri;}
				}else{
				if(p==n){for(b=n;b<32;++b){br[bri]=bt32_1[b];++bri;}}else{printf("BL Error...%d %d\n",p,n);}}
				//printf(".%d.",m);printf(".%d.",bri);
				if(df){printf(".%d.",m);}

				if(!(bri<(BtM-TBEnd))){bri=p_w(f2,m,br,bri);}
			}//printf("\n");
			bri=p_r(f2,br,bri);
			cai=0;
		}
		nH=getc(f1);if(!feof(f1)){nL=getc(f1);}else{nL=0;}
		n=((nH<<8)&0xff00)|(nL&0x00ff);fc+=16;
	}
	if(!(cai>=BuffL))
	{
		m=-1;
		for(i=0;i<cai;++i)
		{
			pr32_(ca[i] ,bt32_1,bt32i_1);
			p=32;for(a=0;a<32;++a){if(bt32_1[a]){p=a;break;}}
			if(m==-1){m=a;}else{if(m>a){m=a;}}
		}n=m;m=32-m;
		//printf(".%d.",m);

		bri=0;
		pr32_(m ,bt32_1, bt32i_1);
	
		br[bri]=bt32_1[28];++bri;
		br[bri]=bt32_1[29];++bri;
		br[bri]=bt32_1[30];++bri;
		br[bri]=bt32_1[31];++bri;

		for(c=0;c<cai;++c)
		{

			//printf(".%d.",ca[c]);

			pr32_(ca[c] ,bt32_1,bt32i_1);
			p=32;for(a=0;a<32;++a){if(bt32_1[a]){p=a;break;}}
			//printf(".%d.",p-n);
			if(p>n){for(b=n;b<p;++b){br[bri]=false;++bri;}for(b=p;b<32;++b){br[bri]=bt32_1[b];++bri;}
			}else{
			if(p==n){for(b=n;b<32;++b){br[bri]=bt32_1[b];++bri;}}else{printf("BL Error...%d %d\n",p,n);}}
			//printf(".%d.",m);printf(".%d.",bri);
			if(df){printf(".%d.",m);}

			if(!(bri<(BtM-TBEnd))){bri=p_w(f2,m,br,bri);}
		}//printf("\n");
		bri=p_r(f2,br,bri);
		cai=0;
	}		
	fclose(f1);
	fclose(f2);
	
	if(nf)
	{
		printf("\nbase number entries:\t\t%05d\nremainder entries:\t\t%05d\n",
		ddi,
		ddfi
		);
	}

	//---------- base number list
	//f3=fopen(out2fn,"wb");fprintf(f3,"%c%c",((ddi&0xff00)>>8),(ddi&0x00ff));bitc+=16;
	//for(i=0;i<ddi-1;){fprintf(f3,"%c",(((dd[i][1]&0x0f)<<4)|(dd[++i][1]&0x0f)));bitc+=8;++i;}
	//if(i!=ddi){fprintf(f3,"%c",(((dd[i][1]&0x0f)<<4)|0));bitc+=8;}
	//fclose(f3);

	//---------- c base number list
	f3=fopen(m_out2fn,"wb");fprintf(f3,"%c%c",((ddi&0xff00)>>8),(ddi&0x00ff));bitc+=16;
	m=-1;
	for(i=0;i<ddi;++i)
	{
		pr32_(dd[i][0] ,bt32_1,bt32i_1);
		p=32;for(a=0;a<32;++a){if(bt32_1[a]){p=a;break;}}
		if(m==-1){m=a;}else{if(m>a){m=a;}}
	}n=m;m=32-m;//printf(".%d.",m);

	bri=0;
	pr32_(m ,bt32_1, bt32i_1);

	br[bri]=bt32_1[24];++bri;
	br[bri]=bt32_1[25];++bri;
	br[bri]=bt32_1[26];++bri;
	br[bri]=bt32_1[27];++bri;	
	br[bri]=bt32_1[28];++bri;
	br[bri]=bt32_1[29];++bri;
	br[bri]=bt32_1[30];++bri;
	br[bri]=bt32_1[31];++bri;

	for(i=0;i<ddi;++i)
	{
		pr32_(dd[i][0] ,bt32_1,bt32i_1);
		p=32;for(a=0;a<32;++a){if(bt32_1[a]){p=a;break;}}
		//printf(".%d.",p-n);
		if(p>n){for(b=n;b<p;++b){br[bri]=false;++bri;}for(b=p;b<32;++b){br[bri]=bt32_1[b];++bri;}
		}else{
		if(p==n){for(b=n;b<32;++b){br[bri]=bt32_1[b];++bri;}}else{printf("BL Error...%d %d\n",p,n);}}

		if(!(bri<(BtM-TBEnd))){bri=p_w(f3,m,br,bri);}
	}
	bri=p_r(f3,br,bri);	
	fclose(f3);
	//---------- c base number list

	//---------- d base number list
	f3=fopen(m_out2fn,"rb");
	
	nH=getc(f3);nL=getc(f3);p=(nH<<8)|nL;
	nH=getc(f3);pr32_(nH ,bt32_1,bt32i_1);
	
	m=0;
	if(bt32_1[24]){m|=1<<7;}
	if(bt32_1[25]){m|=1<<6;}
	if(bt32_1[26]){m|=1<<5;}
	if(bt32_1[27]){m|=1<<4;}
	if(bt32_1[28]){m|=1<<3;}
	if(bt32_1[29]){m|=1<<2;}
	if(bt32_1[30]){m|=1<<1;}
	if(bt32_1[31]){m|=1<<0;}

	bri=0;
	//br[bri]=bt32_1[31];++bri;

	l=0;
	while(!feof(f3)&&l<p)
	{
		while(!feof(f3)&&bri<m)
		{
			nH=getc(f3);
			pr32_(nH ,bt32_1,bt32i_1);
			br[bri]=bt32_1[24];++bri;
			br[bri]=bt32_1[25];++bri;
			br[bri]=bt32_1[26];++bri;
			br[bri]=bt32_1[27];++bri;
			br[bri]=bt32_1[28];++bri;
			br[bri]=bt32_1[29];++bri;
			br[bri]=bt32_1[30];++bri;
			br[bri]=bt32_1[31];++bri;
		}

		n=0;for(i=0;i<m;++i){if(br[i]){n|=1<<(-1+(m-i));}}
		k=0;for(j=i;j<bri;++j){br[k]=br[j];++k;}bri=k;
		//printf(".%d.",n);
		if(dd[l][0]==n){}else{printf("Base number Error ...%d \n",l);}
		++l;

	}
	fclose(f3);
	//---------- d base number list

	//---------- c index refs 
	f4=fopen(m_out3fn,"wb");
	fprintf(f4,"%c%c",((ddfi&0xff00)>>8),(ddfi&0x00ff));bitc+=16;

	pr32_(ddi ,bt32_1,bt32i_1);
	p=32;for(a=0;a<32;++a){if(bt32_1[a]){m=a;break;}}
	n=m;m=32-m;

	bri=0;
	pr32_(m ,bt32_1, bt32i_1);

	br[bri]=bt32_1[25];++bri;	
	br[bri]=bt32_1[26];++bri;	
	br[bri]=bt32_1[27];++bri;
	br[bri]=bt32_1[28];++bri;
	br[bri]=bt32_1[29];++bri;
	br[bri]=bt32_1[30];++bri;
	br[bri]=bt32_1[31];++bri;

	for(i=0;i<ddfi;++i)
	{
		pr32_(ddf[i][0] ,bt32_1,bt32i_1);
		p=32;for(a=0;a<32;++a){if(bt32_1[a]){p=a;break;}}
		//printf(".%d.",p-n);
		if(p>n){for(b=n;b<p;++b){br[bri]=false;++bri;}for(b=p;b<32;++b){br[bri]=bt32_1[b];++bri;}
		}else{
		if(p==n){for(b=n;b<32;++b){br[bri]=bt32_1[b];++bri;}}else{printf("BL Error...%d %d\n",p,n);}}

		if(!(bri<(BtM-TBEnd))){bri=p_w(f4,m,br,bri);}
	}
	bri=p_r(f4,br,bri);	
	fclose(f4);
	//---------- c index refs

	//---------- d index refs
	f4=fopen(m_out3fn,"rb");
	
	nH=getc(f4);nL=getc(f4);p=(nH<<8)|nL;
	nH=getc(f4);pr32_(nH ,bt32_1,bt32i_1);
	
	m=0;
	if(bt32_1[24]){m|=1<<6;}
	if(bt32_1[25]){m|=1<<5;}
	if(bt32_1[26]){m|=1<<4;}
	if(bt32_1[27]){m|=1<<3;}
	if(bt32_1[28]){m|=1<<2;}
	if(bt32_1[29]){m|=1<<1;}
	if(bt32_1[30]){m|=1<<0;}

	bri=0;
	br[bri]=bt32_1[31];++bri;

	l=0;
	while(!feof(f4)&&l<p)
	{
		while(!feof(f4)&&bri<m)
		{
			nH=getc(f4);
			pr32_(nH ,bt32_1,bt32i_1);
			br[bri]=bt32_1[24];++bri;
			br[bri]=bt32_1[25];++bri;
			br[bri]=bt32_1[26];++bri;
			br[bri]=bt32_1[27];++bri;
			br[bri]=bt32_1[28];++bri;
			br[bri]=bt32_1[29];++bri;
			br[bri]=bt32_1[30];++bri;
			br[bri]=bt32_1[31];++bri;
		}

		n=0;for(i=0;i<m;++i){if(br[i]){n|=1<<(-1+(m-i));}}
		k=0;for(j=i;j<bri;++j){br[k]=br[j];++k;}bri=k;
		//printf(".%d.",n);
		if(ddf[l][0]==n){}else{printf("Index Base number Error ...\n");}
		++l;

	}
	fclose(f4);
	//---------- d index refs

	//---------- c remainder	
	f5=fopen(m_out4fn,"wb");
	fprintf(f5,"%c%c",((ddfi&0xff00)>>8),(ddfi&0x00ff));bitc+=16;

	m=-1;
	for(i=0;i<ddfi;++i)
	{
		pr32_(ddf[i][1] ,bt32_1,bt32i_1);
		p=32;for(a=0;a<32;++a){if(bt32_1[a]){p=a;break;}}
		if(m==-1){m=a;}else{if(m>a){m=a;}}
	}n=m;m=32-m;

	bri=0;
	pr32_(m ,bt32_1, bt32i_1);

	br[bri]=bt32_1[25];++bri;	
	br[bri]=bt32_1[26];++bri;	
	br[bri]=bt32_1[27];++bri;	
	br[bri]=bt32_1[28];++bri;
	br[bri]=bt32_1[29];++bri;
	br[bri]=bt32_1[30];++bri;
	br[bri]=bt32_1[31];++bri;

	for(i=0;i<ddfi;++i)
	{
		pr32_(ddf[i][1] ,bt32_1,bt32i_1);
		p=32;for(a=0;a<32;++a){if(bt32_1[a]){p=a;break;}}
		//printf(".%d.",p-n);
		if(p>n){for(b=n;b<p;++b){br[bri]=false;++bri;}for(b=p;b<32;++b){br[bri]=bt32_1[b];++bri;}
		}else{
		if(p==n){for(b=n;b<32;++b){br[bri]=bt32_1[b];++bri;}}else{printf("BL Error...%d %d\n",p,n);}}
		
		br[bri]=sdf[i];++bri;	//signum ass

		if(!(bri<(BtM-TBEnd))){bri=p_w(f5,m,br,bri);}
	}
	bri=p_r(f5,br,bri);	
	fclose(f5);
	//---------- c remainder	

	//---------- d remainder	
	f5=fopen(m_out4fn,"rb");
	
	nH=getc(f5);nL=getc(f5);p=(nH<<8)|nL;
	nH=getc(f5);pr32_(nH ,bt32_1,bt32i_1);
	
	m=0;
	if(bt32_1[24]){m|=1<<6;}
	if(bt32_1[25]){m|=1<<5;}
	if(bt32_1[26]){m|=1<<4;}
	if(bt32_1[27]){m|=1<<3;}
	if(bt32_1[28]){m|=1<<2;}
	if(bt32_1[29]){m|=1<<1;}
	if(bt32_1[30]){m|=1<<0;}

	bri=0;
	//br[bri]=bt32_1[30];++bri;
	br[bri]=bt32_1[31];++bri;

	l=0;
	while(!feof(f5)&&l<p)
	{
		while(!feof(f5)&&bri<m+1)
		{
			nH=getc(f5);
			pr32_(nH ,bt32_1,bt32i_1);
			br[bri]=bt32_1[24];++bri;
			br[bri]=bt32_1[25];++bri;
			br[bri]=bt32_1[26];++bri;
			br[bri]=bt32_1[27];++bri;
			br[bri]=bt32_1[28];++bri;
			br[bri]=bt32_1[29];++bri;
			br[bri]=bt32_1[30];++bri;
			br[bri]=bt32_1[31];++bri;
		}

		n=0;for(i=0;i<m;++i){if(br[i]){n|=1<<(-1+(m-i));}}

		if(sdf[l]==br[i]){}else{printf("Signum Error ...\n");}

		k=0;for(j=i+1;j<bri;++j){br[k]=br[j];++k;}bri=k;
		//printf(".%d.",n);
		if(ddf[l][1]==n){}else{printf("Remainder number Error ...\n");}
		++l;

	}
	fclose(f5);
	//---------- d remainder	

	//----------------
	printf("compressed bytes %d , file bytes %d  (%d)\n\n\n",
	(long)((double)bitc/8.0),
	(long)((double)fc/8.0),
	(long)((100*(double)((double)bitc/8.0))/(double)((double)fc/8.0)));
	//----------------

	return(0);

}

int	mar79_3(char m_outfn[256],char m_out1fn[256],char m_out2fn[256],char m_out3fn[256],char m_out4fn[256],bool vf)
{

	int		i,j,k,l,m,n,p,q;
	int		a,b,c,d;
	int		fbyte,nH,nL;
	bool		sig;


	//---------- d base number list
	f3=fopen(m_out2fn,"rb");
	
	nH=getc(f3);nL=getc(f3);p=(nH<<8)|nL;ddi=p;
	nH=getc(f3);pr32_(nH ,bt32_1,bt32i_1);
	
	m=0;
	if(bt32_1[24]){m|=1<<7;}
	if(bt32_1[25]){m|=1<<6;}
	if(bt32_1[26]){m|=1<<5;}
	if(bt32_1[27]){m|=1<<4;}
	if(bt32_1[28]){m|=1<<3;}
	if(bt32_1[29]){m|=1<<2;}
	if(bt32_1[30]){m|=1<<1;}
	if(bt32_1[31]){m|=1<<0;}

	bri=0;

	l=0;
	while(!feof(f3)&&l<p)
	{
		while(!feof(f3)&&bri<m)
		{
			nH=getc(f3);
			pr32_(nH ,bt32_1,bt32i_1);
			br[bri]=bt32_1[24];++bri;
			br[bri]=bt32_1[25];++bri;
			br[bri]=bt32_1[26];++bri;
			br[bri]=bt32_1[27];++bri;
			br[bri]=bt32_1[28];++bri;
			br[bri]=bt32_1[29];++bri;
			br[bri]=bt32_1[30];++bri;
			br[bri]=bt32_1[31];++bri;
		}

		n=0;for(i=0;i<m;++i){if(br[i]){n|=1<<(-1+(m-i));}}
		k=0;for(j=i;j<bri;++j){br[k]=br[j];++k;}bri=k;
		dd[l][0]=n;
		++l;

	}
	fclose(f3);
	//---------- d base number list

	//---------- d index refs
	f4=fopen(m_out3fn,"rb");
	
	nH=getc(f4);nL=getc(f4);p=(nH<<8)|nL;
	nH=getc(f4);pr32_(nH ,bt32_1,bt32i_1);
	
	m=0;
	if(bt32_1[24]){m|=1<<6;}
	if(bt32_1[25]){m|=1<<5;}
	if(bt32_1[26]){m|=1<<4;}
	if(bt32_1[27]){m|=1<<3;}
	if(bt32_1[28]){m|=1<<2;}
	if(bt32_1[29]){m|=1<<1;}
	if(bt32_1[30]){m|=1<<0;}

	bri=0;
	br[bri]=bt32_1[31];++bri;

	l=0;
	while(!feof(f4)&&l<p)
	{
		while(!feof(f4)&&bri<m)
		{
			nH=getc(f4);
			pr32_(nH ,bt32_1,bt32i_1);
			br[bri]=bt32_1[24];++bri;
			br[bri]=bt32_1[25];++bri;
			br[bri]=bt32_1[26];++bri;
			br[bri]=bt32_1[27];++bri;
			br[bri]=bt32_1[28];++bri;
			br[bri]=bt32_1[29];++bri;
			br[bri]=bt32_1[30];++bri;
			br[bri]=bt32_1[31];++bri;
		}

		n=0;for(i=0;i<m;++i){if(br[i]){n|=1<<(-1+(m-i));}}
		k=0;for(j=i;j<bri;++j){br[k]=br[j];++k;}bri=k;
		ddf[l][0]=n;
		++l;

	}
	fclose(f4);
	//---------- d index refs

	//---------- d remainder	
	f5=fopen(m_out4fn,"rb");
	
	nH=getc(f5);nL=getc(f5);p=(nH<<8)|nL;ddfi=p;
	nH=getc(f5);pr32_(nH ,bt32_1,bt32i_1);
	
	m=0;
	if(bt32_1[24]){m|=1<<6;}
	if(bt32_1[25]){m|=1<<5;}
	if(bt32_1[26]){m|=1<<4;}
	if(bt32_1[27]){m|=1<<3;}
	if(bt32_1[28]){m|=1<<2;}
	if(bt32_1[29]){m|=1<<1;}
	if(bt32_1[30]){m|=1<<0;}

	bri=0;
	//br[bri]=bt32_1[30];++bri;
	br[bri]=bt32_1[31];++bri;

	l=0;
	while(!feof(f5)&&l<p)
	{
		while(!feof(f5)&&bri<m+1)
		{
			nH=getc(f5);
			pr32_(nH ,bt32_1,bt32i_1);
			br[bri]=bt32_1[24];++bri;
			br[bri]=bt32_1[25];++bri;
			br[bri]=bt32_1[26];++bri;
			br[bri]=bt32_1[27];++bri;
			br[bri]=bt32_1[28];++bri;
			br[bri]=bt32_1[29];++bri;
			br[bri]=bt32_1[30];++bri;
			br[bri]=bt32_1[31];++bri;
		}

		n=0;for(i=0;i<m;++i){if(br[i]){n|=1<<(-1+(m-i));}}
		sdf[l]=br[i];
		k=0;for(j=i+1;j<bri;++j){br[k]=br[j];++k;}bri=k;
		ddf[l][1]=n;
		++l;

	}
	fclose(f5);
	//---------- d remainder	

	//---------- d main 
	f6=fopen(m_outfn,"wb");
	f2=fopen(m_out1fn,"rb");
	
	nH=getc(f2);pr32_(nH ,bt32_1,bt32i_1);
	
	m=0;
	if(bt32_1[24]){m|=1<<3;}
	if(bt32_1[25]){m|=1<<2;}
	if(bt32_1[26]){m|=1<<1;}
	if(bt32_1[27]){m|=1<<0;}

	bri=0;
	br[bri]=bt32_1[28];++bri;
	br[bri]=bt32_1[29];++bri;
	br[bri]=bt32_1[30];++bri;
	br[bri]=bt32_1[31];++bri;

	l=0;
	while(!feof(f2))
	{
		while(!feof(f2)&&bri<m)
		{
			nH=getc(f2);
			pr32_(nH ,bt32_1,bt32i_1);
			br[bri]=bt32_1[24];++bri;
			br[bri]=bt32_1[25];++bri;
			br[bri]=bt32_1[26];++bri;
			br[bri]=bt32_1[27];++bri;
			br[bri]=bt32_1[28];++bri;
			br[bri]=bt32_1[29];++bri;
			br[bri]=bt32_1[30];++bri;
			br[bri]=bt32_1[31];++bri;
		}

		n=0;for(i=0;i<m;++i){if(br[i]){n|=1<<(-1+(m-i));}}
		k=0;for(j=i;j<bri;++j){br[k]=br[j];++k;}bri=k;
		//printf(".%d.",n);

		if(sdf[n])
		{
			if(vf)
			{
				printf("%c%c",
				(((dd[ddf[n][0]][0]+ddf[n][1])&0xff00)>>8),
				(((dd[ddf[n][0]][0]+ddf[n][1])&0x00ff)>>0)
				);
			}else{
				fprintf(f6,"%c%c",
				(((dd[ddf[n][0]][0]+ddf[n][1])&0xff00)>>8),
				(((dd[ddf[n][0]][0]+ddf[n][1])&0x00ff)>>0)
				);
			}
		}else{
			if(vf)
			{
				printf("%c%c",
				(((dd[ddf[n][0]][0]-ddf[n][1])&0xff00)>>8),
				(((dd[ddf[n][0]][0]-ddf[n][1])&0x00ff)>>0)
				);
			}else{
				fprintf(f6,"%c%c",
				(((dd[ddf[n][0]][0]-ddf[n][1])&0xff00)>>8),
				(((dd[ddf[n][0]][0]-ddf[n][1])&0x00ff)>>0)
				);
			}
		}
		++l;

		if(l>=BuffL)
		{
			nH=getc(f2);pr32_(nH ,bt32_1,bt32i_1);
	
			m=0;
			if(bt32_1[24]){m|=1<<3;}
			if(bt32_1[25]){m|=1<<2;}
			if(bt32_1[26]){m|=1<<1;}
			if(bt32_1[27]){m|=1<<0;}

			bri=0;
			br[bri]=bt32_1[28];++bri;
			br[bri]=bt32_1[29];++bri;
			br[bri]=bt32_1[30];++bri;
			br[bri]=bt32_1[31];++bri;

			l=0;//printf("\n");
		}
	}
	fclose(f2);
	fclose(f6);
	//---------- d main 
		
	return(0);

}

int main(int argc,char *argv[])
{

	int	a,b,c,ci,d;
	int	i,j,k,l,m;

	char	cmd[50][256];
	char	c_1[256];
	char	c_2[256];

	char	fn[10][2];int	fi=0;
	int	op=0;

/*
	if(argv[1]!=NULL)
	{
		strcpy(rfn,argv[1]);
		f1=fopen(rfn,"rb");if(f1==NULL){return(0);}
	}else{return(0);}

	mar79_1(rfn,"n.txt");
	mar79_2(rfn,"a.txt","b.txt","c.txt","d.txt");

	mar79_3("out.txt","a.txt","b.txt","c.txt","d.txt",false);
*/

	//
	printf("\nBinary Compression 79\n");
	printf("written by Dzinleski Jasenko March-July , 2008 , May 2010\n");
	printf("OS Win32 VRM 3.0.1\n\n");
	//

	for(i=0;i<50;++i){for(j=0;j<256;++j){cmd[i][j]='\0';}}
	for(i=0;i<argc;++i){strcpy(cmd[i],argv[i]);}

	//|	-
	ci=1;
	for(i=0;i<256;++i){c_1[i]='\0';}
	c_p(c_l,ci,true,c_1);
	//for(i=0;i<strlen(c_1);++i){printf("%c",c_1[i]);}

	ci=1;
	for(i=0;i<256;++i){c_2[i]='\0';}
	c_p(c_1,ci,false,c_2);
	//for(i=0;i<strlen(c_2);++i){printf("%c",c_2[i]);}

	if(cmd[1][0]==c_2[0]||cmd[1][0]==c_2[1]){}else{return(0);}
	//|


	//|	h , e , c , d 
	ci=2;
	for(i=0;i<256;++i){c_1[i]='\0';}
	c_p(c_l,ci,true,c_1);
	//for(i=0;i<strlen(c_1);++i){printf("%c",c_1[i]);}

	ci=1;
	for(i=0;i<256;++i){c_2[i]='\0';}
	c_p(c_1,ci,false,c_2);
	//for(i=0;i<strlen(c_2);++i){printf("%c",c_2[i]);}

	if(cmd[1][1]==c_2[0]||cmd[1][1]==c_2[1]){op=1;/*printf("h");*/}

	ci=2;
	for(i=0;i<256;++i){c_2[i]='\0';}
	c_p(c_1,ci,false,c_2);
	//for(i=0;i<strlen(c_2);++i){printf("%c",c_2[i]);}

	if(cmd[1][1]==c_2[0]||cmd[1][1]==c_2[1]){op=2;/*printf("l");*/}

	ci=3;
	for(i=0;i<256;++i){c_2[i]='\0';}
	c_p(c_1,ci,false,c_2);
	//for(i=0;i<strlen(c_2);++i){printf("%c",c_2[i]);}

	if(cmd[1][1]==c_2[0]||cmd[1][1]==c_2[1]){op=3;/*printf("c");*/}

	ci=4;
	for(i=0;i<256;++i){c_2[i]='\0';}
	c_p(c_1,ci,false,c_2);
	//for(i=0;i<strlen(c_2);++i){printf("%c",c_2[i]);}

	if(cmd[1][1]==c_2[0]||cmd[1][1]==c_2[1]){op=4;/*printf("d");*/}

	if(!(op==1||op==2||op==3||op==4)){return(0);}else{

		if(op==1)
		{

			printf("\nBinary Compression 79\n");
			printf("March-July , 2008 , May 2010\n");
			printf("\nOS Win32 VRM 3.0.1\n\n");
			printf("\n");
			printf("mar79_xxx -c <filename to compress>\n");
			printf("mar79_xxx -d <compressed filename> [<output filename>]\n");
			printf("\n");

			return(0);

		}

		if(op==2)
		{

			printf("\nBinary Compression 79\n");
			printf("written by Dzinleski Jasenko 2008,2009,2010\n");
			printf("\nOS Win32 VRM 3.0.1\n\n");
			printf("\n");
			printf("\tThis source and compression method apply to GNU General Public License.\n");
			printf("\t		Copyright (C) 2008,2009,2010 Jasenko Dzinleski \n");
			printf("\n");
			printf("\t	This program is free software; you can redistribute it\n");
			printf("\tand/or modify it under the terms of the GNU General Public License as\n");
			printf("\tpublished by the Free Software Foundation; either version 2 of the\n");
			printf("\tLicense, or (at your option) any later version.\n");
			printf("\n");
			printf("\tThis program is distributed in the hope that it will be useful, but\n");
			printf("\tWITHOUT ANY WARRANTY; without even the implied warranty of\n");
			printf("\tMERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU\n");
			printf("\tGeneral Public License for more details.\n");
			printf("\n");
			printf("\tYou should have received a copy of the GNU General Public License along\n");
			printf("\twith this program; if not, write to the Free Software Foundation, Inc.,\n");
			printf("\t51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.\n");
			printf("\n");

			return(0);
		}

		if(op==3)
		{

		//|	<filename>
		ci=3;
		for(i=0;i<256;++i){c_1[i]='\0';}
		c_p(c_l,ci,true,c_1);
		//for(i=0;i<strlen(c_1);++i){printf("%c",c_1[i]);}

		ci=1;
		for(i=0;i<256;++i){c_2[i]='\0';}
		c_p(c_1,ci,false,c_2);
		//for(i=0;i<strlen(c_2);++i){printf("%c",c_2[i]);}

		fn[fi][0]=c_2[0];fn[fi][1]=c_2[1];++fi;

		ci=2;
		for(i=0;i<256;++i){c_2[i]='\0';}
		c_p(c_1,ci,false,c_2);
		//for(i=0;i<strlen(c_2);++i){printf("%c",c_2[i]);}

		fn[fi][0]=c_2[0];fn[fi][1]=c_2[1];++fi;

		ci=3;
		for(i=0;i<256;++i){c_2[i]='\0';}
		c_p(c_1,ci,false,c_2);
		//for(i=0;i<strlen(c_2);++i){printf("%c",c_2[i]);}

		fn[fi][0]=c_2[0];fn[fi][1]=c_2[1];++fi;

		ci=4;
		for(i=0;i<256;++i){c_2[i]='\0';}
		c_p(c_1,ci,false,c_2);
		//for(i=0;i<strlen(c_2);++i){printf("%c",c_2[i]);}

		fn[fi][0]=c_2[0];fn[fi][1]=c_2[1];++fi;

		ci=5;
		for(i=0;i<256;++i){c_2[i]='\0';}
		c_p(c_1,ci,false,c_2);
		//for(i=0;i<strlen(c_2);++i){printf("%c",c_2[i]);}

		fn[fi][0]=c_2[0];fn[fi][1]=c_2[1];++fi;

		ci=6;
		for(i=0;i<256;++i){c_2[i]='\0';}
		c_p(c_1,ci,false,c_2);
		//for(i=0;i<strlen(c_2);++i){printf("%c",c_2[i]);}

		fn[fi][0]=c_2[0];fn[fi][1]=c_2[1];++fi;
		//|

		for(i=0;i<strlen(cmd[2]);++i)
		{
			if
				(
				(cmd[2][i]>=fn[0][0]&&cmd[2][i]<=fn[0][1])||
				(cmd[2][i]>=fn[1][0]&&cmd[2][i]<=fn[1][1])||
				(cmd[2][i]>=fn[2][0]&&cmd[2][i]<=fn[2][1])||
				(cmd[2][i]>=fn[3][0]&&cmd[2][i]<=fn[3][1])||
				(cmd[2][i]>=fn[4][0]&&cmd[2][i]<=fn[4][1])||
				(cmd[2][i]>=fn[5][0]&&cmd[2][i]<=fn[5][1])
				){}else{break;}
		}
		if(i==strlen(cmd[2])){/*printf("?");*/}else{return(0);}
		//|

		f_n(cmd[2],NULL);
		mar79_1(cmd[2],"n.txt");
		mar79_2(cmd[2],out1fn,out2fn,out3fn,out4fn);

		}

		if(op==4)
		{

		//|	<filename>
		ci=3;
		for(i=0;i<256;++i){c_1[i]='\0';}
		c_p(c_l,ci,true,c_1);
		//for(i=0;i<strlen(c_1);++i){printf("%c",c_1[i]);}

		ci=1;
		for(i=0;i<256;++i){c_2[i]='\0';}
		c_p(c_1,ci,false,c_2);
		//for(i=0;i<strlen(c_2);++i){printf("%c",c_2[i]);}

		fn[fi][0]=c_2[0];fn[fi][1]=c_2[1];++fi;

		ci=2;
		for(i=0;i<256;++i){c_2[i]='\0';}
		c_p(c_1,ci,false,c_2);
		//for(i=0;i<strlen(c_2);++i){printf("%c",c_2[i]);}

		fn[fi][0]=c_2[0];fn[fi][1]=c_2[1];++fi;

		ci=3;
		for(i=0;i<256;++i){c_2[i]='\0';}
		c_p(c_1,ci,false,c_2);
		//for(i=0;i<strlen(c_2);++i){printf("%c",c_2[i]);}

		fn[fi][0]=c_2[0];fn[fi][1]=c_2[1];++fi;

		ci=4;
		for(i=0;i<256;++i){c_2[i]='\0';}
		c_p(c_1,ci,false,c_2);
		//for(i=0;i<strlen(c_2);++i){printf("%c",c_2[i]);}

		fn[fi][0]=c_2[0];fn[fi][1]=c_2[1];++fi;

		ci=5;
		for(i=0;i<256;++i){c_2[i]='\0';}
		c_p(c_1,ci,false,c_2);
		//for(i=0;i<strlen(c_2);++i){printf("%c",c_2[i]);}

		fn[fi][0]=c_2[0];fn[fi][1]=c_2[1];++fi;

		ci=6;
		for(i=0;i<256;++i){c_2[i]='\0';}
		c_p(c_1,ci,false,c_2);
		//for(i=0;i<strlen(c_2);++i){printf("%c",c_2[i]);}

		fn[fi][0]=c_2[0];fn[fi][1]=c_2[1];++fi;
		//|

		for(i=0;i<strlen(cmd[2]);++i)
		{
			if
				(
				(cmd[2][i]>=fn[0][0]&&cmd[2][i]<=fn[0][1])||
				(cmd[2][i]>=fn[1][0]&&cmd[2][i]<=fn[1][1])||
				(cmd[2][i]>=fn[2][0]&&cmd[2][i]<=fn[2][1])||
				(cmd[2][i]>=fn[3][0]&&cmd[2][i]<=fn[3][1])||
				(cmd[2][i]>=fn[4][0]&&cmd[2][i]<=fn[4][1])||
				(cmd[2][i]>=fn[5][0]&&cmd[2][i]<=fn[5][1])
				){}else{break;}
		}
		if(i==strlen(cmd[2])){/*printf("?");*/}else{return(0);}
		//|

		if(strlen(cmd[3])!=0)
		{
			f_n(cmd[2],cmd[3]);
			mar79_3(outfn,out1fn,out2fn,out3fn,out4fn,false);
		}else{
			f_n(cmd[2],NULL);
			mar79_3("out.txt",out1fn,out2fn,out3fn,out4fn,true);
		}

		}
	}
	//|

	return(0);

}

