/*
 * Copyright (C) 1998 by Mike Goldman.  All rights reserved.
 * Please read the file LICENSE.TXT for License information.
 */

#include <stdlib.h>
#include <string.h>
#include "Types.h"
#include "Text.h"
#include "Error.h"
#include "Queue.h"

#define TEXTOFS(t) ((t)&0xFFFF)
#define TEXTSEG(t) ((t)>>16)

typedef struct {
    U8 *Text;
    Queue Q;
}   Seg;

static Text  Curr = 0;
static U16  nHist = 0;
static U16  xHist = 0;
static Seg  *Hist = NULL;

Text TextPut(int c)
{
    if (!TEXTOFS(Curr)) {
        if ((!(Hist = realloc(Hist, sizeof(*Hist) * ++nHist)) ||
            !(Hist[TEXTSEG(Curr)].Text = malloc(0x10000))))
            FatalError("No memory for history.\n");
        Q_Init(&Hist[TEXTSEG(Curr)].Q);
    }
    Hist[TEXTSEG(Curr)].Text[TEXTOFS(Curr)] = c;
    return Curr++;
}

int TextGet(Text T)
{
    return (int)Hist[TEXTSEG(T)].Text[TEXTOFS(T)];
}

QNod *TextPush(Text T, Mem Data)
{
    QNod *Push = NULL;
    Push = Q_Push(&Hist[TEXTSEG(T)].Q, Data);
    return Push;
}

int TextProt(Text T, Mem Data)
{
    int Prot = Q_Prot(&Hist[TEXTSEG(T)].Q, Data);
    return Prot;
}

QNod *TextRest(Text T)
{
    QNod *Rest = Q_Rest(&Hist[TEXTSEG(T)].Q);
    return Rest;
}

Mem TextPull(void)
{
    Mem Pull;
    while ((Pull = Q_Pull(&Hist[xHist].Q)) == MEM_INV)
        free(Hist[xHist++].Text);
    return Pull;
}

Mem TextYank(Text T, QNod *Node)
{
    Mem Yank = MEM_INV;
    Yank = Q_Yank(&Hist[TEXTSEG(T)].Q, Node);
    return Yank;
}
