/*
 * Copyright (C) 1998 by Mike Goldman.  All rights reserved.
 * Please read the file LICENSE.TXT for License information.
 */

#include <string.h>
#include "Score.h"
#include "Item.h"

void StoreScore(Score *Score, Context *Ctx)
{
    int i, j;
    U8 *Syms = GETMEM(&MemSym[Ctx->NSym], Ctx->XSym);
    if (!Score->Scored) bzero((void *)Score, sizeof(*Score));
    for (i = 0; i < 4; i++) if (Ctx->MSym[i])
	for (j = 0; j < 8; j++) if (Ctx->MSym[i] & (1<<j)) 
            Score->Flags[(i<<3)+j] |= *Syms++;
    Score->Scored = 1;
}

Count *CountScore(Context *Ctx, Score *Score, U16 *pTCnt)
{
    U8 *Syms;
    int Item, i, j, fK;
    U16 TCnt = Ctx->TCnt;
    static Count Counts[256];
    Count *pCnt = GETMEM(&MemCnt[Ctx->NCnt], Ctx->XCnt);
    if (!Score->Scored) {
	*pTCnt = TCnt;
	return (pCnt);
    }
    memcpy(Counts, pCnt, MEMUSE(&MemCnt[Ctx->NCnt]));
    Syms = GETMEM(&MemSym[Ctx->NSym], Ctx->XSym);
    for (Item = i = 0; i < 4; i++) if (Ctx->MSym[i])
	for (j = 0; j < 8; j++) if (Ctx->MSym[i] & (1<<j)) {
	for (fK = 1; fK < 256; fK += fK) if (*Syms & fK) {
	    if (Score->Flags[(i<<3)|j] & fK) {
	        TCnt -= Counts[Item]; Counts[Item] = 0;
	    }
	    Item++;
	}
	Syms++;
    }
    *pTCnt = TCnt;
    return (Counts);
}
