/*
 * Copyright (C) 1998 by Mike Goldman.  All rights reserved.
 * Please read the file LICENSE.TXT for License information.
 */

#ifndef QUEUE_H
#define QUEUE_H

#include "Types.h"

struct Queue {
    QNod *Push;
    QNod *Pull;
    Mem   Save;
};

struct QNod {
    Mem   Data;
    QNod *Prev;
    QNod *Next;
};

void  Q_Init(Queue *Q);
QNod *Q_Push(Queue *Q, Mem Data);
Mem   Q_Pull(Queue *Q);
Mem   Q_Yank(Queue *Q, QNod *Node);
int   Q_Prot(Queue *Q, Mem Data);
QNod *Q_Rest(Queue *Q);

#endif
