/*
 * Copyright (C) 1998 by Mike Goldman.  All rights reserved.
 * Please read the file LICENSE.TXT for License information.
 */

#include <stdlib.h>
#include <string.h>
#include "Types.h"
#include "Queue.h"
#include "Error.h"

void Q_Init(Queue *Q)
{
    Q->Push = Q->Pull = NULL;
    Q->Save = MEM_INV;
}

QNod *Q_Push(Queue *Q, Mem Data)
{
    QNod *Node = malloc(sizeof *Node);
    if (!Node) FatalError("No memory for Q\n");
    Node->Data = Data;
    Node->Prev = NULL;
    if ((Node->Next = Q->Push) != NULL)
        Q->Push->Prev = Node;
    else
        Q->Pull = Node;
    Q->Push = Node;
    return (Node);
}

Mem Q_Pull(Queue *Q)
{
    Mem Data;
    QNod *Node;
    if (Q->Pull == NULL) return (MEM_INV);
    Node = Q->Pull;
    Data = Node->Data;
    Node = Node->Prev;
    free(Q->Pull);
    if (!(Q->Pull = Node)) Q->Push = NULL;
    else Node->Next = NULL;
    return Data;
}

Mem Q_Yank(Queue *Q, QNod *Node)
{
    U16 Data = Node->Data;
    if (Node->Prev != NULL)
        Node->Prev->Next = Node->Next;
    if (Node->Next != NULL)
        Node->Next->Prev = Node->Prev;
    if (Q->Push == Node && (Q->Push = Node->Next) == NULL)
	Q->Push = Node->Prev;
    if (Q->Pull == Node && (Q->Pull = Node->Prev) == NULL)
	Q->Pull = Node->Next;
    free(Node);
    return (Data);
}

int Q_Prot(Queue *Q, Mem Data)
{
    if (Q->Pull == NULL || Q->Pull->Data != Data) return (0);
    Q->Save = Q_Pull(Q); return (1);
}

QNod *Q_Rest(Queue *Q)
{
    QNod *Node = malloc(sizeof *Node);
    if (!Node) FatalError("No memory for Q\n");
    Node->Data = Q->Save; Q->Save = MEM_INV;
    Node->Next = NULL;
    if ((Node->Prev = Q->Pull) != NULL)
        Q->Pull->Next = Node;
    else
        Q->Push = Node;
    Q->Pull = Node;
    return (Node);
}
