/*
 * Copyright (C) 1998 by Mike Goldman.  All rights reserved.
 * Please read the file LICENSE.TXT for License information.
 */

#ifndef MEM_H
#define MEM_H

#include "Types.h"

struct MemArr {
    void *Arr;
    Mem  *Lst;
    Mem   Del;
    Mem   Use;
    U16   UBS;
};

#define GETMEM(p,i)   ((p)->Arr+(p)->UBS*(i))
#define MEMUSE(p)     ((p)->UBS)

Mem  New_Struc(MemArr *Arr);
void Del_Struc(MemArr *Arr, Mem Index);
void Init_Mem(MemArr *Arr, U16 UnitByteSize);

#endif
