/*
 * Copyright (C) 1998 by Mike Goldman.  All rights reserved.
 * Please read the file LICENSE.TXT for License information.
 */

#include <string.h>
#include <stdlib.h>
#include "Error.h"
#include "Mem.h"

void Init_Mem(MemArr *Arr, U16 UnitByteSize)
{
    bzero((void *)Arr, sizeof(*Arr));
    Arr->UBS = UnitByteSize;
}

static Mem Get_Last_Del(MemArr *Arr)
{
    void *Alloc;
    Mem New = Arr->Lst[--Arr->Del];
    if (!Arr->Del) { free(Arr->Lst); Arr->Lst = NULL; }
    else if ((Alloc = realloc(Arr->Lst, Arr->Del * sizeof(*Arr->Lst))))
	Arr->Lst = Alloc;
    return (New);
}

static void Free_Struc(MemArr *Arr)
{
    Mem Del;
    void *Alloc;
    Arr->Use--;
    if ((Del = Arr->Del) && Arr->Lst[--Del] == Arr->Use-1) {
	for (Arr->Use--; Del && Arr->Lst[Del-1] == Arr->Use-1; Del--)
	     Arr->Use--;
	if (!Del) { free(Arr->Lst); Arr->Lst = NULL; }
	else if ((Alloc = realloc(Arr->Lst, Del * sizeof(*Arr->Lst))))
	    Arr->Lst = Alloc;
	Arr->Del = Del;
    }
    if (!Arr->Use) { free(Arr->Arr); Arr->Arr = NULL; }
    else if ((Alloc = realloc(Arr->Arr, Arr->Use * Arr->UBS))) Arr->Arr = Alloc;
}

void Del_Struc(MemArr *Arr, Mem Index)
{
    Mem Del;
    void *Alloc;
    if (Index == Arr->Use-1) { Free_Struc(Arr); return; }
    if (!(Del = Arr->Del)) {
        if (!(Alloc = malloc(sizeof(*Arr->Lst)))) return; Arr->Lst = Alloc;
        Arr->Lst[0] = Index;
	Arr->Del = 1;
	return;
    }
    if (!(Alloc = realloc(Arr->Lst, (Del+1)*sizeof(*Arr->Lst)))) return;
    Arr->Lst = Alloc;
    while (Del && Arr->Lst[Del-1] > Index) Del--;
    if (Del < Arr->Del) memmove(&Arr->Lst[Del+1], &Arr->Lst[Del],
        (Arr->Del-Del) * sizeof(*Arr->Lst));
    Arr->Lst[Del] = Index;
    Arr->Del++;
}

Mem New_Struc(MemArr *Arr)
{
    void *Alloc;
    if (Arr->Del) return (Get_Last_Del(Arr));
    if (Arr->Use == MEM_INV) return (MEM_INV);
    if (!(Alloc = realloc(Arr->Arr, (Arr->Use+1) * Arr->UBS)))
        FatalError("Could not allocate memory!\n");
    Arr->Arr = Alloc; return (Arr->Use++);
}
