/*
 * Copyright (C) 1998 by Mike Goldman.  All rights reserved.
 * Please read the file LICENSE.TXT for License information.
 */

#include <string.h>
#include <stdio.h>
#include <sys/time.h>
#include "Copyr.h"
#include "File.h"
#include "Error.h"
#include "Model.h"

void UsageExit(char *arg0)
{
    char *name, *ext;
    License();
    if (!(name = strrchr(arg0, '\\')) &&
        !(name = strrchr(arg0, '/'))  &&
        !(name = strrchr(arg0, ':')))
        name = arg0;
    else name++;
    if ((ext = strrchr(name, '.'))) *ext = 0;
    printf("Usage: %s %s\n", name, Usage);
    exit(0);
}

void PrintTiming(long ms)
{
    double Secs = ms/1e3;
    long Mins = Secs/60;
    printf("Restored file in %ld:%04.1f\n", Mins, Secs - Mins * 60);
}

int main(int argc, char *argv[])
{
    struct timeval tv[2]; long ms;
    Copyright("UnLZap");
    setbuf(stdout, NULL);
    if (argc < 3) UsageExit(argv[0]);
    if (!OpenGetBitFile(argv[1]))
        FatalError("Error opening %s for input\n", argv[1]);
    if (!OpenPutByteFile(argv[2]))
        FatalError("Error opening %s for output\n", argv[2]);
    printf("Expanding %s to %s\n", argv[1], argv[2]);
    printf("Using %s\n", COMPRESSION);
    gettimeofday(&tv[0], NULL);
    DecodeFile();
    gettimeofday(&tv[1], NULL);
    ms = (tv[1].tv_sec  - tv[0].tv_sec)  * 1000 +
         (tv[1].tv_usec - tv[0].tv_usec) / 1000;
    PrintTiming(ms);
    ClosePutByteFile();
    CloseGetBitFile();
    return (0);
}
