/*
 * Copyright (C) 1998 by Mike Goldman.  All rights reserved.
 * Please read the file LICENSE.TXT for License information.
 */

#include <string.h>
#include <stdio.h>
#include <sys/time.h>
#include "Copyr.h"
#include "File.h"
#include "Error.h"
#include "Model.h"

void UsageExit(char *arg0)
{
    char *name, *ext;
    License();
    if (!(name = strrchr(arg0, '\\')) &&
        !(name = strrchr(arg0, '/'))  &&
        !(name = strrchr(arg0, ':')))
        name = arg0;
    else name++;
    if ((ext = strrchr(name, '.'))) *ext = 0;
    printf("Usage: %s %s\n", name, Usage);
    exit(0);
}

void PrintRatios(long ms)
{
    double Secs = ms/1e3;
    long Mins = Secs/60;
    long GetLen, PutLen;
    if (!(GetLen = SizeByteFile())) GetLen++;
    if (!(PutLen = SizeBitFile()))  PutLen++;
    if (!ms) ms++;
    printf("Reduced %5.1f%%  (%ld to %ld) in %ld:%04.1f\n",
	1e2-(1e2*PutLen)/GetLen, GetLen, PutLen,
	Mins, Secs - Mins * 60);
    printf("Ratio: %5.2f:1", (double)GetLen/PutLen);
    printf("  (%.3fb/B)\n", 8.*PutLen/GetLen);
    printf("Speed: %4.1fK/s", 1e3 * GetLen / ms / 1024.);
    printf("  (%.1fms/K)\n", 1024. * ms / GetLen);
}

int main(int argc, char *argv[])
{
    struct timeval tv[2]; long ms;
    Copyright("LZap");
    setbuf(stdout, NULL);
    if (argc < 3) UsageExit(argv[0]);
    if (!OpenGetByteFile(argv[1]))
        FatalError("Error opening %s for input\n", argv[1]);
    if (!OpenPutBitFile(argv[2]))
        FatalError("Error opening %s for output\n", argv[2]);
    printf("Compressing %s to %s\n", argv[1], argv[2]);
    printf("Using %s\n", COMPRESSION);
    gettimeofday(&tv[0], NULL);
    EncodeFile();
    gettimeofday(&tv[1], NULL);
    ms = (tv[1].tv_sec  - tv[0].tv_sec)  * 1000 +
         (tv[1].tv_usec - tv[0].tv_usec) / 1000;
    PrintRatios(ms);
    ClosePutBitFile();
    CloseGetByteFile();
    return (0);
}
