/*
 * Copyright (C) 1998 by Mike Goldman.  All rights reserved.
 * Please read the file LICENSE.TXT for License information.
 */

#include <string.h>
#include <stdlib.h>
#include "Mem.h"
#include "Context.h"
#include "Item.h"
#include "Error.h"

static char ItemBits[256] = {
    0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4,
    1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5,
    1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5,
    2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
    1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5,
    2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
    2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
    3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
    1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5,
    2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
    2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
    3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
    2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
    3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
    3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
    4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8
};

int ItemSymbol(Context *Ctx, U8 Item)
{
    int i, j, k, Bits;
    U8 *pSym = GETMEM(&MemSym[Ctx->NSym], Ctx->XSym);
    for (i = 0; i < 4; i++) if (Ctx->MSym[i])
        for (j = 0; j < 8; j++) if (Ctx->MSym[i] & (1<<j)) {
        if ((Bits = ItemBits[*pSym]) <= Item) Item -= Bits;
        else for (k = 0; k < 8; k++)
            if (*pSym & (1<<k) && !Item--) return ((i<<6)|(j<<3)|k);
        pSym++;
    }
    return (-1);
}

void DelItem(Context *Ctx, U8 Item)
{
    int i, j, k, Bits, Find, Offs;
    int NCnt; Mem XCnt; Count *OldCnt, *NewCnt;
    int NSym; Mem XSym; U8    *OldSym, *NewSym;
    i = j = k = 0;
    OldSym = GETMEM(&MemSym[Ctx->NSym], Ctx->XSym); Offs = 0;
    for (Find = Item; i < 4; i++, j = 0) if (Ctx->MSym[i])
        for (; j < 8; j++) if (Ctx->MSym[i] & (1<<j)) {
        if ((Bits = ItemBits[OldSym[Offs]]) <= Find) Find -= Bits;
        else for (k = 1; k < 256; k+=k)
            if (OldSym[Offs] & k && !Find--) goto Found;
        Offs++;
    }
Found:
    if (!(OldSym[Offs] &= ~k)) {
        Ctx->MSym[i] &= ~(1<<(j&7));
        XSym = New_Struc(&MemSym[NSym = Ctx->NSym-1]);
        NewSym = GETMEM(&MemSym[NSym], XSym);
        if (Offs)
            memcpy(NewSym, OldSym, Offs);
        if (Offs < Ctx->NSym)
            memcpy(&NewSym[Offs], &OldSym[Offs+1], Ctx->NSym-Offs);
        Del_Struc(&MemSym[Ctx->NSym], Ctx->XSym);
        Ctx->NSym = NSym; Ctx->XSym = XSym;
    }
    XCnt = New_Struc(&MemCnt[NCnt = Ctx->NCnt-1]);
    OldCnt = GETMEM(&MemCnt[Ctx->NCnt], Ctx->XCnt);
    NewCnt = GETMEM(&MemCnt[NCnt], XCnt);
    if (Item)
        memcpy(NewCnt, OldCnt, Item);
    if (Item < Ctx->NCnt)
        memcpy(&NewCnt[Item], &OldCnt[Item+1], Ctx->NCnt-Item);
    Del_Struc(&MemCnt[Ctx->NCnt], Ctx->XCnt);
    Ctx->NCnt = NCnt; Ctx->XCnt = XCnt;
}

int FindItem(Context *Ctx, U8 Sym)
{
    U8 *pSym;
    int Offs, MBit, Item, i;
    pSym = Ctx->MSym; Offs = Sym>>6; MBit = 1<<((Sym>>3)&7);
    if (!(pSym[Offs] & MBit)) return (-1);
    Item = ItemBits[pSym[Offs] & (MBit-1)];
    for (i = 0; i < Offs; i++) Item += ItemBits[pSym[i]];
    pSym = GETMEM(&MemSym[Ctx->NSym], Ctx->XSym);
    Offs = Item; MBit = 1<<(Sym&7);
    if (!(pSym[Offs] & MBit)) return (-1);
    Item = ItemBits[pSym[Offs] & (MBit-1)];
    for (i = 0; i < Offs; i++) Item += ItemBits[pSym[i]];
    return (Item);
}

int FirstItem(Context *Ctx, U8 Sym)
{
    Ctx->XCnt = New_Struc(&MemCnt[0]);
    Ctx->XSym = New_Struc(&MemSym[0]);
    ((Count *)GETMEM(&MemCnt[0], Ctx->XCnt))[0] = 0;
    ((U8    *)GETMEM(&MemSym[0], Ctx->XSym))[0] = 1<<(Sym&7);
    bzero(Ctx->MSym, sizeof(Ctx->MSym));
    Ctx->MSym[Sym>>6] = 1<<((Sym>>3)&7);
    Ctx->NCnt = 0;
    Ctx->TCnt = 0;
    Ctx->MCnt = 0;
    Ctx->NSym = 0;
    return (0);
}

int GetItem(Context *Ctx, U8 Sym)
{
    U8 *pSym;
    int i, Item, Offs, MBit;
    int NCnt; Mem XCnt; Count *OldCnt, *NewCnt;
    int NSym; Mem XSym; U8    *OldSym, *NewSym;
    if (Ctx->XCnt == MEM_INV) return (FirstItem(Ctx, Sym));
    pSym = Ctx->MSym; Offs = Sym>>6; MBit = 1<<((Sym>>3)&7);
    Item = ItemBits[pSym[Offs] & (MBit-1)];
    for (i = 0; i < Offs; i++) Item += ItemBits[pSym[i]];
    if (pSym[Offs] & MBit) {
        pSym = GETMEM(&MemSym[Ctx->NSym], Ctx->XSym);
        Offs = Item; MBit = 1<<(Sym&7);
        Item = ItemBits[pSym[Offs] & (MBit-1)];
        for (i = 0; i < Offs; i++) Item += ItemBits[pSym[i]];
        if (pSym[Offs] & MBit) return (Item);
        pSym[Offs] |= MBit;
    } else {
        pSym[Offs] |= MBit;
        XSym = New_Struc(&MemSym[NSym = Ctx->NSym+1]);
        OldSym = GETMEM(&MemSym[Ctx->NSym], Ctx->XSym);
        NewSym = GETMEM(&MemSym[NSym], XSym);
        for (i = 0; i < Item; i++) NewSym[i] = OldSym[i];
        for (i++; i <= NSym; i++) NewSym[i] = OldSym[i-1];
        Del_Struc(&MemSym[Ctx->NSym], Ctx->XSym);
        Ctx->NSym = NSym; Ctx->XSym = XSym;
        pSym = NewSym; Offs = Item; MBit = 1<<(Sym&7);
        for (Item = i = 0; i < Offs; i++) Item += ItemBits[pSym[i]];
        pSym[Offs] = MBit;
    }
    XCnt = New_Struc(&MemCnt[NCnt = Ctx->NCnt+1]);
    OldCnt = GETMEM(&MemCnt[Ctx->NCnt], Ctx->XCnt);
    NewCnt = GETMEM(&MemCnt[NCnt], XCnt);
    for (i = 0; i < Item; i++) NewCnt[i] = OldCnt[i];
    for (i++; i <= NCnt; i++) NewCnt[i] = OldCnt[i-1];
    Del_Struc(&MemCnt[Ctx->NCnt], Ctx->XCnt);
    Ctx->NCnt = NCnt; Ctx->XCnt = XCnt;
    NewCnt[Item] = 0;
    return (Item);
}
