/*
 * Copyright (C) 1998 by Mike Goldman.  All rights reserved.
 * Please read the file LICENSE.TXT for License information.
 */

#include <stdio.h>
#include <stdlib.h>
#include "Types.h"
#include "File.h"

static FILE *ByteFile;
static FILE *BitFile;
static int   BitByte;
static int   BitMask;
static U32   BytePos;
static U32   InDiv;
static U32   InPos;

static void FlushPutByteFile(void)
{
}

static void FlushPutBitFile(void)
{
    if (BitMask != 0x01) {
	fputc(BitByte, BitFile);
	BitMask = 0x01;
	BitByte = 0x00;
    }
}

static long SizeFile(FILE *File)
{
    long pos, end;
    pos = ftell(File);
    fseek(File, 0, SEEK_END);
    end = ftell(File);
    fseek(File, pos, SEEK_SET);
    return (end);
}

long SizeByteFile(void)
{
    return SizeFile(ByteFile);
}

long SizeBitFile(void)
{
    return SizeFile(BitFile);
}

static void CloseByteFile(void)
{
    fclose(ByteFile);
    ByteFile = NULL;
}

static void CloseBitFile(void)
{
    fclose(BitFile);
    BitFile = NULL;
}

void CloseGetByteFile(void)
{
    CloseByteFile();
}

void CloseGetBitFile(void)
{
    CloseBitFile();
}

void ClosePutByteFile(void)
{
    FlushPutByteFile();
    CloseByteFile();
}

void ClosePutBitFile(void)
{
    FlushPutBitFile();
    CloseBitFile();
}

static int OpenByteFile(char *name, char *flags)
{
    return ((ByteFile = fopen(name, flags)) != NULL);
}

static int OpenBitFile(char *name, char *flags)
{
    return ((BitFile = fopen(name, flags)) != NULL);
}

int OpenGetByteFile(char *name)
{
    if (!OpenByteFile(name, "rb")) return 0;
    InDiv = (99+SizeByteFile()) / 100;
    if (!InDiv) InDiv++;
    InPos = BytePos = 0;
    return 1;
}

int OpenGetBitFile(char *name)
{
    if (!OpenBitFile(name, "rb")) return 0;
    InDiv = (99+SizeBitFile())  / 100;
    if (!InDiv) InDiv++;
    InPos = BytePos = 0;
    BitMask = 0xFF; return 1;
}

int OpenPutByteFile(char *name)
{
    if (!OpenByteFile(name, "wb")) return 0;
    return 1;
}

int OpenPutBitFile(char *name)
{
    if (!OpenBitFile(name, "wb")) return 0;
    BitMask = 0x01; return 1;
}

int GetByte(void)
{
    if (!(InPos++ & 0x7FFF))
        printf(" %ld%%\r", InPos/InDiv);
    return (fgetc(ByteFile));
}

int GetBit(void)
{
    if ((BitMask += BitMask) > 0xFF) {
        int c = fgetc(BitFile);
	if (c == EOF) return (-1);
	BitMask = 0x01;
	BitByte = c;
        InPos++;
    }
    return ((BitByte & BitMask) != 0);
}

void PutByte(int c)
{
    if (!(BytePos++ & 0x7FFF))
        printf(" %ld%%\r", InPos/InDiv);
    fputc(c, ByteFile);
}

void PutBit(int b)
{
    if (b) BitByte |= BitMask;
    if ((BitMask += BitMask) > 0xFF) {
	fputc(BitByte, BitFile);
	BitMask = 0x01;
	BitByte = 0x00;
    }
}
