/*
 * Copyright (C) 1998 by Mike Goldman.  All rights reserved.
 * Please read the file LICENSE.TXT for License information.
 */

#include "Model.h"
#include "Context.h"
#include "Escape.h"

static char Log2[] = {
    0, 0, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8
};

static U8 Escs[1024];
void InitEscapes(void)
{
    int i;
    for (i = 0; i < 512; i++) Escs[i] = 1;
    for (i = 512; i < 1024; i += 2) { Escs[i] = 0xFE; Escs[i+1] = 1; }
}

int EscapeCode(Context *Ctx)
{
    int Code = (Log2[(int)Ctx->NCnt+1] << 6) | (Log2[Ctx->MCnt] << 3);
    if (Ctx->Dpth < 4) Code |= Ctx->Dpth << 1; else Code |= 6;
    return Code;
}

void EscapeScale(Scale *Scale, int Code, int Esc)
{
    U8 *pEsc = &Escs[Code];
    Scale->sc = pEsc[0] + pEsc[1];
    if (!Esc) {
	Scale->lo = 0;
	Scale->hi = pEsc[0]++;
    } else {
	Scale->lo = pEsc[0];
	Scale->hi = Scale->sc; pEsc[1]++;
    }
    if (pEsc[0] == 0xFF || pEsc[1] == 0xFF) {
	if      (pEsc[0] == 1) pEsc[1]--;
	else if (pEsc[1] == 1) pEsc[0]--;
	else {
            pEsc[0] -= pEsc[0] >> 1;
	    pEsc[1] -= pEsc[1] >> 1;
	}
    }
}

int EscapeStatus(int Code, Model *m)
{
    U8 *pEsc = &Escs[Code];
    int Esc = ((m->cd-m->lo+1L)*(pEsc[0]+pEsc[1])-1)/m->rg>=pEsc[0];
    return Esc;
}
