/*
 * Copyright (C) 1998 by Mike Goldman.  All rights reserved.
 * Please read the file LICENSE.TXT for License information.
 */

#ifndef CONTEXT_H
#define CONTEXT_H

#include"Types.h"

struct Context {
    Tern *Tern;
    Mem  *More;
    QNod *Text;
    Mem   XSym;
    Mem   XCnt;
    U16   TCnt;
    U16   Dpth;
    Count MCnt;
    U8    NCnt;
    U8    NMor;
    U8    NSym;
    U8    MSym[4];
};

extern MemArr MemSym[];
extern MemArr MemCnt[];

void InitContexts(void);
void UsedContext(Context *Ctx);
void UpdateContexts(U8 Sym, Text T);
Context *NegContext(void);
Context *ZeroContext(void);
Context *LoadContext(void);
Context *ReadContext(Mem XCtx);
Context *LessContext(Context *Ctx);
Context *NextContext(Context *Ctx, Text T);
Context *BestContext(Context *Ctx);

#endif
