/*
 *	tardir.c - handle tar directory
 */

static char rcsid[] = "$Header: RCS/tardir.c 2.6 91/02/19 14:27:58 kmori Exp $";

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "defs.h"

#include "tar.h"
#include "tardir.h"
#include "main.h"
#include "misc.h"



unsigned compsum(HEADER *block)
{
	int	i;
	unsigned sum;

	sum = 0;
	for (i = 0; i < NAMSIZ + 8 + 8 + 8 + 12 + 12; i++)
		sum += block->dummy[i];
	sum += ' ' * 8;
	for (i += 8; i < TBLOCK; i++)
		sum += block->dummy[i];
	return (sum);
}



global char decode_dir_e(char *name, struct stat *p, HEADER *block)
{
	unsigned sum;

	p->st_mode = strtol(block->dbuf.mode, NULL, 8);
	p->st_size = strtol(block->dbuf.size, NULL, 8);
	p->st_mtime = strtol(block->dbuf.mtime, NULL, 8);
	p->st_uid = strtol(block->dbuf.uid, NULL, 8);
	p->st_gid = strtol(block->dbuf.gid, NULL, 8);
	sum = strtol(block->dbuf.chksum, NULL, 8);
	strncpy(name, block->dbuf.name, 100);
	name[99] = '\0';
	if (sum != compsum(block))
		return ('e');
	return (block->dbuf.typeflag);
}



global char decode_dir(char *name, struct stat *p, HEADER *block)
{
	char type;

	type = decode_dir_e(name, p, block);
	if (type == 'e')
		fatal(NULL, "Check sum error");
	return (type);
}




global void encode_dir(HEADER *block, char *name, struct stat *p, char flag)
{
	char *user;

	strcpy(block->dbuf.name, name);
	if ((p->st_mode & S_IFMT) == S_IFDIR)
		addsl(block->dbuf.name);
	sprintf(block->dbuf.mode, "%6o ", p->st_mode);
	strcpy(block->dbuf.uid, "000000 ");
	strcpy(block->dbuf.gid, "000000 ");
	sprintf(block->dbuf.size, "%11lo ", p->st_size);
	sprintf(block->dbuf.mtime, "%11lo ", p->st_mtime);
	block->dbuf.typeflag = flag;
	memset(block->dbuf.linkname, 0, NAMSIZ);
	if (Gflag) {
		memcpy(block->dbuf.magic, TOMAGIC, TOMAGLEN);
	} else {
		memcpy(block->dbuf.magic, TMAGIC, TMAGLEN);
		memcpy(block->dbuf.version, TVERSION, TVERSLEN);
	}
	if ((user = getenv("USER")) != NULL)
		strncpy(block->dbuf.uname, user, sizeof block->dbuf.uname);
	else
		strcpy(block->dbuf.uname, "root");
	sprintf(block->dbuf.chksum, "%6o ", compsum(block));
}



global int eofblock(char *block)
{
	int n;

	for (n = TBLOCK; n; n--) {
		if (*block++)
			return (0);
	}
	return (1);
}
