/*
 * misc - miscellaneous functions
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <jctype.h>
#include <ctype.h>

#include "defs.h"

#include "main.h"
#include "misc.h"



/*
 * Report error, s: object msg: reason
 */
global void error(char *s, char *msg)
{
	fprintf(stderr, "%s: ", Progname);
	if (msg == NULL) {
		if (errno == 0)
			fprintf(stderr, "%s: Device not ready\n", s);
		else
			perror(s);
	} else {
		if (s)
			fprintf(stderr, "%s: ", s);
		fprintf(stderr, "%s\n", msg);
	}
	Exitcode = 1;
}



/*
 * Report error and terminate program
 */
global void fatal(char *s, char *msg)
{
	error(s, msg);
	exit(1);
}




/*
 * Return true if string t's head is same as string p
 */
global int strmatch(char *t, char *p)
{
	return (strncmp(t, p, strlen(p)) == 0);
}



int	strcmpl(char *s, char *t)
{
	for (; *s; s++, t++) {
		if (iskanji(*s) && iskanji2(s[1])
			&& iskanji(*t) && iskanji2(t[1])) {
			if (*s != *t) {
				break;
			}
			s++;
			t++;
			if (*s != *t) {
				break;
			}
		} else if (iskanji(*s) && iskanji2(s[1])
				 || iskanji(*t) && iskanji2(t[1])) {
			break;
		} else if (isascii(*s) && isascii(*t)) {
			if (tolower(*s) != tolower(*t)) {
				break;
			}
		} else if (*s != *t) {
			break;
		}
	}
	return (*s - *t);	
}



FILE *fopenpath(char *file)
{
	FILE *fp;
	char *p, *d;
	char buf[100];

	if ((p = getenv("TAR")) != NULL) {
		strcat(addsl(strcpy(buf, p)), file);
		if ((fp = fopen(buf, "r")) != NULL)
			return (fp);
	}
	if ((fp = fopen(file, "r")) != NULL)
		return (fp);
	if ((p = getenv("PATH")) != NULL) {
		while (*p) {
			d = buf;
			while (*p && *p != ';')
				*d++ = *p++;
			*d = '\0';
			strcat(addsl(buf), file);
			if ((fp = fopen(buf, "r")) != NULL)
				return (fp);
			if (*p == ';')
				p++;
		}
	}
	return (NULL);
}



/*
 * Return device-description string
 */
global char *get_dev_alias(char *device)
{
	FILE *fp;
	char *p, *s;
	char line[201];

	if ((fp = fopenpath("_tar")) == NULL)
		return (NULL);
	while (fgets(line, 200, fp)) {
		for (p = line; isspace(*p); p++)
			;
		if (*p == '#' || *p == '\0')
			continue;
		for (s = p; *s && !isspace(*s); s++)
			;
		if (*s == '\0')
			continue;
		*s++ = '\0';
		if (device == NULL || strcmpl(p, device) == 0) {
			while (isspace(*s))
				s++;
			for (p = s; *p && !isspace(*p); p++)
				;
			*p = '\0';
			if ((p = malloc(strlen(s) + 1)) == NULL)
				fatal(NULL, "Out of memory");
			strcpy(p, s);
			fclose(fp);
			return (p);
		}
	}
	fclose(fp);
	return (NULL);
}



/*
 * Append '/' to string buf
 */
global char *addsl(char *buf)
{
	char *p;
	int c;

	if (buf[0]) {
		c = '\0';
		p = buf;
		while (*p != '\0') {
			c = *p;
			if (iskanji(*p) && iskanji2(p[1])) {
				p++;
			}
			p++;
		}
		if (c != '/' && c != ':') {
			strcat(buf, "/");
		}
	}
	return (buf);
}



/*
 * Read with ASCII conversion
 */
global int read_a(int fd, char *buff, int size)
{
	int n;
	char *p, *q, *t;

	do {
		n = read(fd, buff, size);
		if (n == 0 || !Aflag)
			break;
		t = buff + n;
		for (q = p = buff; p < t; ) {
			char *s;

			if (*p == '\r')
				p++;
			s = memchr(p, '\r', t - p);
			if (s == NULL)
				s = t;
			if (p != q)
				memcpy(q, p, s - p);
			q += s - p;
			p = s;
		}
		n = q - buff;
	} while (n == 0);
	return (n);
}



/*
 * Write with ASCII conversion
 */
global int write_a(int fd, char *buff, int size)
{
	char *q, *p, *s, *t;
	int n, m;
	char buff2[512];

	if (!Aflag)
		return (write(fd, buff, size));
	m = 0;
	t = buff + size;
	q = buff2;
	for (s = p = buff; p < t; ) {
		s = memchr(s, '\n', t - p);
		if (s == NULL)
			s = t;
		do {
			n = s - p;
			if (q + n > buff2 + sizeof buff2)
				n = buff2 + sizeof buff2 - q;
			memcpy(q, p, n);
			q += n;
			p += n;
			if (q >= buff2 + sizeof buff2) {
				m += write(fd, buff2, sizeof buff2);
				q = buff2;
			}
		} while (p < s);
		if (s < t)
			*q++ = '\r';
		s++;
	}
	if (q > buff2)
		m += write(fd, buff2, q - buff2);
	return (m);
}



/*
 * Return 1 if contents of file fd and *buff are different
 */
global int compare_a(int fd, char *buff, int size)
{
	char buff2[512];

	while (size > 0) {
		int n = sizeof buff2;
		if (n > size)
			n = size;
		n = read_a(fd, buff2, n);
		if (n == 0 || memcmp(buff, buff2, n) != 0)
			return 1;
		size -= n;
		buff += n;
	}
	return 0;
}



/*
 * Return real size of file fd
 */
global long realsize(int fd)
{
	char buff[512];
	int n;
	long size;
	char *p, *t;

	size = 0;
	while ((n = read(fd, buff, sizeof buff)) > 0) {
		t = buff + n;
		for (p = buff; p = memchr(p, '\r', t - p); p++)
			n--;
		size += n;
	}
	lseek(fd, 0L, 0);
	return (size);
}



/*
 * Convert date-string s (mm/dd[/yyyy] [hh:mm[:ss]]) to time_t type
 */
global time_t getdate(char *s)
{
	time_t now;
	struct tm t, *nowp;

	memset(&t, 0, sizeof t);
	now = time(NULL);
	nowp = localtime(&now);
	t.tm_mon = strtol(s, &s, 10) - 1;
	if (*s++ != '/')
		return (-1L);
	t.tm_mday = strtol(s, &s, 10);
	if (*s == '/') {
		s++;
		t.tm_year = strtol(s, &s, 10);
		if (t.tm_year >= 1900)
			t.tm_year -= 1900;
	} else {
		t.tm_year = nowp->tm_year;
		if (t.tm_mon > nowp->tm_mon
		   || t.tm_mon == nowp->tm_mon && t.tm_mday > nowp->tm_mday)
			t.tm_year--;
	}
	while (isspace(*s))
		s++;
	if (*s) {
		t.tm_hour = strtol(s, &s, 10);
		if (*s != ':')
			return (-1L);
		s++;
		t.tm_min = strtol(s, &s, 10);
		if (*s == ':') {
			s++;
			t.tm_sec = strtol(s, &s, 10);
		}
	}
	while (isspace(*s))
		s++;
	if (*s)
		return (-1L);
	return (mktime(&t));
}
