/*
 * get_dir() - get list of directory
 */

static char rcsid[] = "$Header: RCS/getdir.c 2.3 91/02/17 18:02:08 kmori Exp $";

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <jctype.h>
#include <ctype.h>
#include <dos.h>

#include "defs.h"
#include "misc.h"
#include "getdir.h"

#ifndef global

typedef struct flist {
	struct flist *next;
	char name[0];
} FLIST;

#endif /* global */


/*
 * list merge sorting
 *	Donald E Knuth, "The Art of Computer Programming",
 *	Vol.3 / Sorting & Searching, pp. 165-166, Algorithm L.
 */
FLIST *sort(FLIST *p)
{
	FLIST xh, yh, *xp, *yp, *x, *y;
	unsigned int n, xn, yn;

	/* L1. Separate list p into 2 lists. */
	xp = &xh;
	yp = &yh;
	while (p != NULL) {
		xp->next = p;
		xp = p;
		p = p->next;
		if (p == NULL)
			break;
		yp->next = p;
		yp = p;
		p = p->next;
	}
	xp->next = NULL;
	yp->next = NULL;
	for (n = 1; yh.next != NULL; n *= 2) {
		/* L2. Begin new pass. */
		xp = &xh;
		yp = &yh;
		x = xp->next;
		y = yp->next;
		xn = yn = n;
		do {
			/* L3. Compare */
			if (strcmp(x->name, y->name) <= 0) {
				/* L4. Advance x. */
				xp->next = x;
				xp = x;
				x = x->next;
				if (--xn != 0 && x != NULL)
					continue;
				/* L5. Complete the sublist. */
				xp->next = y;
				xp = yp;
				do {
					yp = y;
					y = y->next;
				} while (--yn != 0 && y != NULL);
			} else {
				/* L6. Advance y. */
				xp->next = y;
				xp = y;
				y = y->next;
				if (--yn != 0 && y != NULL)
					continue;
				/* L7. Complete the sublist. */
				xp->next = x;
				xp = yp;
				do {
					yp = x;
					x = x->next;
				} while (--xn != 0 && x != NULL);
			}
			xn = yn = n;
			/* L8. End of pass? */
		} while (y != NULL);
		xp->next = x;
		yp->next = NULL;
	}
	return (xh.next);
}



/*
 * Returns list of the directory 'dir'
 */
global FLIST *get_dir(char *dir)
{
	struct find_t buf;
	char fn[100];
	int rc;
	FLIST *dp, *fp, *w;
	char *s;

	strcat(addsl(strcpy(fn, dir)), "*.*");
	dp = fp = NULL;
	rc = _dos_findfirst(fn,
		_A_NORMAL | _A_RDONLY | _A_HIDDEN | _A_SUBDIR | _A_ARCH,
		&buf);
	for (; rc == 0; rc = _dos_findnext(&buf)) {
		w = (FLIST *)malloc(sizeof(FLIST) + strlen(buf.name) + 1);
		if (w == NULL)
			fatal(NULL, "Out of memory");
		for (s = buf.name; *s; s++) {
			if (iskanji(*s) && iskanji2(s[1])) {
				s++;
			} else if (isascii(*s) && isupper(*s)) {
				*s = tolower(*s);
			}
		}
		strcpy(w->name, buf.name);
		if (buf.attrib & _A_SUBDIR) {
			w->next = dp;
			dp = w;
		} else {
			w->next = fp;
			fp = w;
		}
	}
	dp = sort(dp);
	fp = sort(fp);
	if (fp == NULL)
		fp = dp;
	else {
		for (w = fp; w->next; w = w->next)
			;
		w->next = dp;
	}
	return (fp);
}


/*
 * Free directory list p
 */
global void free_dir(FLIST *p)
{
	FLIST *q;

	while (p) {
		q = p->next;
		free(p);
		p = q;
	}
}
