/*
 *	chkfname - check & rename file name to MS-DOS style
 *
 *	Written by AssistantIO
 */

#include <stdio.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <io.h>
#include <fcntl.h>
#include <jctype.h>
#include <string.h>
#include "chkfname.h"

#define global

#ifdef __TURBOC__
#include <dir.h>
#else
#include <direct.h>
#endif

struct _rename_t {
	char *org_name;
	char *new_name;
	int dir_p;
	struct _rename_t *next;
};

typedef struct _rename_t rename_t;

#define NAMLEN 128
#define MAX_NAM 8
#define MAX_EXT 3

#define	is_pathchar(c)	((c) == '\\' || (c) == '/')

static void register_rename_table(char *org_name, int dir_p, char *new_name);
static char *search_orgname(char *org_name, int dir_p);
static char *search_newname(char *new_name);
static char *make_new_fname(char *newname, char *name, int make_new, int dir_p);
static int last_char(char *p);
static char *normalize_fname(char *destin, char *source, int dir_p);
static char *trim_jstr(char *p, char *q, int len);
static int is_dir(char *filename);
static int is_character_device(char *name);

global void check_fname(char *dest, char *sour, int make_new, int dir_p)
{
	char *p;

	if ((p = search_orgname(sour, dir_p)) != NULL) {
		strcpy(dest, p);
		return;
	}
	if (make_new_fname(dest, sour, make_new, dir_p) == NULL) {
		strcpy(dest, sour);
	}
	register_rename_table(sour, dir_p, dest);
}

static rename_t *rename_table = NULL;

static void
register_rename_table(char *org_name, int dir_p, char *new_name) {
	rename_t *nt;

	if ((nt = (rename_t *) malloc(sizeof(rename_t))) == NULL) {
		return;
	}
	if ((nt->org_name = strdup(org_name)) == NULL) {
		return;
	}
	if ((nt->new_name = strdup(new_name)) == NULL) {
		return;
	}
	nt->dir_p = dir_p;
	nt->next = rename_table;
	rename_table = nt;
}

static char *
search_orgname(char *org_name, int dir_p) {
	rename_t *nt;

	for (nt = rename_table; nt != NULL; nt = nt->next) {
		if (strcmp(org_name, nt->org_name) == 0
			&& dir_p == nt->dir_p) {
			return nt->new_name;
		}
	}
	return NULL;
}

static char *
search_newname(char *new_name) {
	rename_t *nt;

	for (nt = rename_table; nt != NULL; nt = nt->next) {
		if (strcmp(new_name, nt->new_name) == 0) {
			return nt->new_name;
		}
	}
	return NULL;
}

static char *
make_new_fname(char *newname, char *name, int make_new, int dir_p) {
	int is_dir();
	char *d, *s, *p, *q, *period;
	char tmpname[NAMLEN], basename[NAMLEN];
	int extent_no;
	struct stat statbuf;

	normalize_fname(tmpname, name, dir_p);

	d = newname;
	s = tmpname;
	if (isascii(*s) && isalpha(*s) && *(s + 1) ==':') {
		*d++ = *s++;
		*d++ = *s++;
	}
	while (*s != '\0') {
		if (is_pathchar(*s)) {
			*d++ = *s++;
		}
		if (*s == '.' && *(s + 1) == '.' && is_pathchar(*(s + 2))) {
			*d++ = *s++;
			*d++ = *s++;
		} else if (*s == '.' && is_pathchar(*(s + 1))) {
			*d++ = *s++;
		} else {
			p = d;
			period = NULL;
			while (*s != '\0' && !is_pathchar(*s)) {
				if (iskanji(*s) && iskanji2(*(s + 1))) {
					*d++ = *s++;
					*d++ = *s++;
				} else if (*s == '.') {
					period = d;
					*d++ = *s++;
				} else {
					*d++ = *s++;
				}
			}
			*d = '\0';
			if (dir_p || *s != '\0') {
				if (strchr("/\\:", last_char(newname)) == NULL
					&& !is_dir(newname)
					&& make_new
					&& mkdir(newname) < 0) {
					basename[0] = '_';
					strcpy(basename + 1, p);
					normalize_fname(p, basename, 1);
					d = p + strlen(p);
					if (!is_dir(newname) && mkdir(newname) < 0) {
						return NULL;
					}
				}
			}
		}
	}
	if (dir_p) {
		return newname;
	}
	if (stat(newname, &statbuf) != 0) {
		return newname;
	}
	if (!is_character_device(newname)
		&& make_new == 0 && search_newname(newname) == NULL) {
		return newname;
	}
	basename[0] = '_';
	strcpy(basename + 1, p);
	extent_no = -1;
	q = period != NULL ? period : d;
	while (++extent_no < 1000) {
		sprintf(q, ".%03d", extent_no);
		if (stat(newname, &statbuf) != 0) {
			return newname;
		}
		if (is_character_device(newname)) {
			break;
		}
		if (make_new == 0 && search_newname(newname) == NULL) {
			return newname;
		}
	}
	normalize_fname(p, basename, 0);
	if (stat(newname, &statbuf) != 0) {
		return newname;
	}
	if (!is_character_device(newname) && make_new == 0) {
		return newname;
	}
	d = p + strlen(p);
	q = d;
	while (*p != '\0') {
		if (iskanji(*p) && iskanji2(*(p + 1))) {
			p++;
		} else if (*p == '.') {
			q = p;
		}
		p++;
	}
	extent_no = -1;
	while (++extent_no < 1000) {
		sprintf(q, ".%03d", extent_no);
		if (stat(newname, &statbuf) != 0) {
			return newname;
		}
		if (is_character_device(newname)) {
			break;
		}
		if (make_new == 0 && search_newname(newname) == NULL) {
			return newname;
		}
	}
	return NULL;
}

static int
last_char(char *p) {
	int c;

	for (c = *p; *p; p++) {
		c = *p;
		if (iskanji(*p) && iskanji2(p[1])) {
			p++;
		}
	}
	return c;
}

static char *
normalize_fname(char *destin, char *source, int dir_p) {
	char *d, *s, *p, *q, *period;

	d = destin;
	s = source;
	if (isascii(*s) && isalpha(*s) && *(s + 1) ==':') {
		*d++ = tolower(*s++);
		*d++ = *s++;
	}
	while (*s != '\0') {
		if (is_pathchar(*s)) {
			*d++ = *s++;
		}
		while (is_pathchar(*s)) {
			s++;
		}
		p = d;
		if (*s == '.' && *(s + 1) == '.' &&
			(is_pathchar(*(s + 2)) || (dir_p && *(s + 2) == '\0'))) {
			*d++ = *s++;
			*d++ = *s++;
		} else if (*s == '.' &&
			(is_pathchar(*(s + 1)) || (dir_p && *(s + 1) == '\0'))) {
			*d++ = *s++;
		} else {
			if (*s == '.') {
				*d++ = '_';
				s++;
			}
			period = NULL;
			while (*s != '\0' && !is_pathchar(*s)) {
				if (iskanji(*s) && iskanji2(*(s + 1))) {
					*d++ = *s++;
					*d++ = *s++;
				} else if (isascii(*s) && isupper(*s)) {
					*d++ = tolower(*s++);
				} else if ((isascii(*s) && isalnum(*s))
						   || iskana(*s)
						   || strchr("!#$&'()-@^_{}~", *s) != NULL) {
					*d++ = *s++;
				} else if (*s == '.') {
					if (period != NULL) {
						if (stricmp(s, ".Z") == 0) {
							if (d > period + MAX_EXT) {
								d = period + MAX_EXT;
							}
							s++;
						} else {
							*period = '_';
							period = d;
						}
					} else {
						period = d;
					}
					*d++ = *s++;
				} else {
					*d++ = '_';
					s++;
				}
			}
			if (period != NULL) {
				if ((q = trim_jstr(p, period, MAX_NAM)) != NULL) {
					memmove(q, period, d - period);
					d += q - period;
					period = q;
				}
				if ((q = trim_jstr(period + 1, d, MAX_EXT)) != NULL) {
					d = q;
				}
			} else {
				if ((q = trim_jstr(p, d, MAX_NAM)) != NULL) {
					d = q;
				}
			}
		}
	}
	*d = '\0';
	return destin;
}

static char *
trim_jstr(char *p, char *q, int len) {
	char *r, *s;

	if (q - p <= len) {
		return NULL;
	}
	r = p;
	while ((s = r + (iskanji(*r) ? 2 : 1)) - p <= len) {
		r = s;
	}
	return r;
}

static int
is_dir(char *filename) {
	struct stat stat_buf;
	int result;

	result = stat(filename, &stat_buf);
	if (result < 0
		&& (access(filename, 0) == 0
			|| (isascii(*filename)
				&& isalpha(*filename)
				&& strcmp(filename + 1, ":") == 0))) {
		result = 0;
	    stat_buf.st_mode = S_IFDIR;
						/* July 30 1990 */
	 }
	return result == 0 && (stat_buf.st_mode & S_IFMT) == S_IFDIR;
						/* July 30 1990 */
}

static int
is_character_device(char *name) {
	int ret;
	FILE *fp;

	if ((fp = fopen(name, "r")) == NULL) {
		return 0;
	}
	ret = isatty(fileno(fp));
	fclose(fp);
	return ret ? 1: 0;
}
