#include <stdio.h>
#include <alloc.h>

#define dic_size     8192
#define base          256
#define nil           256
#define unused          0
#define fst_code      257

typedef struct
{
   unsigned char name;
   int  son;
   int  dad;
}
dic_item;

dic_item *dic;
FILE *source, *target;
long bitbuf=0, bits=0;
int code_len=9, code, available=fst_code-1;
int mapped=0, tagged=0, pure_char=0;

int read_code(void);
int read_bits(int len);
unsigned char write_string(int code);
int shrink();

main(int argc, char *argv[])
{
  int  old_code=nil, i, j;
  unsigned char c;

  if (argc!=3)
  {
     printf("usage: unjam jamfile newfile");
     return;
  }

  dic=(dic_item*)malloc(dic_size*sizeof(dic_item));
  if (dic==NULL)
  {
    printf("fail to allocate memory");
    return;
  }

  source=fopen(argv[1], "rb");
  if (source==NULL)
  {
    printf("fail to open source file.");
    free(dic);
    return;
  }

  target=fopen(argv[2], "wb");
  if (source==NULL)
  {
    printf("fail to open target file.");
    fclose(source);
    free(dic);
    return;
  }

#ifdef UNJAM
  fgetc(source);
  fgetc(source);
  fgetc(source);
#endif

  /* clear the dictionary */
  for (i=0; i<fst_code; i++)
  {
    dic[i].name=i;
    dic[i].son=nil;
    dic[i].dad=nil;
  }

  while (1)
  {
     code=read_code();
     if (code==EOF || code==nil || code>available)
        break;
     if (code<available || old_code==nil)
        c=write_string(code);
     else
     {
        c=write_string(old_code);
        fputc(c, target);
     }
     if (old_code!=nil)
     {
        dic[available].name=c;
        dic[available].son=nil;
        dic[available].dad=old_code;
     }
     available++;
     if (available==(1<<code_len))
        code_len++;
     old_code=code;
     if (available==dic_size)
     {
        shrink();
        while (available<=(1<<(code_len-1))) code_len--;
        available--;
        old_code=nil;
     }
  }
  free(dic);
  fclose(target);
  fclose(source);
  if (code!=EOF)
    printf("Bad code.");
  return;
}

/* ----------------------- routines ------------------------ */


int read_code(void)
{ int val;
  if (!tagged)
  { val=read_bits(code_len); if (val==EOF) return EOF;
    if (!mapped)
    { if (val<=available)  /* unshifted */
      { if (val+available+1<1<<code_len)  /* but shiftable */ mapped=1;
        return val;
      }
      val-=available+1; tagged=1; pure_char=1; return val;
    }
    else  /* mapped */
    { mapped=0;
      if (val<=available-base)  /* unshifted */
      { if (val+available+1-base<1<<code_len) mapped=1;
        return val+base;
      }
      val-=available+1-base; tagged=1; pure_char=1; return val+base;
    }
  }
  else  /* tagged */
    if (pure_char)
    { val=read_bits(8); pure_char=0; return val; }
    else
    { int tag=read_bits(1); if (tag==EOF) return EOF;
      if (tag==0)  /* char */
      { val=read_bits(8); return val; }
      else /* tag==1 */
      { tagged=0; val=read_bits(code_len); if (val==EOF) return EOF;
        if (val>available-base)
        { val-=available-base+1; tagged=1; pure_char=1; }
        else
          if (val+available+1-base<1<<code_len) mapped=1;
        return val+base;
      }
    }
}

int read_bits(int len)
{
   int c;
   while (bits<len)
   {
      c=fgetc(source);
      if (c==EOF)
         return EOF;
      bitbuf=(bitbuf<<8)|c; bits+=8;
   }
   bits-=len;
   return (bitbuf>>bits)&((1<<len)-1);
}

unsigned char write_string(int code)
{
   unsigned char c;
   int i=code;
   while (dic[i].dad!=nil)
   {
      int j=dic[i].dad;
      dic[j].son=i;
      i=j;
   }
   c=dic[i].name;
   /* write out the string */
   do
   {
      int j=dic[i].son; dic[i].son=nil;
      fputc(dic[i].name, target);
      i=j;
   }
   while (i!=nil);
   return c;
}

int shrink()
{ int i; /* 'dad' will be used as 'next' */

  /* step one: mark leaves, reconstruct the tree structure, and
     transform the tree to well-formed */
  for (i=available-1; i>=fst_code; i--)
  { int j=dic[i].dad;
    if (dic[j].son==nil) dic[j].son=unused;
    if (dic[i].son==nil)
    { dic[i].son=unused; if (i<available) available=i; continue; }
    if (dic[i].son==unused) dic[i].son=nil;
    if (dic[j].son==unused) dic[j].son=nil;
    dic[i].dad/*next*/=dic[j].son; dic[j].son=i;
  }
  for (i=0; i<fst_code; i++) if (dic[i].son==unused) dic[i].son=nil;

  /* step two: move the unused nodes to the end of the array.
  notice that the tree remains well-formed after each loop! */
  i=0;
  while (i<available)
  { int j;
    /* if i has a son behind available, move it to available */
    j=dic[i].son;
    if (j!=nil && j>available)
    { dic[available]=dic[j];
      dic[i].son=available;
      dic[j].son=unused;
      do available++; while (dic[available].son!=unused);
    }

    /* do the same to the brother of i */
    j=dic[i].dad/*next*/;
    if (j!=nil && j>available)
    { dic[available]=dic[j];
      dic[i].dad/*next*/=available;
      dic[j].son=unused;
      do available++; while (dic[available].son!=unused);
    }

    i++;
  }

  /* step three: transform the tree back to its original form */
  for (i=0; i<available; i++)
  { int j=dic[i].son;
    dic[i].son=nil;
    while (j!=nil)
    { int k=dic[j].dad;/*next*/
      dic[j].dad=i;
      j=k;
    }
  }

  return;
}
