/* Example program, see jamkit.doc for detail */

#include <stdio.h>
#define bufsize 16384

void error(int i)
{ printf("\rerror: ");
  switch (i)
  { case 1: printf("jam not initiated"); break;
    case 3: printf("fail to allocate memory"); break;
    case 5: printf("jam not closed"); break;
    case 7: printf("data not exhausted"); break;
  }
  return;
}

main(int argc, char *argv[])
{
   FILE  *f1, *f2;
   unsigned char buf_in[bufsize], buf_out[bufsize];
   int i, cnt, cnt2;
   long len1=0, len2=0;

   if (argc!=3) return;
   f1 = fopen(argv[1], "rb"); if (f1==NULL) return;
   f2 = fopen(argv[2], "wb"); if (f2==NULL) { fclose(f1); return; }
   i=reset_jam(); if (i!=0) { error(i); return; }

   while (1)
   { cnt=fread(buf_in, 1, bufsize, f1); if (cnt<=0) break;
     len1+=cnt;
     printf("\r%ld", len1);
     i=dump_data(buf_in, cnt);
     if (i!=0) { error(i); return; }
     while (1)
     { i=get_code(buf_out, bufsize, &cnt, &cnt2);
       if (i!=0) { error(i); return; }
       fwrite(buf_out, 1, cnt, f2);
       len2+=cnt;
       if (cnt<bufsize) break;
     }
   }
   i=end_jam(buf_out, &cnt);
   if (i!=0) { error(i); return; }
   fwrite(buf_out, 1, cnt, f2);
   len2+=cnt;
   fclose(f1);  fclose(f2);
   if (len2>=len1) { printf("\rfile incompressable"); return; }
   printf("\r%d%% packed out", (int)((len1-len2)*100/len1));
   return;
}
