;
; Installations-SFX-Modul
; Erstellt von Bernd Hohenester
;
;     FIDO: Bernd Hohenester@2:2490/2001.2
; INTERNET: Bernd.Hohenester@T-Online.de
;
;
; Im Script sind folgende Funktionen enthalten:
;
; - speziell fr den Gebrauch mit EASYRAR erstellt
; - Anzeige des Zielverzeichnisses, des bentigten und des verfgbaren
;   Speicherplatzes auf dem Ziellaufwerk
; - Warnung bei ungengendem Speicherplatz auf dem Ziellaufwerk
; - Warnung bei nicht vorhandenem Ziellaufwerk
; - automatische Menweiterschaltung
; - Anwender kann Zielverzeichnis ndern
; - whrend des Entpackens Anzeige durch Fortschritts-Balken und einzelne
;   Dateinamen
; - Hilfeseite
; - es werden nur nicht vorhandene oder aktuellere Dateien entpackt
; - Aufforderung zum Diskettenwechsel bei Mehrdisketten-Archiven
; - Fehlererkennung
;
;
; iSFX-Skript wird ab RAR V 1.54 nicht als Archivkommentar angezeigt!

; Variable fr Zielverzeichnis. BITTE GEWNSCHTEN PFAD EINTRAGEN!
; Wird innerhalb des Scripts mehrfach verwendet!
ERAR_DestDir="C:\\INSTALL"
DestDir=ERAR_DestDir

; Anzahl der Dateien im Archiv. BITTE KORREKTEN WERT EINTRAGEN!
ERAR_TotalFiles=1

; Zum Entpacken bentigter Plattenspeicher in BYTES. BITTE WERT EINTRAGEN!
ERAR_DiskNeed=1024

; brige Variablen leer vorbelegen
ERAR_ProgName=""
ERAR_ProgGroesse=""
ERAR_Passwort=0
ERAR_ChangeDir=1
ERAR_BatchStart=0
ERAR_StartProg=0
ERAR_StartProgName=""

; Balken definieren
defbar YELLOW,CYAN,BLUE,WHITE,14,7,52
; Standard-Ansikommentar ausgeben 
clrscr
outtext ansi on
outtext ansi off

; Hintergrundfarben setzen und Bildschirm lschen
setcolor CYAN,CYAN
window 1,1,80,25
clrscr

; AV-berprfung
if AVPresent == -1
  Title="Warnung"
  Message="Siegelinformation ist nicht korrekt"
  call ErrMsg
endif

if AVPresent == 1
  window 22, 12, 55, 15
  setcolor YELLOW, BLACK
  text "Ŀ\n"
  text " Siegelinformation einwandfrei \n"
  text "\n"
  delay 1000
endif

; Hintergrundfarben setzen und Bildschirm lschen
setcolor CYAN,CYAN
window 1,1,80,25
clrscr

; Passwort-Abfrage
if ERAR_Passwort==1
  clrscr
  outtext ansi on
[46m[K
[46m [37;1;47m[0;30;47m[46m[K
[46m [37;1;47m                           PROGRAMM-INFORMATION                           [0;30;47m[46m[K
[46m [37;1;47m                                                                          [0;30;47m[46m[K
[46m [37;1;47m Name:                                                                    [0;30;47m[46m[K
[46m [37;1;47m Gre (entpackt):                                                        [0;30;47m[46m[K
[46m [37;1;47m                      [0;5;31;47mPROGRAMM IST PASSWORT-GESCHTZT![37;1;47m                    [0;30;47m[46m[K
[46m [37;1;47m[0;30;47m[46m[K
[46m [37;1;47m Bitte Code eingeben:                                                     [0;30;47m[46m[K
[46m [37;1;47m[0;30;47m[46m[K
[46m[K
  outtext ansi off

  ; Schatten unten
  setcolor DARKGRAY,CYAN
  window 4,11,79,11
  clrscr 219

  ; Schatten rechts
  setcolor DARKGRAY,CYAN
  window 78,3,79,11
  clrscr 219

  ; Programm-Name anzeigen
  window 25,5,76,6
  setcolor YELLOW,WHITE
  gotoxy 1,1
  text ERAR_ProgName

  ; Programm-Gre anzeigen
  gotoxy 1,2
  text ERAR_ProgGroesse

  Code:

  ; Passwort abfragen
  savescr 1
  window 25,9,75,9
  Res=INPUT BLACK,CYAN,Password,"",51
  restscr 1

  if Res == 0
    goto Code
  endif

  ; Hintergrundfarben setzen und Bildschirm lschen
  setcolor CYAN,CYAN
  window 1,1,80,25
  clrscr
endif

; Programm Info
clrscr
outtext ansi on
[46m[K
[46m [37;1;47m[0;30;47m[46m[K
[46m [37;1;47m                           PROGRAMM-INFORMATION                           [0;30;47m[46m[K
[46m [37;1;47m                                                                          [0;30;47m[46m[K
[46m [37;1;47m Name:                                                                    [0;30;47m[46m[K
[46m [37;1;47m Gre (entpackt):                                                        [0;30;47m[46m[K
[46m [37;1;47m                                                                          [0;30;47m[46m[K
[46m [37;1;47m[0;30;47m[46m[K
[46m [37;1;47m              Zielverzeichnis:                                            [0;30;47m[46m[K
[46m [37;1;47m erforderlicher Speicherplatz:                                            [0;30;47m[46m[K
[46m [37;1;47m    verfgbarer Speicherplatz:                                            [0;30;47m[46m[K
[46m [37;1;47m[0;30;47m[46m[K
[46m[K
outtext ansi off

; Schatten unten
setcolor DARKGRAY,CYAN
window 4,13,79,13
clrscr 219

; Schatten rechts
setcolor DARKGRAY,CYAN
window 78,3,79,13
clrscr 219

; Programm-Name anzeigen
window 25,5,76,6
setcolor YELLOW,WHITE
gotoxy 1,1
text ERAR_ProgName

; Programm-Gre anzeigen
gotoxy 1,2
text ERAR_ProgGroesse

; Zielverzeichnis anzeigen
window 34,9,76,11
setcolor BLACK,WHITE
gotoxy 1,1
text DestDir

; erforderlicher Speicherplatz
gotoxy 1,2
KDiskNeed=ERAR_DiskNeed/1024
text KDiskNeed," KB"

; verfgbarer Speicherplatz
DiskSpace=getdfree
KDiskSpace=DiskSpace/1024
setcolor LIGHTGREEN,WHITE
gotoxy 1,3
text KDiskSpace," KB"

Bar=2

; ungengender Speicherplatz
if DiskSpace < ERAR_DiskNeed
  setcolor RED,WHITE
  gotoxy 1,3
  text "                                          "
  gotoxy 1,3
  text KDiskSpace, " KB", " ungengender Speicherplatz!"
  Bar=1
endif

; Laufwerk nicht vorhanden
if DiskSpace == -1
  setcolor RED,WHITE
  gotoxy 1,3
  text "                                          "
  gotoxy 1,3
  text "Laufwerk ", DestDir, " nicht vorhanden!"
  Bar=1
endif

window 1,1,80,25
; unterste Zeile
setcolor WHITE,CYAN
gotoxy 1,25
text "                        F1 fr Hilfe, ALT-X zum Beenden                        "

; Sound-Effekt
sound 90,1

; Installations-Men
Menu:

Choice = menu 27,16,YELLOW,BLUE,Bar,"Installations-Men","Zielverzeichnis ndern"," Installation starten","         Ende"

if Choice == 0
  goto Menu
endif

; Zielverzeichnis setzen
if Choice == 1
  savescr 1
  window 34,9,76,9
  Res=INPUT BLACK,CYAN,DestDir,DestDir,43
  restscr 1
  Bar=2

  ; bei Abbruch alte Vorgabe
  if Res == 0
    DestDir=ERAR_DestDir
    Bar=1
  endif

  ; neu anzeigen
  window 34,9,76,11
  setcolor BLACK,WHITE
  clrscr
  gotoxy 1,1
  text DestDir

  gotoxy 1,2
  text KDiskNeed, " KB"

  ; verfgbarer Speicherplatz
  setcolor LIGHTGREEN,WHITE
  gotoxy 1,3
  DiskSpace=getdfree
  KDiskSpace=DiskSpace/1024
  text KDiskSpace, " KB"

  ; ungengender Speicherplatz
  if DiskSpace < ERAR_DiskNeed
    setcolor RED,WHITE
    gotoxy 1,3
    text "                                          "
    gotoxy 1,3
    text KDiskSpace, " KB", " ungengender Speicherplatz!"
    Bar=1
  endif

  ; Laufwerk nicht vorhanden
  if DiskSpace == -1
    setcolor RED,WHITE
    gotoxy 1,3
    text "                                          "
    gotoxy 1,3
    text "Laufwerk ", DestDir, " nicht vorhanden!"
    Bar=1
  endif

  window 1,1,80,25
  goto Menu
endif

if Choice == 2
  box 6,11,75,24,LIGHTCYAN,BLUE,DOUBLE
  setcolor LIGHTCYAN,BLUE

  ; Titel
  gotoxy 27,11
  text " Installations-Status: "
  window 7,12,74,23
  clrscr

  ; freien Speicherplatz prfen
  DiskSpace=getdfree
  KDiskSpace=DiskSpace/1024
  KDiskNeed=ERAR_DiskNeed/1024
  text "Installation begonnen.\n"
  text "erforderlicher Speicherplatz: ",KDiskNeed," KB\n"
  text "verfgbarer Speicherplatz:    ",KDiskSpace," KB\n"
  inswrow=4
  window 1,1,80,25

  if DiskSpace < ERAR_DiskNeed
    savescr 1
    window 1,1,80,25
    sound 2300,25
    delay 100
    sound 1450,25
    delay 100
    sound 2300,100
    Choice = menu 26,16,WHITE,RED,1,"ungengender Speicherplatz","        Fortsetzen        ","        Abbrechen         "

    ; Abbruch mit ESC
    if Choice == 0
      goto Quit
    endif

    ; "Abbrechen" gewhlt
    if Choice == 2
      goto Quit
    endif
    restscr 1
  endif
endif

if Choice == 3
  Quit:
  setcolor WHITE,BLACK
  clrscr
  gotoxy 2,4
  text "Das Programm wurde NICHT installiert!"
  sound 380,25
  delay 210
  sound 190,25
  exit 1
  goto Menu
endif

; HIER BEGINNT DIE INSTALLATION
; nur nicht vorhandene oder neuere Dateien entpacken
Overwrite UPDATE

proc OnKey
  window 1,1,80,25

  if Par1 == 3
    savescr 15
    Par1=-1
    sound 2300,25
    delay 100
    sound 1450,100
    Choice=Menu 32,11,WHITE,LIGHTRED,1,"Unterbrechung"," Fortsetzen  ","  Abbrechen  "
    if Choice == 2
      exit 1
    endif
    restscr 15
  endif

  ; "Abbrechen" gewhlt
  if Par1 == 301
    goto Quit
  endif

  ; F1 Hilfe angefordert
  if Par1 == 315
    savescr 15
    call OutHelp
    Par1=-1
    restscr 15
  endif
endp

proc ChangeVol
  window 7,12,74,23
  setcolor YELLOW,BLUE
  gotoxy 1,inswrow

  if Par2 == 0
    Par1=Par1+2
    text "... Diskette #",Par1," einlegen."
    savescr 14
    Par1=-1
    sound 2300,25
    delay 100
    sound 1450,100
    sound 5450,50
    sound 7450,25
    sound 1450,100
    window 1,1,80,25
    Choice = Menu 30,15,WHITE,GREEN,1,"Diskette wechseln","   Fortsetzen    ","    Abbrechen    "
    restscr 14

    if Choice == 2
      window 1,1,80,25
      setcolor WHITE,BLACK
      clrscr
      gotoxy 2,3
      text " Diskette nicht gefunden. Abbruch! "
      exit 1
    endif
  endif

  if Par2 != 0
    setcolor LIGHTCYAN,BLUE
    Par1=Par1+1
    text "... Diskette #",Par1," wurde bearbeitet."
  endif

  if inswrow = 12
    text "\n"
  endif

  if inswrow < 12
    inswrow=inswrow+1
  endif
  window 1,1,80,25
endp

proc FileDone
  gotoxy 50,11
  setcolor LIGHTCYAN,BLUE
  Percent=Par1*100
  Percent=Percent/ERAR_TotalFiles
  text Percent,"%% "
  window 7,12,74,23
  setcolor LIGHTCYAN,BLUE
  gotoxy 1,inswrow
  text DestFileName

  if inswrow = 12
    text "\n"
  endif

  if inswrow < 12
    inswrow=inswrow+1
  endif
  window 1,1,80,25
endp

proc Error
  window 7,12,74,23
  setcolor LIGHTCYAN,BLUE
  gotoxy 1,inswrow
  Title="Fehler!"

  ; Par1 enthlt die Fehlernummer:

  if Par1 == 1
    Message="Schwerer Fehler"
    call ErrMsg
  endif

  if Par1 == 2
    Message="CRC-Fehler oder Passort falsch"
    call ErrMsg
  endif

  if Par1 == 3
    Message="Schreibfehler"
    call ErrMsg
  endif

  if Par1 == 4
    Message="Fehler beim Erstellen der Datei"
    call ErrMsg
  endif

  if Par1 == 5
    Message="Lesefehler"
    call ErrMsg
  endif

  if Par1 == 6
    Message="Fehler beim Schlieen der Datei"
    call ErrMsg
  endif

  if Par1 == 7
    Message="Fehler beim ffnen der Datei"
    call ErrMsg
  endif

  if Par1 == 8
    Message="Nicht gengend Speicher"
    call ErrMsg
  endif

  if inswrow = 12
    text "\n"
  endif

  if inswrow < 12
    inswrow=inswrow+1
  endif
  window 1,1,80,25
endp

proc ErrMsg
  window 17,14,62,21
  setcolor WHITE,RED
  clrscr
  window 1,1,80,25
  box 20,15,59,20,WHITE,RED,DOUBLE
  gotoxy 1,15
  ctext " ",Title," "
  gotoxy 1,17
  ctext Message
  setcolor WHITE,BLACK
  gotoxy 1,19
  ctext " Ok "
  sound 20,5
  sound 80,50
  delay 15000
  window 1,1,80,25
endp

proc ArcDone
  sound 3300,25
  delay 100
  sound 2450,100
  window 7,12,74,23
  setcolor LIGHTCYAN,BLUE
  gotoxy 1,inswrow
  text "Fertig. Installation beendet"
  delay 500
  savescr 2
  Title="Installations-Status"
  Message=" Beendet "
  call OkMsg
  restscr 2
  window 1,1,80,25

  if ERAR_ChangeDir==1
    ; Laufwerk wechseln
    SYSTEM DestDir,
    ; Verzeichnis wechseln
    SYSTEM "CD ",DestDir,"."
  endif

  call ClearScreen

  if ERAR_StartProg==1
    ; externes Installationsprogramm aufrufen
    SYSTEM "IF EXIST ", DestDir, ERAR_StartProgName, " ", DestDir, ERAR_StartProgName
  endif

  setcolor WHITE,BLACK
  exit
endp

proc ClearScreen
  i=1
  loop:
    if i > 13
      goto exloop
    endif
    j=81-i
    k=26-i
    box i,i,j,k,LIGHTBLUE,BLACK,DOUBLE
    i=i+1
  goto loop

  exloop:
  i=1
  loop1:
    if i > 13
      goto exloop1
    endif
    j=81-i
    k=26-i
    box i,i,j,k,BLACK,BLACK,SINGLE
    i=i+1
  goto loop1

  exloop1:
    window 1,1,80,25
endp

proc OkMsg
  window 24,14,57,21
  setcolor BLACK,WHITE
  clrscr
  window 1,1,80,25
  box 27,15,53,20,BLACK,WHITE,DOUBLE
  gotoxy 1,15
  ctext " ",Title," "
  gotoxy 1,17
  ctext Message
  setcolor WHITE,BLACK
  gotoxy 1,19
  ctext " Ok "
  delay 50000
  window 1,1,80,25
endp

proc OutHelp
  ; Hilfe anzeigen
  savescr 13
  setcolor BLACK,CYAN
  window 6,7,75,19
  clrscr
  gotoxy 1,14
;text " Hilfe zur Installation ͻ\n"
  text "                                                                     \n"
  text " - Whlen Sie aus dem Men ZIELVERZEICHNIS NDERN, wenn Sie das Ziel-\n"
  text "   verzeichnis ndern mchten oder nicht gengend  Speicherplatz zur \n"
  text "   Verfgung steht. Geben Sie anschlieend das  gewnschte  Laufwerk \n"
  text "   und Verzeichnis an und drcken Sie die EINGABETASTE.              \n"
  text "                                                                     \n"
  text " - Beginnen Sie  die  Installation  durch  Auswahl  des  Menpunktes \n"
  text "   INSTALLATION STARTEN. Sie werden ggf.  automatisch  zum  Wechseln \n"
  text "   der Diskette aufgefordert.                                        \n"
  text "                                                                     \n"
  text " - Falls Sie die Installation nicht durchfhren mchten, whlen  Sie \n"
  text "   den Menpunkt ENDE.                                               \n"
;text "                                                                       \n"
;text " Weiter mit beliebiger Taste ͼ\n"
  window 1,1,80,25
  box 5,6,75,20,BLACK,CYAN,DOUBLE

  window 5,6,75,20
  setcolor WHITE,CYAN
  gotoxy 25,1
  text " Hilfe zur Installation "
  gotoxy 22,15
  text " Weiter mit beliebiger Taste "

  setcolor YELLOW,CYAN
  gotoxy 29,3
  text "ZIELVERZEICHNIS NDERN"
  gotoxy 5,9
  text "INSTALLATION STARTEN"
  gotoxy 19,13
  text "ENDE"

  setcolor LIGHTCYAN,CYAN
  gotoxy 44,6
  text "EINGABETASTE"

  ; Schatten unten
  setcolor DARKGRAY,CYAN
  window 7,21,77,21
  clrscr 219

  ; Schatten rechts
  setcolor DARKGRAY,CYAN
  window 76,7,77,21
  clrscr 219

  ; Pause bis Taste
  delay
  restscr 13
  window 1,1,80,25
endp

