//ACKNOWLEDGMENTS
//Matt Mahoney (PAQ's creator from which is derived Emilcont V0.2)
//Fabio Buffoni
//David Scott
//Jason Schmidt
//Alexander Ratushnyak
//And all the world of compression
#define PROGNAME "Emilcont"  
#define hash ___hash  
#include <cstdio>
#include <cstdlib>
#include <cctype>
#include <cmath>
#include <ctime>
#include <cassert>
#include <new>
#include <string>
#include <vector>
#include <algorithm>
#include <map>
#include <windows.h>  
#include <stdio.h>	 
#include <winbase.h>  
#undef hash
const int PSCALE=4096;   
int MEM=3;                         
template <class T> inline int size(const T& t) {return t.size();}
typedef unsigned char U8;
typedef unsigned short U16;
typedef unsigned long U32;
#define Top_value U32(0XFFFFFFFF)	
#define First_qtr U32(Top_value/4+1)  
#define Half	  U32(2*First_qtr)   
#define Third_qtr U32(3*First_qtr)   
#define min(a,b)	((a)<(b)?(a):(b))
#define max(a,b)	((a)>(b)?(a):(b))
void handler() {
  printf("Out of memory\n");
  exit(1);
}
int _wlen,_clen;
class ProgramChecker {
  clock_t start;
public:
  ProgramChecker() {
    start=clock();
    assert(sizeof(U8)==1);
    assert(sizeof(U16)==2);
    assert(sizeof(U32)==4);
    assert(sizeof(int)==4);
  }
  clock_t start_time() const {return start;}  
} programChecker;
int i;
int wlen,tf, bp, po,fsize=0;
class Random {
  U32 table[55];  
  int i;   
public:
  Random();
  U32 operator()() {   
    if (++i==55) i=0;
    if (i>=24) return table[i]^=table[i-24];
    else return table[i]^=table[i+31];
  }
} rnd;
Random::Random(): i(0) {  
  table[0]=123456789;
  table[1]=987654321;
  for (int j=2; j<55; ++j)
    table[j]=table[j-1]*11+table[j-2]*19/16;					
}
class Hash {
  U32 table[8][256];   
public:
  Hash() {
    for (int i=7; i>=0; --i)
      for (int j=0; j<256; ++j)
        table[i][j]=rnd();
    assert(table[0][255]==3610026313LU);
  }
  U32 operator()(U8 i0) const {
    return table[0][i0];
  }
  U32 operator()(U8 i0, U8 i1) const {
    return table[0][i0]+table[1][i1];
  }
  U32 operator()(U8 i0, U8 i1, U8 i2) const {
    return table[0][i0]+table[1][i1]+table[2][i2];
  }
  U32 operator()(U8 i0, U8 i1, U8 i2, U8 i3) const {
    return table[0][i0]+table[1][i1]+table[2][i2]+table[3][i3];
  }
} hash;
class Counter {
  U8 state;
  struct E {      
    U16 n0, n1;   
    U8 s00, s01;  
    U8 s10, s11;  
    U32 p0, p1;  
  };
  static E table[];  
public:
  Counter(): state(0) {}
  int get0() const {return table[state].n0;}
  int get1() const {return table[state].n1;}
  int priority() const {return get0()+get1();}
  void add(int y) {
    if (y) {
      if (state<208 || rnd()<table[state].p1)
        state=table[state].s11;
      else
        state=table[state].s10;
    }
    else {
      if (state<208 || rnd()<table[state].p0)
        state=table[state].s01;
      else
        state=table[state].s00;
    }
  }
};
Counter::E Counter::table[] = {
    {  0,  0,  0,  2,  0,  1,4294967295u,4294967295u},  
    {  0,  6,  1,  4,  1,  3,4294967295u,4294967295u},  
    {  6,  0,  2,  5,  2,  4,4294967295u,4294967295u},  
    {  0,  8,  1,  4,  3,  6,4294967295u,4294967295u},  
    {  2,  2,  4,  8,  4,  7,4294967295u,4294967295u},  
    {  8,  0,  5,  9,  2,  4,4294967295u,4294967295u},  
    {  0, 13,  1,  4,  6, 10,4294967295u,4294967295u}, 
    {  1,  2,  4,  8,  7, 11,4294967295u,4294967295u}, 
    {  2,  1,  8, 13,  4,  7,4294967295u,4294967295u}, 
    { 13,  0,  9, 14,  2,  4,4294967295u,4294967295u}, 
    {  0, 16,  3,  7, 10, 15,4294967295u,4294967295u}, 
    {  1,  3,  4,  8, 11, 16,4294967295u,4294967295u}, 
    {  2,  2,  8, 13,  7, 11,4294967295u,4294967295u}, 
    {  3,  1, 13, 19,  4,  7,4294967295u,4294967295u}, 
    { 16,  0, 14, 20,  5,  8,4294967295u,4294967295u}, 
    {  0, 20,  3,  7, 15, 21,4294967295u,4294967295u}, 
    {  1,  4,  7, 12, 16, 22,4294967295u,4294967295u}, 
    {  2,  3,  8, 13, 11, 16,4294967295u,4294967295u}, 
    {  3,  2, 13, 19,  7, 11,4294967295u,4294967295u}, 
    {  4,  1, 19, 26,  8, 12,4294967295u,4294967295u}, 
    { 20,  0, 20, 27,  5,  8,4294967295u,4294967295u}, 
    {  0, 24,  6, 11, 21, 28,4294967295u,4294967295u}, 
    {  1,  5,  7, 12, 22, 29,4294967295u,4294967295u}, 
    {  1,  3, 12, 18, 16, 22,4294967295u,4294967295u}, 
    {  3,  3, 13, 19, 11, 16,4294967295u,4294967295u}, 
    {  3,  1, 19, 26, 12, 17,4294967295u,4294967295u}, 
    {  5,  1, 26, 34,  8, 12,4294967295u,4294967295u}, 
    { 24,  0, 27, 35,  9, 13,4294967295u,4294967295u}, 
    {  0, 28,  6, 11, 28, 36,4294967295u,4294967295u}, 
    {  1,  6, 11, 17, 29, 37,4294967295u,4294967295u}, 
    {  1,  2, 12, 18, 22, 29,4294967295u,4294967295u}, 
    {  1,  1, 18, 25, 16, 22,4294967295u,4294967295u}, 
    {  1,  1, 19, 26, 17, 23,4294967295u,4294967295u}, 
    {  2,  1, 26, 34, 12, 17,4294967295u,4294967295u}, 
    {  6,  1, 34, 43, 13, 18,4294967295u,4294967295u}, 
    { 28,  0, 35, 44,  9, 13,4294967295u,4294967295u}, 
    {  0, 32, 10, 16, 36, 45,4294967295u,4294967295u}, 
    {  1,  7, 11, 17, 37, 46,4294967295u,4294967295u}, 
    {  1,  3, 17, 24, 29, 37,4294967295u,4294967295u}, 
    {  1,  1, 18, 25, 22, 29,4294967295u,4294967295u}, 
    {  1,  1, 25, 33, 23, 30,4294967295u,4294967295u}, 
    {  1,  1, 26, 34, 17, 23,4294967295u,4294967295u}, 
    {  3,  1, 34, 43, 18, 24,4294967295u,4294967295u}, 
    {  7,  1, 43, 53, 13, 18,4294967295u,4294967295u}, 
    { 32,  0, 44, 54, 14, 19,4294967295u,4294967295u}, 
    {  0, 36, 10, 16, 45, 55,4294967295u,4294967295u}, 
    {  1,  8, 16, 23, 46, 56,4294967295u,4294967295u}, 
    {  1,  3, 17, 24, 37, 46,4294967295u,4294967295u}, 
    {  1,  2, 24, 32, 29, 37,4294967295u,4294967295u}, 
    {  1,  1, 25, 33, 30, 38,4294967295u,4294967295u}, 
    {  1,  1, 33, 42, 23, 30,4294967295u,4294967295u}, 
    {  2,  1, 34, 43, 24, 31,4294967295u,4294967295u}, 
    {  3,  1, 43, 53, 18, 24,4294967295u,4294967295u}, 
    {  8,  1, 53, 61, 19, 25,4294967295u,4294967295u}, 
    { 36,  0, 54, 62, 14, 19,4294967295u,4294967295u}, 
    {  0, 40, 15, 22, 55, 63,4294967295u,4294967295u}, 
    {  1,  9, 16, 23, 56, 64,4294967295u,4294967295u}, 
    {  1,  4, 23, 31, 46, 56,4294967295u,4294967295u}, 
    {  1,  2, 24, 32, 37, 46,4294967295u,4294967295u}, 
    {  2,  1, 43, 53, 24, 31,4294967295u,4294967295u}, 
    {  4,  1, 53, 61, 25, 32,4294967295u,4294967295u}, 
    {  9,  1, 61, 69, 19, 25,4294967295u,4294967295u}, 
    { 40,  0, 62, 70, 20, 26,4294967295u,4294967295u}, 
    {  0, 44, 15, 22, 63, 71,4294967295u,4294967295u}, 
    {  1, 10, 22, 30, 64, 72,4294967295u,4294967295u}, 
    {  1,  4, 23, 31, 56, 64,4294967295u,4294967295u}, 
    {  1,  2, 31, 40, 46, 56,4294967295u,4294967295u}, 
    {  2,  1, 53, 61, 32, 40,4294967295u,4294967295u}, 
    {  4,  1, 61, 69, 25, 32,4294967295u,4294967295u}, 
    { 10,  1, 69, 77, 26, 33,4294967295u,4294967295u}, 
    { 44,  0, 70, 78, 20, 26,4294967295u,4294967295u}, 
    {  0, 48, 21, 29, 71, 79,4294967295u,4294967295u}, 
    {  1, 11, 22, 30, 72, 80,4294967295u,4294967295u}, 
    {  1,  5, 30, 39, 64, 72,4294967295u,4294967295u}, 
    {  1,  3, 31, 40, 56, 64,4294967295u,4294967295u}, 
    {  3,  1, 61, 69, 32, 40,4294967295u,4294967295u}, 
    {  5,  1, 69, 77, 33, 41,4294967295u,4294967295u}, 
    { 11,  1, 77, 85, 26, 33,4294967295u,4294967295u}, 
    { 48,  0, 78, 86, 27, 34,4294967295u,4294967295u}, 
    {  0, 52, 21, 29, 79, 87,4294967295u,4294967295u}, 
    {  1, 12, 29, 38, 80, 88,4294967295u,4294967295u}, 
    {  1,  5, 30, 39, 72, 80,4294967295u,4294967295u}, 
    {  1,  3, 39, 49, 64, 72,4294967295u,4294967295u}, 
    {  3,  1, 69, 77, 41, 50,4294967295u,4294967295u}, 
    {  5,  1, 77, 85, 33, 41,4294967295u,4294967295u}, 
    { 12,  1, 85, 91, 34, 42,4294967295u,4294967295u}, 
    { 52,  0, 86, 92, 27, 34,4294967295u,4294967295u}, 
    {  0, 56, 28, 37, 87, 93,4294967295u,4294967295u}, 
    {  1, 13, 29, 38, 88, 94,4294967295u,4294967295u}, 
    {  1,  6, 38, 48, 80, 88,4294967295u,4294967295u}, 
    {  6,  1, 85, 91, 42, 51,4294967295u,4294967295u}, 
    { 13,  1, 91, 97, 34, 42,4294967295u,4294967295u}, 
    { 56,  0, 92, 98, 35, 43,4294967295u,4294967295u}, 
    {  0, 60, 28, 37, 93, 99,4294967295u,4294967295u}, 
    {  1, 14, 37, 47, 94,100,4294967295u,4294967295u}, 
    {  1,  6, 38, 48, 88, 94,4294967295u,4294967295u}, 
    {  6,  1, 91, 97, 42, 51,4294967295u,4294967295u}, 
    { 14,  1, 97,103, 43, 52,4294967295u,4294967295u}, 
    { 60,  0, 98,104, 35, 43,4294967295u,4294967295u}, 
    {  0, 64, 36, 46, 99,105,4294967295u,4294967295u}, 
    {  1, 15, 37, 47,100,106,4294967295u,4294967295u}, 
    {  1,  7, 47, 58, 94,100,4294967295u,4294967295u}, 
    {  7,  1, 97,103, 52, 59,4294967295u,4294967295u}, 
    { 15,  1,103,109, 43, 52,4294967295u,4294967295u}, 
    { 64,  0,104,110, 44, 53,4294967295u,4294967295u}, 
    {  0, 68, 36, 46,105,111,4294967295u,4294967295u}, 
    {  1, 16, 46, 57,106,112,4294967295u,4294967295u}, 
    {  1,  7, 47, 58,100,106,4294967295u,4294967295u}, 
    {  7,  1,103,109, 52, 59,4294967295u,4294967295u}, 
    { 16,  1,109,113, 53, 60,4294967295u,4294967295u}, 
    { 68,  0,110,114, 44, 53,4294967295u,4294967295u}, 
    {  0, 72, 45, 56,111,115,4294967295u,4294967295u}, 
    {  1, 17, 46, 57,112,116,4294967295u,4294967295u}, 
    { 17,  1,113,119, 53, 60,4294967295u,4294967295u}, 
    { 72,  0,114,120, 54, 61,4294967295u,4294967295u}, 
    {  0, 76, 45, 56,115,121,4294967295u,4294967295u}, 
    {  1, 18, 56, 65,116,122,4294967295u,4294967295u}, 
    {  1,  8, 57, 66,112,116,4294967295u,4294967295u}, 
    {  8,  1,113,119, 60, 67,4294967295u,4294967295u}, 
    { 18,  1,119,125, 61, 68,4294967295u,4294967295u}, 
    { 76,  0,120,126, 54, 61,4294967295u,4294967295u}, 
    {  0, 80, 55, 64,121,127,4294967295u,4294967295u}, 
    {  1, 19, 56, 65,122,128,4294967295u,4294967295u}, 
    {  1,  9, 65, 74,116,122,4294967295u,4294967295u}, 
    {  9,  1,119,125, 68, 75,4294967295u,4294967295u}, 
    { 19,  1,125,131, 61, 68,4294967295u,4294967295u}, 
    { 80,  0,126,132, 62, 69,4294967295u,4294967295u}, 
    {  0, 84, 55, 64,127,133,4294967295u,4294967295u}, 
    {  1, 20, 64, 73,128,134,4294967295u,4294967295u}, 
    {  1,  9, 65, 74,122,128,4294967295u,4294967295u}, 
    {  9,  1,125,131, 68, 75,4294967295u,4294967295u}, 
    { 20,  1,131,137, 69, 76,4294967295u,4294967295u}, 
    { 84,  0,132,138, 62, 69,4294967295u,4294967295u}, 
    {  0, 88, 63, 72,133,139,4294967295u,4294967295u}, 
    {  1, 21, 64, 73,134,140,4294967295u,4294967295u}, 
    {  1, 10, 73, 82,128,134,4294967295u,4294967295u},
    { 10,  1,131,137, 76, 83,4294967295u,4294967295u},
    { 21,  1,137,143, 69, 76,4294967295u,4294967295u},
    { 88,  0,138,144, 70, 77,4294967295u,4294967295u},
    {  0, 92, 63, 72,139,145,4294967295u,4294967295u},
    {  1, 22, 72, 81,140,146,4294967295u,4294967295u},
    {  1, 10, 73, 82,134,140,4294967295u,4294967295u},
    { 10,  1,137,143, 76, 83,4294967295u,4294967295u},
    { 22,  1,143,147, 77, 84,4294967295u,4294967295u},
    { 92,  0,144,148, 70, 77,4294967295u,4294967295u},
    {  0, 96, 71, 80,145,149,4294967295u,4294967295u},
    {  1, 23, 72, 81,146,150,4294967295u,4294967295u},
    { 23,  1,147,151, 77, 84,4294967295u,4294967295u},
    { 96,  0,148,152, 78, 85,4294967295u,4294967295u},
    {  0,100, 63, 72,149,153,4294967295u,4294967295u},
    {  1, 24, 80, 89,150,154,4294967295u,4294967295u},
    { 24,  1,151,155, 85, 90,4294967295u,4294967295u},
    {100,  0,152,156, 70, 77,4294967295u,4294967295u},
    {  0,104, 63, 72,153,157,4294967295u,4294967295u},
    {  1, 25, 72, 81,154,158,4294967295u,4294967295u},
    { 25,  1,155,159, 77, 84,4294967295u,4294967295u},
    {104,  0,156,160, 70, 77,4294967295u,4294967295u},
    {  0,108, 63, 72,157,161,4294967295u,4294967295u},
    {  1, 26, 72, 81,158,162,4294967295u,4294967295u},
    { 26,  1,159,163, 77, 84,4294967295u,4294967295u},
    {108,  0,160,164, 70, 77,4294967295u,4294967295u},
    {  0,112, 63, 72,161,165,4294967295u,4294967295u},
    {  1, 27, 72, 81,162,166,4294967295u,4294967295u},
    { 27,  1,163,167, 77, 84,4294967295u,4294967295u},
    {112,  0,164,168, 70, 77,4294967295u,4294967295u},
    {  0,116, 63, 72,165,169,4294967295u,4294967295u},
    {  1, 28, 72, 81,166,170,4294967295u,4294967295u},
    { 28,  1,167,171, 77, 84,4294967295u,4294967295u},
    {116,  0,168,172, 70, 77,4294967295u,4294967295u},
    {  0,120, 63, 72,169,173,4294967295u,4294967295u},
    {  1, 29, 72, 81,170,174,4294967295u,4294967295u},  
    { 29,  1,171,175, 77, 84,4294967295u,4294967295u}, 
    {120,  0,172,176, 70, 77,4294967295u,4294967295u}, 
    {  0,124, 63, 72,173,177,4294967295u,4294967295u}, 
    {  1, 30, 72, 81,174,178,4294967295u,4294967295u}, 
    { 30,  1,175,179, 77, 84,4294967295u,4294967295u}, 
    {124,  0,176,180, 70, 77,4294967295u,4294967295u}, 
    {  0,128, 63, 72,177,181,4294967295u,4294967295u}, 
    {  1, 31, 72, 81,178,182,4294967295u,4294967295u}, 
    { 31,  1,179,183, 77, 84,4294967295u,4294967295u}, 
    {128,  0,180,184, 70, 77,4294967295u,4294967295u}, 
    {  0,132, 63, 72,181,185,4294967295u,4294967295u}, 
    {  1, 32, 72, 81,182,186,4294967295u,4294967295u}, 
    { 32,  1,183,187, 77, 84,4294967295u,4294967295u}, 
    {132,  0,184,188, 70, 77,4294967295u,4294967295u}, 
    {  0,136, 63, 72,185,189,4294967295u,4294967295u}, 
    {  1, 33, 72, 81,186,190,4294967295u,4294967295u}, 
    { 33,  1,187,191, 77, 84,4294967295u,4294967295u}, 
    {136,  0,188,192, 70, 77,4294967295u,4294967295u}, 
    {  0,140, 63, 72,189,193,4294967295u,4294967295u}, 
    {  1, 34, 72, 81,190,194,4294967295u,4294967295u}, 
    { 34,  1,191,195, 77, 84,4294967295u,4294967295u}, 
    {140,  0,192,196, 70, 77,4294967295u,4294967295u}, 
    {  0,144, 71, 80,193,197,4294967295u,4294967295u}, 
    {  1, 35, 72, 81,194,198,4294967295u,4294967295u}, 
    { 35,  1,195,199, 77, 84,4294967295u,4294967295u}, 
    {144,  0,196,200, 78, 85,4294967295u,4294967295u}, 
    {  0,148, 71, 80,197,201,4294967295u,4294967295u},  
    {  1, 36, 80, 89,198,202,4294967295u,4294967295u}, 
    { 36,  1,199,203, 85, 90,4294967295u,4294967295u}, 
    {148,  0,200,204, 78, 85,4294967295u,4294967295u}, 
    {  0,152, 71, 80,201,205,4294967295u,4294967295u}, 
    {  1, 37, 80, 89,202,206,4294967295u,4294967295u}, 
    { 37,  1,203,207, 85, 90,4294967295u,4294967295u}, 
    {152,  0,204,208, 78, 85,4294967295u,4294967295u}, 
    {  0,156, 71, 80,205,209,4294967295u,4294967295u}, 
    {  1, 38, 80, 89,206,210,4294967295u,4294967295u}, 
    { 38,  1,207,211, 85, 90,4294967295u,4294967295u}, 
    {156,  0,208,212, 78, 85,4294967295u,4294967295u}, 
    {  0,160, 71, 80,209,215,4294967295u,1073741823u/8},  
    {  1, 39, 80, 89,210,213,4294967295u,4294967295u},  
    { 39,  1,211,214, 85, 90,4294967295u,4294967295u},  
    {160,  0,212,216, 78, 85,1073741823u/8,4294967295u},  
    {  1, 40, 80, 89,213,217,4294967295u,1073741823u/8}, 
    { 40,  1,214,218, 85, 90,1073741823u/8,4294967295u}, 
    {  0,176, 71, 80,215,219,4294967295u,1073741823u/8}, 
    {176,  0,216,220, 78, 85,1073741823u/8,4294967295u}, 
    {  1, 44, 80, 89,217,221,4294967295u,1073741823u/8}, 
    { 44,  1,218,222, 85, 90,1073741823u/8,4294967295u}, 
    {  0,192, 71, 80,219,223,4294967295u, 536870911u/8}, 
    {192,  0,220,224, 78, 85, 536870911u/8,4294967295u}, 
    {  1, 48, 80, 89,221,225,4294967295u, 536870911u/8}, 
    { 48,  1,222,226, 85, 90, 536870911u/8,4294967295u}, 
    {  0,224, 79, 88,223,227,4294967295u, 536870911u/8}, 
    {224,  0,224,228, 86, 91, 536870911u/8,4294967295u}, 
    {  1, 56, 88, 95,225,229,4294967295u, 536870911u/8}, 
    { 56,  1,226,230, 91, 96, 536870911u/8,4294967295u}, 
    {  0,256, 87, 94,227,231,4294967295u, 134217727u/8}, 
    {256,  0,228,232, 92, 97, 134217727u/8,4294967295u}, 
    {  1, 64, 94,101,229,233,4294967295u, 134217727u/8}, 
    { 64,  1,230,234, 97,102, 134217727u/8,4294967295u}, 
    {  0,384, 93,100,231,235,4294967295u, 134217727u/8}, 
    {384,  0,232,236, 98,103, 134217727u/8,4294967295u}, 
    {  1, 96,100,107,233,237,4294967295u, 134217727u/8}, 
    { 96,  1,234,238,103,108, 134217727u/8,4294967295u}, 
    {  0,512,105,112,235,239,4294967295u, 134217727u/8}, 
    {512,  0,236,240,110,113, 134217727u/8,4294967295u}, 
    {  1,128,112,117,237,241,4294967295u, 134217727u/8}, 
    {128,  1,238,242,113,118, 134217727u/8,4294967295u}, 
    {  0,640,111,116,239,243,4294967295u, 134217727u/8}, 
    {640,  0,240,244,114,119, 134217727u/8,4294967295u}, 
    {  1,160,116,123,241,245,4294967295u, 134217727u/8}, 
    {160,  1,242,246,119,124, 134217727u/8,4294967295u}, 
    {  0,768,115,122,243,247,4294967295u, 134217727u/8}, 
    {768,  0,244,248,120,125, 134217727u/8,4294967295u}, 
    {  1,192,122,129,245,249,4294967295u, 134217727u/8}, 
    {192,  1,246,250,125,130, 134217727u/8,4294967295u},  
    {  0,896,121,128,247,251,4294967295u, 138547332u/8}, 
    {896,  0,248,252,126,131, 138547332u/8,4294967295u}, 
    {  1,224,128,135,249,253,4294967295u, 138547332u/8}, 
    {224,  1,250,254,131,136, 138547332u/8,4294967295u}, 
    { 0,1020,127,134,251,251,4294967295u,         0u},  
    {1020, 0,252,252,132,137,         0u,4294967295u}, 
    {  1,255,134,141,253,253,4294967295u,         0u}, 
    {255,  1,254,254,137,142,         0u,4294967295u}  
};
class Ch {
  U32 N;   
  U32 N1;   
  U8 *buf;   
  U32 p;   
  U32 bp;  
  U32 hi_nibble, lo_nibble;   
  U32 lpos[256][4];   
  U32 lidx[256];
public:
  Ch(): N(0), buf(0), p(0), bp(0), hi_nibble(0), lo_nibble(1) {
    memset(lpos, 0, 256*4*sizeof(U32));
	memset(lidx, 0, 256*sizeof(U32));
  }
  void init() {
    N = 1 << (19+MEM-(MEM>=6));
	N1 = N-1;
    buf=(U8*)calloc(N, 1);
    if (!buf)
      handler();
      buf[0]=1;
  }
  U32 operator()(int i) const {return buf[(p-i)&(N1)];}
  U32 operator()() const {return buf[p&(N1)];}
  void update(int y) {
    U8 &r=buf[p&(N1)];
    r=(r<<1)|y;
	++bp;
    if ((lo_nibble=(lo_nibble<<1)|y)>=16) {
      lo_nibble=1;
	  if (!(bp&=7)) {
        ++lidx[r];
	  	  lpos[r][lidx[r]&=3]=p++;
		buf[p&(N1)]=1;
	  } 
    }
  }
  U32 pos() const {return p;}
  U32 pos(U8 c, int i=0) const {return lpos[c][(lidx[c]-i)&3];}
  U32 bpos() const {return bp;}
  U32 operator[](int i) const {return buf[i&(N1)];}
  U32 hi() const {if (bp>3) return buf[p&N1]&15; else return buf[(p-1)&N1]>>4;}
  U32 lo() const {return lo_nibble;}
} ch;  
template<class T>
class Hashtable {
private:
  const U32 N;   
  struct HashElement {
    U8 checksum;  
    T c[15];   
    HashElement(): checksum(0) {}
  };
  HashElement *table;   
  U32 cxt;  
  T *Tcxt;
public:
  Hashtable(U32 n);
  void set(U32 h) {
    const U8 checksum=h+(h>>16);
    const U32 lo= (h>>(32-N)) & -4;                    
    const U32 hi=lo+4;					
    U32 i;
    for (i=lo; i<hi; ++i) {
      if (table[i].checksum==checksum) {  
        cxt=i;
        break;
      }
      else if (table[i].c[0].priority()==0) {   
        table[i].checksum=checksum;
        cxt=i;
        break;
      }
    }
    if (i==hi) {
      cxt=lo;
      if (table[lo+2].c[0].priority()<table[lo+3].c[0].priority())
        memmove(table+lo+1, table+lo, 32);
      else
        memmove(table+lo+1, table+lo, 48);
      memset(table+lo, 0, 16);
      table[cxt].checksum=checksum;
    }
    else if (cxt!=lo) {
      HashElement he=table[cxt];
      memmove(table+lo+1, table+lo, (cxt-lo)*16);
      table[lo]=he;
      cxt=lo;
    }
	Tcxt=&(table[cxt].c[-1]);
  }
  T& operator()(U32 c) {
	  return Tcxt[c];
  }
};
template <class T>
Hashtable<T>::Hashtable(U32 n): N(n>4?n-4:1), table(0), cxt(0) {
  assert(sizeof(HashElement)==16);
  assert(sizeof(char)==1);
  char *p=(char*)calloc((16<<N)+64, 1);
  if (!p)
    handler();
  p+=64-(((int)p)&63);  
  table=(HashElement*)p;
  Tcxt=&(table[0].c[-1]);
}
class Mixer {
protected:
  enum {N=64};   
  const int C;
  U32 *bc0, *bc1;  
  U32 (*wt)[N];   
  int n;   
  int c;   
  int _b0,_b1;
public:
  Mixer(int C_);
  ~Mixer();
  U32 getN() const {return N;}
  U32 getC() const {return C;}
  void write(int n0, int n1) {
    bc0[++n]=n0;
    bc1[n]=n1;
  }
  void add(int n0, int n1) {
    bc0[n]+=n0;
    bc1[n]+=n1;
  }
  void mul(int m) {
    bc0[n]*=m;
    bc1[n]*=m;
  }
  int predict(int c_);
  virtual void update(int y) {};
};
int Mixer::predict(int c_) {
  assert(n>0 && n<N);
  assert(c_>=0 && c_<C);
  c=c_;
  int n0=n, n1=n0;
  for (int j=0; j<=n; ++j) {
    U32 w=wt[c][j];
    n0+=bc0[j]*w;
    n1+=bc1[j]*w;
  }
  _b0=n0;
  _b1=n1;
  int sum=n0+n1;
  return (int)((float)(n1)*PSCALE/sum);
}
Mixer::Mixer(int C_): C(C_), bc0(new U32[N]), bc1(new U32[N]),
                      wt(new U32[C_][N]), n(-1), c(0) {
  int i;
  for (i=0; i<C; ++i) {
    for (int j=0; j<N; ++j)
      wt[i][j]=1;
  }
  for (i=0; i<N; ++i)
    bc0[i]=bc1[i]=0;
}
Mixer::~Mixer() {
}
class Mixer1 : public Mixer {
public:
Mixer1(int _C) : Mixer(_C) {}
void update(int y) {
  U32 s0, s1;
  s0=_b0;
  s1=_b1;
  if (s0>0 && s1>0) {
	U32 rn= rnd();
	const U32 s=s0+s1;
	const U32 sy=y?s1:s0;
	const U32 s1 =(0x1ffffff/s);
	const U32 syd=(0xffffffff*(1.0/sy-1.0/s)+(rn&127))/128;
	const int m0=y?-s1:syd;
	const int m1=y?syd:-s1;
	rn=(rn>>14)&1023;
	for (int i=0; i<=n; ++i) {
	  int dw = int( bc0[i]*m0+bc1[i]*m1 + rn ) >>10;
	  wt[c][i]=min(65535, max(1, int(wt[c][i]+dw)));
	}
  }
  n=-1;
}
};
class Mixer2 : public Mixer {
public:
Mixer2(int _C) : Mixer(_C) {}
void update(int y) {
  U32 s0, s1;
  s0=_b0;
  s1=_b1;
  if (s0>0 && s1>0) {
	const U32 s = s0+s1;
	const U32 sy = y?s1:s0;
	const U32 k = 0x18000;
	const U32 sy1=k/sy;
	const int su =k/s;
	const int syd=sy1-su;
	const int m0=y?-su-1:syd;
	const int m1=y?syd:-su-1;
	U32 rn=rnd()&255;
	for (int i=0; i<=n; ++i) {
	  int dw = int( m0*bc0[i]+m1*bc1[i]+rn)>>8;
	  wt[c][i]=min(0xffff, max(1, int(wt[c][i]+dw)));
	}
  }
  n=-1;
}
};
class MultiMixer {
  enum {MINMEM=5};  
  Mixer1 m1;
  Mixer2 m2;
public:
  MultiMixer(): m1(128), m2(128) {}
  void write(int n0, int n1) {
    m1.write(n0, n1);
    if (MEM>=MINMEM)
      m2.write(n0, n1);
  }
  void add(int n0, int n1) {
    m1.add(n0, n1);
    if (MEM>=MINMEM) 
      m2.add(n0, n1);
  }
  int predict() {
	U32 u1;
	if (ch.pos(0, 3) < ch.pos(32, 3)) 
		u1 = (ch(2)>>5) + 8*(ch(1)>>5) + 64*(_wlen==_clen);
	else if (ch.pos(0, 3) > ch.pos(167, 3)) 
		u1 = (ch(2)>>4);
	else
		u1 = (ch(2)>>4) + 16*(ch(3)>>5);
	U32 p1=m1.predict(u1);
	if (MEM>=MINMEM) {
	  U32 p2=m2.predict((ch(1)>>5) + 8*(ch(2)>>6) + (ch(3)>>6)*32);
      return (p1+p2)>>1;
    }
    else
     return p1;
  }
  void update(int y) {
    m1.update(y);
    if (MEM>=MINMEM)
	  m2.update(y);
  }
  void mul(int m) {
	m1.mul(m);
    if (MEM>=MINMEM)
	  m2.mul(m);
  }
  U32 getC() const {return 256;}
  U32 getN() const {return m1.getN();}
};
MultiMixer mixer;
class CounterMap1 {
  const int N;
  struct S {
    U8 n;  
    U8 c;  
  };
  S* t;   
  S* cxt;
public:
  CounterMap1(int n): N(n>1?n-1:1) {
    assert(sizeof(S)==2);
    t=(S*)calloc(1<<N, 2);
    if (!t)
      handler();
	cxt=t;
  }
  void update(U32 h) {
    if (ch.bpos()==0) {
      if (cxt->n==0) {
        cxt->n=1;
        cxt->c=ch(1);
      }
      else if (U32(cxt->c)==ch(1)) {
        if (cxt->n<255)
          ++(cxt->n);
      }
      else {
        cxt->n=1;
        cxt->c=ch(1);
      }
    }
    cxt = t+((h+(h<<16)) >> (32-N));
  }
  void add() {
	U32 d=((cxt->c+256) >> (7-ch.bpos()));
    if (!(d^=(ch()<<1))) 
        mixer.add(cxt->n, 0);
	else if (d==1)
        mixer.add(0, cxt->n);
  }
  void write() {
	U32 d=((cxt->c+256) >> (7-ch.bpos()));
    if (!(d^=(ch()<<1))) 
        mixer.write(cxt->n, 0);
	else if (d==1)
        mixer.write(0, cxt->n);
  }
  void mul(int m) {
	  mixer.mul(m);
  }
};
class CounterMap2 {
private:
  const U32 N2;   
  U32 cxt;   
  Hashtable<Counter> ht2;   
  Counter* cp[8];  
public:
  CounterMap2(int n);   
  void add();
  void update(U32 h);
  void write() {
  const U32 bcount = ch.bpos();
	  if (bcount==4) {
		cxt^=hash(ch.hi());
		ht2.set(cxt);
	  }
	  cp[bcount]=&ht2(ch.lo());
	  mixer.write(cp[bcount]->get0(), cp[bcount]->get1());
  }
  void mul(int m) {
	  mixer.mul(m);
  }
};
CounterMap2::CounterMap2(int n): N2(n), cxt(0), ht2(N2) {
  for (int i=0; i<8; ++i)
    cp[i]=0;
}
void CounterMap2::add() {
  const U32 bcount = ch.bpos();
  if (bcount==4) {
    cxt^=hash(ch.hi());
    ht2.set(cxt);
  }
  cp[bcount]=&ht2(ch.lo());
  mixer.add(cp[bcount]->get0(), cp[bcount]->get1());
}
void CounterMap2::update(U32 h) {
  const U32 c=ch(1);
  for (int i=0; i<8; ++i) {
    if (cp[i]) {
      cp[i]->add((c>>(7-i))&1);
      cp[i]=0;
    }
  }
  cxt=h;
  ht2.set(cxt);
}
class CounterMap3 {
  enum {MINMEM=5};   
  CounterMap1 cm1;
  CounterMap2 cm2;
public:
  CounterMap3(int n): cm1(MEM>=MINMEM ? n-2 : 0), cm2(n) {}
  void update(U32 h) {
    if (MEM>=MINMEM)
      cm1.update(h);
    cm2.update(h);
  }
  void write() {
    cm2.write();
    if (MEM>=MINMEM)
      cm1.add();
  }
  void add() {
    cm2.add();
    if (MEM>=MINMEM)
      cm1.add();
  }
  void mul(int m) {
    cm2.mul(m);
    if (MEM>=MINMEM)
      cm1.mul(m);
  }
};
#define CounterMap CounterMap3
class Model {
public:
  virtual void model() = 0;
  virtual ~Model() {}
};
class DeMo: public Model {
public:
  void model() {mixer.write(1, 1);}
};
class CMo: public Model {
  const int SIZE;
  enum {N=10};        
  Counter *t0, *t1;    
  CounterMap  _t0,_t1,t2, t3;
  CounterMap2 t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14, t15;   
  U32 *cxt;            
  Counter *cp0, *cp1;  
public:
  CMo(): 
  SIZE((MEM>=0)*(MEM+18)),
  t0(new Counter[256]), t1(new Counter[65536]),	
	  _t0(8),_t1(16),
               t2(SIZE),  
               t3(SIZE+1),  
               t4(SIZE+1),   
               t5(SIZE+1),   
               t6(SIZE+1),   
               t7(SIZE+1),  
               t8(SIZE+1),   
               t9(SIZE+1),   
               t10(SIZE+1),   
               t11(SIZE+1),     
               t12(SIZE+1),    
               t13(SIZE+1),    
               t14(SIZE+1),   
               t15(SIZE+1),                                 
               cxt(new U32[N]) {
    cp0=&t0[0];
    cp1=&t1[0];
    memset(cxt, 0, N*sizeof(U32));
    memset(t0, 0, 256*sizeof(Counter));
    memset(t1, 0, 65536*sizeof(Counter));
  }
  void model();          
};
inline void CMo::model() {
  int y = ch(ch.bpos()==0)&1;   
  cp0->add(y);
  cp1->add(y);
  if (ch.bpos()==0) {   
cxt[15]=cxt[0]^hash(ch(12),2,0);    
cxt[14]=cxt[0]^hash(ch(6),1,0);  
cxt[13]=cxt[0]^hash(ch(2),2,0);  
cxt[12]=cxt[9]^hash(ch(1),9,0); 
cxt[11]=cxt[0]^hash(ch(3),1,0);  
cxt[10]=cxt[8]^hash(ch(1),8,0);  
cxt[9]=cxt[7]^hash(ch(1),7,0); 
cxt[8]=cxt[0]^hash(ch(4),2,0);   
cxt[7]=cxt[6]^hash(ch(1),6,0);  
cxt[6]=cxt[5]^hash(ch(1),5,0);  
cxt[5]=cxt[4]^hash(ch(1),4,0);  
cxt[4]=cxt[3]^hash(ch(1),3,0);   
cxt[3]=cxt[2]^hash(ch(1),2,0);      
cxt[2]=cxt[1]^hash(ch(1),1,0);    
cxt[1]=cxt[0]^hash(ch(1),0,0);  
t2.update(cxt[2]);
t3.update(cxt[3]);
t4.update(cxt[4]);
t5.update(cxt[5]);
t6.update(cxt[6]);
t7.update(cxt[7]);
t8.update(cxt[8]);
t9.update(cxt[9]);
t10.update(cxt[10]);
t11.update(cxt[11]);
t12.update(cxt[12]);
t13.update(cxt[13]);
t14.update(cxt[14]); 
t15.update(cxt[15]);      
  }
  cp0=&t0[ch()];
  cp1=&t1[ch()+256*ch(1)];
  mixer.write(cp0->get0(), cp0->get1());
  mixer.write(cp1->get0(), cp1->get1());
  t2.write();
  t3.write();
  t4.write();
  t5.write();
  t6.write();
  t7.write();
  t8.write();
  t9.write();
  t10.write();
  t11.write();
  t12.write();
  t13.write();
  t14.write();   
  t15.write();   
}
class ReMo: public Model {
  enum {N=20};   
  const int SIZE;
CounterMap t0, t1;
int r1,r2,r3,r4,c1,c2;
public:
ReMo():SIZE((MEM>=0)*(MEM+18)),
t0(SIZE),
t1(SIZE),
r1(2),
r2(3),
r3(2),
r4(3),
c1(0),
c2(0)
{}
  void model(); 
};	
	inline void ReMo::model() {
  if (ch.bpos()==0) {	
int c=ch(1);
int d=ch.pos(c,0)-ch.pos(c,1);
if(d>2&&d==ch.pos(c,1)-ch.pos(c,2)&&d==ch.pos(c,2)-ch.pos(c,3))
if(d==r1){
if(++c1>=c2){
swap(c1,c2);
swap(r1,r2);
}
}
else
if(d==r2)
++c2;
else
if(c1>=c2){
r1=r2;
c1=++c2;
r2=d;
c2=0;
}
else
{
r1=d;
c1=0;
}
if(d>2){
if(d==r3)
swap(r3,r4);
if(d!=r4)
r3=d;
}
t0.update(hash(ch(r2),ch(r2*2),r2));
t1.update(hash(ch(r2),po%r2));
}
  t0.write();
  t1.write();
}
class ReMon3: public Model {
  enum {N=2};            
    const int SIZE;
  CounterMap t0;   
  int repeat1, repeat2;   
  int _c1,_c2;
public:
  ReMon3(): SIZE((MEM>=0)*(MEM+18)),
                 t0(SIZE),   
                 repeat1(2), repeat2(3), _c1(0), _c2(0) {}
  void model(); 
};
inline void ReMon3::model() {
  if (ch.bpos()==0) {
    const int c=ch(1);
    const int d1=ch.pos(c,0)-ch.pos(c,1);
    const int d2=ch.pos(c,1)-ch.pos(c,2);
    const int d3=ch.pos(c,2)-ch.pos(c,3);
    if (d1>2 && d1==d2       && d1==d3     ) 
	{
		if (d1==repeat1) {
			_c1++;_c2--;
			if (_c1>_c2) {
				swap(_c1,_c2);
				swap(repeat1, repeat2);
			}
		} else if (d1!=repeat2) {
			if (_c1<_c2) {
				repeat1=d1;
				_c1=0;
			} else {
				repeat1=repeat2;
				_c1=_c2+1;
				repeat2=d1;
				_c2=0;
			}
		}
    }
    int r1=repeat2, r2=repeat1;
        t0.update(hash(ch(r1), ch(r1*3), r1));   
  }
  t0.write();
}
class ReMod2: public Model {
  enum {N=2};           
    const int SIZE;
  CounterMap t0;  
  int repeat1, repeat2;  
  int _c1,_c2;
public:
  ReMod2(): SIZE((MEM>=0)*(MEM+18)),
                 t0(SIZE),   
                 repeat1(2), repeat2(3), _c1(0), _c2(0) {}
  void model(); 
};
inline void ReMod2::model() {
  if (ch.bpos()==0) {
    const int c=ch(1);
    const int d1=ch.pos(c,0)-ch.pos(c,1);
    const int d2=ch.pos(c,1)-ch.pos(c,2);
    if (d1>2 && d1==d2           ) 
	{
		if (d1==repeat1) {
			_c1++;_c2--;
			if (_c1>_c2) {
				swap(_c1,_c2);
				swap(repeat1, repeat2);
			}
		} else if (d1!=repeat2) {
			if (_c1<_c2) {
				repeat1=d1;
				_c1=0;
			} else {
				repeat1=repeat2;
				_c1=_c2+1;
				repeat2=d1;
				_c2=0;
			}
		}
    }
    int r1=repeat2, r2=repeat1;
       t0.update(hash(ch(r1), ch(r1*2), r1));   
  }
  t0.write();
}
class WMo: public Model {
  enum {N=3}; 
     const int SIZE;
  CounterMap t0,t1;
  U32 cxt[N];    
  U32 word[N];   
public:
  WMo():  SIZE((MEM>=0)*(MEM+16)),
               t0(SIZE), t1(SIZE){
    for (int i=0; i<N; ++i)
      cxt[i]=word[i]=0;
	_clen=0;
	_wlen=0;
  }
  void model() {
    if (ch.bpos()==0) {
      int c=ch(1);
      if (c>32) {						 
        cxt[0]^=hash(cxt[0], cxt[0]>>8, c, _clen++);   
      }
      else if (cxt[0]) {
        for (int i=N-1; i>0; --i)
          cxt[i]=cxt[i-1];
        cxt[0]=0;
		_clen=0;
      }
      if (isalpha(c) || c>=192) {                               
        word[0]^=hash(word[0], tolower(c));  
		_wlen++;
	  }
      else {
        for (int i=N-1; i>0; --i)
          word[i]=word[i-1];
        word[0]=0;
		_wlen=0;
      }      
      t0.update(-word[0]);
      t1.update(cxt[3]+cxt[2]-cxt[0]);
    }
    t0.write();
  t1.write();
  }
};
class MaMo: public Model {
  const int N;      
  enum {M=4};        
  U32 hash[2];     
  U32 begin[M];    
  U32 end[M];      
  U32 *ptr;          
public:
  MaMo(): N(15+MEM-(MEM>=6)), ptr(new U32[1 << N]) {
    memset(ptr, 0, (1 << N)*sizeof(U32));                             
    hash[0]=hash[1]=0;
    for (int i=0; i<M; ++i)
      begin[i]=end[i]=0;
  }
  void model();
};
inline void MaMo::model() {
  if (ch.bpos()==0) {  
    hash[0]=hash[0]*(16*56797157)+ch(1)+1;  
    hash[1]=hash[1]*(2*45684217)+ch(1)+1;   
    U32 h=hash[0] >> (32-N);
    if ((hash[0]>>28)==0)
      h=hash[1] >> (32-N);  
    int i;
    for (i=0; i<M; ++i) {
      if (end[i] && ch(1)==ch[end[i]])
        ++end[i];
    }
    for ( i=0; i<M; ++i) {
      if (!end[i]) {  
        int j;
        for (j=0; j<M; ++j)   
          if (ptr[h]==end[j])
            break;
        if (j!=M)   
          break;
        end[i]=ptr[h];
        if (end[i]>0) {
          begin[i]=end[i];
          U32 p=ch.pos();
          while (begin[i]>0 && p>0 && begin[i]!=p+1
              && ch[begin[i]-1]==ch[p-1]) {
            --begin[i];
            --p;
          }
        }
        if (end[i]==begin[i])   
          begin[i]=end[i]=0;
        break;
      }
    }
    ptr[h]=ch.pos();
  }
  int n0=0, n1=0;
  for (int i=0; i<M; ++i) {
	  if (end[i]) {
                U32 d=(ch[end[i]]+256) >> (7-ch.bpos());
		if ((d>>1) != ch())
	      begin[i]=end[i]=0;
		else	
		{ 
		  U32 wt=(end[i]-begin[i]);
		  if (wt>45)
			wt=1024;   
		  else
	        wt=wt*wt>>2;
		  if (d & 1)
			n1+=wt;
		  else
			n0+=wt;
		}
	  }
  }
  mixer.write(n0, n1);
}
class AMo: public Model { 
  enum {N=6};
  const int SIZE;
  
  CounterMap t0,t1,t2,t3, t4,t5,t6,t7;
  int pos3;   
public:
AMo(): SIZE((MEM>=0)*(MEM+14)),
   t0(SIZE),  t1(SIZE),  t2(SIZE),  t3(SIZE), t4(SIZE), t5(SIZE), t6(SIZE), t7(SIZE), pos3(0) {}
  void model() {
    if (ch.bpos()==0) {
      if (++pos3==3) pos3=0;
        t0.update(hash(ch(1)/8,  ch(2)/16,   ch(3)/32,  ch(4)/24));  
        t1.update(hash(ch(1)/6,  ch(2)/12,   ch(3)/18        ));
        t2.update(hash(ch(1)/4, (ch(3)-  ch(4))/6        ));
        t3.update(hash(ch(1)/2, (ch(2)-  ch(3))/12  ));
        t4.update(hash(ch(1)/9,  ch(2)/13,   ch(3)/17 , ch(4)/26)); 
        t5.update(hash(ch(1)/7,  ch(2)/11,    ch(3)/12 ,   ch(4)/13));      
        t6.update(hash(ch(1)/5,  ch(2)/8,    ch(3)/9 ,   ch(4)/10));
        t7.update(hash(ch(1)/5,  ch(2)/6,    ch(3)/7 ,   ch(4)/8));   
    }
    t0.write();
    t1.write();
    t2.write();
    t3.write();
    t4.write();
    t5.write();
    t6.write();
    t7.write();
  }
};
class EMo {
  struct S {
    U32 a;  
    U8 n;  
    S(): a(0), n(0) {}
  };
  S t[256];   
public:
  void model() {
    if (ch.bpos()==0) {
      if (ch(5)==0xe8 && (ch(1)==0 || ch(1)==0xff)) {
        U32 a=ch(4)+(ch(3)<<8)+(ch(2)<<16)+(ch(1)<<24)+ch.pos()-5;
        int i=a&0xff;
        if (t[i].a==a) {
			if (t[i].n<255)
				++t[i].n;
		}
        else {
          t[i].a=a;
          t[i].n=1;
        }
      }
    }
    int n0=0, n1=0;
    if (ch(4)==0xe8) {
      int i=(ch(3)+ch.pos()-4)&0xff;  
      if (t[i].n>0) {
        U32 r=t[i].a-ch.pos()+4;   
        U32 ck=(((r&0xff000000)>>8)+0x1000000)>>(24-ch.bpos());
        int y=(r>>(31-ch.bpos()))&1;   
        if (ch(0)==ck && ch(1)==((r>>16)&0xff)) {
          if (y)
            n1=0x7fff;  
          else
            n0=0x7fff; 
        }
      }
	}   
    if (ch(3)==0xe8) {
      int i=(ch(2)+ch.pos()-3)&0xff;
      if (t[i].n>0) {
        U32 r=t[i].a-ch.pos()+3;
        U32 ck=((r&0xff0000)+0x1000000)>>(24-ch.bpos());
        int y=(r>>(23-ch.bpos()))&1;
        if (ch(0)==ck && ch(1)==((r>>8)&0xff)) {
          if (y)
            n1=0x7fff; 
          else
            n0=0x7fff; 
        }
      }
    } 
    else if (ch(2)==0xe8) {
      int i=(ch(1)+ch.pos()-2)&0xff;
      if (t[i].n>0) {
        U32 r=t[i].a-ch.pos()+2;
        U32 ck=((r&0xff00)+0x10000)>>(16-ch.bpos());
        int y=(r>>(15-ch.bpos()))&1;
        if (ch(0)==ck) {
          if (y)
            n1=t[i].n*(ch.bpos()+9);
          else
            n0=t[i].n*(ch.bpos()+9);
        }
      }
    }
    mixer.write(n0, n1);
  }
};
class Predictor {
DeMo deMo;
CMo cMo;
ReMo reMo;
ReMon3 reMon3;
ReMod2 reMod2;
WMo wMo;
MaMo maMo;
AMo aMo;
EMo eMo;
  enum {SSE1=256*4*2, SSE2=32,  
    SSESCALE=1024/SSE2};     
   class SSEMap {
    U16 table[PSCALE];
  public:
    int operator()(int p) const {return table[p];}
    SSEMap();
  } ssemap;  
  struct SSEContext {
    U8 c1, n;  
    int p() const {return PSCALE*(c1*64+1)/(n*64+2);}
    void update(int y) {
        c1+=y;
      if (++n>254) {  
        c1/=2;
        n/=2;
      }
    }
    SSEContext(): c1(0), n(0) {}
  };
  SSEContext (*sse)[SSE2+1];   
  U32 nextp;   
  U32 ssep;     
  U32 context;  
public:
  Predictor();
  int p() const {return nextp;}   
  void update(int y);   
};
Predictor::SSEMap::SSEMap() {
  for (int i=0; i<PSCALE; ++i) {
    int p=int(64*log((i+0.5)/(PSCALE-0.5-i))+512);
    if (p>1023) p=1023;
    if (p<0) p=0;
    table[i]=p;
  }
}
Predictor::Predictor(): sse(0), nextp(PSCALE/2), ssep(512), context(0) {
  ch.init();
  if (MEM>=1) {
    sse=(SSEContext(*)[SSE2+1]) new SSEContext[SSE1][SSE2+1];
    int N=PSCALE;
    int oldp=SSE2+1;
    for (int i=N-1; i>=0; --i) {
      int p=(ssemap(i*PSCALE/N)+SSESCALE/2)/SSESCALE;
      int n=1+N*N/((i+1)*(N-i));
      if (n>254) n=254;
      int c1=(i*n+N/2)/N;
      for (int j=oldp-1; j>=p; --j) {
        for (int k=0; k<SSE1; ++k) {
          sse[k][j].n=n;
          sse[k][j].c1=c1;
        }
      }
      oldp=p;
    }
  }
}
inline void Predictor::update(int y) {
  if (MEM>=1) {
    sse[context][ssep/SSESCALE].update(y);
    sse[context][ssep/SSESCALE+1].update(y);
  }
  mixer.update(y);
  ch.update(y);
  deMo.model(); 
  cMo.model();
  reMo.model();
  reMon3.model();
  reMod2.model();
  wMo.model();
  maMo.model(); 
  aMo.model(); 
  eMo.model();   
  nextp=mixer.predict();
  if (MEM>=1) {
    context=ch(0)*8+(ch(1)/64)*2+(ch.pos(0,3)<ch.pos(32,3))*(_wlen==_clen);   
    ssep=ssemap(nextp);
    U32 wt=ssep%SSESCALE;
    U32 i=ssep/SSESCALE;
    nextp=(((sse[context][i].p()*(SSESCALE-wt)+sse[context][i+1].p()*wt)
      /SSESCALE)*3+nextp)/4;
  }
}
typedef enum {COMPRESS, DECOMPRESS} Mode;
class Encoder {
private:
  Predictor predictor;
  const Mode mode;       
  FILE* archive;         
  U32 x1, x2;             
  U32 x;                 
  int  LPS;
  U32 bits_to_follow;
  U8 bptr,bout,bptrin;
  int bin;
public:
  Encoder(Mode m, FILE* f);
  void encode(int y);     
  int decode();          
  void flush();         
  void bit_plus_follow(int bit);
  int input_bit(void);
};
void Encoder::bit_plus_follow(int bit)
{ 
	if (bit) bout|=bptr;
	if (!(bptr>>=1)) {
		putc(bout,archive);
		bptr=128;
		bout=0;
	}
	bit^=1;
	for (; bits_to_follow > 0; bits_to_follow--) {
		if (bit) bout|=bptr;
		if (!(bptr>>=1)) {
			putc(bout,archive);
			bptr=128;
			bout=0;
		}
	}
}
inline int Encoder::input_bit(void)
{
	if (!(bptrin>>=1)) {
		bin=getc(archive);
		if (bin==EOF) bin=0;
		bptrin=128;
	}
	return ((bin&bptrin)!=0);
}
Encoder::Encoder(Mode m, FILE* f): predictor(), mode(m), archive(f), x1(0),
                                   x2(0xffffffff), x(0), bits_to_follow(0), bptr(128), bout(0), bptrin(1) {
  if (mode==DECOMPRESS) {
    x = 1;
    for (;x < Half;) x = 2 * x + input_bit();
    x = 2 * x + input_bit();
  }
}
inline void Encoder::encode(int y) {
  U32 p=predictor.p()*(4096/PSCALE);  
  assert(p<4096);
  const U32 xdiff=x2-x1;
  U32 a,b,c;
  U32 xmid;  
  c = 2*p + 1;
  a = xdiff >> 13;
  b = xdiff & 0x1fff;
  xmid = x1 + a * c + (( c * b ) >> 13);
  if (y)
    x2=xmid;
  else
    x1=xmid+1;
  predictor.update(y);
  for (;;) {
    if ( x2 < Half ) {
	 bit_plus_follow(0);	 
      } else if (x1 >= Half) {	 
	 bit_plus_follow(1);
      } else if (x1 >= First_qtr	
		 && x2 < Third_qtr) {	
	 bits_to_follow ++;
	 x1 ^= First_qtr;	 
	 x2 ^= First_qtr;
      } else {
	 break;			 
      }
      x1 = 2 * x1;
      x2 = 2 * x2 + 1;	 
   }
}
inline int Encoder::decode() {
  const U32 p=predictor.p()*(4096/PSCALE); 
  assert(p<4096);
  const U32 xdiff=x2-x1;
  U32 a,b,c;
  U32 xmid;  
  c = 2*p + 1;
  a = xdiff >> 13;
  b = xdiff & 0x1fff;
  xmid = x1 + a * c + (( c * b ) >> 13);
  int y=0;
  if (x<=xmid) {
    y=1;
    x2=xmid;
  }
  else
    x1=xmid+1;
  predictor.update(y);
  for (;;) {
      if ( x2 < Half ) {
      } else if (x1 >= Half) {	 
	 x1 -= Half;
	 x -= Half;
	 x2 -= Half;		 
      } else if (x1 >= First_qtr	 
		 && x2 < Third_qtr) {	 
	 x1 -= First_qtr;	 
	 x -=  First_qtr;
	 x2 -= First_qtr;
      } else {
	 break;			 
      }
      x1 = 2 * x1;
      x = 2 * x + input_bit();
      x2 = 2 * x2 + 1;	 
   }
  return y;
}
void Encoder::flush() {
   if (mode==COMPRESS) {
  if ( x1 == 0 ) 
     bit_plus_follow(0);
   else 
     bit_plus_follow(1); 
	if (bout) putc(bout,archive);
   }
}
class Transformer {
  Encoder e;
public:
  Transformer(Mode mode, FILE* f): e(mode, f) {}
  void encode(int c) {
    for (int i=7; i>=0; --i)
      e.encode((c>>i)&1);
  }
  U32 decode() {
    U32 c=0;
    for (int i=0; i<8; ++i)
      c=c+c+e.decode();
    return c;
  }
  void flush() {
    e.flush();
  }
};
string getline(FILE* f=stdin) {
  int c;
  string result="";
  while ((c=getc(f))!=EOF && (c>=32 || c=='\t'))
    result+=char(c);
  if (c=='\r')
    (void) getc(f);
  return result;
}
int main(int argc, char** argv) {
  if (argc<2) {
    printf(
    "\n"
    "\n"
    "\n"
    "\n"
      PROGNAME " V0.2  compressor                                (C) 2004 Emilcont\n"
      "This program is free software distributed without warranty under the terms\n"
      "of the GNU General Public License, see http://www.gnu.org/licenses/gpl.txt\n"
      "USE AT YOUR OWN RISK   -  DO NOT DELETE THE ORIGINAL FILE WITHOUT CHECKING   \n"
      "              Many thanks to Matt Mahoney and his marvelous PAQ\n"
      "                    Thanks to the world of compression\n\n                     "
      
      
      "\n"
      "To compress:         " PROGNAME " -3 Name filenames...  (Name will be created)\n"
    
      "To extract/compare:  " PROGNAME " Name  (does not clobber existing files)\n"
      "To view contents:    more < archive\n"
      "\n"
      "Compression options: from -0 to -9   \n");
    return 1;
  }
  if (argc>1 && argv[1][0]=='-') {
    if (isdigit(argv[1][1]) && argv[1][2]==0) {
      MEM=argv[1][1]-'0';        
    }
    else
      printf("Option %s ignored\n", argv[1]);
    argc--;
    argv++;
  }
  vector<string> filename;  
  vector<long> filesize;   
  int uncompressed_bytes=0, compressed_bytes=0;  
  FILE* archive=fopen(argv[1], "rb");
  if (archive) {
    if (argc>2) {
      printf("File %s already exists\n", argv[1]);
      return 1;
    }
    string s=getline(archive);
    if (s.substr(0, string(PROGNAME).size()) != PROGNAME) {
      printf("Archive file %s not in " PROGNAME " format\n", argv[1]);
      return 1;
    }
    if (s.size()>2 && s[s.size()-2]=='-') {
      int c=s[s.size()-1];
      if (c>='0' && c<='9')
        MEM=c-'0';
    }
    printf("Extracting archive " PROGNAME " -%d %s ...\n", MEM, argv[1]);
    while (true) {
      string s=getline(archive);
      if (s.size()>1) {
        filesize.push_back(atol(s.c_str()));
        string::iterator tab=find(s.begin(), s.end(), '\t');
        if (tab!=s.end())
          filename.push_back(string(tab+1, s.end()));
        else
          filename.push_back("");
      }
      else
        break;
    }
    {
      int c1=0, c2=0;
      if ((c1=getc(archive))!='\f' || (c2=getc(archive))!=0) {
        printf("%s: Bad " PROGNAME " header format %d %d\n", argv[1],
          c1, c2);
        return 1;
      }
    }
    Transformer e(DECOMPRESS, archive);
    for (int i=0; i<int(filename.size()); ++i) {
      printf("%10ld %s: ", filesize[i], filename[i].c_str());
      FILE* f=fopen(filename[i].c_str(), "rb");
      const long size=filesize[i];
      uncompressed_bytes+=size;
      if (f) {
        bool different=false;
        for (long j=0; j<size; ++j) {
          int c1=e.decode();
          int c2=getc(f);
          if (!different && c1!=c2) {
            printf("differ at offset %ld, archive=%d file=%d\n",
              j, c1, c2);
            different=true;
          }
        }
        if (!different)
          printf("identical\n");
        fclose(f);
      }
      else {
        f=fopen(filename[i].c_str(), "wb");
        if (!f)
          printf("cannot create, skipping...\n");
        printf("      ");
        long step=ceil((double)size/1000);
        for (long j=0; j<size; ++j) {
          if (j%step==0) printf("\b\b\b\b\b\b%5.1f%%",((double)j/size)*100);
          int c=e.decode();
          if (f)
            putc(c, f);
        }
        printf("\b\b\b\b\b\b");
        if (f) {
          printf("extracted\n");
          fclose(f);
        }
      }
    }
    compressed_bytes=ftell(archive);
  }
  else {
    if (argc>2)
      for (int i=2; i<argc; ++i)
        filename.push_back(argv[i]);
    else {
      printf(
        "Enter names of files to compress, followed by blank line or EOF.\n");
      while (true) {
        string s=getline(stdin);
        if (s=="")
          break;
        else
          filename.push_back(s);
      }
    }
    int i;
    for (i=0; i<int(filename.size()); ++i) {
      FILE* f=fopen(filename[i].c_str(), "rb");
      if (!f) {
        printf("File not found, skipping: %s\n",
          filename[i].c_str());
        filesize.push_back(-1);
      }
      else {
        fseek(f, 0L, SEEK_END);
        filesize.push_back(ftell(f));
        fclose(f);
      }
    }
    if (filesize.empty() || *max_element(filesize.begin(), filesize.end())<0){
      printf("No files to compress, no archive created.\n");
      return 1;
    }
    archive=fopen(argv[1], "wb");
    if (!archive) {
      printf("Cannot create archive: %s\n", argv[1]);
      return 1;
    }
    fprintf(archive, PROGNAME " -%d\r\n", MEM);
    for ( i=0; i<int(filename.size()); ++i) {
      if (filesize[i]>=0)
        fprintf(archive, "%ld\t%s\r\n", filesize[i], filename[i].c_str());
    }
    putc(032, archive);  
    putc('\f', archive);
    putc(0, archive);
    Transformer e(COMPRESS, archive);
    long file_start=ftell(archive);
    for ( i=0; i<int(filename.size()); ++i) {
      const long size=filesize[i];
      if (size>=0) {
        uncompressed_bytes+=size;
        printf("%-23s %10ld ---compressing--> ", filename[i].c_str(), size);
        FILE* f=fopen(filename[i].c_str(), "rb");
        int c;
        printf("      ");
        long step=ceil((double)size/1000);
        for (long j=0; j<size; ++j) {
          if (j%step==0) printf("\b\b\b\b\b\b%5.1f%%",((double)j/size)*100);
          if (f)
            c=getc(f);
          else
            c=0;
          e.encode(c); 
        }
        printf("\b\b\b\b\b\b");
        if (f)
          fclose(f);
          printf("done      \n");  
        file_start=ftell(archive);
      }
    }
    e.flush();
    compressed_bytes=ftell(archive);
    fclose(archive);
  }
   {
     HANDLE  hConsole;
     WORD    ForeColor = 0;
     WORD    BackColor = 0;
     WORD    wAttributesOld;
     CONSOLE_SCREEN_BUFFER_INFO csbi;
     if( ( hConsole = CreateFile(
                        "CONOUT$", GENERIC_WRITE | GENERIC_READ,
                        FILE_SHARE_READ | FILE_SHARE_WRITE,
                        0L, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0L) )
                    == (HANDLE) -1 ) {
         printf("\nError: Unable to open console.\n");
         return( -1 );
     }
     printf("\n");
     GetConsoleScreenBufferInfo( hConsole, &csbi );
     wAttributesOld = csbi.wAttributes;
  const double elapsed_time =
    double(clock()-programChecker.start_time())/CLOCKS_PER_SEC;
         printf("\n"); 
         printf("Initial Size    (Bytes)    %d", uncompressed_bytes);
         printf("\n");           
           if (compressed_bytes*100.0/uncompressed_bytes>80) {
         ForeColor = 12;
         SetConsoleTextAttribute( hConsole, (WORD) ( (BackColor << 4) |
		 ForeColor) ); 
         }         
                  if (compressed_bytes*100.0/uncompressed_bytes>50 && compressed_bytes*100.0/uncompressed_bytes<81) {
         ForeColor = 14;
         SetConsoleTextAttribute( hConsole, (WORD) ( (BackColor << 4) |
		 ForeColor) ); 
         }         
                  if (compressed_bytes*100.0/uncompressed_bytes<51) {
         ForeColor = 10;
         SetConsoleTextAttribute( hConsole, (WORD) ( (BackColor << 4) |
		 ForeColor) ); 
         }
         printf("Compressed Size (Bytes)    %d", compressed_bytes);
         SetConsoleTextAttribute( hConsole, wAttributesOld );
         printf("\n");   
         printf("Time Wasted   (Seconds)    %1.2f", elapsed_time);   
  if (uncompressed_bytes>0 && elapsed_time>0) {
  	 printf("\n"); 
         printf("Bits per Character         %1.4f",
         compressed_bytes*8.0/uncompressed_bytes);
         printf("\n");
         printf("Percentage                 %1.2f%%",   
         compressed_bytes*100.0/uncompressed_bytes);
         printf("\n");
         printf("Speed (KBytes/sec)         %1.1f ",
         uncompressed_bytes/(elapsed_time*1024.0));
  }
  printf("\n");
  return 0;
}
}
