/* Demo how to can call DPINFO95 from C
   written by Dirk Paehl with LCC-WIN32
*/
#include <stdio.h>
#include <windows.h>

typedef void __stdcall ArcType(char* datei);
ArcType *ARc_Type = NULL;

typedef void __stdcall DPINFO(HWND wnd, char* buf,int mode);
DPINFO *DPINFOConfigDialog = NULL;

int main(int argc,char *argv[])
{
char *datei;

HMODULE hDll = LoadLibrary("dpinfo95.dll");
if (argc != 1)
{
if (0 == hDll)
{
MessageBox(0, "Could not load library \"dpinfo95\"!\n", "Error",
MB_OK | MB_ICONERROR | MB_TASKMODAL);
return 0;
}
datei = argv[1];
ARc_Type = (ArcType*)GetProcAddress(hDll, "ARc_Type");
if (NULL == ARc_Type)
{
MessageBox(0, "Missing function in library \"dpinfo95\"!\n", "Error",
MB_OK | MB_ICONERROR | MB_TASKMODAL);
FreeLibrary(hDll);
return 0;
}
ARc_Type(datei);
FreeLibrary(hDll);
} else
   {
    MessageBox(0, "Wrong call: correct is: DPINFO archive.zip\n", "Error",MB_OK | MB_ICONERROR | MB_TASKMODAL);
    if (0 == hDll) return 0;
    DPINFOConfigDialog = (DPINFO*)GetProcAddress(hDll, "DPINFOConfigDialog");
    if (NULL != DPINFOConfigDialog)
    DPINFOConfigDialog(0,NULL,0);
    FreeLibrary(hDll);
    }


}
