/* compress.h - this is part of the Tar program (see file define.h) */

/* Set USERMEM to the maximum amount of physical user memory available
 * in bytes.  USERMEM is used to determine the maximum BITS that can be used
 * for compression.
 *
 * SACREDMEM is the amount of physical memory saved for others; compress
 * will hog the rest.
 */
#define USE_COMPRESS

#ifndef SACREDMEM
# define SACREDMEM 0
#endif

#ifndef USERMEM
# define USERMEM 450000L /* default user memory */
#endif

#ifdef pdp11
# define BITS	12	/* max bits/code for 16-bit machine */
# define NO_UCHAR	/* also if "unsigned char" functions as signed char */
# undef USERMEM		/* don't forget to compile with -i */
#endif

#ifdef z8000
# define BITS 12
# undef vax	/* weird preprocessor */
# undef USERMEM
#endif

#ifdef __TURBOC__
# ifndef MSDOS
#  define MSDOS
# endif
#endif

#ifdef MSDOS
# define BIG
# undef USERMEM
# ifdef BIG		/* then this is a large data compilation */
#  define BITS	 16
#  define XENIX_16
# else			/* this is a small model compilation */
#  define BITS	 12
# endif
#else
#undef BIG
#endif

#ifdef pcxt
# define BITS	12
# undef USERMEM
#endif

#ifdef USERMEM
# if USERMEM >= (433484L+SACREDMEM)
#  define PBITS 16
# else
#  if USERMEM >= (229600L+SACREDMEM)
#   define PBITS	15
#  else
#   if USERMEM >= (127536L+SACREDMEM)
#    define PBITS	14
#   else
#    if USERMEM >= (73464L+SACREDMEM)
#     define PBITS	13
#    else
#     define PBITS	12
#    endif
#   endif
#  endif
# endif
# undef USERMEM
#endif

#ifdef PBITS
# ifndef BITS
#  define BITS PBITS /* Preferred BITS for this memory size */
# endif
#endif

#ifdef M_XENIX
# if BITS == 16		/* Stupid compiler can't handle arrays with */
#  define XENIX_16	/* more than 65535 bytes - so we fake it */
# else
#  if BITS > 13		/* Code only handles BITS = 12, 13, or 16 */
#   define BITS 13
#  endif
# endif
#endif

void z_reltab __ARGS__(( void ));
int  z_gettab __ARGS__(( int ));
int  cbegin   __ARGS__(( int, void(*)(), long ));
void cpiece   __ARGS__(( char *, int ));
long cflush   __ARGS__(( void ));

int  z_getmem __ARGS__(( int ));
void z_relmem __ARGS__(( void ));
int  dbegin   __ARGS__(( int(*)() ));
int  dpiece   __ARGS__(( char *, int ));
