// Unit1.cpp   Zip Demo 1  for C++ Builder    by Eric W. Engler
//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#include <sharemem.hpp>
#pragma hdrstop

// In C++ Builder, your own include files should be below the system
// and VCL include files.
#include "Unit1.h"

//---------------------------------------------------------------------------
#pragma link "ZipMstr"
#pragma resource "*.dfm"

TForm1 *Form1;

//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}

//---------------------------------------------------------------------------
void __fastcall TForm1::ZipButClick(TObject *Sender)
{
   Memo1->Clear();
   Memo1->Lines->Add("Adding test*.txt to test1.zip");
   ZipMaster1->ZipFilename="test1.zip";
   ZipMaster1->Verbose=TRUE;

   // Add as many filespecs as we want to:
   // (MS-DOS Wildcards are OK)
   ZipMaster1->FSpecArgs->Add("test*.txt");
   // Set the AddOptions; these also appear in Property Inspector:
   ZipMaster1->AddOptions << AddZipTime << AddHiddenFiles;
   ZipMaster1->Add();
}

//---------------------------------------------------------------------------
void __fastcall TForm1::ZipMaster1Message(TObject *Sender, int ErrCode,
	AnsiString Message)
{
   // Add a message from the DLLs to the memo box
   Memo1->Lines->Add(Message);
}

//---------------------------------------------------------------------------
void __fastcall TForm1::Button2Click(TObject *Sender)
{
   Close();  // exit program
}

//---------------------------------------------------------------------------
void __fastcall TForm1::UnzButClick(TObject *Sender)
{
   Memo1->Clear();
   if (!FileExists("test1.zip"))
   {
      ShowMessage("Error - test1.zip not found; do a Zip Test first");
      return;
   }
   Memo1->Lines->Add("Extracting from test1.zip");
   ZipMaster1->ZipFilename="test1.zip";
   ZipMaster1->Verbose=TRUE;

   // We can specify as many filespecs as we want to extract:
   // (MS-DOS Wildcards are OK)
   ZipMaster1->FSpecArgs->Add("test*.txt");

   // Set the ExtrOptions; these also appear in Property Inspector:
   ZipMaster1->ExtrOptions << ExtrOverWrite;
   ZipMaster1->Extract();
}

//---------------------------------------------------------------------------
void __fastcall TForm1::VersButClick(TObject *Sender)
{
   char outbuf[80];

   // When using a C string for output, I can use sprintf to format, and
   // MessageBox to display.
   // I could have used an AnsiString, and it's Format method, and
   // ShowMessage to display.
   sprintf(outbuf,"ZIPDLL.DLL = %d,  UNZDLL.DLL = %d",
       ZipMaster1->ZipVers, ZipMaster1->UnzVers);
   MessageBox(Handle, outbuf, "DLL Versions", MB_OK + MB_ICONINFORMATION);
}

//---------------------------------------------------------------------------
void __fastcall TForm1::ListButClick(TObject *Sender)
{
   int i;
   ZipDirEntry *dirp;
   char fname[80], datetime[20], outbuf[120];

   Memo1->Clear();
   if (!FileExists("test1.zip"))
   {
      ShowMessage("Error - test1.zip not found; do a Zip Test first");
      return;
   }
   Memo1->Lines->Add("Listing test1.zip");
   // The ZipContents TList is automatically filled with the contents of the
   // zipfile when the filename is assigned.
   ZipMaster1->ZipFilename="test1.zip";

   if (ZipMaster1->Count == 0)
      return;

   // I normally prefer to use TSortGrid for showing the user this info.
   // In this demo, I'm just using a plain memo so I can demonstrate how
   // to manipulate the strings and integers for display.  I want to
   // emphasize how to use C with the VCL components.

   // Print some column headers
   Memo1->Lines->Add("Filename         Cmp byt  Unc byt      Date/Time");
   for (i=0; i < ZipMaster1->Count; i++)
   {
      // ZipContnets is a TList, which contains an array of pointers
      // to ZipDirEntry structs.
      dirp=(ZipDirEntry *)(ZipMaster1->ZipContents->Items[i]);

      // In this demo, I'm going to convert the AnsiStrings to C strings
      // in order to use sprintf for the output formatting.  It would have
      // also been possible to use the Format method of AnsiString to do
      // output formatting.
      strcpy(fname, dirp->FileName.c_str());
      strcpy(datetime,
         FormatDateTime("ddddd  t",FileDateToDateTime(dirp->DateTime)).c_str());
      sprintf(outbuf, "%-16s %6d   %6d    %-16s",
         fname, dirp->CompressedSize, dirp->UncompressedSize, datetime);
      Memo1->Lines->Add(outbuf);
   } // end for
}

//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
   // The easiest way to handle DLL loading and unloading is to load them in
   // the form's OnCreate event handler, and unload them in the form's
   // OnDestroy event handler.
   ZipMaster1->Load_Zip_Dll();
   ZipMaster1->Load_Unz_Dll();
}

//---------------------------------------------------------------------------
void __fastcall TForm1::FormDestroy(TObject *Sender)
{
   ZipMaster1->Unload_Zip_Dll();
   ZipMaster1->Unload_Unz_Dll();
}
//---------------------------------------------------------------------------
