unit Sample;
{*****************************************************************
Important information for use with the
PKWARE Data Compression Library (R) for Windows
Copyright 1991,1992,1994,1995,1996 PKWARE Inc. All Rights Reserved
PKWARE Data Compression Library Reg. U.S. Pat. and Tm. Off.
******************************************************************}

interface

uses
  Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, PKCmp;

const ERR_BUF_SIZE = 255;

type

  TObjectRef = class of TObject;

  TCompressor = class(TForm)
    ExplodeButton: TButton;
    ImplodeButton: TButton;
    ClearButton: TButton;
    Label1: TLabel;
    Label2: TLabel;
    InputCRC: TEdit;
    OutputCRC: TEdit;
    procedure ImplodeButtonClick(Sender: TObject);
    procedure ExplodeButtonClick(Sender: TObject);
    procedure ClearButtonClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    InStream, OutStream : TFileStream;
    InCRC, OutCRC       : Longint;
    Compressing         : Boolean;
  end;

var
  Compressor: TCompressor;
{
  cmp_buff : array [1..CMP_BUFFER_SIZE] of char;
  exp_buff : array [1..EXP_BUFFER_SIZE] of char;
}

ErrorString : array [1..ERR_BUF_SIZE] of char;

implementation
{$R *.DFM}

  function ReadBuff(var buffer; size :Integer; var Param ):Integer;far;
   var read_size : Integer;
  begin
    try
       with TObject(Param) as TCompressor do
       begin
            read_size :=InStream.Read(buffer,size);
            if (read_size > 0) AND Compressing then
               InCRC := crc32(buffer,read_size,InCRC);
            ReadBuff := read_size;
       end;
    except
            ReadBuff := 0;
    end;
  end;

  function WriteBuff(var buffer; size :Integer; var Param ):Integer;far;
   var write_size : Integer;
  begin
    try
       with TObject(Param) as TCompressor do
       begin
            write_size := OutStream.Write(buffer,size);
            if (size > 0) AND NOT Compressing then
               OutCRC := crc32(buffer,size,OutCRC);
            WriteBuff := write_size;
       end;
    except
            WriteBuff := 0;
    end;
  end;


procedure TCompressor.ImplodeButtonClick(Sender: TObject);
 var cmp_type,dsize,res : Integer;
     p : TObject;
begin
     cmp_type := CMP_BINARY;
     dsize    := CMP_DICT_SIZE3;
     Compressing := TRUE;
     InCRC := -1;
     InputCRC.Text:='';
     try
          InStream  := TFileStream.Create('PKTEST.IN',fmOpenRead or fmShareExclusive);
          OutStream := TFileStream.Create('PKTEST.OUT',fmCreate or fmShareExclusive);
          p:=self;
          res := implode(ReadBuff,WriteBuff,cmp_type,dsize,p);
          if res <> CMP_NO_ERROR then
            begin
                 PKWareGetErrorString(res,@ErrorString[1],ERR_BUF_SIZE);
                 ShowMessage(ErrorString);
            end
     finally
        InStream.Free;
        OutStream.Free;
     end;
     InCRC := Not InCRC;

     InputCRC.Text := ' '+IntToHex(InCRC,8);
end;

procedure TCompressor.ExplodeButtonClick(Sender: TObject);
 var p : TObject;
     res : Integer;
begin
     Compressing := FALSE;
     OutCRC := -1;
     OutputCRC.Text:='';
     try
        InStream  := TFileStream.Create('PKTEST.OUT',fmOpenRead or fmShareExclusive);
        OutStream := TFileStream.Create('PKTEST.NEW',fmCreate or fmShareExclusive);
        p := self;
        res := explode(ReadBuff,WriteBuff,p);
          if res <> CMP_NO_ERROR then
            begin
                 PKWareGetErrorString(res,@ErrorString[1],ERR_BUF_SIZE);
                 ShowMessage(ErrorString);
            end
     finally
        InStream.Free;
        OutStream.Free;
     end;
     OutCRC := Not OutCRC;

     OutputCRC.Text := ' '+IntToHex(OutCRC,8);
end;

procedure TCompressor.ClearButtonClick(Sender: TObject);
begin
     InputCRC.Text:='';
     OutputCRC.Text:='';
end;

end.
