unit PKCmp;
{*****************************************************************
PKWARE Data Compression Library (R) for Windows
Copyright 1991,1992,1994,1995,1996 PKWARE Inc. All Rights Reserved
PKWARE Data Compression Library Reg. U.S. Pat. and Tm. Off.
******************************************************************}
interface

const
     CMP_BUFFER_SIZE = 36312;
     EXP_BUFFER_SIZE = 12596;

     CMP_DICT_SIZE1  = 1024;
     CMP_DICT_SIZE2  = 2048;
     CMP_DICT_SIZE3  = 4096;

     CMP_BINARY = 0;
     CMP_ASCII  = 1;

     CMP_NO_ERROR         = 0;
     CMP_INVALID_DICTSIZE = 1;
     CMP_INVALID_MODE     = 2;
     CMP_BAD_DATA         = 3;
     CMP_ABORT            = 4;
     CMP_NO_MEMORY        = 5;
     CMP_MEMORY_ERROR     = 6;


type
     TIOCallBack = function(var buffer; size : Integer; var Param ):Integer;

     TICallBack = TIOCallBack;
     TOCallBack = TIOCallBack;

     PTICallBack = ^TICallBack;
     PTOCallBack = ^TOCallBack;


     function implode( read_buff :TICallBack; write_buff:TOCallBack;
                       cmp_type:integer; iSize:Integer; var Param ):Integer;far;

     function explode( read_buff :TICallBack; write_buff:TOCallBack; var Param ):Integer;far;

     function implode_param( read_buff :TICallBack; write_buff :TOCallBack;
                             cmp_type, dsize : Integer; var param, work_buf):Integer;far;

     function explode_param( read_buff :TICallBack; write_buff :TOCallBack;
                             var param, work_buf):Integer;far;

     function crc32( var buffer; size : Integer; var old_crc : Longint):Longint;far;

     function PKWareGetErrorString(iErrNum:integer; szBuffer:PChar; iSize:integer):WordBool; far;


implementation

     function implode( read_buff :TICallBack; write_buff:TOCallBack;
                       cmp_type:integer; iSize:Integer; var Param ):Integer;
                       external 'PKWDCL';


     function explode( read_buff :TICallBack; write_buff:TOCallBack; var Param ):Integer;
                       external 'PKWDCL';

     function implode_param( read_buff :TICallBack; write_buff :TOCallBack;
                             cmp_type, dsize : Integer; var param, work_buf):Integer;
                             external 'PKWDCL';

     function explode_param( read_buff :TICallBack; write_buff :TOCallBack;
                             var param, work_buf):Integer;
                             external 'PKWDCL';


     function crc32( var buffer; size : Integer; var old_crc : Longint):Longint;
                     external 'PKWDCL';

     function PKWareGetErrorString( iErrNum:integer; szBuffer:PChar; iSize:integer):WordBool;
                                    external 'PKWDCL';


end.
